<?php

/**
 * This class adds the options with the related callbacks and validations.
 */
class Dahm_Menu_Options {

	/**
	 * Instance of the shared class.
	 *
	 * @var Daexthrmal_Shared|null
	 */
	private $shared = null;

	public function __construct( $shared ) {

		//assign an instance of the plugin info
		$this->shared = $shared;

	}

	public function register_options()
	{

		//section general ----------------------------------------------------------
		add_settings_section(
			'da_hm_general_settings_section',
			NULL,
			NULL,
			'da_hm_general_options'
		);

		add_settings_field(
			'detect_url_mode',
			esc_html__('Detect URL Mode', 'dahm'),
			array($this, 'detect_url_mode_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_detect_url_mode',
			array($this, 'detect_url_mode_validation')
		);

		add_settings_field(
			'https',
			esc_html__('HTTPS', 'dahm'),
			array($this, 'https_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_https',
			array($this, 'https_validation')
		);

		add_settings_field(
			'auto_trailing_slash',
			esc_html__('Auto Trailing Slash', 'dahm'),
			array($this, 'auto_trailing_slash_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_auto_trailing_slash',
			array($this, 'auto_trailing_slash_validation')
		);

		add_settings_field(
			'auto_delete',
			esc_html__('Auto Delete', 'dahm'),
			array($this, 'auto_delete_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_auto_delete',
			array($this, 'auto_delete_validation')
		);

		add_settings_field(
			'auto_alternate_pages',
			esc_html__('Auto Alternate Pages', 'dahm'),
			array($this, 'auto_alternate_pages_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_auto_alternate_pages',
			array($this, 'auto_alternate_pages_validation')
		);

		add_settings_field(
			'sanitize_url',
			esc_html__('Sanitize URL', 'dahm'),
			array($this, 'sanitize_url_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_sanitize_url',
			array($this, 'sanitize_url_validation')
		);

		add_settings_field(
			'sample_future_permalink',
			esc_html__('Sample Future Permalink', 'dahm'),
			array($this, 'sample_future_permalink_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_sample_future_permalink',
			array($this, 'sample_future_permalink_validation')
		);

		add_settings_field(
			'show_log',
			esc_html__('Show Log', 'dahm'),
			array($this, 'show_log_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_show_log',
			array($this, 'show_log_validation')
		);

		add_settings_field(
			'connections_in_menu',
			esc_html__('Connections in Menu', 'dahm'),
			array($this, 'connections_in_menu_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_connections_in_menu',
			array($this, 'connections_in_menu_validation')
		);

		add_settings_field(
			'meta_box_post_types',
			esc_html__('Meta Box Post Types', 'dahm'),
			array($this, 'meta_box_post_types_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_meta_box_post_types',
			array($this, 'meta_box_post_types_validation')
		);

		add_settings_field(
			'set_max_execution_time',
			esc_html__('Set Max Execution Time', 'dahm'),
			array($this, 'set_max_execution_time_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_set_max_execution_time',
			array($this, 'set_max_execution_time_validation')
		);

		add_settings_field(
			'max_execution_time_value',
			esc_html__('Max Execution Time Value', 'dahm'),
			array($this, 'max_execution_time_value_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_max_execution_time_value',
			array($this, 'max_execution_time_value_validation')
		);

		add_settings_field(
			'set_memory_limit',
			esc_html__('Set Memory Limit', 'dahm'),
			array($this, 'set_memory_limit_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_set_memory_limit',
			array($this, 'set_memory_limit_validation')
		);

		add_settings_field(
			'memory_limit_value',
			esc_html__('Memory Limit Value', 'dahm'),
			array($this, 'memory_limit_value_callback'),
			'da_hm_general_options',
			'da_hm_general_settings_section'
		);

		register_setting(
			'da_hm_general_options',
			'da_hm_memory_limit_value',
			array($this, 'memory_limit_value_validation')
		);

		//section sync ----------------------------------------------------------
		add_settings_section(
			'da_hm_sync_settings_section',
			NULL,
			NULL,
			'da_hm_sync_options'
		);

		add_settings_field(
			'sync_status',
			esc_html__('Status', 'dahm'),
			array($this, 'sync_status_callback'),
			'da_hm_sync_options',
			'da_hm_sync_settings_section'
		);

		register_setting(
			'da_hm_sync_options',
			'da_hm_sync_status',
			array($this, 'sync_status_validation')
		);

		add_settings_field(
			'sync_role',
			esc_html__('Role', 'dahm'),
			array($this, 'sync_role_callback'),
			'da_hm_sync_options',
			'da_hm_sync_settings_section'
		);

		register_setting(
			'da_hm_sync_options',
			'da_hm_sync_role',
			array($this, 'sync_role_validation')
		);

		add_settings_field(
			'sync_frequency',
			esc_html__('Frequency', 'dahm'),
			array($this, 'sync_frequency_callback'),
			'da_hm_sync_options',
			'da_hm_sync_settings_section'
		);

		register_setting(
			'da_hm_sync_options',
			'da_hm_sync_frequency',
			array($this, 'sync_frequency_validation')
		);

		add_settings_field(
			'sync_master_rest_endpoint',
			esc_html__('Master Endpoint', 'dahm'),
			array($this, 'sync_master_rest_endpoint_callback'),
			'da_hm_sync_options',
			'da_hm_sync_settings_section'
		);

		register_setting(
			'da_hm_sync_options',
			'da_hm_sync_master_rest_endpoint',
			array($this, 'sync_master_rest_endpoint_validation')
		);

		add_settings_field(
			'sync_mode',
			esc_html__('Sync Mode', 'dahm'),
			array($this, 'sync_mode_callback'),
			'da_hm_sync_options',
			'da_hm_sync_settings_section'
		);

		register_setting(
			'da_hm_sync_options',
			'da_hm_sync_mode',
			array($this, 'sync_mode_validation')
		);
		
		add_settings_field(
			'sync_language',
			esc_html__('Language', 'dahm'),
			array($this, 'sync_language_callback'),
			'da_hm_sync_options',
			'da_hm_sync_settings_section'
		);

		register_setting(
			'da_hm_sync_options',
			'da_hm_sync_language',
			array($this, 'sync_language_validation')
		);

		add_settings_field(
			'sync_script',
			esc_html__('Script', 'dahm'),
			array($this, 'sync_script_callback'),
			'da_hm_sync_options',
			'da_hm_sync_settings_section'
		);

		register_setting(
			'da_hm_sync_options',
			'da_hm_sync_script',
			array($this, 'sync_script_validation')
		);

		add_settings_field(
			'sync_locale',
			esc_html__('Locale', 'dahm'),
			array($this, 'sync_locale_callback'),
			'da_hm_sync_options',
			'da_hm_sync_settings_section'
		);

		register_setting(
			'da_hm_sync_options',
			'da_hm_sync_locale',
			array($this, 'sync_locale_validation')
		);

		add_settings_field(
			'sync_delete_target',
			esc_html__('Delete Target', 'dahm'),
			array($this, 'sync_delete_target_callback'),
			'da_hm_sync_options',
			'da_hm_sync_settings_section'
		);

		register_setting(
			'da_hm_sync_options',
			'da_hm_sync_delete_target',
			array($this, 'sync_delete_target_validation')
		);
		
		//import capabilities ------------------------------------------------------------------------------------------
		add_settings_section(
			'da_hm_import_settings_section',
			NULL,
			NULL,
			'da_hm_import_options'
		);
		
		add_settings_field(
			'import_mode',
			esc_html__('Mode', 'dahm'),
			array($this, 'import_mode_callback'),
			'da_hm_import_options',
			'da_hm_import_settings_section'
		);

		register_setting(
			'da_hm_import_options',
			'da_hm_import_mode',
			array($this, 'import_mode_validation')
		);

		add_settings_field(
			'import_language',
			esc_html__('Language', 'dahm'),
			array($this, 'import_language_callback'),
			'da_hm_import_options',
			'da_hm_import_settings_section'
		);

		register_setting(
			'da_hm_import_options',
			'da_hm_import_language',
			array($this, 'import_language_validation')
		);

		add_settings_field(
			'import_script',
			esc_html__('Script', 'dahm'),
			array($this, 'import_script_callback'),
			'da_hm_import_options',
			'da_hm_import_settings_section'
		);

		register_setting(
			'da_hm_import_options',
			'da_hm_import_script',
			array($this, 'import_script_validation')
		);

		add_settings_field(
			'import_locale',
			esc_html__('Locale', 'dahm'),
			array($this, 'import_locale_callback'),
			'da_hm_import_options',
			'da_hm_import_settings_section'
		);

		register_setting(
			'da_hm_import_options',
			'da_hm_import_locale',
			array($this, 'import_locale_validation')
		);

		//section capabilities -----------------------------------------------------------------------------------------
		add_settings_section(
			'da_hm_capabilities_settings_section',
			NULL,
			NULL,
			'da_hm_capabilities_options'
		);
		
		add_settings_field(
			'meta_box_capability',
			esc_html__('Meta Box Capability', 'dahm'),
			array($this, 'meta_box_capability_callback'),
			'da_hm_capabilities_options',
			'da_hm_capabilities_settings_section'
		);

		register_setting(
			'da_hm_capabilities_options',
			'da_hm_meta_box_capability',
			array($this, 'meta_box_capability_validation')
		);

		add_settings_field(
			'editor_sidebar_capability',
			esc_html__('Editor Sidebar Capability', 'dahm'),
			array($this, 'editor_sidebar_capability_callback'),
			'da_hm_capabilities_options',
			'da_hm_capabilities_settings_section'
		);

		register_setting(
			'da_hm_capabilities_options',
			'da_hm_editor_sidebar_capability',
			array($this, 'editor_sidebar_capability_validation')
		);

		add_settings_field(
			'connections_menu_capability',
			esc_html__('Connections Menu Capability', 'dahm'),
			array($this, 'connections_menu_capability_callback'),
			'da_hm_capabilities_options',
			'da_hm_capabilities_settings_section'
		);

		register_setting(
			'da_hm_capabilities_options',
			'da_hm_connections_menu_capability',
			array($this, 'connections_menu_capability_validation')
		);

		add_settings_field(
			'wizard_menu_capability',
			esc_html__('Wizard Menu Capability', 'dahm'),
			array($this, 'wizard_menu_capability_callback'),
			'da_hm_capabilities_options',
			'da_hm_capabilities_settings_section'
		);

		register_setting(
			'da_hm_capabilities_options',
			'da_hm_wizard_menu_capability',
			array($this, 'wizard_menu_capability_validation')
		);

		add_settings_field(
			'import_menu_capability',
			esc_html__('Import Menu Capability', 'dahm'),
			array($this, 'import_menu_capability_callback'),
			'da_hm_capabilities_options',
			'da_hm_capabilities_settings_section'
		);

		register_setting(
			'da_hm_capabilities_options',
			'da_hm_import_menu_capability',
			array($this, 'import_menu_capability_validation')
		);

		add_settings_field(
			'export_menu_capability',
			esc_html__('Export Menu Capability', 'dahm'),
			array($this, 'export_menu_capability_callback'),
			'da_hm_capabilities_options',
			'da_hm_capabilities_settings_section'
		);

		register_setting(
			'da_hm_capabilities_options',
			'da_hm_export_menu_capability',
			array($this, 'export_menu_capability_validation')
		);

		add_settings_field(
			'maintenance_menu_capability',
			esc_html__('Maintenance Menu Capability', 'dahm'),
			array($this, 'maintenance_menu_capability_callback'),
			'da_hm_capabilities_options',
			'da_hm_capabilities_settings_section'
		);

		register_setting(
			'da_hm_capabilities_options',
			'da_hm_maintenance_menu_capability',
			array($this, 'maintenance_menu_capability_validation')
		);

		//section defaults ----------------------------------------------------------

		add_settings_section(
			'da_hm_defaults_settings_section',
			NULL,
			NULL,
			'da_hm_defaults_options'
		);

		$connections_in_menu = get_option('da_hm_connections_in_menu');
		for($i=1;$i<=$connections_in_menu;$i++){

			add_settings_field(
				'default_language_' . $i,
				esc_html__('Default Language', 'dahm') . ' ' . $i,
				array($this, 'default_language_' . $i . '_callback'),
				'da_hm_defaults_options',
				'da_hm_defaults_settings_section'
			);

			register_setting(
				'da_hm_defaults_options',
				'da_hm_default_language_' . $i,
				array($this, 'default_language_' . $i . '_validation')
			);

			add_settings_field(
				'default_script_' . $i,
				esc_html__('Default Script', 'dahm') . ' ' . $i,
				array($this, 'default_script_' . $i . '_callback'),
				'da_hm_defaults_options',
				'da_hm_defaults_settings_section'
			);

			register_setting(
				'da_hm_defaults_options',
				'da_hm_default_script_' . $i,
				array($this, 'default_script_' . $i . '_validation')
			);

			add_settings_field(
				'default_locale_' . $i,
				esc_html__('Default Locale', 'dahm') . ' ' . $i,
				array($this, 'default_locale_' . $i . '_callback'),
				'da_hm_defaults_options',
				'da_hm_defaults_settings_section'
			);

			register_setting(
				'da_hm_defaults_options',
				'da_hm_default_locale_' . $i,
				array($this, 'default_locale_' . $i . '_validation')
			);

		}

	}

	public function show_log_callback($args){

		$html = '<select id="da-hm-show-log" name="da_hm_show_log">';
		$html .= '<option ' . selected(intval(get_option("da_hm_show_log")), 0, false) . ' value="0">' . esc_html__('No', 'dahm') . '</option>';
		$html .= '<option ' . selected(intval(get_option("da_hm_show_log")), 1, false) . ' value="1">' . esc_html__('Yes', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Select "Yes" to display the log on the front-end. Please note that the log will be displayed only to the users who have access to the "Connections" menu.', 'dahm') . '"></div>';

		echo $html;

	}

	public function show_log_validation($input){

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function https_callback($args){

		$html = '<select id="da-hm-https" name="da_hm_https">';
		$html .= '<option ' . selected(intval(get_option("da_hm_https")), 0, false) . ' value="0">' . esc_html__('No', 'dahm') . '</option>';
		$html .= '<option ' . selected(intval(get_option("da_hm_https")), 1, false) . ' value="1">' . esc_html__('Yes', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Select "Yes" if your website is using the HTTPS protocol. This option will be considered only if "Detect URL Mode" is set to "Server Variable".', 'dahm') . '"></div>';

		echo $html;

	}

	public function https_validation($input){

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function connections_in_menu_callback($args){

		$html = '<input autocomplete="off" type="text" id="da_hm_connections_in_menu" name="da_hm_connections_in_menu" class="regular-text" value="' . intval(get_option("da_hm_connections_in_menu"), 10) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('Please enter a number from 1 to 100. This option determines the number of connections displayed in the "Defaults" tab, in the "Connections" menu and in the "Hreflang Manager" meta box.', 'dahm') . '"></div>';
		echo $html;

	}

	public function connections_in_menu_validation($input){

		if( intval($input, 10) < 1 or intval($input, 10) > 100 ){
			add_settings_error( 'da_hm_connections_in_menu', 'da_hm_connections_in_menu', esc_html__('Please enter a number from 1 to 100 in the "Connections in Menu" option.', 'dahm') );
			$output = get_option('da_hm_connections_in_menu');
		}else{
			$output = $input;
		}

		return intval($output,  10);

	}

	public function meta_box_post_types_callback($args){

		$html = '<input autocomplete="off" type="text" id="da_hm_meta_box_post_types" name="da_hm_meta_box_post_types" class="regular-text" value="' . esc_attr(get_option("da_hm_meta_box_post_types")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('A list of post types, separated by comma, where the "Hreflang Manager" meta box should be loaded.', 'dahm') . '"></div>';

		echo $html;

	}

	public function meta_box_post_types_validation($input){

		if(!preg_match($this->shared->regex_list_of_post_types, $input)){
			add_settings_error( 'da_hm_meta_box_post_types', 'da_hm_meta_box_post_types', esc_html__('Please enter a valid list of post types separated by a comma in the "Meta Box Post Types" option.', 'dahm') );
			$output = get_option('da_hm_meta_box_post_types');
		}else{
			$output = $input;
		}

		return $output;

	}


	public function detect_url_mode_callback($args){

		$html = '<select id="da-hm-detect-url-mode" name="da_hm_detect_url_mode">';
		$html .= '<option ' . selected(get_option("da_hm_detect_url_mode"), 'server_variable', false) . ' value="server_variable">' . esc_html__('Server Variable', 'dahm') . '</option>';
		$html .= '<option ' . selected(get_option("da_hm_detect_url_mode"), 'wp_request', false) . ' value="wp_request">' . esc_html__('WP Request', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Select the method used to detect the URL of the page.', 'dahm') . '"></div>';

		echo $html;

	}

	public function detect_url_mode_validation($input){

		if($input === 'server_variable' or $input === 'wp_request'){
			$output = $input;
		}else{
			$output = 'server_variable';
		}

		return $output;

	}

	public function auto_trailing_slash_callback($args){

		$html = '<select id="da-hm-auto-delete" name="da_hm_auto_trailing_slash">';
		$html .= '<option ' . selected(intval(get_option("da_hm_auto_trailing_slash")), 0, false) . ' value="0">' . esc_html__('No', 'dahm') . '</option>';
		$html .= '<option ' . selected(intval(get_option("da_hm_auto_trailing_slash")), 1, false) . ' value="1">' . esc_html__('Yes', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Enable this option to compare the URL defined in the "URL to Connect" field with the URL of the page with and without trailing slash.', 'dahm') . '"></div>';

		echo $html;

	}

	public function auto_trailing_slash_validation($input){

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function auto_delete_callback($args){

		$html = '<select id="da-hm-auto-delete" name="da_hm_auto_delete">';
		$html .= '<option ' . selected(intval(get_option("da_hm_auto_delete")), 0, false) . ' value="0">' . esc_html__('No', 'dahm') . '</option>';
		$html .= '<option ' . selected(intval(get_option("da_hm_auto_delete")), 1, false) . ' value="1">' . esc_html__('Yes', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Enable this option to automatically delete the connection associated with a post when the post is trashed.', 'dahm') . '"></div>';

		echo $html;

	}

	public function auto_delete_validation($input){

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function auto_alternate_pages_callback(){

		$html = '<select id="da-hm-auto-alternate-pages" name="da_hm_auto_alternate_pages">';
		$html .= '<option ' . selected(intval(get_option("da_hm_auto_alternate_pages")), 0, false) . ' value="0">' . esc_html__('No', 'dahm') . '</option>';
		$html .= '<option ' . selected(intval(get_option("da_hm_auto_alternate_pages")), 1, false) . ' value="1">' . esc_html__('Yes', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled, the plugin automatically generates the connections for the alternate pages. This option should only be used if this WordPress installation serves the alternate pages.', 'dahm') . '"></div>';

		echo $html;

	}

	public function auto_alternate_pages_validation($input){

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function sanitize_url_callback($args){

		$html = '<select id="da-hm-sanitize-url" name="da_hm_sanitize_url">';
		$html .= '<option ' . selected(intval(get_option("da_hm_sanitize_url")), 0, false) . ' value="0">' . esc_html__('No', 'dahm') . '</option>';
		$html .= '<option ' . selected(intval(get_option("da_hm_sanitize_url")), 1, false) . ' value="1">' . esc_html__('Yes', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Enable this option to sanitize the URL in the href attribute of the link element.', 'dahm') . '"></div>';

		echo $html;

	}

	public function sanitize_url_validation($input){

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function sample_future_permalink_callback($args){

		$html = '<select id="da-hm-sample-future-permalink" name="da_hm_sample_future_permalink">';
		$html .= '<option ' . selected(intval(get_option("da_hm_sample_future_permalink")), 0, false) . ' value="0">' . esc_html__('No', 'dahm') . '</option>';
		$html .= '<option ' . selected(intval(get_option("da_hm_sample_future_permalink")), 1, false) . ' value="1">' . esc_html__('Yes', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Enable this option to assign a permalink based on the post name to the posts scheduled to be published in a future date.', 'dahm') . '"></div>';

		echo $html;

	}

	public function sample_future_permalink_validation($input){

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function set_max_execution_time_callback($args)
	{

		$html = '<select id="da_hm_set_max_execution_time" name="da_hm_set_max_execution_time" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("da_hm_set_max_execution_time")), 0,
				false) . ' value="0">' . esc_html__('No', 'dahm') . '</option>';
		$html .= '<option ' . selected(intval(get_option("da_hm_set_max_execution_time")), 1,
				false) . ' value="1">' . esc_html__('Yes', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Select "Yes" to enable your custom "Max Execution Time Value" on long running scripts.',
				'dahm') . '"></div>';

		echo $html;

	}

	public function set_max_execution_time_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function max_execution_time_value_callback($args)
	{

		$html = '<input maxlength="7" type="text" id="da_hm_max_execution_time_value" name="da_hm_max_execution_time_value" class="regular-text" value="' . intval(get_option("da_hm_max_execution_time_value"),
				10) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('This value determines the maximum number of seconds allowed to execute long running scripts.',
				'dahm') . '"></div>';
		echo $html;

	}

	public function max_execution_time_value_validation($input)
	{

		if ( ! preg_match($this->shared->regex_number_ten_digits, $input) or intval($input, 10) > 1000000) {
			add_settings_error('da_hm_max_execution_time_value', 'da_hm_max_execution_time_value',
				esc_html__('Please enter a valid value in the "Max Execution Time" option.', 'dahm'));
			$output = get_option('da_hm_max_execution_time_value');
		} else {
			$output = $input;
		}

		return intval($output, 10);

	}

	public function set_memory_limit_callback($args)
	{

		$html = '<select id="da_hm_set_memory_limit" name="da_hm_set_memory_limit" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("da_hm_set_memory_limit")), 0,
				false) . ' value="0">' . esc_html__('No', 'dahm') . '</option>';
		$html .= '<option ' . selected(intval(get_option("da_hm_set_memory_limit")), 1,
				false) . ' value="1">' . esc_html__('Yes', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Select "Yes" to enable your custom "Memory Limit Value" on long running scripts.',
				'dahm') . '"></div>';

		echo $html;

	}

	public function set_memory_limit_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function memory_limit_value_callback($args)
	{

		$html = '<input maxlength="7" type="text" id="da_hm_memory_limit_value" name="da_hm_memory_limit_value" class="regular-text" value="' . intval(get_option("da_hm_memory_limit_value"),
				10) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('This value determines the PHP memory limit in megabytes allowed to execute long running scripts.',
				'da_hm') . '"></div>';
		echo $html;

	}

	public function memory_limit_value_validation($input)
	{

		if ( ! preg_match($this->shared->regex_number_ten_digits, $input) or intval($input, 10) > 1000000) {
			add_settings_error('da_hm_memory_limit_value', 'da_hm_memory_limit_value',
				esc_html__('Please enter a valid value in the "Memory Limit Value" option.', 'dahm'));
			$output = get_option('da_hm_memory_limit_value');
		} else {
			$output = $input;
		}

		return intval($output, 10);

	}

	//Sync section -----------------------------------------------------------------------------------------------------
	
	public function sync_status_callback($args){

		$html = '<select id="da-hm-sync-status" name="da_hm_sync_status">';
		$html .= '<option ' . selected(get_option("da_hm_sync_status"), 0, false) . ' value="0">' . esc_html__('Disabled', 'dahm') . '</option>';
		$html .= '<option ' . selected(get_option("da_hm_sync_status"), 1, false) . ' value="1">' . esc_html__('Enabled', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Whether to enable or not the sync feature.', 'dahm') . '"></div>';

		echo $html;

	}

	public function sync_status_validation($input){

		return intval($input, 10) === 0 ? 0 : 1;

	}

	public function sync_role_callback($args){

		$html = '<select id="da-hm-sync-role" name="da_hm_sync_role">';
		$html .= '<option ' . selected(get_option("da_hm_sync_role"), 0, false) . ' value="0">' . esc_html__('Master', 'dahm') . '</option>';
		$html .= '<option ' . selected(get_option("da_hm_sync_role"), 1, false) . ' value="1">' . esc_html__('Slave', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('The role of this website in the synced network. Note that a website with the "Master" role exposes its hreflang data with a REST API endpoint, while a website with the "Slave" role imports the hreflang data from the REST API endpoint defined "Master Endpoint" option. IMPORTANT: By setting a website as a "Slave" you will lose all the hreflang data stored in the website.', 'dahm') . '"></div>';

		echo $html;

	}

	public function sync_role_validation($input){

		return intval($input, 10) === 0 ? 0 : 1;

	}

	public function sync_frequency_callback($args){

		$html = '<select id="da-hm-sync-frequency" name="da_hm_sync_frequency">';
		$html .= '<option ' . selected(get_option("da_hm_sync_frequency"), 0, false) . ' value="0">' . esc_html__('Hourly', 'dahm') . '</option>';
		$html .= '<option ' . selected(get_option("da_hm_sync_frequency"), 1, false) . ' value="1">' . esc_html__('Twice Daily', 'dahm') . '</option>';
		$html .= '<option ' . selected(get_option("da_hm_sync_frequency"), 2, false) . ' value="2">' . esc_html__('Daily', 'dahm') . '</option>';
		$html .= '<option ' . selected(get_option("da_hm_sync_frequency"), 3, false) . ' value="3">' . esc_html__('Weekly', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines how often the sync should occur.', 'dahm') . '"></div>';

		echo $html;

	}

	public function sync_frequency_validation($input){

		return intval($input, 10);

	}

	public function sync_master_rest_endpoint_callback($args)
	{

		$html = '<input maxlength="2048" type="text" id="da_hm_sync_master_rest_endpoint" name="da_hm_sync_master_rest_endpoint" class="regular-text" value="' . get_option("da_hm_sync_master_rest_endpoint") . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The REST API endpoint used to sync a "Slave" website with a "Master" website. This value should be equal to the URL of the master website plus the suffix "/wp-json/daext-hreflang-manager/v1/sync". For example, if the master website is "https://example.com" the value of this option should be "https://example.com/wp-json/daext-hreflang-manager/v1/sync".',
				'da_hm') . '"></div>';
		echo $html;

	}

	public function sync_master_rest_endpoint_validation($input)
	{

		return sanitize_text_field($input);

	}

	public function sync_mode_callback($args){

		$html = '<select id="da-hm-sync-mode" name="da_hm_sync_mode">';
		$html .= '<option ' . selected(get_option("da_hm_sync_mode"), 0, false) . ' value="0">' . esc_html__('Exact Copy', 'dahm') . '</option>';
		$html .= '<option ' . selected(get_option("da_hm_sync_mode"), 1, false) . ' value="1">' . esc_html__('Based on Sync Options', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Select "Exact Copy" to sync an exact copy of the connections available in the "Master" website or "Based on Sync Options" to determine the "URL to Connect" value of the synced connections by using the "Sync Language", "Sync Script", and "Sync Locale" options.', 'dahm') . '"></div>';

		echo $html;

	}

	public function sync_mode_validation($input){

		return intval($input, 10) === 0 ? 0 : 1;

	}
	
	public function sync_language_callback($args){
		$html = '<select id="da-hm-sync-language" name="da_hm_sync_language">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_sync_language") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option is used to determine the "URL to Connect" value of the synced connections.', 'dahm') . '"></div>';
		echo $html;
	}

	public function sync_language_validation($input){
		return sanitize_text_field($input);
	}

	public function sync_script_callback($args){
		$html = '<select id="da-hm-sync-script" name="da_hm_sync_script">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_sync_script") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option is used to determine the "URL to Connect" value of the synced connections.', 'dahm') . '"></div>';

		echo $html;
	}

	public function sync_script_validation($input){
		return sanitize_text_field($input);
	}

	public function sync_locale_callback($args){
		$html = '<select id="da-hm-sync-locale" name="da_hm_sync_locale">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_sync_locale") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option is used to determine the "URL to Connect" value of the synced connections.', 'dahm') . '"></div>';

		echo $html;
	}

	public function sync_locale_validation($input){
		return sanitize_text_field($input);
	}

	public function sync_delete_target_callback($args){

		$html = '<select id="da-hm-sync-delete-target" name="da_hm_sync_delete_target">';
		$html .= '<option ' . selected(get_option("da_hm_sync_delete_target"), 0, false) . ' value="0">' . esc_html__('All', 'dahm') . '</option>';
		$html .= '<option ' . selected(get_option("da_hm_sync_delete_target"), 1, false) . ' value="1">' . esc_html__('Inherited', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines which connections of a "Slave" site can be deleted during the sync process. With "All" selected, any connection can be deleted. With "Inherited" selected, only the connections inherited from the master site can be deleted.', 'dahm') . '"></div>';

		echo $html;

	}

	public function sync_delete_target_validation($input){

		return intval($input, 10) === 0 ? 0 : 1;

	}

	//Import section ---------------------------------------------------------------------------------------------------

	public function import_mode_callback($args){

		$html = '<select id="da-hm-auto-delete" name="da_hm_import_mode">';
		$html .= '<option ' . selected(get_option("da_hm_import_mode"), 'exact_copy', false) . ' value="exact_copy">' . esc_html__('Exact Copy', 'dahm') . '</option>';
		$html .= '<option ' . selected(get_option("da_hm_import_mode"), 'import_options', false) . ' value="import_options">' . esc_html__('Based on Import Options', 'dahm') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Select "Exact Copy" to import an exact copy of the connections stored in your XML file or "Based on Import Options" to determine the "URL to Connect" value of the imported connections by using the "Import Language", "Import Script" and "Import Locale" options.', 'dahm') . '"></div>';

		echo $html;

	}

	public function import_mode_validation($input){

		if($input === 'exact_copy' or $input === 'import_options'){
			$output = $input;
		}else{
			$output = 'exact_copy';
		}

		return $output;

	}

	public function import_language_callback($args){
		$html = '<select id="da-hm-import-language" name="da_hm_import_language">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_import_language") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option is used to determine the "URL to Connect" value of the imported connections.', 'dahm') . '"></div>';
		echo $html;
	}

	public function import_language_validation($input){
		return sanitize_text_field($input);
	}

	public function import_script_callback($args){
		$html = '<select id="da-hm-import-script" name="da_hm_import_script">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_import_script") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option is used to determine the "URL to Connect" value of the imported connections.', 'dahm') . '"></div>';

		echo $html;
	}

	public function import_script_validation($input){
		return sanitize_text_field($input);
	}

	public function import_locale_callback($args){
		$html = '<select id="da-hm-import-locale" name="da_hm_import_locale">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_import_locale") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option is used to determine the "URL to Connect" value of the imported connections.', 'dahm') . '"></div>';

		echo $html;
	}

	public function import_locale_validation($input){
		return sanitize_text_field($input);
	}

	//Section capabilities ---------------------------------------------------------------------------------------------

	public function meta_box_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="da_hm_meta_box_capability" name="da_hm_meta_box_capability" class="regular-text" value="' . esc_attr(get_option("da_hm_meta_box_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Hreflang Manager" meta box.', 'dahm') . '"></div>';

		echo $html;

	}

	public function meta_box_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'da_hm_meta_box_capability', 'da_hm_meta_box_capability', esc_html__('Please enter a valid capability in the "Meta Box Capability" option.', 'dahm') );
			$output = get_option('da_hm_meta_box_capability');
		}else{
			$output = $input;
		}

		return $output;

	}

	public function editor_sidebar_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="da_hm_editor_sidebar_capability" name="da_hm_editor_sidebar_capability" class="regular-text" value="' . esc_attr(get_option("da_hm_editor_sidebar_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the editor sidebar.', 'dahm') . '"></div>';

		echo $html;

	}

	public function editor_sidebar_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'da_hm_editor_sidebar_capability', 'da_hm_editor_sidebar_capability', esc_html__('Please enter a valid capability in the "Editor Sidebar Capability" option.', 'dahm') );
			$output = get_option('da_hm_editor_sidebar_capability');
		}else{
			$output = $input;
		}

		return $output;

	}

	public function connections_menu_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="da_hm_connections_menu_capability" name="da_hm_connections_menu_capability" class="regular-text" value="' . esc_attr(get_option("da_hm_connections_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Connections" menu.', 'dahm') . '"></div>';

		echo $html;

	}

	public function connections_menu_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'da_hm_connections_menu_capability', 'da_hm_connections_menu_capability', esc_html__('Please enter a valid capability in the "Connections Menu Capability" option.', 'dahm') );
			$output = get_option('da_hm_connections_menu_capability');
		}else{
			$output = $input;
		}

		return $output;

	}

	public function wizard_menu_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="da_hm_wizard_menu_capability" name="da_hm_wizard_menu_capability" class="regular-text" value="' . esc_attr(get_option("da_hm_wizard_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Wizard" menu.', 'dahm') . '"></div>';

		echo $html;

	}

	public function wizard_menu_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'da_hm_wizard_menu_capability', 'da_hm_wizard_menu_capability', esc_html__('Please enter a valid capability in the "Wizard Menu Capability" option.', 'dahm') );
			$output = get_option('da_hm_wizard_menu_capability');
		}else{
			$output = $input;
		}

		return $output;

	}

	public function import_menu_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="da_hm_import_menu_capability" name="da_hm_import_menu_capability" class="regular-text" value="' . esc_attr(get_option("da_hm_import_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Import" menu.', 'dahm') . '"></div>';

		echo $html;

	}

	public function import_menu_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'da_hm_import_menu_capability', 'da_hm_import_menu_capability', esc_html__('Please enter a valid capability in the "Import Menu Capability" option.', 'dahm') );
			$output = get_option('da_hm_import_menu_capability');
		}else{
			$output = $input;
		}

		return $output;

	}

	public function export_menu_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="da_hm_export_menu_capability" name="da_hm_export_menu_capability" class="regular-text" value="' . esc_attr(get_option("da_hm_export_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Export" menu.', 'dahm') . '"></div>';

		echo $html;

	}

	public function export_menu_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'da_hm_export_menu_capability', 'da_hm_export_menu_capability', esc_html__('Please enter a valid capability in the "Export Menu Capability" option.', 'dahm') );
			$output = get_option('da_hm_export_menu_capability');
		}else{
			$output = $input;
		}

		return $output;

	}

	public function maintenance_menu_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="da_hm_maintenance_menu_capability" name="da_hm_maintenance_menu_capability" class="regular-text" value="' . esc_attr(get_option("da_hm_maintenance_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Maintenance" menu.', 'dahm') . '"></div>';

		echo $html;

	}

	public function maintenance_menu_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'da_hm_maintenance_menu_capability', 'da_hm_maintenance_menu_capability', esc_html__('Please enter a valid capability in the "Maintenance Menu Capability" option.', 'dahm') );
			$output = get_option('da_hm_maintenance_menu_capability');
		}else{
			$output = $input;
		}

		return $output;

	}

	//1 ----------------------------------------------------------------------------------------------------------------
	public function default_language_1_callback($args){
		$html = '<select id="da-hm-default-language-1" class="da-hm-default-language" name="da_hm_default_language_1">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_1") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of language', 'dahm') . ' 1.' . '"></div>';
		echo $html;
	}

	public function default_language_1_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_1_callback($args){
		$html = '<select id="da-hm-default-script-1" class="da-hm-default-script" name="da_hm_default_script_1">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_1") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of script', 'dahm') . ' 1.' . '"></div>';

		echo $html;
	}

	public function default_script_1_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_1_callback($args){
		$html = '<select id="da-hm-default-locale-1" class="da-hm-default-locale" name="da_hm_default_locale_1">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_1") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of locale', 'dahm') . ' 1.' . '"></div>';

		echo $html;
	}

	public function default_locale_1_validation($input){
		return sanitize_text_field($input);
	}

	//2 ----------------------------------------------------------------------------------------------------------------
	public function default_language_2_callback($args){
		$html = '<select id="da-hm-default-language-2" class="da-hm-default-language" name="da_hm_default_language_2">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_2") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of language', 'dahm') . ' 2.' . '"></div>';
		echo $html;
	}

	public function default_language_2_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_2_callback($args){
		$html = '<select id="da-hm-default-script-2" class="da-hm-default-script" name="da_hm_default_script_2">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_2") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of script', 'dahm') . ' 2.' . '"></div>';
		echo $html;
	}

	public function default_script_2_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_2_callback($args){
		$html = '<select id="da-hm-default-locale-2" class="da-hm-default-locale" name="da_hm_default_locale_2">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_2") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of locale', 'dahm') . ' 2.' . '"></div>';
		echo $html;
	}

	public function default_locale_2_validation($input){
		return sanitize_text_field($input);
	}

	//3 ----------------------------------------------------------------------------------------------------------------
	public function default_language_3_callback($args){
		$html = '<select id="da-hm-default-language-3" class="da-hm-default-language" name="da_hm_default_language_3">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_3") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of language', 'dahm') . ' 3.' . '"></div>';
		echo $html;
	}

	public function default_language_3_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_3_callback($args){
		$html = '<select id="da-hm-default-script-3" class="da-hm-default-script" name="da_hm_default_script_3">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_3") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of script', 'dahm') . ' 3.' . '"></div>';

		echo $html;
	}

	public function default_script_3_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_3_callback($args){
		$html = '<select id="da-hm-default-locale-3" class="da-hm-default-locale" name="da_hm_default_locale_3">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_3") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of locale', 'dahm') . ' 3.' . '"></div>';

		echo $html;
	}

	public function default_locale_3_validation($input){
		return sanitize_text_field($input);
	}

	//4 ----------------------------------------------------------------------------------------------------------------
	public function default_language_4_callback($args){
		$html = '<select id="da-hm-default-language-4" class="da-hm-default-language" name="da_hm_default_language_4">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_4") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of language', 'dahm') . ' 4.' . '"></div>';
		echo $html;
	}

	public function default_language_4_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_4_callback($args){
		$html = '<select id="da-hm-default-script-4" class="da-hm-default-script" name="da_hm_default_script_4">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_4") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of script', 'dahm') . ' 4.' . '"></div>';

		echo $html;
	}

	public function default_script_4_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_4_callback($args){
		$html = '<select id="da-hm-default-locale-4" class="da-hm-default-locale" name="da_hm_default_locale_4">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_4") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of locale', 'dahm') . ' 4.' . '"></div>';

		echo $html;
	}

	public function default_locale_4_validation($input){
		return sanitize_text_field($input);
	}

	//5 ----------------------------------------------------------------------------------------------------------------
	public function default_language_5_callback($args){
		$html = '<select id="da-hm-default-language-5" class="da-hm-default-language" name="da_hm_default_language_5">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_5") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of language', 'dahm') . ' 5.' . '"></div>';
		echo $html;
	}

	public function default_language_5_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_5_callback($args){
		$html = '<select id="da-hm-default-script-5" class="da-hm-default-script" name="da_hm_default_script_5">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_5") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of script', 'dahm') . ' 5.' . '"></div>';

		echo $html;
	}

	public function default_script_5_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_5_callback($args){
		$html = '<select id="da-hm-default-locale-5" class="da-hm-default-locale" name="da_hm_default_locale_5">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_5") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of locale', 'dahm') . ' 5.' . '"></div>';

		echo $html;
	}

	public function default_locale_5_validation($input){
		return sanitize_text_field($input);
	}

	//6 ----------------------------------------------------------------------------------------------------------------
	public function default_language_6_callback($args){
		$html = '<select id="da-hm-default-language-6" class="da-hm-default-language" name="da_hm_default_language_6">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_6") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of language', 'dahm') . ' 6.' . '"></div>';
		echo $html;
	}

	public function default_language_6_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_6_callback($args){
		$html = '<select id="da-hm-default-script-6" class="da-hm-default-script" name="da_hm_default_script_6">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_6") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of script', 'dahm') . ' 6.' . '"></div>';

		echo $html;
	}

	public function default_script_6_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_6_callback($args){
		$html = '<select id="da-hm-default-locale-6" class="da-hm-default-locale" name="da_hm_default_locale_6">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_6") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of locale', 'dahm') . ' 6.' . '"></div>';

		echo $html;
	}

	public function default_locale_6_validation($input){
		return sanitize_text_field($input);
	}

	//7 ----------------------------------------------------------------------------------------------------------------
	public function default_language_7_callback($args){
		$html = '<select id="da-hm-default-language-7" class="da-hm-default-language" name="da_hm_default_language_7">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_7") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of language', 'dahm') . ' 7.' . '"></div>';
		echo $html;
	}

	public function default_language_7_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_7_callback($args){
		$html = '<select id="da-hm-default-script-7" class="da-hm-default-script" name="da_hm_default_script_7">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_7") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of script', 'dahm') . ' 7.' . '"></div>';

		echo $html;
	}

	public function default_script_7_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_7_callback($args){
		$html = '<select id="da-hm-default-locale-7" class="da-hm-default-locale" name="da_hm_default_locale_7">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_7") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of locale', 'dahm') . ' 7.' . '"></div>';

		echo $html;
	}

	public function default_locale_7_validation($input){
		return sanitize_text_field($input);
	}

	//8 ----------------------------------------------------------------------------------------------------------------
	public function default_language_8_callback($args){
		$html = '<select id="da-hm-default-language-8" class="da-hm-default-language" name="da_hm_default_language_8">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_8") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of language', 'dahm') . ' 8.' . '"></div>';
		echo $html;
	}

	public function default_language_8_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_8_callback($args){
		$html = '<select id="da-hm-default-script-8" class="da-hm-default-script" name="da_hm_default_script_8">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_8") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of script', 'dahm') . ' 8.' . '"></div>';

		echo $html;
	}

	public function default_script_8_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_8_callback($args){
		$html = '<select id="da-hm-default-locale-8" class="da-hm-default-locale" name="da_hm_default_locale_8">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_8") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of locale', 'dahm') . ' 8.' . '"></div>';

		echo $html;
	}

	public function default_locale_8_validation($input){
		return sanitize_text_field($input);
	}

	//9 ----------------------------------------------------------------------------------------------------------------
	public function default_language_9_callback($args){
		$html = '<select id="da-hm-default-language-9" class="da-hm-default-language" name="da_hm_default_language_9">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_9") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of language', 'dahm') . ' 9.' . '"></div>';
		echo $html;
	}

	public function default_language_9_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_9_callback($args){
		$html = '<select id="da-hm-default-script-9" class="da-hm-default-script" name="da_hm_default_script_9">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_9") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of script', 'dahm') . ' 9.' . '"></div>';

		echo $html;
	}

	public function default_script_9_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_9_callback($args){
		$html = '<select id="da-hm-default-locale-9" class="da-hm-default-locale" name="da_hm_default_locale_9">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_9") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('This option determines the default value of locale', 'dahm') . ' 9.' . '"></div>';

		echo $html;
	}

	public function default_locale_9_validation($input){
		return sanitize_text_field($input);
	}

	//10 ----------------------------------------------------------------------------------------------------------------
	public function default_language_10_callback($args){
		$html = '<select id="da-hm-default-language-10" class="da-hm-default-language" name="da_hm_default_language_10">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_10") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 10' . '"></div>';
		echo $html;
	}

	public function default_language_10_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_10_callback($args){
		$html = '<select id="da-hm-default-script-10" class="da-hm-default-script" name="da_hm_default_script_10">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_10") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 10' . '"></div>';

		echo $html;
	}

	public function default_script_10_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_10_callback($args){
		$html = '<select id="da-hm-default-locale-10" class="da-hm-default-locale" name="da_hm_default_locale_10">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_10") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 10' . '"></div>';

		echo $html;
	}

	public function default_locale_10_validation($input){
		return sanitize_text_field($input);
	}

	//11 ----------------------------------------------------------------------------------------------------------------
	public function default_language_11_callback($args){
		$html = '<select id="da-hm-default-language-11" class="da-hm-default-language" name="da_hm_default_language_11">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_11") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 11' . '"></div>';
		echo $html;
	}

	public function default_language_11_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_11_callback($args){
		$html = '<select id="da-hm-default-script-11" class="da-hm-default-script" name="da_hm_default_script_11">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_11") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 11' . '"></div>';

		echo $html;
	}

	public function default_script_11_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_11_callback($args){
		$html = '<select id="da-hm-default-locale-11" class="da-hm-default-locale" name="da_hm_default_locale_11">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_11") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 11' . '"></div>';

		echo $html;
	}

	public function default_locale_11_validation($input){
		return sanitize_text_field($input);
	}

	//12 ----------------------------------------------------------------------------------------------------------------
	public function default_language_12_callback($args){
		$html = '<select id="da-hm-default-language-12" class="da-hm-default-language" name="da_hm_default_language_12">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_12") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 12' . '"></div>';
		echo $html;
	}

	public function default_language_12_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_12_callback($args){
		$html = '<select id="da-hm-default-script-12" class="da-hm-default-script" name="da_hm_default_script_12">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_12") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 12' . '"></div>';

		echo $html;
	}

	public function default_script_12_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_12_callback($args){
		$html = '<select id="da-hm-default-locale-12" class="da-hm-default-locale" name="da_hm_default_locale_12">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_12") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 12' . '"></div>';

		echo $html;
	}

	public function default_locale_12_validation($input){
		return sanitize_text_field($input);
	}

	//13 ----------------------------------------------------------------------------------------------------------------
	public function default_language_13_callback($args){
		$html = '<select id="da-hm-default-language-13" class="da-hm-default-language" name="da_hm_default_language_13">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_13") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 13' . '"></div>';
		echo $html;
	}

	public function default_language_13_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_13_callback($args){
		$html = '<select id="da-hm-default-script-13" class="da-hm-default-script" name="da_hm_default_script_13">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_13") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 13' . '"></div>';

		echo $html;
	}

	public function default_script_13_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_13_callback($args){
		$html = '<select id="da-hm-default-locale-13" class="da-hm-default-locale" name="da_hm_default_locale_13">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_13") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 13' . '"></div>';

		echo $html;
	}

	public function default_locale_13_validation($input){
		return sanitize_text_field($input);
	}

	//14 ----------------------------------------------------------------------------------------------------------------
	public function default_language_14_callback($args){
		$html = '<select id="da-hm-default-language-14" class="da-hm-default-language" name="da_hm_default_language_14">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_14") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 14' . '"></div>';
		echo $html;
	}

	public function default_language_14_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_14_callback($args){
		$html = '<select id="da-hm-default-script-14" class="da-hm-default-script" name="da_hm_default_script_14">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_14") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 14' . '"></div>';

		echo $html;
	}

	public function default_script_14_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_14_callback($args){
		$html = '<select id="da-hm-default-locale-14" class="da-hm-default-locale" name="da_hm_default_locale_14">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_14") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 14' . '"></div>';

		echo $html;
	}

	public function default_locale_14_validation($input){
		return sanitize_text_field($input);
	}

	//15 ----------------------------------------------------------------------------------------------------------------
	public function default_language_15_callback($args){
		$html = '<select id="da-hm-default-language-15" class="da-hm-default-language" name="da_hm_default_language_15">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_15") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 15' . '"></div>';
		echo $html;
	}

	public function default_language_15_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_15_callback($args){
		$html = '<select id="da-hm-default-script-15" class="da-hm-default-script" name="da_hm_default_script_15">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_15") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 15' . '"></div>';

		echo $html;
	}

	public function default_script_15_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_15_callback($args){
		$html = '<select id="da-hm-default-locale-15" class="da-hm-default-locale" name="da_hm_default_locale_15">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_15") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 15' . '"></div>';

		echo $html;
	}

	public function default_locale_15_validation($input){
		return sanitize_text_field($input);
	}

	//16 ----------------------------------------------------------------------------------------------------------------
	public function default_language_16_callback($args){
		$html = '<select id="da-hm-default-language-16" class="da-hm-default-language" name="da_hm_default_language_16">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_16") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 16' . '"></div>';
		echo $html;
	}

	public function default_language_16_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_16_callback($args){
		$html = '<select id="da-hm-default-script-16" class="da-hm-default-script" name="da_hm_default_script_16">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_16") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 16' . '"></div>';

		echo $html;
	}

	public function default_script_16_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_16_callback($args){
		$html = '<select id="da-hm-default-locale-16" class="da-hm-default-locale" name="da_hm_default_locale_16">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_16") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 16' . '"></div>';

		echo $html;
	}

	public function default_locale_16_validation($input){
		return sanitize_text_field($input);
	}

	//17 ----------------------------------------------------------------------------------------------------------------
	public function default_language_17_callback($args){
		$html = '<select id="da-hm-default-language-17" class="da-hm-default-language" name="da_hm_default_language_17">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_17") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 17' . '"></div>';
		echo $html;
	}

	public function default_language_17_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_17_callback($args){
		$html = '<select id="da-hm-default-script-17" class="da-hm-default-script" name="da_hm_default_script_17">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_17") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 17' . '"></div>';

		echo $html;
	}

	public function default_script_17_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_17_callback($args){
		$html = '<select id="da-hm-default-locale-17" class="da-hm-default-locale" name="da_hm_default_locale_17">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_17") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 17' . '"></div>';

		echo $html;
	}

	public function default_locale_17_validation($input){
		return sanitize_text_field($input);
	}

	//18 ----------------------------------------------------------------------------------------------------------------
	public function default_language_18_callback($args){
		$html = '<select id="da-hm-default-language-18" class="da-hm-default-language" name="da_hm_default_language_18">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_18") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 18' . '"></div>';
		echo $html;
	}

	public function default_language_18_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_18_callback($args){
		$html = '<select id="da-hm-default-script-18" class="da-hm-default-script" name="da_hm_default_script_18">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_18") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 18' . '"></div>';

		echo $html;
	}

	public function default_script_18_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_18_callback($args){
		$html = '<select id="da-hm-default-locale-18" class="da-hm-default-locale" name="da_hm_default_locale_18">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_18") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 18' . '"></div>';

		echo $html;
	}

	public function default_locale_18_validation($input){
		return sanitize_text_field($input);
	}

	//19 ----------------------------------------------------------------------------------------------------------------
	public function default_language_19_callback($args){
		$html = '<select id="da-hm-default-language-19" class="da-hm-default-language" name="da_hm_default_language_19">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_19") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 19' . '"></div>';
		echo $html;
	}

	public function default_language_19_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_19_callback($args){
		$html = '<select id="da-hm-default-script-19" class="da-hm-default-script" name="da_hm_default_script_19">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_19") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 19' . '"></div>';

		echo $html;
	}

	public function default_script_19_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_19_callback($args){
		$html = '<select id="da-hm-default-locale-19" class="da-hm-default-locale" name="da_hm_default_locale_19">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_19") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 19' . '"></div>';

		echo $html;
	}

	public function default_locale_19_validation($input){
		return sanitize_text_field($input);
	}

	//20 ----------------------------------------------------------------------------------------------------------------
	public function default_language_20_callback($args){
		$html = '<select id="da-hm-default-language-20" class="da-hm-default-language" name="da_hm_default_language_20">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_20") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 20' . '"></div>';
		echo $html;
	}

	public function default_language_20_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_20_callback($args){
		$html = '<select id="da-hm-default-script-20" class="da-hm-default-script" name="da_hm_default_script_20">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_20") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 20' . '"></div>';

		echo $html;
	}

	public function default_script_20_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_20_callback($args){
		$html = '<select id="da-hm-default-locale-20" class="da-hm-default-locale" name="da_hm_default_locale_20">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_20") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 20' . '"></div>';

		echo $html;
	}

	public function default_locale_20_validation($input){
		return sanitize_text_field($input);
	}

	//21 ----------------------------------------------------------------------------------------------------------------
	public function default_language_21_callback($args){
		$html = '<select id="da-hm-default-language-21" class="da-hm-default-language" name="da_hm_default_language_21">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_21") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 21' . '"></div>';
		echo $html;
	}

	public function default_language_21_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_21_callback($args){
		$html = '<select id="da-hm-default-script-21" class="da-hm-default-script" name="da_hm_default_script_21">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_21") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 21' . '"></div>';

		echo $html;
	}

	public function default_script_21_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_21_callback($args){
		$html = '<select id="da-hm-default-locale-21" class="da-hm-default-locale" name="da_hm_default_locale_21">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_21") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 21' . '"></div>';

		echo $html;
	}

	public function default_locale_21_validation($input){
		return sanitize_text_field($input);
	}

	//22 ----------------------------------------------------------------------------------------------------------------
	public function default_language_22_callback($args){
		$html = '<select id="da-hm-default-language-22" class="da-hm-default-language" name="da_hm_default_language_22">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_22") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 22' . '"></div>';
		echo $html;
	}

	public function default_language_22_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_22_callback($args){
		$html = '<select id="da-hm-default-script-22" class="da-hm-default-script" name="da_hm_default_script_22">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_22") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 22' . '"></div>';

		echo $html;
	}

	public function default_script_22_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_22_callback($args){
		$html = '<select id="da-hm-default-locale-22" class="da-hm-default-locale" name="da_hm_default_locale_22">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_22") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 22' . '"></div>';

		echo $html;
	}

	public function default_locale_22_validation($input){
		return sanitize_text_field($input);
	}

	//23 ----------------------------------------------------------------------------------------------------------------
	public function default_language_23_callback($args){
		$html = '<select id="da-hm-default-language-23" class="da-hm-default-language" name="da_hm_default_language_23">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_23") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 23' . '"></div>';
		echo $html;
	}

	public function default_language_23_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_23_callback($args){
		$html = '<select id="da-hm-default-script-23" class="da-hm-default-script" name="da_hm_default_script_23">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_23") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 23' . '"></div>';

		echo $html;
	}

	public function default_script_23_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_23_callback($args){
		$html = '<select id="da-hm-default-locale-23" class="da-hm-default-locale" name="da_hm_default_locale_23">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_23") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 23' . '"></div>';

		echo $html;
	}

	public function default_locale_23_validation($input){
		return sanitize_text_field($input);
	}

	//24 ----------------------------------------------------------------------------------------------------------------
	public function default_language_24_callback($args){
		$html = '<select id="da-hm-default-language-24" class="da-hm-default-language" name="da_hm_default_language_24">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_24") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 24' . '"></div>';
		echo $html;
	}

	public function default_language_24_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_24_callback($args){
		$html = '<select id="da-hm-default-script-24" class="da-hm-default-script" name="da_hm_default_script_24">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_24") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 24' . '"></div>';

		echo $html;
	}

	public function default_script_24_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_24_callback($args){
		$html = '<select id="da-hm-default-locale-24" class="da-hm-default-locale" name="da_hm_default_locale_24">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_24") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 24' . '"></div>';

		echo $html;
	}

	public function default_locale_24_validation($input){
		return sanitize_text_field($input);
	}

	//25 ----------------------------------------------------------------------------------------------------------------
	public function default_language_25_callback($args){
		$html = '<select id="da-hm-default-language-25" class="da-hm-default-language" name="da_hm_default_language_25">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_25") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 25' . '"></div>';
		echo $html;
	}

	public function default_language_25_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_25_callback($args){
		$html = '<select id="da-hm-default-script-25" class="da-hm-default-script" name="da_hm_default_script_25">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_25") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 25' . '"></div>';

		echo $html;
	}

	public function default_script_25_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_25_callback($args){
		$html = '<select id="da-hm-default-locale-25" class="da-hm-default-locale" name="da_hm_default_locale_25">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_25") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 25' . '"></div>';

		echo $html;
	}

	public function default_locale_25_validation($input){
		return sanitize_text_field($input);
	}

	//26 ----------------------------------------------------------------------------------------------------------------
	public function default_language_26_callback($args){
		$html = '<select id="da-hm-default-language-26" class="da-hm-default-language" name="da_hm_default_language_26">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_26") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 26' . '"></div>';
		echo $html;
	}

	public function default_language_26_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_26_callback($args){
		$html = '<select id="da-hm-default-script-26" class="da-hm-default-script" name="da_hm_default_script_26">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_26") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 26' . '"></div>';

		echo $html;
	}

	public function default_script_26_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_26_callback($args){
		$html = '<select id="da-hm-default-locale-26" class="da-hm-default-locale" name="da_hm_default_locale_26">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_26") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 26' . '"></div>';

		echo $html;
	}

	public function default_locale_26_validation($input){
		return sanitize_text_field($input);
	}

	//27 ----------------------------------------------------------------------------------------------------------------
	public function default_language_27_callback($args){
		$html = '<select id="da-hm-default-language-27" class="da-hm-default-language" name="da_hm_default_language_27">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_27") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 27' . '"></div>';
		echo $html;
	}

	public function default_language_27_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_27_callback($args){
		$html = '<select id="da-hm-default-script-27" class="da-hm-default-script" name="da_hm_default_script_27">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_27") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 27' . '"></div>';

		echo $html;
	}

	public function default_script_27_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_27_callback($args){
		$html = '<select id="da-hm-default-locale-27" class="da-hm-default-locale" name="da_hm_default_locale_27">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_27") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 27' . '"></div>';

		echo $html;
	}

	public function default_locale_27_validation($input){
		return sanitize_text_field($input);
	}

	//28 ----------------------------------------------------------------------------------------------------------------
	public function default_language_28_callback($args){
		$html = '<select id="da-hm-default-language-28" class="da-hm-default-language" name="da_hm_default_language_28">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_28") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 28' . '"></div>';
		echo $html;
	}

	public function default_language_28_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_28_callback($args){
		$html = '<select id="da-hm-default-script-28" class="da-hm-default-script" name="da_hm_default_script_28">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_28") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 28' . '"></div>';

		echo $html;
	}

	public function default_script_28_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_28_callback($args){
		$html = '<select id="da-hm-default-locale-28" class="da-hm-default-locale" name="da_hm_default_locale_28">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_28") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 28' . '"></div>';

		echo $html;
	}

	public function default_locale_28_validation($input){
		return sanitize_text_field($input);
	}

	//29 ----------------------------------------------------------------------------------------------------------------
	public function default_language_29_callback($args){
		$html = '<select id="da-hm-default-language-29" class="da-hm-default-language" name="da_hm_default_language_29">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_29") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 29' . '"></div>';
		echo $html;
	}

	public function default_language_29_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_29_callback($args){
		$html = '<select id="da-hm-default-script-29" class="da-hm-default-script" name="da_hm_default_script_29">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_29") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 29' . '"></div>';

		echo $html;
	}

	public function default_script_29_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_29_callback($args){
		$html = '<select id="da-hm-default-locale-29" class="da-hm-default-locale" name="da_hm_default_locale_29">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_29") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 29' . '"></div>';

		echo $html;
	}

	public function default_locale_29_validation($input){
		return sanitize_text_field($input);
	}

	//30 ----------------------------------------------------------------------------------------------------------------
	public function default_language_30_callback($args){
		$html = '<select id="da-hm-default-language-30" class="da-hm-default-language" name="da_hm_default_language_30">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_30") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 30' . '"></div>';
		echo $html;
	}

	public function default_language_30_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_30_callback($args){
		$html = '<select id="da-hm-default-script-30" class="da-hm-default-script" name="da_hm_default_script_30">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_30") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 30' . '"></div>';

		echo $html;
	}

	public function default_script_30_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_30_callback($args){
		$html = '<select id="da-hm-default-locale-30" class="da-hm-default-locale" name="da_hm_default_locale_30">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_30") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 30' . '"></div>';

		echo $html;
	}

	public function default_locale_30_validation($input){
		return sanitize_text_field($input);
	}

	//31 ----------------------------------------------------------------------------------------------------------------
	public function default_language_31_callback($args){
		$html = '<select id="da-hm-default-language-31" class="da-hm-default-language" name="da_hm_default_language_31">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_31") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 31' . '"></div>';
		echo $html;
	}

	public function default_language_31_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_31_callback($args){
		$html = '<select id="da-hm-default-script-31" class="da-hm-default-script" name="da_hm_default_script_31">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_31") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 31' . '"></div>';

		echo $html;
	}

	public function default_script_31_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_31_callback($args){
		$html = '<select id="da-hm-default-locale-31" class="da-hm-default-locale" name="da_hm_default_locale_31">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_31") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 31' . '"></div>';

		echo $html;
	}

	public function default_locale_31_validation($input){
		return sanitize_text_field($input);
	}

	//32 ----------------------------------------------------------------------------------------------------------------
	public function default_language_32_callback($args){
		$html = '<select id="da-hm-default-language-32" class="da-hm-default-language" name="da_hm_default_language_32">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_32") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 32' . '"></div>';
		echo $html;
	}

	public function default_language_32_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_32_callback($args){
		$html = '<select id="da-hm-default-script-32" class="da-hm-default-script" name="da_hm_default_script_32">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_32") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 32' . '"></div>';

		echo $html;
	}

	public function default_script_32_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_32_callback($args){
		$html = '<select id="da-hm-default-locale-32" class="da-hm-default-locale" name="da_hm_default_locale_32">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_32") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 32' . '"></div>';

		echo $html;
	}

	public function default_locale_32_validation($input){
		return sanitize_text_field($input);
	}

	//33 ----------------------------------------------------------------------------------------------------------------
	public function default_language_33_callback($args){
		$html = '<select id="da-hm-default-language-33" class="da-hm-default-language" name="da_hm_default_language_33">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_33") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 33' . '"></div>';
		echo $html;
	}

	public function default_language_33_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_33_callback($args){
		$html = '<select id="da-hm-default-script-33" class="da-hm-default-script" name="da_hm_default_script_33">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_33") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 33' . '"></div>';

		echo $html;
	}

	public function default_script_33_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_33_callback($args){
		$html = '<select id="da-hm-default-locale-33" class="da-hm-default-locale" name="da_hm_default_locale_33">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_33") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 33' . '"></div>';

		echo $html;
	}

	public function default_locale_33_validation($input){
		return sanitize_text_field($input);
	}

	//34 ----------------------------------------------------------------------------------------------------------------
	public function default_language_34_callback($args){
		$html = '<select id="da-hm-default-language-34" class="da-hm-default-language" name="da_hm_default_language_34">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_34") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 34' . '"></div>';
		echo $html;
	}

	public function default_language_34_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_34_callback($args){
		$html = '<select id="da-hm-default-script-34" class="da-hm-default-script" name="da_hm_default_script_34">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_34") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 34' . '"></div>';

		echo $html;
	}

	public function default_script_34_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_34_callback($args){
		$html = '<select id="da-hm-default-locale-34" class="da-hm-default-locale" name="da_hm_default_locale_34">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_34") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 34' . '"></div>';

		echo $html;
	}

	public function default_locale_34_validation($input){
		return sanitize_text_field($input);
	}

	//35 ----------------------------------------------------------------------------------------------------------------
	public function default_language_35_callback($args){
		$html = '<select id="da-hm-default-language-35" class="da-hm-default-language" name="da_hm_default_language_35">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_35") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 35' . '"></div>';
		echo $html;
	}

	public function default_language_35_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_35_callback($args){
		$html = '<select id="da-hm-default-script-35" class="da-hm-default-script" name="da_hm_default_script_35">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_35") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 35' . '"></div>';

		echo $html;
	}

	public function default_script_35_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_35_callback($args){
		$html = '<select id="da-hm-default-locale-35" class="da-hm-default-locale" name="da_hm_default_locale_35">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_35") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 35' . '"></div>';

		echo $html;
	}

	public function default_locale_35_validation($input){
		return sanitize_text_field($input);
	}

	//36 ----------------------------------------------------------------------------------------------------------------
	public function default_language_36_callback($args){
		$html = '<select id="da-hm-default-language-36" class="da-hm-default-language" name="da_hm_default_language_36">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_36") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 36' . '"></div>';
		echo $html;
	}

	public function default_language_36_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_36_callback($args){
		$html = '<select id="da-hm-default-script-36" class="da-hm-default-script" name="da_hm_default_script_36">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_36") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 36' . '"></div>';

		echo $html;
	}

	public function default_script_36_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_36_callback($args){
		$html = '<select id="da-hm-default-locale-36" class="da-hm-default-locale" name="da_hm_default_locale_36">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_36") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 36' . '"></div>';

		echo $html;
	}

	public function default_locale_36_validation($input){
		return sanitize_text_field($input);
	}

	//37 ----------------------------------------------------------------------------------------------------------------
	public function default_language_37_callback($args){
		$html = '<select id="da-hm-default-language-37" class="da-hm-default-language" name="da_hm_default_language_37">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_37") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 37' . '"></div>';
		echo $html;
	}

	public function default_language_37_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_37_callback($args){
		$html = '<select id="da-hm-default-script-37" class="da-hm-default-script" name="da_hm_default_script_37">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_37") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 37' . '"></div>';

		echo $html;
	}

	public function default_script_37_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_37_callback($args){
		$html = '<select id="da-hm-default-locale-37" class="da-hm-default-locale" name="da_hm_default_locale_37">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_37") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 37' . '"></div>';

		echo $html;
	}

	public function default_locale_37_validation($input){
		return sanitize_text_field($input);
	}

	//38 ----------------------------------------------------------------------------------------------------------------
	public function default_language_38_callback($args){
		$html = '<select id="da-hm-default-language-38" class="da-hm-default-language" name="da_hm_default_language_38">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_38") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 38' . '"></div>';
		echo $html;
	}

	public function default_language_38_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_38_callback($args){
		$html = '<select id="da-hm-default-script-38" class="da-hm-default-script" name="da_hm_default_script_38">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_38") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 38' . '"></div>';

		echo $html;
	}

	public function default_script_38_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_38_callback($args){
		$html = '<select id="da-hm-default-locale-38" class="da-hm-default-locale" name="da_hm_default_locale_38">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_38") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 38' . '"></div>';

		echo $html;
	}

	public function default_locale_38_validation($input){
		return sanitize_text_field($input);
	}

	//39 ----------------------------------------------------------------------------------------------------------------
	public function default_language_39_callback($args){
		$html = '<select id="da-hm-default-language-39" class="da-hm-default-language" name="da_hm_default_language_39">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_39") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 39' . '"></div>';
		echo $html;
	}

	public function default_language_39_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_39_callback($args){
		$html = '<select id="da-hm-default-script-39" class="da-hm-default-script" name="da_hm_default_script_39">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_39") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 39' . '"></div>';

		echo $html;
	}

	public function default_script_39_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_39_callback($args){
		$html = '<select id="da-hm-default-locale-39" class="da-hm-default-locale" name="da_hm_default_locale_39">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_39") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 39' . '"></div>';

		echo $html;
	}

	public function default_locale_39_validation($input){
		return sanitize_text_field($input);
	}

	//40 ----------------------------------------------------------------------------------------------------------------
	public function default_language_40_callback($args){
		$html = '<select id="da-hm-default-language-40" class="da-hm-default-language" name="da_hm_default_language_40">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_40") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 40' . '"></div>';
		echo $html;
	}

	public function default_language_40_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_40_callback($args){
		$html = '<select id="da-hm-default-script-40" class="da-hm-default-script" name="da_hm_default_script_40">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_40") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 40' . '"></div>';

		echo $html;
	}

	public function default_script_40_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_40_callback($args){
		$html = '<select id="da-hm-default-locale-40" class="da-hm-default-locale" name="da_hm_default_locale_40">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_40") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 40' . '"></div>';

		echo $html;
	}

	public function default_locale_40_validation($input){
		return sanitize_text_field($input);
	}

	//41 ----------------------------------------------------------------------------------------------------------------
	public function default_language_41_callback($args){
		$html = '<select id="da-hm-default-language-41" class="da-hm-default-language" name="da_hm_default_language_41">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_41") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 41' . '"></div>';
		echo $html;
	}

	public function default_language_41_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_41_callback($args){
		$html = '<select id="da-hm-default-script-41" class="da-hm-default-script" name="da_hm_default_script_41">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_41") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 41' . '"></div>';

		echo $html;
	}

	public function default_script_41_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_41_callback($args){
		$html = '<select id="da-hm-default-locale-41" class="da-hm-default-locale" name="da_hm_default_locale_41">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_41") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 41' . '"></div>';

		echo $html;
	}

	public function default_locale_41_validation($input){
		return sanitize_text_field($input);
	}

	//42 ----------------------------------------------------------------------------------------------------------------
	public function default_language_42_callback($args){
		$html = '<select id="da-hm-default-language-42" class="da-hm-default-language" name="da_hm_default_language_42">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_42") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 42' . '"></div>';
		echo $html;
	}

	public function default_language_42_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_42_callback($args){
		$html = '<select id="da-hm-default-script-42" class="da-hm-default-script" name="da_hm_default_script_42">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_42") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 42' . '"></div>';

		echo $html;
	}

	public function default_script_42_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_42_callback($args){
		$html = '<select id="da-hm-default-locale-42" class="da-hm-default-locale" name="da_hm_default_locale_42">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_42") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 42' . '"></div>';

		echo $html;
	}

	public function default_locale_42_validation($input){
		return sanitize_text_field($input);
	}

	//43 ----------------------------------------------------------------------------------------------------------------
	public function default_language_43_callback($args){
		$html = '<select id="da-hm-default-language-43" class="da-hm-default-language" name="da_hm_default_language_43">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_43") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 43' . '"></div>';
		echo $html;
	}

	public function default_language_43_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_43_callback($args){
		$html = '<select id="da-hm-default-script-43" class="da-hm-default-script" name="da_hm_default_script_43">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_43") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 43' . '"></div>';

		echo $html;
	}

	public function default_script_43_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_43_callback($args){
		$html = '<select id="da-hm-default-locale-43" class="da-hm-default-locale" name="da_hm_default_locale_43">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_43") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 43' . '"></div>';

		echo $html;
	}

	public function default_locale_43_validation($input){
		return sanitize_text_field($input);
	}

	//44 ----------------------------------------------------------------------------------------------------------------
	public function default_language_44_callback($args){
		$html = '<select id="da-hm-default-language-44" class="da-hm-default-language" name="da_hm_default_language_44">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_44") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 44' . '"></div>';
		echo $html;
	}

	public function default_language_44_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_44_callback($args){
		$html = '<select id="da-hm-default-script-44" class="da-hm-default-script" name="da_hm_default_script_44">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_44") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 44' . '"></div>';

		echo $html;
	}

	public function default_script_44_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_44_callback($args){
		$html = '<select id="da-hm-default-locale-44" class="da-hm-default-locale" name="da_hm_default_locale_44">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_44") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 44' . '"></div>';

		echo $html;
	}

	public function default_locale_44_validation($input){
		return sanitize_text_field($input);
	}

	//45 ----------------------------------------------------------------------------------------------------------------
	public function default_language_45_callback($args){
		$html = '<select id="da-hm-default-language-45" class="da-hm-default-language" name="da_hm_default_language_45">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_45") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 45' . '"></div>';
		echo $html;
	}

	public function default_language_45_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_45_callback($args){
		$html = '<select id="da-hm-default-script-45" class="da-hm-default-script" name="da_hm_default_script_45">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_45") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 45' . '"></div>';

		echo $html;
	}

	public function default_script_45_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_45_callback($args){
		$html = '<select id="da-hm-default-locale-45" class="da-hm-default-locale" name="da_hm_default_locale_45">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_45") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 45' . '"></div>';

		echo $html;
	}

	public function default_locale_45_validation($input){
		return sanitize_text_field($input);
	}

	//46 ----------------------------------------------------------------------------------------------------------------
	public function default_language_46_callback($args){
		$html = '<select id="da-hm-default-language-46" class="da-hm-default-language" name="da_hm_default_language_46">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_46") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 46' . '"></div>';
		echo $html;
	}

	public function default_language_46_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_46_callback($args){
		$html = '<select id="da-hm-default-script-46" class="da-hm-default-script" name="da_hm_default_script_46">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_46") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 46' . '"></div>';

		echo $html;
	}

	public function default_script_46_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_46_callback($args){
		$html = '<select id="da-hm-default-locale-46" class="da-hm-default-locale" name="da_hm_default_locale_46">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_46") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 46' . '"></div>';

		echo $html;
	}

	public function default_locale_46_validation($input){
		return sanitize_text_field($input);
	}

	//47 ----------------------------------------------------------------------------------------------------------------
	public function default_language_47_callback($args){
		$html = '<select id="da-hm-default-language-47" class="da-hm-default-language" name="da_hm_default_language_47">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_47") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 47' . '"></div>';
		echo $html;
	}

	public function default_language_47_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_47_callback($args){
		$html = '<select id="da-hm-default-script-47" class="da-hm-default-script" name="da_hm_default_script_47">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_47") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 47' . '"></div>';

		echo $html;
	}

	public function default_script_47_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_47_callback($args){
		$html = '<select id="da-hm-default-locale-47" class="da-hm-default-locale" name="da_hm_default_locale_47">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_47") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 47' . '"></div>';

		echo $html;
	}

	public function default_locale_47_validation($input){
		return sanitize_text_field($input);
	}

	//48 ----------------------------------------------------------------------------------------------------------------
	public function default_language_48_callback($args){
		$html = '<select id="da-hm-default-language-48" class="da-hm-default-language" name="da_hm_default_language_48">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_48") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 48' . '"></div>';
		echo $html;
	}

	public function default_language_48_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_48_callback($args){
		$html = '<select id="da-hm-default-script-48" class="da-hm-default-script" name="da_hm_default_script_48">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_48") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 48' . '"></div>';

		echo $html;
	}

	public function default_script_48_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_48_callback($args){
		$html = '<select id="da-hm-default-locale-48" class="da-hm-default-locale" name="da_hm_default_locale_48">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_48") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 48' . '"></div>';

		echo $html;
	}

	public function default_locale_48_validation($input){
		return sanitize_text_field($input);
	}

	//49 ----------------------------------------------------------------------------------------------------------------
	public function default_language_49_callback($args){
		$html = '<select id="da-hm-default-language-49" class="da-hm-default-language" name="da_hm_default_language_49">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_49") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 49' . '"></div>';
		echo $html;
	}

	public function default_language_49_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_49_callback($args){
		$html = '<select id="da-hm-default-script-49" class="da-hm-default-script" name="da_hm_default_script_49">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_49") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 49' . '"></div>';

		echo $html;
	}

	public function default_script_49_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_49_callback($args){
		$html = '<select id="da-hm-default-locale-49" class="da-hm-default-locale" name="da_hm_default_locale_49">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_49") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 49' . '"></div>';

		echo $html;
	}

	public function default_locale_49_validation($input){
		return sanitize_text_field($input);
	}

	//50 ----------------------------------------------------------------------------------------------------------------
	public function default_language_50_callback($args){
		$html = '<select id="da-hm-default-language-50" class="da-hm-default-language" name="da_hm_default_language_50">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_50") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 50' . '"></div>';
		echo $html;
	}

	public function default_language_50_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_50_callback($args){
		$html = '<select id="da-hm-default-script-50" class="da-hm-default-script" name="da_hm_default_script_50">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_50") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 50' . '"></div>';

		echo $html;
	}

	public function default_script_50_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_50_callback($args){
		$html = '<select id="da-hm-default-locale-50" class="da-hm-default-locale" name="da_hm_default_locale_50">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_50") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 50' . '"></div>';

		echo $html;
	}

	public function default_locale_50_validation($input){
		return sanitize_text_field($input);
	}

	//51 ----------------------------------------------------------------------------------------------------------------
	public function default_language_51_callback($args){
		$html = '<select id="da-hm-default-language-51" class="da-hm-default-language" name="da_hm_default_language_51">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_51") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 51' . '"></div>';
		echo $html;
	}

	public function default_language_51_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_51_callback($args){
		$html = '<select id="da-hm-default-script-51" class="da-hm-default-script" name="da_hm_default_script_51">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_51") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 51' . '"></div>';

		echo $html;
	}

	public function default_script_51_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_51_callback($args){
		$html = '<select id="da-hm-default-locale-51" class="da-hm-default-locale" name="da_hm_default_locale_51">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_51") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 51' . '"></div>';

		echo $html;
	}

	public function default_locale_51_validation($input){
		return sanitize_text_field($input);
	}

	//52 ----------------------------------------------------------------------------------------------------------------
	public function default_language_52_callback($args){
		$html = '<select id="da-hm-default-language-52" class="da-hm-default-language" name="da_hm_default_language_52">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_52") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 52' . '"></div>';
		echo $html;
	}

	public function default_language_52_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_52_callback($args){
		$html = '<select id="da-hm-default-script-52" class="da-hm-default-script" name="da_hm_default_script_52">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_52") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 52' . '"></div>';

		echo $html;
	}

	public function default_script_52_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_52_callback($args){
		$html = '<select id="da-hm-default-locale-52" class="da-hm-default-locale" name="da_hm_default_locale_52">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_52") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 52' . '"></div>';

		echo $html;
	}

	public function default_locale_52_validation($input){
		return sanitize_text_field($input);
	}

	//53 ----------------------------------------------------------------------------------------------------------------
	public function default_language_53_callback($args){
		$html = '<select id="da-hm-default-language-53" class="da-hm-default-language" name="da_hm_default_language_53">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_53") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 53' . '"></div>';
		echo $html;
	}

	public function default_language_53_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_53_callback($args){
		$html = '<select id="da-hm-default-script-53" class="da-hm-default-script" name="da_hm_default_script_53">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_53") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 53' . '"></div>';

		echo $html;
	}

	public function default_script_53_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_53_callback($args){
		$html = '<select id="da-hm-default-locale-53" class="da-hm-default-locale" name="da_hm_default_locale_53">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_53") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 53' . '"></div>';

		echo $html;
	}

	public function default_locale_53_validation($input){
		return sanitize_text_field($input);
	}

	//54 ----------------------------------------------------------------------------------------------------------------
	public function default_language_54_callback($args){
		$html = '<select id="da-hm-default-language-54" class="da-hm-default-language" name="da_hm_default_language_54">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_54") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 54' . '"></div>';
		echo $html;
	}

	public function default_language_54_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_54_callback($args){
		$html = '<select id="da-hm-default-script-54" class="da-hm-default-script" name="da_hm_default_script_54">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_54") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 54' . '"></div>';

		echo $html;
	}

	public function default_script_54_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_54_callback($args){
		$html = '<select id="da-hm-default-locale-54" class="da-hm-default-locale" name="da_hm_default_locale_54">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_54") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 54' . '"></div>';

		echo $html;
	}

	public function default_locale_54_validation($input){
		return sanitize_text_field($input);
	}

	//55 ----------------------------------------------------------------------------------------------------------------
	public function default_language_55_callback($args){
		$html = '<select id="da-hm-default-language-55" class="da-hm-default-language" name="da_hm_default_language_55">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_55") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 55' . '"></div>';
		echo $html;
	}

	public function default_language_55_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_55_callback($args){
		$html = '<select id="da-hm-default-script-55" class="da-hm-default-script" name="da_hm_default_script_55">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_55") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 55' . '"></div>';

		echo $html;
	}

	public function default_script_55_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_55_callback($args){
		$html = '<select id="da-hm-default-locale-55" class="da-hm-default-locale" name="da_hm_default_locale_55">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_55") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 55' . '"></div>';

		echo $html;
	}

	public function default_locale_55_validation($input){
		return sanitize_text_field($input);
	}

	//56 ----------------------------------------------------------------------------------------------------------------
	public function default_language_56_callback($args){
		$html = '<select id="da-hm-default-language-56" class="da-hm-default-language" name="da_hm_default_language_56">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_56") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 56' . '"></div>';
		echo $html;
	}

	public function default_language_56_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_56_callback($args){
		$html = '<select id="da-hm-default-script-56" class="da-hm-default-script" name="da_hm_default_script_56">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_56") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 56' . '"></div>';

		echo $html;
	}

	public function default_script_56_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_56_callback($args){
		$html = '<select id="da-hm-default-locale-56" class="da-hm-default-locale" name="da_hm_default_locale_56">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_56") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 56' . '"></div>';

		echo $html;
	}

	public function default_locale_56_validation($input){
		return sanitize_text_field($input);
	}

	//57 ----------------------------------------------------------------------------------------------------------------
	public function default_language_57_callback($args){
		$html = '<select id="da-hm-default-language-57" class="da-hm-default-language" name="da_hm_default_language_57">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_57") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 57' . '"></div>';
		echo $html;
	}

	public function default_language_57_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_57_callback($args){
		$html = '<select id="da-hm-default-script-57" class="da-hm-default-script" name="da_hm_default_script_57">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_57") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 57' . '"></div>';

		echo $html;
	}

	public function default_script_57_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_57_callback($args){
		$html = '<select id="da-hm-default-locale-57" class="da-hm-default-locale" name="da_hm_default_locale_57">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_57") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 57' . '"></div>';

		echo $html;
	}

	public function default_locale_57_validation($input){
		return sanitize_text_field($input);
	}

	//58 ----------------------------------------------------------------------------------------------------------------
	public function default_language_58_callback($args){
		$html = '<select id="da-hm-default-language-58" class="da-hm-default-language" name="da_hm_default_language_58">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_58") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 58' . '"></div>';
		echo $html;
	}

	public function default_language_58_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_58_callback($args){
		$html = '<select id="da-hm-default-script-58" class="da-hm-default-script" name="da_hm_default_script_58">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_58") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 58' . '"></div>';

		echo $html;
	}

	public function default_script_58_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_58_callback($args){
		$html = '<select id="da-hm-default-locale-58" class="da-hm-default-locale" name="da_hm_default_locale_58">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_58") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 58' . '"></div>';

		echo $html;
	}

	public function default_locale_58_validation($input){
		return sanitize_text_field($input);
	}

	//59 ----------------------------------------------------------------------------------------------------------------
	public function default_language_59_callback($args){
		$html = '<select id="da-hm-default-language-59" class="da-hm-default-language" name="da_hm_default_language_59">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_59") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 59' . '"></div>';
		echo $html;
	}

	public function default_language_59_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_59_callback($args){
		$html = '<select id="da-hm-default-script-59" class="da-hm-default-script" name="da_hm_default_script_59">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_59") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 59' . '"></div>';

		echo $html;
	}

	public function default_script_59_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_59_callback($args){
		$html = '<select id="da-hm-default-locale-59" class="da-hm-default-locale" name="da_hm_default_locale_59">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_59") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 59' . '"></div>';

		echo $html;
	}

	public function default_locale_59_validation($input){
		return sanitize_text_field($input);
	}

	//60 ----------------------------------------------------------------------------------------------------------------
	public function default_language_60_callback($args){
		$html = '<select id="da-hm-default-language-60" class="da-hm-default-language" name="da_hm_default_language_60">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_60") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 60' . '"></div>';
		echo $html;
	}

	public function default_language_60_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_60_callback($args){
		$html = '<select id="da-hm-default-script-60" class="da-hm-default-script" name="da_hm_default_script_60">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_60") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 60' . '"></div>';

		echo $html;
	}

	public function default_script_60_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_60_callback($args){
		$html = '<select id="da-hm-default-locale-60" class="da-hm-default-locale" name="da_hm_default_locale_60">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_60") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 60' . '"></div>';

		echo $html;
	}

	public function default_locale_60_validation($input){
		return sanitize_text_field($input);
	}

	//61 ----------------------------------------------------------------------------------------------------------------
	public function default_language_61_callback($args){
		$html = '<select id="da-hm-default-language-61" class="da-hm-default-language" name="da_hm_default_language_61">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_61") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 61' . '"></div>';
		echo $html;
	}

	public function default_language_61_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_61_callback($args){
		$html = '<select id="da-hm-default-script-61" class="da-hm-default-script" name="da_hm_default_script_61">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_61") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 61' . '"></div>';

		echo $html;
	}

	public function default_script_61_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_61_callback($args){
		$html = '<select id="da-hm-default-locale-61" class="da-hm-default-locale" name="da_hm_default_locale_61">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_61") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 61' . '"></div>';

		echo $html;
	}

	public function default_locale_61_validation($input){
		return sanitize_text_field($input);
	}

	//62 ----------------------------------------------------------------------------------------------------------------
	public function default_language_62_callback($args){
		$html = '<select id="da-hm-default-language-62" class="da-hm-default-language" name="da_hm_default_language_62">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_62") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 62' . '"></div>';
		echo $html;
	}

	public function default_language_62_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_62_callback($args){
		$html = '<select id="da-hm-default-script-62" class="da-hm-default-script" name="da_hm_default_script_62">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_62") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 62' . '"></div>';

		echo $html;
	}

	public function default_script_62_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_62_callback($args){
		$html = '<select id="da-hm-default-locale-62" class="da-hm-default-locale" name="da_hm_default_locale_62">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_62") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 62' . '"></div>';

		echo $html;
	}

	public function default_locale_62_validation($input){
		return sanitize_text_field($input);
	}

	//63 ----------------------------------------------------------------------------------------------------------------
	public function default_language_63_callback($args){
		$html = '<select id="da-hm-default-language-63" class="da-hm-default-language" name="da_hm_default_language_63">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_63") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 63' . '"></div>';
		echo $html;
	}

	public function default_language_63_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_63_callback($args){
		$html = '<select id="da-hm-default-script-63" class="da-hm-default-script" name="da_hm_default_script_63">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_63") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 63' . '"></div>';

		echo $html;
	}

	public function default_script_63_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_63_callback($args){
		$html = '<select id="da-hm-default-locale-63" class="da-hm-default-locale" name="da_hm_default_locale_63">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_63") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 63' . '"></div>';

		echo $html;
	}

	public function default_locale_63_validation($input){
		return sanitize_text_field($input);
	}

	//64 ----------------------------------------------------------------------------------------------------------------
	public function default_language_64_callback($args){
		$html = '<select id="da-hm-default-language-64" class="da-hm-default-language" name="da_hm_default_language_64">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_64") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 64' . '"></div>';
		echo $html;
	}

	public function default_language_64_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_64_callback($args){
		$html = '<select id="da-hm-default-script-64" class="da-hm-default-script" name="da_hm_default_script_64">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_64") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 64' . '"></div>';

		echo $html;
	}

	public function default_script_64_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_64_callback($args){
		$html = '<select id="da-hm-default-locale-64" class="da-hm-default-locale" name="da_hm_default_locale_64">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_64") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 64' . '"></div>';

		echo $html;
	}

	public function default_locale_64_validation($input){
		return sanitize_text_field($input);
	}

	//65 ----------------------------------------------------------------------------------------------------------------
	public function default_language_65_callback($args){
		$html = '<select id="da-hm-default-language-65" class="da-hm-default-language" name="da_hm_default_language_65">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_65") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 65' . '"></div>';
		echo $html;
	}

	public function default_language_65_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_65_callback($args){
		$html = '<select id="da-hm-default-script-65" class="da-hm-default-script" name="da_hm_default_script_65">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_65") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 65' . '"></div>';

		echo $html;
	}

	public function default_script_65_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_65_callback($args){
		$html = '<select id="da-hm-default-locale-65" class="da-hm-default-locale" name="da_hm_default_locale_65">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_65") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 65' . '"></div>';

		echo $html;
	}

	public function default_locale_65_validation($input){
		return sanitize_text_field($input);
	}

	//66 ----------------------------------------------------------------------------------------------------------------
	public function default_language_66_callback($args){
		$html = '<select id="da-hm-default-language-66" class="da-hm-default-language" name="da_hm_default_language_66">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_66") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 66' . '"></div>';
		echo $html;
	}

	public function default_language_66_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_66_callback($args){
		$html = '<select id="da-hm-default-script-66" class="da-hm-default-script" name="da_hm_default_script_66">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_66") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 66' . '"></div>';

		echo $html;
	}

	public function default_script_66_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_66_callback($args){
		$html = '<select id="da-hm-default-locale-66" class="da-hm-default-locale" name="da_hm_default_locale_66">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_66") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 66' . '"></div>';

		echo $html;
	}

	public function default_locale_66_validation($input){
		return sanitize_text_field($input);
	}

	//67 ----------------------------------------------------------------------------------------------------------------
	public function default_language_67_callback($args){
		$html = '<select id="da-hm-default-language-67" class="da-hm-default-language" name="da_hm_default_language_67">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_67") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 67' . '"></div>';
		echo $html;
	}

	public function default_language_67_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_67_callback($args){
		$html = '<select id="da-hm-default-script-67" class="da-hm-default-script" name="da_hm_default_script_67">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_67") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 67' . '"></div>';

		echo $html;
	}

	public function default_script_67_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_67_callback($args){
		$html = '<select id="da-hm-default-locale-67" class="da-hm-default-locale" name="da_hm_default_locale_67">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_67") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 67' . '"></div>';

		echo $html;
	}

	public function default_locale_67_validation($input){
		return sanitize_text_field($input);
	}

	//68 ----------------------------------------------------------------------------------------------------------------
	public function default_language_68_callback($args){
		$html = '<select id="da-hm-default-language-68" class="da-hm-default-language" name="da_hm_default_language_68">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_68") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 68' . '"></div>';
		echo $html;
	}

	public function default_language_68_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_68_callback($args){
		$html = '<select id="da-hm-default-script-68" class="da-hm-default-script" name="da_hm_default_script_68">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_68") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 68' . '"></div>';

		echo $html;
	}

	public function default_script_68_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_68_callback($args){
		$html = '<select id="da-hm-default-locale-68" class="da-hm-default-locale" name="da_hm_default_locale_68">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_68") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 68' . '"></div>';

		echo $html;
	}

	public function default_locale_68_validation($input){
		return sanitize_text_field($input);
	}

	//69 ----------------------------------------------------------------------------------------------------------------
	public function default_language_69_callback($args){
		$html = '<select id="da-hm-default-language-69" class="da-hm-default-language" name="da_hm_default_language_69">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_69") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 69' . '"></div>';
		echo $html;
	}

	public function default_language_69_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_69_callback($args){
		$html = '<select id="da-hm-default-script-69" class="da-hm-default-script" name="da_hm_default_script_69">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_69") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 69' . '"></div>';

		echo $html;
	}

	public function default_script_69_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_69_callback($args){
		$html = '<select id="da-hm-default-locale-69" class="da-hm-default-locale" name="da_hm_default_locale_69">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_69") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 69' . '"></div>';

		echo $html;
	}

	public function default_locale_69_validation($input){
		return sanitize_text_field($input);
	}

	//70 ----------------------------------------------------------------------------------------------------------------
	public function default_language_70_callback($args){
		$html = '<select id="da-hm-default-language-70" class="da-hm-default-language" name="da_hm_default_language_70">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_70") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 70' . '"></div>';
		echo $html;
	}

	public function default_language_70_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_70_callback($args){
		$html = '<select id="da-hm-default-script-70" class="da-hm-default-script" name="da_hm_default_script_70">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_70") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 70' . '"></div>';

		echo $html;
	}

	public function default_script_70_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_70_callback($args){
		$html = '<select id="da-hm-default-locale-70" class="da-hm-default-locale" name="da_hm_default_locale_70">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_70") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 70' . '"></div>';

		echo $html;
	}

	public function default_locale_70_validation($input){
		return sanitize_text_field($input);
	}

	//71 ----------------------------------------------------------------------------------------------------------------
	public function default_language_71_callback($args){
		$html = '<select id="da-hm-default-language-71" class="da-hm-default-language" name="da_hm_default_language_71">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_71") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 71' . '"></div>';
		echo $html;
	}

	public function default_language_71_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_71_callback($args){
		$html = '<select id="da-hm-default-script-71" class="da-hm-default-script" name="da_hm_default_script_71">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_71") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 71' . '"></div>';

		echo $html;
	}

	public function default_script_71_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_71_callback($args){
		$html = '<select id="da-hm-default-locale-71" class="da-hm-default-locale" name="da_hm_default_locale_71">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_71") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 71' . '"></div>';

		echo $html;
	}

	public function default_locale_71_validation($input){
		return sanitize_text_field($input);
	}

	//72 ----------------------------------------------------------------------------------------------------------------
	public function default_language_72_callback($args){
		$html = '<select id="da-hm-default-language-72" class="da-hm-default-language" name="da_hm_default_language_72">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_72") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 72' . '"></div>';
		echo $html;
	}

	public function default_language_72_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_72_callback($args){
		$html = '<select id="da-hm-default-script-72" class="da-hm-default-script" name="da_hm_default_script_72">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_72") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 72' . '"></div>';

		echo $html;
	}

	public function default_script_72_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_72_callback($args){
		$html = '<select id="da-hm-default-locale-72" class="da-hm-default-locale" name="da_hm_default_locale_72">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_72") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 72' . '"></div>';

		echo $html;
	}

	public function default_locale_72_validation($input){
		return sanitize_text_field($input);
	}

	//73 ----------------------------------------------------------------------------------------------------------------
	public function default_language_73_callback($args){
		$html = '<select id="da-hm-default-language-73" class="da-hm-default-language" name="da_hm_default_language_73">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_73") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 73' . '"></div>';
		echo $html;
	}

	public function default_language_73_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_73_callback($args){
		$html = '<select id="da-hm-default-script-73" class="da-hm-default-script" name="da_hm_default_script_73">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_73") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 73' . '"></div>';

		echo $html;
	}

	public function default_script_73_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_73_callback($args){
		$html = '<select id="da-hm-default-locale-73" class="da-hm-default-locale" name="da_hm_default_locale_73">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_73") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 73' . '"></div>';

		echo $html;
	}

	public function default_locale_73_validation($input){
		return sanitize_text_field($input);
	}

	//74 ----------------------------------------------------------------------------------------------------------------
	public function default_language_74_callback($args){
		$html = '<select id="da-hm-default-language-74" class="da-hm-default-language" name="da_hm_default_language_74">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_74") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 74' . '"></div>';
		echo $html;
	}

	public function default_language_74_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_74_callback($args){
		$html = '<select id="da-hm-default-script-74" class="da-hm-default-script" name="da_hm_default_script_74">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_74") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 74' . '"></div>';

		echo $html;
	}

	public function default_script_74_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_74_callback($args){
		$html = '<select id="da-hm-default-locale-74" class="da-hm-default-locale" name="da_hm_default_locale_74">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_74") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 74' . '"></div>';

		echo $html;
	}

	public function default_locale_74_validation($input){
		return sanitize_text_field($input);
	}

	//75 ----------------------------------------------------------------------------------------------------------------
	public function default_language_75_callback($args){
		$html = '<select id="da-hm-default-language-75" class="da-hm-default-language" name="da_hm_default_language_75">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_75") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 75' . '"></div>';
		echo $html;
	}

	public function default_language_75_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_75_callback($args){
		$html = '<select id="da-hm-default-script-75" class="da-hm-default-script" name="da_hm_default_script_75">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_75") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 75' . '"></div>';

		echo $html;
	}

	public function default_script_75_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_75_callback($args){
		$html = '<select id="da-hm-default-locale-75" class="da-hm-default-locale" name="da_hm_default_locale_75">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_75") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 75' . '"></div>';

		echo $html;
	}

	public function default_locale_75_validation($input){
		return sanitize_text_field($input);
	}

	//76 ----------------------------------------------------------------------------------------------------------------
	public function default_language_76_callback($args){
		$html = '<select id="da-hm-default-language-76" class="da-hm-default-language" name="da_hm_default_language_76">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_76") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 76' . '"></div>';
		echo $html;
	}

	public function default_language_76_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_76_callback($args){
		$html = '<select id="da-hm-default-script-76" class="da-hm-default-script" name="da_hm_default_script_76">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_76") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 76' . '"></div>';

		echo $html;
	}

	public function default_script_76_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_76_callback($args){
		$html = '<select id="da-hm-default-locale-76" class="da-hm-default-locale" name="da_hm_default_locale_76">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_76") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 76' . '"></div>';

		echo $html;
	}

	public function default_locale_76_validation($input){
		return sanitize_text_field($input);
	}

	//77 ----------------------------------------------------------------------------------------------------------------
	public function default_language_77_callback($args){
		$html = '<select id="da-hm-default-language-77" class="da-hm-default-language" name="da_hm_default_language_77">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_77") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 77' . '"></div>';
		echo $html;
	}

	public function default_language_77_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_77_callback($args){
		$html = '<select id="da-hm-default-script-77" class="da-hm-default-script" name="da_hm_default_script_77">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_77") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 77' . '"></div>';

		echo $html;
	}

	public function default_script_77_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_77_callback($args){
		$html = '<select id="da-hm-default-locale-77" class="da-hm-default-locale" name="da_hm_default_locale_77">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_77") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 77' . '"></div>';

		echo $html;
	}

	public function default_locale_77_validation($input){
		return sanitize_text_field($input);
	}

	//78 ----------------------------------------------------------------------------------------------------------------
	public function default_language_78_callback($args){
		$html = '<select id="da-hm-default-language-78" class="da-hm-default-language" name="da_hm_default_language_78">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_78") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 78' . '"></div>';
		echo $html;
	}

	public function default_language_78_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_78_callback($args){
		$html = '<select id="da-hm-default-script-78" class="da-hm-default-script" name="da_hm_default_script_78">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_78") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 78' . '"></div>';

		echo $html;
	}

	public function default_script_78_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_78_callback($args){
		$html = '<select id="da-hm-default-locale-78" class="da-hm-default-locale" name="da_hm_default_locale_78">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_78") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 78' . '"></div>';

		echo $html;
	}

	public function default_locale_78_validation($input){
		return sanitize_text_field($input);
	}

	//79 ----------------------------------------------------------------------------------------------------------------
	public function default_language_79_callback($args){
		$html = '<select id="da-hm-default-language-79" class="da-hm-default-language" name="da_hm_default_language_79">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_79") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 79' . '"></div>';
		echo $html;
	}

	public function default_language_79_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_79_callback($args){
		$html = '<select id="da-hm-default-script-79" class="da-hm-default-script" name="da_hm_default_script_79">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_79") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 79' . '"></div>';

		echo $html;
	}

	public function default_script_79_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_79_callback($args){
		$html = '<select id="da-hm-default-locale-79" class="da-hm-default-locale" name="da_hm_default_locale_79">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_79") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 79' . '"></div>';

		echo $html;
	}

	public function default_locale_79_validation($input){
		return sanitize_text_field($input);
	}

	//80 ----------------------------------------------------------------------------------------------------------------
	public function default_language_80_callback($args){
		$html = '<select id="da-hm-default-language-80" class="da-hm-default-language" name="da_hm_default_language_80">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_80") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 80' . '"></div>';
		echo $html;
	}

	public function default_language_80_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_80_callback($args){
		$html = '<select id="da-hm-default-script-80" class="da-hm-default-script" name="da_hm_default_script_80">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_80") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 80' . '"></div>';

		echo $html;
	}

	public function default_script_80_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_80_callback($args){
		$html = '<select id="da-hm-default-locale-80" class="da-hm-default-locale" name="da_hm_default_locale_80">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_80") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 80' . '"></div>';

		echo $html;
	}

	public function default_locale_80_validation($input){
		return sanitize_text_field($input);
	}

	//81 ----------------------------------------------------------------------------------------------------------------
	public function default_language_81_callback($args){
		$html = '<select id="da-hm-default-language-81" class="da-hm-default-language" name="da_hm_default_language_81">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_81") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 81' . '"></div>';
		echo $html;
	}

	public function default_language_81_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_81_callback($args){
		$html = '<select id="da-hm-default-script-81" class="da-hm-default-script" name="da_hm_default_script_81">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_81") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 81' . '"></div>';

		echo $html;
	}

	public function default_script_81_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_81_callback($args){
		$html = '<select id="da-hm-default-locale-81" class="da-hm-default-locale" name="da_hm_default_locale_81">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_81") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 81' . '"></div>';

		echo $html;
	}

	public function default_locale_81_validation($input){
		return sanitize_text_field($input);
	}

	//82 ----------------------------------------------------------------------------------------------------------------
	public function default_language_82_callback($args){
		$html = '<select id="da-hm-default-language-82" class="da-hm-default-language" name="da_hm_default_language_82">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_82") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 82' . '"></div>';
		echo $html;
	}

	public function default_language_82_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_82_callback($args){
		$html = '<select id="da-hm-default-script-82" class="da-hm-default-script" name="da_hm_default_script_82">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_82") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 82' . '"></div>';

		echo $html;
	}

	public function default_script_82_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_82_callback($args){
		$html = '<select id="da-hm-default-locale-82" class="da-hm-default-locale" name="da_hm_default_locale_82">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_82") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 82' . '"></div>';

		echo $html;
	}

	public function default_locale_82_validation($input){
		return sanitize_text_field($input);
	}

	//83 ----------------------------------------------------------------------------------------------------------------
	public function default_language_83_callback($args){
		$html = '<select id="da-hm-default-language-83" class="da-hm-default-language" name="da_hm_default_language_83">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_83") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 83' . '"></div>';
		echo $html;
	}

	public function default_language_83_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_83_callback($args){
		$html = '<select id="da-hm-default-script-83" class="da-hm-default-script" name="da_hm_default_script_83">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_83") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 83' . '"></div>';

		echo $html;
	}

	public function default_script_83_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_83_callback($args){
		$html = '<select id="da-hm-default-locale-83" class="da-hm-default-locale" name="da_hm_default_locale_83">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_83") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 83' . '"></div>';

		echo $html;
	}

	public function default_locale_83_validation($input){
		return sanitize_text_field($input);
	}

	//84 ----------------------------------------------------------------------------------------------------------------
	public function default_language_84_callback($args){
		$html = '<select id="da-hm-default-language-84" class="da-hm-default-language" name="da_hm_default_language_84">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_84") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 84' . '"></div>';
		echo $html;
	}

	public function default_language_84_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_84_callback($args){
		$html = '<select id="da-hm-default-script-84" class="da-hm-default-script" name="da_hm_default_script_84">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_84") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 84' . '"></div>';

		echo $html;
	}

	public function default_script_84_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_84_callback($args){
		$html = '<select id="da-hm-default-locale-84" class="da-hm-default-locale" name="da_hm_default_locale_84">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_84") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 84' . '"></div>';

		echo $html;
	}

	public function default_locale_84_validation($input){
		return sanitize_text_field($input);
	}

	//85 ----------------------------------------------------------------------------------------------------------------
	public function default_language_85_callback($args){
		$html = '<select id="da-hm-default-language-85" class="da-hm-default-language" name="da_hm_default_language_85">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_85") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 85' . '"></div>';
		echo $html;
	}

	public function default_language_85_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_85_callback($args){
		$html = '<select id="da-hm-default-script-85" class="da-hm-default-script" name="da_hm_default_script_85">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_85") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 85' . '"></div>';

		echo $html;
	}

	public function default_script_85_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_85_callback($args){
		$html = '<select id="da-hm-default-locale-85" class="da-hm-default-locale" name="da_hm_default_locale_85">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_85") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 85' . '"></div>';

		echo $html;
	}

	public function default_locale_85_validation($input){
		return sanitize_text_field($input);
	}

	//86 ----------------------------------------------------------------------------------------------------------------
	public function default_language_86_callback($args){
		$html = '<select id="da-hm-default-language-86" class="da-hm-default-language" name="da_hm_default_language_86">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_86") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 86' . '"></div>';
		echo $html;
	}

	public function default_language_86_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_86_callback($args){
		$html = '<select id="da-hm-default-script-86" class="da-hm-default-script" name="da_hm_default_script_86">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_86") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 86' . '"></div>';

		echo $html;
	}

	public function default_script_86_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_86_callback($args){
		$html = '<select id="da-hm-default-locale-86" class="da-hm-default-locale" name="da_hm_default_locale_86">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_86") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 86' . '"></div>';

		echo $html;
	}

	public function default_locale_86_validation($input){
		return sanitize_text_field($input);
	}

	//87 ----------------------------------------------------------------------------------------------------------------
	public function default_language_87_callback($args){
		$html = '<select id="da-hm-default-language-87" class="da-hm-default-language" name="da_hm_default_language_87">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_87") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 87' . '"></div>';
		echo $html;
	}

	public function default_language_87_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_87_callback($args){
		$html = '<select id="da-hm-default-script-87" class="da-hm-default-script" name="da_hm_default_script_87">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_87") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 87' . '"></div>';

		echo $html;
	}

	public function default_script_87_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_87_callback($args){
		$html = '<select id="da-hm-default-locale-87" class="da-hm-default-locale" name="da_hm_default_locale_87">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_87") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 87' . '"></div>';

		echo $html;
	}

	public function default_locale_87_validation($input){
		return sanitize_text_field($input);
	}

	//88 ----------------------------------------------------------------------------------------------------------------
	public function default_language_88_callback($args){
		$html = '<select id="da-hm-default-language-88" class="da-hm-default-language" name="da_hm_default_language_88">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_88") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 88' . '"></div>';
		echo $html;
	}

	public function default_language_88_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_88_callback($args){
		$html = '<select id="da-hm-default-script-88" class="da-hm-default-script" name="da_hm_default_script_88">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_88") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 88' . '"></div>';

		echo $html;
	}

	public function default_script_88_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_88_callback($args){
		$html = '<select id="da-hm-default-locale-88" class="da-hm-default-locale" name="da_hm_default_locale_88">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_88") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 88' . '"></div>';

		echo $html;
	}

	public function default_locale_88_validation($input){
		return sanitize_text_field($input);
	}

	//89 ----------------------------------------------------------------------------------------------------------------
	public function default_language_89_callback($args){
		$html = '<select id="da-hm-default-language-89" class="da-hm-default-language" name="da_hm_default_language_89">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_89") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 89' . '"></div>';
		echo $html;
	}

	public function default_language_89_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_89_callback($args){
		$html = '<select id="da-hm-default-script-89" class="da-hm-default-script" name="da_hm_default_script_89">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_89") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 89' . '"></div>';

		echo $html;
	}

	public function default_script_89_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_89_callback($args){
		$html = '<select id="da-hm-default-locale-89" class="da-hm-default-locale" name="da_hm_default_locale_89">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_89") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 89' . '"></div>';

		echo $html;
	}

	public function default_locale_89_validation($input){
		return sanitize_text_field($input);
	}

	//90 ----------------------------------------------------------------------------------------------------------------
	public function default_language_90_callback($args){
		$html = '<select id="da-hm-default-language-90" class="da-hm-default-language" name="da_hm_default_language_90">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_90") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 90' . '"></div>';
		echo $html;
	}

	public function default_language_90_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_90_callback($args){
		$html = '<select id="da-hm-default-script-90" class="da-hm-default-script" name="da_hm_default_script_90">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_90") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 90' . '"></div>';

		echo $html;
	}

	public function default_script_90_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_90_callback($args){
		$html = '<select id="da-hm-default-locale-90" class="da-hm-default-locale" name="da_hm_default_locale_90">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_90") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 90' . '"></div>';

		echo $html;
	}

	public function default_locale_90_validation($input){
		return sanitize_text_field($input);
	}

	//91 ----------------------------------------------------------------------------------------------------------------
	public function default_language_91_callback($args){
		$html = '<select id="da-hm-default-language-91" class="da-hm-default-language" name="da_hm_default_language_91">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_91") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 91' . '"></div>';
		echo $html;
	}

	public function default_language_91_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_91_callback($args){
		$html = '<select id="da-hm-default-script-91" class="da-hm-default-script" name="da_hm_default_script_91">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_91") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 91' . '"></div>';

		echo $html;
	}

	public function default_script_91_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_91_callback($args){
		$html = '<select id="da-hm-default-locale-91" class="da-hm-default-locale" name="da_hm_default_locale_91">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_91") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 91' . '"></div>';

		echo $html;
	}

	public function default_locale_91_validation($input){
		return sanitize_text_field($input);
	}

	//92 ----------------------------------------------------------------------------------------------------------------
	public function default_language_92_callback($args){
		$html = '<select id="da-hm-default-language-92" class="da-hm-default-language" name="da_hm_default_language_92">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_92") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 92' . '"></div>';
		echo $html;
	}

	public function default_language_92_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_92_callback($args){
		$html = '<select id="da-hm-default-script-92" class="da-hm-default-script" name="da_hm_default_script_92">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_92") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 92' . '"></div>';

		echo $html;
	}

	public function default_script_92_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_92_callback($args){
		$html = '<select id="da-hm-default-locale-92" class="da-hm-default-locale" name="da_hm_default_locale_92">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_92") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 92' . '"></div>';

		echo $html;
	}

	public function default_locale_92_validation($input){
		return sanitize_text_field($input);
	}

	//93 ----------------------------------------------------------------------------------------------------------------
	public function default_language_93_callback($args){
		$html = '<select id="da-hm-default-language-93" class="da-hm-default-language" name="da_hm_default_language_93">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_93") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 93' . '"></div>';
		echo $html;
	}

	public function default_language_93_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_93_callback($args){
		$html = '<select id="da-hm-default-script-93" class="da-hm-default-script" name="da_hm_default_script_93">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_93") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 93' . '"></div>';

		echo $html;
	}

	public function default_script_93_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_93_callback($args){
		$html = '<select id="da-hm-default-locale-93" class="da-hm-default-locale" name="da_hm_default_locale_93">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_93") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 93' . '"></div>';

		echo $html;
	}

	public function default_locale_93_validation($input){
		return sanitize_text_field($input);
	}

	//94 ----------------------------------------------------------------------------------------------------------------
	public function default_language_94_callback($args){
		$html = '<select id="da-hm-default-language-94" class="da-hm-default-language" name="da_hm_default_language_94">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_94") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 94' . '"></div>';
		echo $html;
	}

	public function default_language_94_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_94_callback($args){
		$html = '<select id="da-hm-default-script-94" class="da-hm-default-script" name="da_hm_default_script_94">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_94") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 94' . '"></div>';

		echo $html;
	}

	public function default_script_94_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_94_callback($args){
		$html = '<select id="da-hm-default-locale-94" class="da-hm-default-locale" name="da_hm_default_locale_94">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_94") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 94' . '"></div>';

		echo $html;
	}

	public function default_locale_94_validation($input){
		return sanitize_text_field($input);
	}

	//95 ----------------------------------------------------------------------------------------------------------------
	public function default_language_95_callback($args){
		$html = '<select id="da-hm-default-language-95" class="da-hm-default-language" name="da_hm_default_language_95">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_95") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 95' . '"></div>';
		echo $html;
	}

	public function default_language_95_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_95_callback($args){
		$html = '<select id="da-hm-default-script-95" class="da-hm-default-script" name="da_hm_default_script_95">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_95") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 95' . '"></div>';

		echo $html;
	}

	public function default_script_95_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_95_callback($args){
		$html = '<select id="da-hm-default-locale-95" class="da-hm-default-locale" name="da_hm_default_locale_95">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_95") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 95' . '"></div>';

		echo $html;
	}

	public function default_locale_95_validation($input){
		return sanitize_text_field($input);
	}

	//96 ----------------------------------------------------------------------------------------------------------------
	public function default_language_96_callback($args){
		$html = '<select id="da-hm-default-language-96" class="da-hm-default-language" name="da_hm_default_language_96">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_96") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 96' . '"></div>';
		echo $html;
	}

	public function default_language_96_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_96_callback($args){
		$html = '<select id="da-hm-default-script-96" class="da-hm-default-script" name="da_hm_default_script_96">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_96") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 96' . '"></div>';

		echo $html;
	}

	public function default_script_96_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_96_callback($args){
		$html = '<select id="da-hm-default-locale-96" class="da-hm-default-locale" name="da_hm_default_locale_96">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_96") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 96' . '"></div>';

		echo $html;
	}

	public function default_locale_96_validation($input){
		return sanitize_text_field($input);
	}

	//97 ----------------------------------------------------------------------------------------------------------------
	public function default_language_97_callback($args){
		$html = '<select id="da-hm-default-language-97" class="da-hm-default-language" name="da_hm_default_language_97">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_97") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 97' . '"></div>';
		echo $html;
	}

	public function default_language_97_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_97_callback($args){
		$html = '<select id="da-hm-default-script-97" class="da-hm-default-script" name="da_hm_default_script_97">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_97") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 97' . '"></div>';

		echo $html;
	}

	public function default_script_97_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_97_callback($args){
		$html = '<select id="da-hm-default-locale-97" class="da-hm-default-locale" name="da_hm_default_locale_97">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_97") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 97' . '"></div>';

		echo $html;
	}

	public function default_locale_97_validation($input){
		return sanitize_text_field($input);
	}

	//98 ----------------------------------------------------------------------------------------------------------------
	public function default_language_98_callback($args){
		$html = '<select id="da-hm-default-language-98" class="da-hm-default-language" name="da_hm_default_language_98">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_98") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 98' . '"></div>';
		echo $html;
	}

	public function default_language_98_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_98_callback($args){
		$html = '<select id="da-hm-default-script-98" class="da-hm-default-script" name="da_hm_default_script_98">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_98") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 98' . '"></div>';

		echo $html;
	}

	public function default_script_98_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_98_callback($args){
		$html = '<select id="da-hm-default-locale-98" class="da-hm-default-locale" name="da_hm_default_locale_98">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_98") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 98' . '"></div>';

		echo $html;
	}

	public function default_locale_98_validation($input){
		return sanitize_text_field($input);
	}

	//99 ----------------------------------------------------------------------------------------------------------------
	public function default_language_99_callback($args){
		$html = '<select id="da-hm-default-language-99" class="da-hm-default-language" name="da_hm_default_language_99">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_99") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 99' . '"></div>';
		echo $html;
	}

	public function default_language_99_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_99_callback($args){
		$html = '<select id="da-hm-default-script-99" class="da-hm-default-script" name="da_hm_default_script_99">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_99") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 99' . '"></div>';

		echo $html;
	}

	public function default_script_99_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_99_callback($args){
		$html = '<select id="da-hm-default-locale-99" class="da-hm-default-locale" name="da_hm_default_locale_99">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_99") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 99' . '"></div>';

		echo $html;
	}

	public function default_locale_99_validation($input){
		return sanitize_text_field($input);
	}

	//100 ----------------------------------------------------------------------------------------------------------------
	public function default_language_100_callback($args){
		$html = '<select id="da-hm-default-language-100" class="da-hm-default-language" name="da_hm_default_language_100">';
		$array_language = get_option('da_hm_language');
		foreach ($array_language as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_language_100") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Language', 'dahm') . ' 100' . '"></div>';
		echo $html;
	}

	public function default_language_100_validation($input){
		return sanitize_text_field($input);
	}

	public function default_script_100_callback($args){
		$html = '<select id="da-hm-default-script-100" class="da-hm-default-script" name="da_hm_default_script_100">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_script = get_option('da_hm_script');
		foreach ($array_script as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_script_100") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Script', 'dahm') . ' 100' . '"></div>';

		echo $html;
	}

	public function default_script_100_validation($input){
		return sanitize_text_field($input);
	}

	public function default_locale_100_callback($args){
		$html = '<select id="da-hm-default-locale-100" class="da-hm-default-locale" name="da_hm_default_locale_100">';
		$html .= '<option value="">' . esc_html__('Not Assigned', 'dahm') . '</option>';
		$array_locale = get_option('da_hm_locale');
		foreach ($array_locale as $key => $value) {
			$html .= '<option value="' . $value . '" ' . selected( get_option("da_hm_default_locale_100") , $value, false ) . '>' . $value . " - " . $key . '</option>';
		}
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('Default Locale', 'dahm') . ' 100' . '"></div>';

		echo $html;
	}

	public function default_locale_100_validation($input){
		return sanitize_text_field($input);
	}

}