<?php

if ( !current_user_can(get_option($this->shared->get('slug') . "_connections_menu_capability")) )  {
    wp_die( esc_html__( 'You do not have sufficient permissions to access this page.' ) );
}

?>

<!-- process data -->

<?php

//Initialize variables -------------------------------------------------------------------------------------------------
$dismissible_notice_a = [];

//save the connection into the database
if( isset($_POST['form_submitted']) ) {

    //Sanitization -------------------------------------------------------------------------------------------------
    $update_id      = isset( $_POST['update_id'] ) ? intval( $_POST['update_id'], 10 ) : '';
    $url_to_connect = esc_url_raw( $_POST['url_to_connect'] );
    $url = [];
    $language = [];
    $script = [];
    $locale = [];
	$inherited      = (isset( $_POST['inherited'] ) and intval($_POST['inherited'], 10 ) === 1) ? 1 : 0;

	for ( $i = 1; $i <= 100; $i ++ ) {

        if ( isset( $_POST[ 'url' . $i ] ) ) {
            $sanitized_url = esc_url_raw( $_POST[ 'url' . $i ] );
            if ( strlen( trim( $sanitized_url ) ) > 0 ) {
                $url[$i] = $sanitized_url;
            } else {
                $url[$i] = '';
            }
        } else {
            $url[$i] = '';
        }

        if ( isset( $_POST[ 'language' . $i ] ) ) {
            $language[$i] = sanitize_text_field( $_POST[ 'language' . $i ] );
        } else {
            $language[$i] = get_option( $this->shared->get( 'slug' ) . '_default_language_' . $i );
        }

        if ( isset( $_POST[ 'script' . $i ] ) ) {
            $script[$i] = sanitize_text_field( $_POST[ 'script' . $i ] );
        } else {
            $script[$i] = get_option( $this->shared->get( 'slug' ) . '_default_script_' . $i );
        }

        if ( isset( $_POST[ 'locale' . $i ] ) ) {
            $locale[$i] = sanitize_text_field( $_POST[ 'locale' . $i ] );
        } else {
            $locale[$i] = get_option( $this->shared->get( 'slug' ) . '_default_locale_' . $i );
        }

    }

    //Validation ---------------------------------------------------------------------------------------------------

    //verify if the "URL to Connect" is empty
    if ( strlen( trim( $url_to_connect ) ) == 0 ) {
	    $dismissible_notice_a[] = [
		    'message' => __( 'The "URL to Connect" field is empty.', 'dahm'),
		    'class' => 'error'
	    ];
	    $invalid_data         = true;
    }

}

//Update or add the record in the database
if ( isset( $_POST['form_submitted'] ) and ! isset( $invalid_data ) ) {

    $url_json = json_encode($url);
    $language_json = json_encode($language);
    $script_json = json_encode($script);
    $locale_json = json_encode($locale);

    if ( isset( $update_id ) and ! empty( $update_id ) ) {

        //Update

        global $wpdb;
        $table_name = $wpdb->prefix . "da_hm_connect";

        $safe_sql = $wpdb->prepare("UPDATE $table_name SET
        url_to_connect = %s ,
                 url = %s,
                 language = %s,
                 script = %s,
                 locale = %s,
                 inherited = %d
            WHERE id = %d",
            $url_to_connect,
            $url_json,
            $language_json,
            $script_json,
            $locale_json,
            $inherited,
            $update_id);

        $query_result = $wpdb->query($safe_sql);

	    if ( $query_result !== false ) {
		    $dismissible_notice_a[] = [
			    'message' => __('The connection has been successfully updated.', 'dahm'),
			    'class' => 'updated'
		    ];
	    }

    } else {

        //add a new connection into the database
	    global $wpdb;
	    $table_name = $wpdb->prefix . "da_hm_connect";
        $safe_sql = $wpdb->prepare("INSERT INTO $table_name SET url_to_connect = %s ,
                 url = %s,
                 language = %s,
                 script = %s,
                 locale = %s,
                 inherited = %d",
            $url_to_connect,
            $url_json,
            $language_json,
            $script_json,
            $locale_json,
            $inherited
        );

            $query_result = $wpdb->query($safe_sql);

	    if ( isset( $query_result ) and $query_result !== false ) {
		    $dismissible_notice_a[] = [
			    'message' => __('The connection has been successfully added.', 'dahm'),
			    'class' => 'updated'
		    ];
	    }

	    $auto_alternate_pages = intval(get_option("da_hm_auto_alternate_pages"), 10);
	    $query_result = false;
	    if($auto_alternate_pages === 1){

		    for($i=1;$i<=100;$i++){

			    if ( strlen( trim( $url[$i] ) ) > 0 and $url[$i] !== $url_to_connect ) {

				    $safe_sql = $wpdb->prepare( "INSERT INTO $table_name SET url_to_connect = %s ,
                         url = %s,
                         language = %s,
                         script = %s,
                         locale = %s,
                         inherited = %d",
					    $url[$i],
					    $url_json,
					    $language_json,
					    $script_json,
					    $locale_json,
                        $inherited);

				    $query_result = $wpdb->query( $safe_sql );

			    }

		    }

		    if ( isset( $query_result ) and $query_result !== false ) {
			    $dismissible_notice_a[] = [
				    'message' => __('The connections of the alternate pages have been successfully added.', 'dahm'),
				    'class' => 'updated'
			    ];

		    }

	    }

    }

}

//delete a Connection
if( isset( $_POST['delete_id']) ){

    global $wpdb;
    $delete_id = intval($_POST['delete_id'], 10);
    $table_name = $wpdb->prefix."da_hm_connect";
    $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE id = %d ", $delete_id);

    $query_result = $wpdb->query( $safe_sql );
	if ( $query_result !== false ) {
		$dismissible_notice_a[] = [
			'message' => __('The connection has been successfully deleted.', 'dahm'),
			'class' => 'updated'
		];
	}

}

//clone action and elements in the field
if( isset( $_POST['clone_id']) ){

    global $wpdb;
    $clone_id = intval($_POST['clone_id'], 10);;

    //clone action
    $table_name = $wpdb->prefix."da_hm_connect";
	$query_result_1 = $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE id = $clone_id");
	$query_result_2 = $wpdb->query("UPDATE tmptable_1 SET id = NULL");
	$query_result_3 = $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
	$query_result_4 = $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");

	if ( intval( $query_result_1, 10 ) === 1 and
	     intval( $query_result_2, 10 ) === 1 and
	     intval( $query_result_3, 10 ) === 1 and
	     intval( $query_result_4, 10 ) === 1 ) {

		$dismissible_notice_a[] = [
			'message' => __( 'The connection has been successfully cloned.', 'dahm' ),
			'class'   => 'updated'
		];

	}

}

//get the connection data
if( isset( $_GET['edit_id']) ){

    global $wpdb;
    $edit_id = intval($_GET['edit_id'], 10);
    $table_name = $wpdb->prefix."da_hm_connect";
    $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE id = %d ", $edit_id);
    $edit_obj = $wpdb->get_row($safe_sql);

    $edit_obj->url = json_decode($edit_obj->url);
    $edit_obj->language = json_decode($edit_obj->language);
    $edit_obj->script = json_decode($edit_obj->script);
    $edit_obj->locale = json_decode($edit_obj->locale);

}

?>

<!-- output ******************************************************************************* -->

<div class="wrap">

    <?php if ($this->shared->number_of_connections() > 0) : ?>

        <div id="daext-header-wrapper" class="daext-clearfix">

            <h2><?php esc_html_e('Hreflang Manager - Connections', 'dahm'); ?></h2>

            <form action="admin.php" method="get">
                <input type="hidden" name="page" value="da_hm_connections">
                <?php
                if (isset($_GET['s'])) {
                    $s = sanitize_text_field($_GET['s']);
                    if(strlen(trim($s)) > 0){
                        $search_string = $s;
                    }else{
	                    $search_string = '';
                    }
                } else {
                    $search_string = '';
                }
                ?>
                <input type="text" name="s" placeholder="<?php esc_attr_e('Search...', 'dahm'); ?>"
                       value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
                <input type="submit" value="">
            </form>

        </div>

    <?php else: ?>

        <div id="daext-header-wrapper" class="daext-clearfix">

            <h2><?php esc_html_e('Hreflang Manager - Connections', 'dahm'); ?></h2>

        </div>

    <?php endif; ?>

    <div id="daext-menu-wrapper">

	    <?php $this->dismissible_notice($dismissible_notice_a); ?>

        <!-- table -->

        <?php

        //create the query part used to filter the results when a search is performed
        if (isset($_GET['s'])) {
            $s = sanitize_text_field($_GET['s']);
            if(strlen(trim($s)) > 0){
                $search_string = $s;
            }
            global $wpdb;
            $filter = $wpdb->prepare('WHERE (id LIKE %s OR url_to_connect LIKE %s)', '%' . $search_string . '%', '%' . $search_string . '%');
        } else {
            $filter = '';
        }

        //retrieve the total number of connections
        global $wpdb;
        $table_name=$wpdb->prefix."da_hm_connect";
        $total_items = $wpdb->get_var( "SELECT COUNT(*) FROM $table_name $filter" );

        //Initialize the pagination class
        require_once( $this->shared->get('dir') . '/admin/inc/class-dahm-pagination.php' );
        $pag = new Dahm_pagination();
        $pag->set_total_items( $total_items );//Set the total number of items
        $pag->set_record_per_page( 10 ); //Set records per page
        $pag->set_target_page( "admin.php?page=da_hm_connections" );//Set target page
        $pag->set_current_page();//set the current page number from $_GET

        ?>

        <!-- Query the database -->
        <?php
        $dc_wp_query_limit = $pag->query_limit();
        $results = $wpdb->get_results("SELECT id, url_to_connect, url, language, script, locale, inherited FROM $table_name $filter ORDER BY id DESC $dc_wp_query_limit ", ARRAY_A);

        //get the number of connections that should be displayed in the menu
        $connections_in_menu = intval(get_option('da_hm_connections_in_menu'), 10);

        ?>

        <?php if( count($results) > 0 ) : ?>

            <div class="daext-items-container">

                <!-- list of featured news -->
                <table class="daext-items">
                    <thead>
                    <tr>
                        <th><?php esc_html_e('ID', 'dahm'); ?></th>
                        <th><?php esc_html_e('URL to Connect', 'dahm'); ?></th>
                        <th><?php esc_html_e('Connections', 'dahm'); ?></th>
                        <th><?php esc_html_e('Inherited', 'dahm'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($results as $result) : ?>
                        <tr>
                            <td><?php echo $result['id']; ?></td>
                            <td><a target="_blank" href="<?php echo esc_attr( stripslashes( $result['url_to_connect'] ) ); ?>"><?php echo esc_html( stripslashes( $result['url_to_connect'] ) ); ?></a></td>

                            <td>

                                <?php

                                $url = json_decode($result['url']);
                                $language = json_decode($result['language']);
                                $script = json_decode($result['script']);
                                $locale = json_decode($result['locale']);

                                for($i=1;$i<=100;$i++){

                                    if( strlen($url->{$i}) > 0 ){
                                        echo '<a target="_blank" href="' . esc_attr( stripslashes( $url->{$i} ) ) . '">' . esc_html( stripslashes( $language->{$i} ) );
                                        if( strlen($script->{$i}) > 0 ){
                                            echo "-" . esc_html( stripslashes( $script->{$i} ) );
                                        }
                                        if( strlen($locale->{$i}) > 0 ){
                                            echo "-" . esc_html( stripslashes( $locale->{$i} ) );
                                        }
                                        echo '</a> ';
                                    }

                                }

                                ?>


                            </td>

	                        <td><?php echo intval($result['inherited'], 10) === 0 ? esc_html('No', 'dahm') : esc_html('Yes', 'dahm'); ?></td>

                            <td class="icons-container">
                                <form method="POST" action="admin.php?page=<?php echo esc_attr($this->shared->get('slug')); ?>_connections">
                                    <input type="hidden" value="<?php echo esc_attr($result['id']); ?>" name="clone_id" >
                                    <input class="menu-icon clone" type="submit" value="">
                                </form>
                                <a class="menu-icon edit" href="admin.php?page=<?php echo esc_attr($this->shared->get('slug')); ?>_connections&edit_id=<?php echo esc_attr($result['id']); ?>"></a>
                                <form method="POST" action="admin.php?page=<?php echo esc_attr($this->shared->get('slug')); ?>_connections">
                                    <input type="hidden" value="<?php echo esc_attr($result['id']); ?>" name="delete_id" >
                                    <input class="menu-icon delete" type="submit" value="">
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>
                </table>

            </div>

            <!-- Display the pagination -->
            <?php if($pag->total_items > 0) : ?>
                <div class="daext-tablenav daext-clearfix">
                    <div class="daext-tablenav-pages">
                        <span class="daext-displaying-num"><?php echo esc_html($pag->total_items); ?> <?php esc_html_e('items', 'dahm'); ?></span>
                        <?php $pag->show(); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php endif; ?>

        <!-- form -->

        <form method="POST" action="admin.php?page=<?php echo esc_attr($this->shared->get('slug')); ?>_connections" >

            <input name="form_submitted" type="hidden" value="true">

            <?php if(isset($edit_obj)) : ?>

                <!-- Generate the form to edit an existing connection -->

                <div class="daext-form-container">

                    <h3 class="daext-form-title"><?php esc_html_e('Edit Connection', 'dahm'); ?> <?php echo esc_html($edit_obj->id); ?></h3>

                    <table class="daext-form">

                        <input name="update_id" type="hidden" value="<?php echo esc_attr($edit_obj->id); ?>">

                        <!-- URL to connect -->
                        <tr valign="top">
                            <th scope="row"><label for="url_to_connect"><label for="url_to_connect"><?php esc_html_e('URL to Connect', 'dahm'); ?></label></th>
                            <td>
                                <input autocomplete="off" type="text" id="url_to_connect" maxlength="2083" name="url_to_connect" class="regular-text" value="<?php echo esc_attr( stripslashes( $edit_obj->url_to_connect) ); ?>" />
                                <div class="help-icon" title='<?php esc_attr_e('The URL where the hreflang tag should be applied.', 'dahm'); ?>'></div>
                            </td>
                        </tr>

                        <?php

                        for($i=1;$i<=$connections_in_menu;$i++){

                            ?>

                                <!-- url<?php echo $i; ?> -->
                                <tr valign="top">
                                    <th scope="row"><label for="url<?php echo $i; ?>">URL <?php echo esc_html($i); ?></label></th>
                                    <td>
                                        <input autocomplete="off" type="text" id="url<?php echo esc_attr($i); ?>" maxlength="2083" name="url<?php echo esc_attr($i); ?>" class="regular-text" value="<?php echo esc_attr( stripslashes( $edit_obj->url->{$i} ) ); ?>" />
                                        <div class="help-icon" title='<?php esc_attr_e('The URL of the variant of the page.', 'dahm'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Language <?php echo $i; ?> -->
                                <tr valign="top">
                                    <th scope="row"><label for="language<?php echo esc_attr($i); ?>" ><?php esc_html_e('Language', 'dahm'); ?> <?php echo esc_html($i); ?></label></th>
                                    <td>
                                        <select id="language<?php echo $i; ?>" class="dahm-language" name="language<?php echo esc_attr($i); ?>">
                                            <?php

                                            $array_language = get_option('da_hm_language');
                                            foreach ($array_language as $key => $value) {
                                                echo '<option value="' . esc_attr($value) . '" ' . selected( $edit_obj->language->{$i} , $value, false ) . '>' . esc_html($value) . " - " . esc_html($key) . '</option>';
                                            }

                                            ?>
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('The language of the variant of the page.', 'dahm'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Script <?php echo $i; ?> -->
                                <tr valign="top">
                                    <th scope="row"><label for="script<?php echo esc_attr($i); ?>" ><?php esc_html_e('Script', 'dahm'); ?> <?php echo esc_html($i); ?></label></th>
                                    <td>
                                        <select id="script<?php echo esc_attr($i); ?>" class="dahm-script" name="script<?php echo esc_attr($i); ?>">
                                            <option value=""><?php esc_html_e('Not Assigned', 'dahm'); ?></option>
                                            <?php

                                            $array_script = get_option('da_hm_script');
                                            foreach ($array_script as $key => $value) {
                                                echo '<option value="' . esc_attr($value) . '" ' . selected( $edit_obj->script->{$i} , $value, false ) . '>' . esc_html($value) . " - " . esc_html($key) . '</option>';
                                            }

                                            ?>
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('The script of the variant of the page.', 'dahm'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Locale <?php echo esc_html($i); ?> -->
                                <tr valign="top">
                                    <th scope="row"><label for="locale<?php echo $i; ?>" ><?php esc_html_e('Locale', 'dahm'); ?> <?php echo esc_html($i); ?></label></th>
                                    <td>
                                        <select id="locale<?php echo esc_attr($i); ?>" class="dahm-locale" name="locale<?php echo esc_attr($i); ?>">
                                            <option value=""><?php esc_html_e('Not Assigned', 'dahm'); ?></option>
                                            <?php

                                            $array_language = get_option('da_hm_locale');
                                            foreach ($array_language as $key => $value) {
                                                echo '<option value="' . esc_attr($value) . '" ' . selected( $edit_obj->locale->{$i} , $value, false ) . '>' . esc_html($value) . " - " . esc_html($key) . '</option>';
                                            }

                                            ?>
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('The locale of the variant of the page.', 'dahm'); ?>'></div>
                                    </td>
                                </tr>

                            <?php

                        }

                        ?>

                        <!-- Advanced Options ---------------------------------------------------------------- -->
                        <tr class="group-trigger" data-trigger-target="advanced-options">
                            <th class="group-title"><?php esc_html_e('Advanced', 'dahm'); ?></th>
                            <td>
                                <div class="expand-icon"></div>
                            </td>
                        </tr>

                        <!-- Inherited -->
                        <tr class="advanced-options">
                            <th scope="row"><label for="inherited" ><?php esc_html_e('Inherited', 'dahm'); ?></label></th>
                            <td>
                                <select id="inherited" class="dahm-language" name="inherited">
                                    <option value="0" <?php selected( $edit_obj->inherited , 0, true ); ?>><?php esc_html_e('No', 'dahm'); ?></option>
                                    <option value="1" <?php selected( $edit_obj->inherited , 1, true ); ?>><?php esc_html_e('Yes', 'dahm'); ?></option>
                                </select>
                                <div class="help-icon" title='<?php esc_attr_e('This option is used during the sync process to distinguish the connections inherited from the master site from the connections manually created.', 'dahm'); ?>'></div>
                            </td>
                        </tr>

                    </table>

                    <!-- submit button -->
                    <div class="daext-form-action">
                        <input class="button" type="submit" value="<?php esc_attr_e('Update Connection', 'dahm'); ?>" >
                    </div>

                </div>

            <?php else : ?>

                <!-- Generate the form to add new connection -->

                <div class="daext-form-container">

                    <div class="daext-form-title"><?php esc_html_e('Create New Connection', 'dahm'); ?></div>

                    <table class="daext-form">

                        <!-- URL to connect -->
                        <tr valign="top">
                            <th scope="row"><label for="url_to_connect"><?php esc_html_e('URL to Connect', 'dahm'); ?></label></th>
                            <td>
                                <input autocomplete="off" type="text" id="url_to_connect" maxlength="2083" name="url_to_connect" class="regular-text" />
                                <div class="help-icon" title='<?php esc_attr_e('The URL where the hreflang tag should be applied.', 'dahm'); ?>'></div>
                            </td>
                        </tr>

                        <?php

                        for($i=1;$i<=$connections_in_menu;$i++){

                            ?>

                                <!-- url -->
                                <tr valign="top">
                                    <th scope="row"><label for="url<?php echo esc_attr($i); ?>">URL <?php echo esc_html($i); ?></label></th>
                                    <td>
                                        <input autocomplete="off" type="text" id="url<?php echo esc_attr($i); ?>" maxlength="2083" name="url<?php echo esc_attr($i); ?>" class="regular-text" />
                                        <div class="help-icon" title='<?php esc_attr_e('The URL of the variant of the page.', 'dahm'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Language -->
                                <tr valign="top">
                                    <th scope="row"><label for="language<?php echo esc_attr($i); ?>" ><?php esc_html_e('Language', 'dahm'); ?> <?php echo esc_html($i); ?></label></th>
                                    <td>
                                        <select id="language<?php echo esc_attr($i); ?>" class="dahm-language" name="language<?php echo esc_attr($i); ?>">
                                            <?php

                                            $array_language = get_option('da_hm_language');
                                            foreach ($array_language as $key => $value) {
                                                echo '<option value="' . esc_attr($value) . '" ' . selected( get_option("da_hm_default_language_" . $i) , $value, false ) . '>' . esc_html($value) . " - " . esc_html($key) . '</option>';
                                            }

                                            ?>
                                        </select>
                                        <div class="help-icon" title='<?php esc_attr_e('The language of the variant of the page.', 'dahm'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Script -->
                                <tr valign="top">
                                    <th scope="row"><label for="script<?php echo esc_attr($i); ?>" ><?php esc_html_e('Script', 'dahm'); ?> <?php echo esc_html($i); ?></label></th>
                                    <td>
                                        <select id="script<?php echo esc_attr($i); ?>" class="dahm-script" name="script<?php echo esc_attr($i); ?>">
                                            <option value=""><?php esc_html_e('Not Assigned', 'dahm'); ?></option>
                                            <?php

                                            $array_script = get_option('da_hm_script');
                                            foreach ($array_script as $key => $value) {
                                                echo '<option value="' . esc_attr($value) . '" ' . selected( get_option("da_hm_default_script_" . $i) , $value, false ) . '>' . esc_html($value) . " - " . esc_html($key) . '</option>';
                                            }

                                            ?>
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('The script of the variant of the page.', 'dahm'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Locale -->
                                <tr valign="top">
                                    <th scope="row"><label for="locale<?php echo $i; ?>" ><?php esc_html_e('Locale', 'dahm'); ?> <?php echo $i; ?></label></th>
                                    <td>
                                        <select id="locale<?php echo $i; ?>" class="dahm-locale" name="locale<?php echo esc_attr($i); ?>">
                                            <option value=""><?php esc_html_e('Not Assigned', 'dahm'); ?></option>
                                            <?php

                                            $array_language = get_option('da_hm_locale');
                                            foreach ($array_language as $key => $value) {
                                                echo '<option value="' . esc_attr($value) . '" ' . selected( get_option("da_hm_default_locale_" . $i) , $value, false ) . '>' . esc_html($value) . " - " . esc_html($key) . '</option>';
                                            }

                                            ?>
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('The locale of the variant of the page.', 'dahm'); ?>'></div>
                                    </td>
                                </tr>

                        <?php

                    }

                    ?>

                        <!-- Advanced Options ---------------------------------------------------------------- -->
                        <tr class="group-trigger" data-trigger-target="advanced-options">
                            <th class="group-title"><?php esc_html_e('Advanced', 'dahm'); ?></th>
                            <td>
                                <div class="expand-icon"></div>
                            </td>
                        </tr>

                        <!-- Inherited -->
                        <tr class="advanced-options">
                            <th scope="row"><label for="inherited" ><?php esc_html_e('Inherited', 'dahm'); ?></label></th>
                            <td>
                                <select id="inherited" class="dahm-language" name="inherited">
				                    <option value="0" selected="selected"><?php esc_html_e('No', 'dahm'); ?></option>
				                    <option value="1"><?php esc_html_e('Yes', 'dahm'); ?></option>
                                </select>
                                <div class="help-icon" title='<?php esc_attr_e('This option is used during the sync process to distinguish the connections inherited from the master site from the connections manually created.', 'dahm'); ?>'></div>
                            </td>
                        </tr>

                    </table>

                    <!-- submit button -->
                    <div class="daext-form-action">
                        <input class="button" type="submit" value="<?php esc_html_e('Add Connection', 'dahm'); ?>" >
                    </div>

                </div>

            <?php endif; ?>

        </form>

</div>