<?php

if ( ! current_user_can(get_option($this->shared->get('slug') . '_maintenance_menu_capability'))) {
    wp_die(esc_attr__('You do not have sufficient permissions to access this page.', 'dahm'));
}

?>

<!-- process data -->

<?php

if (isset($_POST['form_submitted'])) {

    //prepare data
    $task = intval($_POST['task'], 10);
    $from = intval($_POST['from'], 10);
    $to   = intval($_POST['to'], 10);

    $invalid_data_message = '';
    $invalid_data         = false;

    //validation
    if ($from >= $to) {
        $invalid_data_message .= '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_html__('Please enter a valid range.',
                'dahm') . '</p></div>';
        $invalid_data         = true;
    }

    if (($to - $from) > 10000) {
        $invalid_data_message .= '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_html__("For performance reasons the range can't include more than 10000 items.",
                'dahm') . '</p></div>';
        $invalid_data         = true;
    }

    if ($invalid_data === false) {

        switch ($task) {

            //Delete Connection
            case 0:

                global $wpdb;
                $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_connect";
                $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE id >= %d AND id <= %d",
                    $from, $to);
                $query_result = $wpdb->query($safe_sql);

                if ($query_result !== false) {

                    if ($query_result > 0) {
                        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . intval($query_result,
                                10) . '&nbsp' . esc_html__('connections have been successfully deleted.',
                                'dahm') . '</p></div>';
                    } else {
                        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_html__('The are no connections in this range.',
                                'dahm') . '</p></div>';
                    }

                }

                break;

        }

    }

}

?>

<!-- output -->

<div class="wrap">

    <div id="daext-header-wrapper" class="daext-clearfix">

        <h2><?php esc_html_e('Hreflang Manager - Maintenance', 'dahm'); ?></h2>

    </div>

    <div id="daext-menu-wrapper">

        <?php if (isset($invalid_data_message)) {
            echo $invalid_data_message;
        } ?>
        <?php if (isset($process_data_message)) {
            echo $process_data_message;
        } ?>

        <!-- table -->

        <div>

            <form id="form-maintenance" method="POST"
                  action="admin.php?page=<?php echo $this->shared->get('slug'); ?>_maintenance"
                  autocomplete="off">

                <input type="hidden" value="1" name="form_submitted">

                <div class="daext-form-container">

                    <div class="daext-form-title"><?php esc_html_e('Maintenance', 'dahm'); ?></div>

                    <table class="daext-form daext-form-table">

                        <!-- Task -->
                        <tr>
                            <th scope="row"><?php esc_html_e('Task', 'dahm'); ?></th>
                            <td>
                                <select id="task" name="task" class="daext-display-none">
                                    <option value="0" selected="selected"><?php esc_html_e('Delete Connections',
                                            'dahm'); ?></option>
                                </select>
                                <div class="help-icon"
                                     title='<?php esc_attr_e('The task that should be performed.', 'dahm'); ?>'></div>
                            </td>
                        </tr>

                        <!-- From -->
                        <tr>
                            <th><label for="from"><?php esc_html_e('From', 'dahm'); ?></label></th>
                            <td>
                                <input type="text" id="from" maxlength="10" size="30" name="from" value="1"/>
                                <div class="help-icon"
                                     title="<?php esc_attr_e('The initial ID of the range.', 'dahm'); ?>"></div>
                            </td>
                        </tr>

                        <!-- To -->
                        <tr>
                            <th scope="row"><label for="to"><?php esc_html_e('To', 'dahm'); ?></label></th>
                            <td>
                                <input type="text" id="to" maxlength="10" size="30" name="to" value="1000"/>
                                <div class="help-icon"
                                     title="<?php esc_attr_e('The final ID of the range.', 'dahm'); ?>"></div>
                            </td>
                        </tr>

                    </table>

                    <!-- submit button -->
                    <div class="daext-form-action">
                        <input id="execute-task" class="button" type="submit"
                               value="<?php esc_attr_e('Execute Task', 'dahm'); ?>">
                    </div>

                </div>

            </form>

        </div>

    </div>

</div>

<!-- Dialog Confirm -->
<div id="dialog-confirm" title="<?php esc_attr_e('Execute the task?', 'dahm'); ?>" class="daext-display-none">
    <p><?php esc_html_e('Multiple database items are going to be deleted. Do you really want to proceed?',
            'dahm'); ?></p>
</div>