<?php

if ( !current_user_can( 'manage_options' ) )  {
    wp_die( esc_html__( 'You do not have sufficient capabilities to access this page.' ) );
}

?>

<div class="wrap">

    <h2><?php esc_html_e('Hreflang Manager - Options', 'dahm'); ?></h2>

    <?php

    //settings errors
    if( isset($_GET['settings-updated'])){
        $settings_updated = sanitize_key($_GET['settings-updated']);
	    if($settings_updated === 'true'){
		    settings_errors();
		    $this->schedule_cron_event();
        }
    }

    ?>

    <div id="daext-options-wrapper">

        <?php
        //get current tab value
        $active_tab = isset( $_GET[ 'tab' ] ) ? sanitize_key($_GET[ 'tab' ]) : 'general_options';
        ?>

        <div class="nav-tab-wrapper">
            <a href="?page=da_hm_options&tab=general_options" class="nav-tab <?php echo $active_tab == 'general_options' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('General', 'dahm'); ?></a>
            <a href="?page=da_hm_options&tab=sync_options" class="nav-tab <?php echo $active_tab == 'sync_options' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('Sync', 'dahm'); ?></a>
            <a href="?page=da_hm_options&tab=import_options" class="nav-tab <?php echo $active_tab == 'import_options' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('Import', 'dahm'); ?></a>
            <a href="?page=da_hm_options&tab=capabilities_options" class="nav-tab <?php echo $active_tab == 'capabilities_options' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('Capabilities', 'dahm'); ?></a>
            <a href="?page=da_hm_options&tab=defaults_options" class="nav-tab <?php echo $active_tab == 'defaults_options' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('Defaults', 'dahm'); ?></a>
        </div>

        <form method='post' action='options.php'>

            <?php

            if( $active_tab == 'general_options' ) {

                settings_fields( $this->shared->get('slug') . '_general_options' );
                do_settings_sections( $this->shared->get('slug') . '_general_options' );

            }

            if( $active_tab == 'sync_options' ) {

	            settings_fields( $this->shared->get('slug') . '_sync_options' );
	            do_settings_sections( $this->shared->get('slug') . '_sync_options' );

            }

            if( $active_tab == 'import_options' ) {

	            settings_fields( $this->shared->get('slug') . '_import_options' );
	            do_settings_sections( $this->shared->get('slug') . '_import_options' );

            }

            if( $active_tab == 'capabilities_options' ) {

	            settings_fields( $this->shared->get('slug') . '_capabilities_options' );
	            do_settings_sections( $this->shared->get('slug') . '_capabilities_options' );

            }

            if( $active_tab == 'defaults_options' ) {

                settings_fields( $this->shared->get('slug') . '_defaults_options' );
                do_settings_sections( $this->shared->get('slug') . '_defaults_options' );

            }

            ?>

            <div class="daext-options-action">
                <input type="submit" name="submit" id="submit" class="button" value="<?php esc_attr_e('Save Changes', 'dahm'); ?>">
            </div>

        </form>

    </div>

</div>