<?php

namespace wpbuddy\rich_snippets\pro;

use wpbuddy\rich_snippets\Cache_Model;
use wpbuddy\rich_snippets\Snippets_Model;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


/**
 * Class Admin_Snippets_Controller.
 *
 * Starts up all the admin things needed to control snippets.
 *
 * @package wpbuddy\rich_snippets
 *
 * @since   2.19.0
 */
class Admin_Snippets_Controller extends \wpbuddy\rich_snippets\Admin_Snippets_Controller {
	/**
	 * Get the singleton instance.
	 *
	 * Creates a new instance of the class if it does not exists.
	 *
	 * @return Admin_Snippets_Controller
	 *
	 * @since 2.0.0
	 */
	public static function instance() {

		if ( null === self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}


	/**
	 * Init.
	 *
	 * @since 2.19.0
	 */
	public function init() {

		if ( $this->initialized ) {
			return;
		}

		parent::init();

		add_filter( 'wpbuddy/rich_snippets/rest/property/html/actions', [ self::$instance, 'property_actions' ] );

	}

	/**
	 * Initializes the fields.
	 *
	 * Prevents double-init.
	 *
	 * @since 2.0.0
	 */
	public function init_fields() {

		if ( ! $this->fields instanceof Fields_Model ) {
			$this->fields = new Fields_Model();
		}
	}


	/**
	 * Returns the current scripts controller.
	 *
	 * @since 2.19.0
	 */
	public function get_scripts_controller() {
		return Admin_Scripts_Controller::instance();
	}

	/**
	 * Adds the delete link to property action list.
	 *
	 * @param array $actions
	 *
	 * @return array
	 * @since 2.19.13
	 */
	public function property_actions( $actions ) {
		$actions['delete'] = __( 'Delete' );

		return $actions;
	}
}