<?php

namespace wpbuddy\rich_snippets\pro;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


/**
 * Class Support.
 *
 * Admin support actions.
 *
 * @package wpbuddy\rich_snippets
 *
 * @since   2.19.0
 */
class Admin_Support_Controller extends \wpbuddy\rich_snippets\Admin_Support_Controller {

	/**
	 * Add metaboxes for the support page.
	 *
	 * @since 2.19.0
	 */
	public function add_metaboxes() {
		parent::add_metaboxes();

		add_meta_box(
			'support-validity',
			_x( 'Support', 'metabox title', 'rich-snippets-schema' )
//			. Helper_Model::instance()->get_support_menu_counter_html()
			,
			array( '\wpbuddy\rich_snippets\View', 'admin_support_metabox_validity' ),
			'rich-snippets-support',
			'side',
			'high'
		);

		add_meta_box(
			'support-deactivate-site',
			_x( 'License Deactivation', 'metabox title', 'rich-snippets-schema' ),
			array( '\wpbuddy\rich_snippets\View', 'admin_support_metabox_deactivation' ),
			'rich-snippets-support',
			'side',
			'high'
		);

		add_meta_box(
			'support-features',
			__( 'Feature Requests', 'rich-snippets-schema' ),
			array( '\wpbuddy\rich_snippets\View', 'admin_support_metabox_features' ),
			'rich-snippets-support',
			'normal'
		);
	}

	/**
	 * Sends an info email about expired support.
	 * @since 2.20.0
	 */
	public static function maybe_send_expired_support_infomail() {
		if ( ! (bool) get_option( 'wpb_rs/setting/expired_support_info_mail' ) ) {
			return;
		}

		$helper = Helper_Model::instance();
		switch ( $helper->user_has_valid_support() ) {
			case 'valid':
				return;
			case 'about-to-expire':
				$text     = __( 'Hey there, here is your WordPress site (%1$s).<br /><br />I just want to inform you that your license from SNIP - The Structured Data Plugin for WordPress is about to expire on %2$s. You should renew your license now to save money (it is much cheaper to renew the license now than when the support has expired).<br /><br /><a href="%3$s">Renew now</a><br /><br />Have a nice day!', 'rich-snippets-schema' );
				$headline = __( '[Action required] SNIP support is expiring soon. Renew now.', 'rich-snippets-schema' );
				break;
			case 'expired':
				$text     = __( 'Hey there, here is your WordPress site (%1$s).<br /><br />I just want to inform you that your license from SNIP - The Structured Data Plugin for WordPress has expired on %2$s. You should renew now. Otherwise you will not get any support in the future.<br /><br /><a href="%3$s">Renew now</a><br /><br />Have a nice day!', 'rich-snippets-schema' );
				$headline = __( '[Action required] SNIP support has expired. Renew now.', 'rich-snippets-schema' );
				break;
		}

		if ( ! isset( $text ) ) {
			return;
		}

		$text = sprintf(
			$text,
			site_url(),
			date_i18n( get_option( 'date_format', 'd.m.Y' ), $helper->get_user_support_expiration_date() ),
			esc_url( $helper->get_campaignify( 'https://rich-snippets.io/ext/renew-support', 'expired-support-infomail' ) )
		);

		$headers = [
			sprintf( 'From: %s <%s>', strip_tags( get_option( 'blogname' ) ), sanitize_email( get_option( 'admin_email' ) ) ),
			'Content-Type: text/html; charset=UTF-8'
		];

		$s = wp_mail(
			sanitize_email( get_option( 'admin_email' ) ),
			$headline,
			$text,
			$headers
		);

		error_log( $s );

	}
}