<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

if ( ! class_exists( 'PSU_Compatibility_WPSEO' ) ) :

class PSU_Compatibility_WPSEO {

    /**
     * Breadcrumb trail
     *
     * @var array
     */
    private $crumbs = array();

    /**
     * Construct
     */
    public function __construct() {
        if ( get_option( 'psu_breadcrumb_rewrite_enabled' ) === 'yes' ) {
            add_filter( 'wpseo_breadcrumb_links', array( $this, 'wpseo_breadcrumb_links' ) );
        }

        add_filter( 'psu_post_type_link_terms_before', array( $this, 'psu_post_type_link_terms_before' ), 10, 2 );
    }

    /**
     * Add a crumb so we don't get lost
     *
     * @param array $data
     */
    public function add_crumb( $data ) {
        $this->crumbs[] = $data;
    }

    /**
     * Breadcrumbs based on url
     *
     * @param array $breadcrumbs
     * @return array
     */
    public function wpseo_breadcrumb_links( $breadcrumbs ) {
        global $wp_the_query, $wp;

        $categories = explode( '/', $wp->request );
        array_pop( $categories );

        if ( ! $id = $wp_the_query->get_queried_object_id() )
            return $breadcrumbs;

        if ( ! is_single( $id ) || $wp_the_query->query['post_type'] !== PSU()->woocommerce_post_type )
            return $breadcrumbs;

        // Begin PSU breadcrumb trail
        $this->add_crumb( $breadcrumbs[0] );

        foreach ( $categories as $category_slug ) {
            $cache_key = 'term_' . $category_slug;

            $term = wp_cache_get( $cache_key, 'psu' );
            if ( $term === false ) {
                $term = get_term_by( 'slug', $category_slug, PSU()->woocommerce_taxonomy );
                wp_cache_set( $cache_key, $term, 'psu' );
            }

            if ( $term ) {
                $this->add_crumb( array( 'term' => $term ) );
            }
        }

        $last_breadcrumb = end( $breadcrumbs );
        $this->add_crumb( $last_breadcrumb );

        return $this->crumbs;
    }

    public function psu_post_type_link_terms_before( $terms, $post ) {
        $primary_term = new WPSEO_Primary_Term( PSU()->woocommerce_taxonomy, $post->ID );

        if ( $primary_term->get_primary_term() ) {
            $terms = array(
                get_term( $primary_term->get_primary_term(), PSU()->woocommerce_taxonomy )
            );
        }

        return $terms;
    }

}

endif;

new PSU_Compatibility_WPSEO();