<?php
/**
 * Perfect SEO Url unit test, used for testing certain methods.
 */

// use PHPUnit\Framework\TestCase;

class PSU_PHPUnit extends TestCase
{

    private $debug = false;

    /**
     * Construct
     */
    public function __construct()
    {
        parent::__construct();
    }

     /**
     * Test category url
     *
     * @param string $permalink
     * @param object $post
     * @param boolean $leavename
     * @param boolean $sample
     *
     * @return string
     */
    public function test_category_urls( $permalink, $post, $leavename, $sample )
    {
        /**
         * Filter: 'psu_post_type_link_before' - Allow filtering of permalink
         */
        $permalink = apply_filters( 'psu_post_type_link_before', $permalink, $post, $leavename, $sample );

        return $permalink;
    }

    /**
     * Test product url
     */
    public function test_product_urls()
    {
        return null;
    }

    public function wp_load()
    {
        define('WP_USE_THEMES', true);

        require dirname(dirname(dirname(__DIR__))) . '/wp-load.php';
    }

    public function is_activated()
    {
        if ( get_option( 'psu_activated' ) === 'Activated' ) {
            return true;
        }

        return false;
    }

    public function is_installed()
    {
        if ( get_option( 'psu_install_complete' ) === 'yes' ) {
            return true;
        }

        return false;
    }

}

/**
 * TestCase class.
 */
class TestCase
{

    public function __construct()
    {

    }

}

$test = new PSU_PHPUnit;
$test->wp_load();

if ($test->is_installed()) {
    echo 'Is installed. ';
}
else {
    echo 'Not installed. ';
}

if ($test->is_activated()) {
    echo 'Is activated. ';
}
else {
    echo 'Not activated. ';
}
