/*!
	WPRS Metabox v1.0.0 - 2015-05-28
	jQuery meta box for the WPRichSnippets plugin
	(c) 2015 Hesham Zebida - https://wprichsnippets.com
	license: http://www.opensource.org/licenses/mit-license.php
*/
jQuery(document).ready(function($) {
	
	// tab between them
	jQuery('.wprs-metabox-tabs li.wprs-tab a').each(function(i) {
		var thisTab = jQuery(this).parent().attr('class').replace(/wprs-tab /, '');
		if ( 'active' != jQuery(this).attr('class') )
			jQuery('div.' + thisTab).hide();
 
		jQuery(this).click(function(){
 
			// hide all child content
			jQuery(this).parent().parent().parent().children('div').hide();
 
			// remove all active tabs
			jQuery(this).parent().parent('ul').find('li a.active').removeClass('active');
 
			// show selected content
			jQuery(this).parent().parent().parent().find('div.'+thisTab).show();
			jQuery(this).parent().parent().parent().find('li.'+thisTab+' a').addClass('active');
			jQuery('.wprs-tabs-back').show();
		});

		jQuery('.heading').hide();
		jQuery('.wprs-metabox-tabs').show();
		
	});
	
	// start criteria repeatable
	jQuery('.wprs-repeatable-add').click(function() {  
        field = jQuery(this).closest('div').find('.wprs_custom_repeatable li:last').clone(true);  
        fieldLocation = jQuery(this).closest('div').find('.wprs_custom_repeatable li:last');  
        jQuery('input', field).val('').attr('name', function(index, name) {  
            return name.replace(/(\d+)/, function(fullMatch, n) {  
                return Number(n) + 1;  
            });  
        }) 
		jQuery('select', field).val('').attr('name', function(index, name) {  
            return name.replace(/(\d+)/, function(fullMatch, n) {  
                return Number(n) + 1;  
            });  
        })
        field.insertAfter(fieldLocation, jQuery(this).closest('div'))  
        return false;  
    });  
      
    jQuery('.wprs-repeatable-remove').click(function(){
        if (!confirm('Are you sure?')) return false;
		jQuery(this).parent().remove();
    });
          
    jQuery('.wprs_custom_repeatable').sortable({  
        opacity: 0.6,  
        revert: true,  
        cursor: 'move',  
        handle: '.sort'  
    });
	// end of criteria repeatable
	
	// start of day/time range repeatable
	jQuery('.openinghours-repeatable-add').click(function() {
		field = jQuery(this).closest('div').find('.openinghours_repeatable li:last').clone(true);
		fieldLocation = jQuery(this).closest('div').find('.openinghours_repeatable li:last');
		jQuery('input', field).val('').attr('name', function(index, name) {
			return name.replace(/(\d+)/, function(fullMatch, n) {
				return Number(n) + 1;
			});
		})
		jQuery('select', field).val('').attr('name', function(index, name) {  
            return name.replace(/(\d+)/, function(fullMatch, n) {  
                return Number(n) + 1;  
            });  
        })
		field.insertAfter(fieldLocation, jQuery(this).closest('div'))
		return false;
	});
 
	jQuery('.openinghours-repeatable-remove').click(function(){
		if (!confirm('Are you sure?')) return false;
		jQuery(this).parent().remove();
		return false;
	});
     
	jQuery('.openinghours_repeatable').sortable({
    	opacity: 0.6,
		revert: true,
		cursor: 'move',
		handle: '.sort'
	});
	// end of day/time range repeatable
  
	// rich snippets type select
	jQuery('.wprs_type_box').appendTo( '#wprs_plugin_meta_box h3.hndle span' );

	jQuery(function(){
		// prevent inputs in meta box headings opening/closing contents
		jQuery('#wprs_plugin_meta_box h3.hndle').unbind('click.postboxes');

		jQuery('#wprs_plugin_meta_box').on('click', 'h3.hndle', function(event){

			// if the user clicks on some form input inside the h3 the box should not be toggled
			if ( jQuery(event.target).filter('input, option, label, select').length )
				return;

			jQuery('#wprs_plugin_meta_box').toggleClass('closed');
		});
	});
	
	
	// hide/show group types
	jQuery("div.wprs_group_type").hide();
	var $radios = jQuery('input:radio[name=_wprs_post_review_type]');
	if($radios.is(':checked') === false) {
		$radios.filter('[value=rating]').prop('checked', true);
		jQuery("div.wprs_group_type").hide();
		jQuery("#wprs_group_rating").show();
	}
				
	if ($radios.filter('[value=rating]').prop('checked')) {
		jQuery("div.wprs_group_type").hide();
		jQuery("#wprs_group_rating").show();
	}
					
	if ($radios.filter('[value=percentage]').prop('checked')) {
		jQuery("div.wprs_group_type").hide();
		jQuery("#wprs_group_percentage").show();
	}
	
	if ($radios.filter('[value=none]').prop('checked')) {
		jQuery("div.wprs_group_type").hide();
		jQuery("#wprs_group_percentage").hide();
	}

	jQuery("input[name=_wprs_post_review_type]").change(function() {
		var wprs_type = $(this).val();
		jQuery("div.wprs_group_type").hide();
		jQuery("#wprs_group_"+wprs_type).show();
	}); 
	
	// rich snippets type switch settings
	jQuery('.wprs_group_main').hide();
	jQuery('.wprs_group_arrow').hide();
	jQuery('#_wprs_post_type_ProductReview').show();

	jQuery('#_wprs_post_snippets_types').change(function () {
		
		jQuery('.wprs_group_arrow').hide();
		jQuery('#_wprs_post_type_'+jQuery(this).val()).show();
		
		// enable/disable radios - Review
		if( jQuery('#_wprs_post_snippets_types').val() == 'Review' ) {
			
			jQuery('#wprs_radio_type_votes input:radio').attr('disabled', 'disabled');
			jQuery('#wprs_radio_type_aggregate input:radio').attr('disabled', 'disabled');
			jQuery('#wprs_radio_type_none input:radio').attr('disabled', 'disabled');
			
			jQuery("label#wprs_radio_type_votes").addClass("wprs_disabled");
			jQuery("label#wprs_radio_type_aggregate").addClass("wprs_disabled");
			jQuery("label#wprs_radio_type_none").addClass("wprs_disabled");
			
			var $radios = jQuery('input:radio[name=_wprs_post_review_type]');
			
			if (!$radios.filter('[value=percentage]').prop('checked')) {
				$radios.filter('[value=rating]').prop('checked', true);
				jQuery('#wprs_group_rating').show();
				jQuery('#wprs_group_percentage').hide();
			}
			
		} else {
			
			jQuery('#wprs_radio_type_votes input:radio').removeAttr( "disabled" );
			jQuery('#wprs_radio_type_aggregate input:radio').removeAttr( "disabled" );
			jQuery('#wprs_radio_type_none input:radio').removeAttr( "disabled" );
			
			jQuery("label#wprs_radio_type_votes").removeClass("wprs_disabled");
			jQuery("label#wprs_radio_type_aggregate").removeClass("wprs_disabled");
			jQuery("label#wprs_radio_type_none").removeClass("wprs_disabled");
			
		}
		
		// enable/disable radios - Organization, Restaurant
		var snippets_typesValue = jQuery('#_wprs_post_snippets_types').val();
		
		if( snippets_typesValue == 'Organization' || snippets_typesValue == 'Restaurant' ) {
			
			jQuery('#wprs_radio_type_rating input:radio').attr('disabled', 'disabled');
			jQuery('#wprs_radio_type_percentage input:radio').attr('disabled', 'disabled');
			
			jQuery("label#wprs_radio_type_rating").addClass("wprs_disabled");
			jQuery("label#wprs_radio_type_percentage").addClass("wprs_disabled");
			
			var $radios = jQuery('input:radio[name=_wprs_post_review_type]');
			
			if ( !$radios.filter('[value=votes]').prop('checked') && !$radios.filter('[value=aggregate]').prop('checked') ) {
				$radios.filter('[value=none]').prop('checked', true);
				jQuery('#wprs_group_rating').hide();
				jQuery('#wprs_group_percentage').hide();
			}
			
			//if ( $radios.filter('[value=rating]').prop('checked') || $radios.filter('[value=aggregate]').prop('checked') ) {
			if ( $radios.filter('[value=none]').prop('checked') ) {
				$radios.filter('[value=none]').prop('checked', true);
				jQuery('#wprs_group_rating').hide();
				jQuery('#wprs_group_percentage').hide();
			}
			
		} else {
			
			jQuery('#wprs_radio_type_rating input:radio').removeAttr( "disabled" );
			jQuery('#wprs_radio_type_percentage input:radio').removeAttr( "disabled" );
			
			jQuery("label#wprs_radio_type_rating").removeClass("wprs_disabled");
			jQuery("label#wprs_radio_type_percentage").removeClass("wprs_disabled");

		}
		
		
		// enable/disable radios - SoftwareApplication
		if( jQuery('#_wprs_post_snippets_types').val() == 'SoftwareApplication' || snippets_typesValue == 'Recipe' ) {
			
			jQuery('#wprs_radio_type_rating input:radio').attr('disabled', 'disabled');
			jQuery('#wprs_radio_type_percentage input:radio').attr('disabled', 'disabled');
			jQuery('#wprs_radio_type_none input:radio').attr('disabled', 'disabled');
			
			jQuery("label#wprs_radio_type_rating").addClass("wprs_disabled");
			jQuery("label#wprs_radio_type_percentage").addClass("wprs_disabled");
			jQuery("label#wprs_radio_type_none").addClass("wprs_disabled");
			
			var $radios = jQuery('input:radio[name=_wprs_post_review_type]');
			
			if (!$radios.filter('[value=aggregate]').prop('checked')) {
				$radios.filter('[value=votes]').prop('checked', true);
				jQuery('#wprs_group_rating').hide();
				jQuery('#wprs_group_percentage').hide();
			}
			
		} else {
			
			//jQuery('#wprs_radio_type_votes input:radio').removeAttr( "disabled" );
			//jQuery('#wprs_radio_type_aggregate input:radio').removeAttr( "disabled" );
			//jQuery('#wprs_radio_type_none input:radio').removeAttr( "disabled" );
			
			//jQuery("label#wprs_radio_type_votes").removeClass("wprs_disabled");
			//jQuery("label#wprs_radio_type_aggregate").removeClass("wprs_disabled");
			//jQuery("label#wprs_radio_type_none").removeClass("wprs_disabled");
			
		}
		
		// enable/disable radios - Article
		if( jQuery('#_wprs_post_snippets_types').val() == 'Article' ) {
			
			jQuery('#wprs_radio_type_rating input:radio').attr('disabled', 'disabled');
			jQuery('#wprs_radio_type_percentage input:radio').attr('disabled', 'disabled');
			//jQuery('#wprs_radio_type_none input:radio').attr('disabled', 'disabled');
			
			jQuery("label#wprs_radio_type_rating").addClass("wprs_disabled");
			jQuery("label#wprs_radio_type_percentage").addClass("wprs_disabled");
			//jQuery("label#wprs_radio_type_none").addClass("wprs_disabled");
			
			var $radios = jQuery('input:radio[name=_wprs_post_review_type]');
			
			if ( !$radios.filter('[value=votes]').prop('checked') && !$radios.filter('[value=aggregate]').prop('checked') ) {
				//$radios.filter('[value=none]').prop('checked', true);
				jQuery('#wprs_group_rating').hide();
				jQuery('#wprs_group_percentage').hide();
			}
			
			if ( $radios.filter('[value=rating]').prop('checked') || $radios.filter('[value=percentage]').prop('checked') ) {
				$radios.filter('[value=votes]').prop('checked', true);
				jQuery('#wprs_group_rating').hide();
				jQuery('#wprs_group_percentage').hide();
			}
			
		} else {
			
			//jQuery('#wprs_radio_type_votes input:radio').removeAttr( "disabled" );
			//jQuery('#wprs_radio_type_aggregate input:radio').removeAttr( "disabled" );
			//jQuery('#wprs_radio_type_none input:radio').removeAttr( "disabled" );
			
			//jQuery("label#wprs_radio_type_votes").removeClass("wprs_disabled");
			//jQuery("label#wprs_radio_type_aggregate").removeClass("wprs_disabled");
			//jQuery("label#wprs_radio_type_none").removeClass("wprs_disabled");
			
		}
	
		
		if( jQuery('#_wprs_post_snippets_types').val() != 'Select') {
			jQuery('.wprs_group_main').show();
		} else {
			jQuery('.wprs_group_main').hide();
		}
		
    });
	
	// add class to labels, for box templates
	var radio = jQuery('label.wprs_radio_image input:checked');
    if ( radio.is(':checked') ) {
        radio.parent().addClass('wprs_active');
    }
	
	jQuery('label.wprs_radio_image input[type=checkbox]').click(function() {
		jQuery(this.parentNode).toggleClass('wprs_active', this.checked);
	});

	jQuery('label.wprs_radio_image input[type=radio]').click(function() {
		jQuery('input[name="' + this.name + '"]').each(function(){
			jQuery(this.parentNode).toggleClass('wprs_active', this.checked);
		});
	});
	
	// set the first tab
	jQuery('#_wprs_post_snippets_types').bind('change', function (e) {
		if( jQuery('#_wprs_post_snippets_types').val() != '') {
			jQuery('#_wprs_post_type_'+jQuery(this).val()).show();
		}
		jQuery('._wprs_post_tab1').eq(0).find('a').click();
	}).trigger('change');
 
});

