<?php

/* ------------------------------------------------------------------*/
/* Admin Notices */
/* ------------------------------------------------------------------*/

/*
* If WooCommerce plugin is installed
* Display notice if WooCommerce Integration Add-on is not installed
*
* @since 1.4.2
*/
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) 
	&& ! in_array( 'wprs-woo/wprs-woo.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) )	) {
	add_action( 'admin_notices', 'wprs_woowommerce_plugin_admin_notice' );
}

function wprs_woowommerce_plugin_admin_notice() {
	
	global $pagenow;
	
	$screen = get_current_screen();
	
	// display only on specific admin pages, WPRS page and plugins page
	if ( $pagenow == 'plugins.php' || $screen->id === 'toplevel_page_wprs' ) {
	
    	?>
    	<div class="update-nag notice wprs_woowommerce_plugin-notice" style="width:95%">
        	<p><?php _e( 'WPRichSnippets require WooCommerece Integration add-on to work properly.', 'wprs' ); ?> <a href="https://wprichsnippets.com/addons/woocommerce/" target="_blank"><?php _e( 'Get WooCommerce Add-on Now!', 'wprs' ); ?></a></p>
    	</div>
    	<?php
	}
}
