<?php
/*
 WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
 this file under any circumstances.
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	
	// check if is editor page
	function wprs_is_edit_page_aggregate($new_edit = null){
    	global $post, $pagenow;
    	//make sure we are on the backend
    	if (!is_admin()) return false;
		// get post id
		$id = isset($_GET['post']) ? $_GET['post'] : null;
		// if post id is not set, then get out!
		if (!isset($id)) return;
		// if WPRichSnippets is not enabled, get out!
		if (!wprs_is_enabled($id)) return;
		// if types is not aggregate, get out!
		if (wprs_get_type_by_id($id) != 'aggregate') return;

		if($new_edit == "edit")
			return in_array( $pagenow, array( 'post.php',  ) );
		elseif($new_edit == "new") //check for new post page
			return in_array( $pagenow, array( 'post-new.php' ) );
		else //check for either new or edit
			return in_array( $pagenow, array( 'post.php', 'post-new.php' ) );
	}


	add_action( 'admin_menu', 'wprs_remove_discussion_meta_box' );
	// remove default discussion meta box
	function wprs_remove_discussion_meta_box() {
		
		if (!wprs_is_edit_page_aggregate()) return;
		
		$post_types = wprs_get_post_types();
		
		foreach ( $post_types as $post_type ) {
			remove_meta_box('commentstatusdiv', $post_type, 'normal');
		}
	
	}


	add_action( 'add_meta_boxes', 'wprs_add_custom_discussion_meta_box' );
	// add custom discussion meta boxes
	function wprs_add_custom_discussion_meta_box() {
		
		if (!wprs_is_edit_page_aggregate()) return;
		// get enabled custom post types array
		$post_types = wprs_get_post_types();
		
	foreach ( $post_types as $post_type ) {
		
						
		add_meta_box(
			'commentsdiv',
			__( 'User Reviews', 'wprs' ),
			'wprs_comment_meta_box',
			$post_type,
			'normal'
		);
		
		add_meta_box(
			'commentstatusdiv',
			__( 'User Reviews Settings', 'wprs' ),
			'wprs_custom_discussion_meta_box',
			$post_type,
			'normal'
		);
		
		
		}
	}

		
	// the custom discussion meta box
	function wprs_comment_meta_box( $post ) {
		global $wpdb;
		wp_nonce_field( 'get-comments', 'add_comment_nonce', false );
		?>
		<?php /* <p class="hide-if-no-js" id="add-new-comment"><a class="button" href="#commentstatusdiv" onclick="commentReply.addcomment(<?php echo $post->ID; ?>);return false;"><?php echo __('Add reviews', 'wprs'); ?></a></p> */ ?>
		<?php
		$total = get_comments( array( 'post_id' => $post->ID, 'number' => 1, 'count' => true ) );
		$wp_list_table = _get_list_table('WP_Post_Comments_List_Table');
		$wp_list_table->display( true );
		if ( 1 > $total ) {
			echo '<p id="no-comments">' . __('No user reviews yet.', 'wprs') . '</p>';
		} else {
			$hidden = get_hidden_meta_boxes( get_current_screen() );
			if ( ! in_array('commentsdiv', $hidden) ) {
				?>
				<script type="text/javascript">jQuery(document).ready(function(){commentsBox.get(<?php echo $total; ?>, 10);});</script>
				<?php
			}
			?>
			<p class="hide-if-no-js" id="show-comments"><a href="#commentstatusdiv" onclick="commentsBox.get(<?php echo $total; ?>);return false;"><?php echo __('Show user reviews', 'wprs'); ?></a> <span class="spinner"></span></p>
			<?php
		}
		wp_comment_trashnotice();
	}


	// the custom discussion meta box 
	function wprs_custom_discussion_meta_box($post) {
		?>
		<input name="advanced_view" type="hidden" value="1" />
        	<p class="meta-options">
            	<label for="comment_status" class="selectit"><input name="comment_status" type="checkbox" id="comment_status" value="open" <?php checked($post->comment_status, 'open'); ?> /> <?php _e( 'Allow user reviews.', 'wprs' ) ?></label><br />
                <label for="ping_status" class="selectit"><input name="ping_status" type="checkbox" id="ping_status" value="open" <?php checked($post->ping_status, 'open'); ?> /> <?php printf( __( 'Allow <a href="%s" target="_blank">trackbacks and pingbacks</a> on this page.' ), __( 'http://codex.wordpress.org/Introduction_to_Blogging#Managing_Comments' ) ); ?></label>
                
				<?php do_action('post_comment_status_meta_box-options', $post); ?>
			</p>
		<?php
		
	}

