<?php
/**
 * @package    WPRS
 * @subpackage Admin
 *
 * Add reviews entries count to the ‘At a glance’ dashboard widget
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


//add_action( 'dashboard_glance_items', 'wprs_dashboard_at_a_glance_widget' );
/**
	* At a glance dashboard
	*/
function wprs_dashboard_at_a_glance_widget() {
    
	global $wprs_prefix;

	$query = new WP_Query( array(
							'meta_key' 		=> 	$wprs_prefix.'snippets_types',
							'post_status'	=>	'publish',
							'posts_per_page' => -1
						) );

   	$num_posts = $query->found_posts;
	
	$text = _n( __('Review', 'wprs'), __('Reviews', 'wprs'), intval( $num_posts ) );
	
	 if ( current_user_can( 'edit_posts' ) ) {
		
		$output = '<a href="admin.php?page=wprs-list">' . $num_posts . ' ' . $text . '</a>';
		
		echo '<li class="post-count ' . 'wprs_entries' . '_count">' . $output . '</li>';
		
	 }

}

