<?php
/*
 WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
 this file under any circumstances.
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	// include the news section in admin page
	function wprs_display_news_page(){
		
		include_once( ABSPATH . WPINC . '/feed.php' );
		
		// Get a SimplePie feed object from the specified feed source.
		$rss = fetch_feed( 'http://wprichsnippets.com/feed/' );

		if ( ! is_wp_error( $rss ) ) : // Checks that the object is created correctly

		// Figure out how many total items there are, but limit it to 5. 
		$maxitems = $rss->get_item_quantity( 5 ); 

		// Build an array of all the items, starting with element 0 (first element).
		$rss_items = $rss->get_items( 0, $maxitems );

		endif;
		
		// build our news page
?>

		<div class="wrap">
			<h2 id="wprs_news_headline">
				<?php _e(WPRICHSNIPPETS_PLUGINNAME.' - <a href="https://wprichsnippets.com/blog/" title="Blog News" target="_blank">Blog News</a>'); ?>
			</h2>
            <br /><br />
	
<?php foreach ( $rss_items as $item ) {

				$creators = $item->get_item_tags(SIMPLEPIE_NAMESPACE_DC_11, 'creator');
				$creator_string = is_array($creators) ? sprintf('<em>by</em> <span class="wprs_news_item_creator">%s</span>', $creators[0]['data']) : ''; 
				$content = $item->get_content();
				$content_formatted = wpautop(substr($content, 0, strpos($content, '<div>')));
?>
				<div class="wprs_news_item">
					<h3><a href="<?php esc_attr_e($item->get_link()); ?>"><?php esc_html_e($item->get_title()); ?></a></h3>
					<p><?php printf('<span class="wprs_news_item_date">%s</span> %s', $item->get_date(get_option('date_format')), $creator_string); ?></p>
<?php
					//echo $content_formatted;
					echo '<p>' . strip_tags(substr($content_formatted, 0, 450)) . '</p>';
?>
				</div>
<?php		} ?>
		</div>
<?php
	}
