<?php

/* ----------------------------------------
* To retrieve a value use: $wprs_options[$wprs_prefix.'var']
----------------------------------------- */

global $wprs_prefix;

$wprs_prefix = 'wprs_';

/* ----------------------------------------
* Create the TABS
----------------------------------------- */
global $wprs_custom_tabs;

$wprs_custom_tabs = array(
		array(
			'label' => '<span class="fa fa-cog"></span> ' . __('General', 'wprs'),
			'id'	=> $wprs_prefix.'general'
		),
		array(
			'label' => '<span class="fa fa-group"></span> ' . __('Rating', 'wprs'),
			'id'	=> $wprs_prefix.'rating'
		),
		array(
			'label' => '<span class="fa fa-desktop"></span> ' . __('Display', 'wprs'),
			'id'	=> $wprs_prefix.'display'
		),
		array(
			'label' => '<span class="fa fa-sliders"></span> ' . __('Criteria', 'wprs'),
			'id'	=> $wprs_prefix.'criteria'
		),
		array(
			'label' => '<span class="fa fa-cogs"></span> ' . __('Technical', 'wprs'),
			'id'	=> $wprs_prefix.'technical'
		),
		array(
			'label' => '<span class="fa fa-heart-o"></span> ' . __('Misc', 'wprs'),
			'id'	=> $wprs_prefix.'misc'
		)
	);


/* ----------------------------------------
* Options Field Array
----------------------------------------- */
global $wprs_custom_meta_fields;

$wprs_custom_meta_fields = array( 

	/* -- TAB 1 -- */
	array(
		'id'	=> $wprs_prefix.'general', // Use data in $wprs_custom_tabs
		'type'	=> 'tab_start'
	),
	
	array(
		'label' => 'Diagnostic Data',
		'desc'	=> 'Allow collecting diagnostic data? <br> Want to help make WPRichSnippets even more awesome? Allow us to collect non-sensitive diagnostic data and usage information, which help us to fix issues and provide a better support.',
		'id'	=> $wprs_prefix.'chk_allow_tracking',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Currency',
		'desc'	=> 'Select currency.<br>This is required for the user rating system to work.',
		'id'	=> $wprs_prefix.'currency',
		'type'	=> 'select',
		'options' => array (
			'USD' => array (
				'label' => 'USD',
				'value'	=> 'USD'
			),
			'AED' => array (
				'label' => 'AED',
				'value'	=> 'AED'
			),
			'AUD' => array (
				'label' => 'AUD',
				'value'	=> 'AUD'
			),
			'BTC' => array (
				'label' => 'BTC',
				'value'	=> 'BTC'
			),
			'BRL' => array (
				'label' => 'BRL',
				'value'	=> 'BRL'
			),
			'CAD' => array (
				'label' => 'CAD',
				'value'	=> 'CAD'
			),
			'CZK' => array (
				'label' => 'CZK',
				'value'	=> 'CZK'
			),
			'DKK' => array (
				'label' => 'DKK',
				'value'	=> 'DKK'
			),
			'EUR' => array (
				'label' => 'EUR',
				'value'	=> 'EUR'
			),
			'HKD' => array (
				'label' => 'HKD',
				'value'	=> 'HKD'
			),
			'HUF' => array (
				'label' => 'HUF',
				'value'	=> 'HUF'
			),
			'INR' => array (
				'label' => 'INR',
				'value'	=> 'INR'
			),
			'IRR' => array (
				'label' => 'IRR',
				'value'	=> 'IRR'
			),
			'INR' => array (
				'label' => 'INR',
				'value'	=> 'INR'
			),
			'JPY' => array (
				'label' => 'JPY',
				'value'	=> 'JPY'
			),
			'MYR' => array (
				'label' => 'MYR',
				'value'	=> 'MYR'
			),
			'MXN' => array (
				'label' => 'MXN',
				'value'	=> 'MXN'
			),
			'NGN' => array (
				'label' => 'NGN',
				'value'	=> 'NGN'
			),
			'NOK' => array (
				'label' => 'NOK',
				'value'	=> 'NOK'
			),
			'NZD' => array (
				'label' => 'NZD',
				'value'	=> 'NZD'
			),
			'PHP' => array (
				'label' => 'PHP',
				'value'	=> 'PHP'
			),
			'PLN' => array (
				'label' => 'PLN',
				'value'	=> 'PLN'
			),
			'GBP' => array (
				'label' => 'GBP',
				'value'	=> 'GBP'
			),
			'SGD' => array (
				'label' => 'SGD',
				'value'	=> 'SGD'
			),
			'SEK' => array (
				'label' => 'SEK',
				'value'	=> 'SEK'
			),
			'CHF' => array (
				'label' => 'CHF',
				'value'	=> 'CHF'
			),
			'TWD' => array (
				'label' => 'TWD',
				'value'	=> 'TWD'
			),
			'THB' => array (
				'label' => 'THB',
				'value'	=> 'THB'
			),
			'ZAR' => array (
				'label' => 'ZAR',
				'value'	=> 'ZAR'
			)
		)
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Custom Post Types',
		'desc'	=> 'Enabled reviews on specific custom post types.',
		'id'	=> $wprs_prefix.'chk_post_type_',
		'type'	=> 'cpt'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Publisher',
		'desc'	=> 'Name of the Organization/Author of content',
		'id'	=> $wprs_prefix.'publisher_name',
		'type'	=> 'text',
	),
	array(
		'label' => '',
		'desc'	=> 'Organization/Author url',
		'id'	=> $wprs_prefix.'publisher_url',
		'type'	=> 'text'
	),
	array(
		'label' => '',
		'desc'	=> 'Organization/Author logo url',
		'id'	=> $wprs_prefix.'publisher_logo_url',
		'type'	=> 'text'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Disclose Paid Reviews',
		'desc'	=> 'Link title (example: <i class="fa fa-exclamation-circle"></i> Disclaimer)',
		'id'	=> $wprs_prefix.'disclaimer_title',
		'type'	=> 'text'
	),
	array(
		'label' => 'Disclose Page URL',
		'desc'	=> 'Enter your Disclaimer Page full URL. <br> This will display an icon with a link to the Disclaimer Page in the review box (this field is required for the Disclaimer link to show)',
		'id'	=> $wprs_prefix.'disclaimer_url',
		'type'	=> 'text'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Links Target',
		'desc'	=> 'Open all links in the same window? <br> By default all links open in a new window, use this check box to open them in the same window.',
		'id'	=> $wprs_prefix.'chk_link_window',
		'type'	=> 'checkbox'
	),
	
	array(
		'type'	=> 'tab_end'
	),
	/* -- /TAB 1 -- */
	
	/* -- TAB 2 -- */
	array(
		'id'	=> $wprs_prefix.'rating', // Use data in $wpsr_custom_tabs
		'type'	=> 'tab_start'
	),
	
	/*
	array(
		'label' => 'Author Rating',
		'desc'	=> 'Disable author rating on all reviews?',
		'id'	=> $wprs_prefix.'chk_author_rating_disable',
		'type'	=> 'checkbox'
	),
	array(
		'label' => 'User Rating',
		'desc'	=> 'Enable user reviews system?',
		'id'	=> $wprs_prefix.'chk_user_rating_enable',
		'type'	=> 'checkbox'
	),
	*/
	
	array(
		'label' => 'Site Visitors',
		'desc'	=> 'Enable user reviews for site visitors? (anyone can rate)',
		'id'	=> $wprs_prefix.'chk_user_rating_visitors_enable',
		'type'	=> 'checkbox'
	),
	
	
	array(
		'label' => 'Make User Rating Required',
		'desc'	=> 'Users must choose a rating?',
		'id'	=> $wprs_prefix.'chk_user_rating_required',
		'type'	=> 'checkbox'
	),
	
	array(
		'label' => 'Enable User Rating Popup',
		'desc'	=> 'Enable users to submit reviews via a popup form?<br>(note: this option will attempt to hide the default WordPress commenting system, it may not for all themes)',
		'id'	=> $wprs_prefix.'chk_user_rating_popup_enable',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Hide User Rating From Comment Replies',
		'desc'	=> 'Attempt to hide user rating from replies?<br>(note: in order to make this option work best, Do NOT make user rating required, make sure the check box above it not checked)',
		'id'	=> $wprs_prefix.'chk_replytocom',
		'type'	=> 'checkbox'
	),
	
	array(
		'label' => 'User Comment url',
		'desc'	=> 'Disable user comment URL/Website field?<br>(note: this option works only for Themes that uses defaul WordPress commenting system)',
		'id'	=> $wprs_prefix.'chk_user_comment_url_disable',
		'type'	=> 'checkbox'
	),
	
	array(
		'label' => 'Avatars',
		'desc'	=> 'Load avatars via WordPress settings?<br>(note: The plugin has its own way to display avatars in user aggregate reviews, in some cases you will need to switch to the default WordPress avatar functionality)',
		'id'	=> $wprs_prefix.'chk_wp_avatars',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'IP Address',
		'desc'	=> 'Enable IP address check? (prevent multiple votes)',
		'id'	=> $wprs_prefix.'chk_user_rating_ip',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Reset Vote IPs',
		'id'	=> $wprs_prefix.'reset_vote_ips',
		'type'	=> 'reset_vote_ips',
		'desc'	=> 'Use this feature only if you want to reset/delete IPs stored in post meta off entries.',
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Reset Vote All Data',
		'id'	=> $wprs_prefix.'reset_vote_all_data',
		'type'	=> 'reset_vote_ips',
		'desc'	=> 'Use this feature only if you want to reset/delete all votes data.',
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Update User Rating Data',
		'desc'	=> 'Click on this button to update all user review data.<br>(note: use it after deleting/adding/approving user reviews)',
		'id'	=> $wprs_prefix.'update_user_rating',
		'type'	=> 'update_user_rating'
	),
	
	array(
		'type'	=> 'tab_end'
	),
	/* -- /TAB 2 -- */
	
	/* -- TAB 3 -- */
	array(
		'id'	=> $wprs_prefix.'display', // Use data in $wprs_custom_tabs
		'type'	=> 'tab_start'
	),
	/*
	array(
		'label' => 'Display Settings',
		'desc'	=> 'Try to display rating stars on home page?',
		'id'	=> $wprs_prefix.'chk_rating_home_display',
		'type'	=> 'checkbox'
	),
	array(
		'label' => '',
		'desc'	=> 'Try to display rating stars on archive pages?',
		'id'	=> $wprs_prefix.'chk_rating_archives_display',
		'type'	=> 'checkbox'
	),
	*/
	array(
		'label' => 'Display Settings',
		'desc'	=> 'Show Box below content?',
		'id'	=> $wprs_prefix.'chk_display_box_below_content',
		'type'	=> 'checkbox'
	),
	
	array(
		'label' => '',
		'desc'	=> 'Display item description below the Box?',
		'id'	=> $wprs_prefix.'chk_display_description_in_box',
		'type'	=> 'checkbox'
	),

	array(
		'label' => '',
		'desc'	=> 'Hide criteria on user reviews?',
		'id'	=> $wprs_prefix.'chk_user_criteria_to_author_display',
		'type'	=> 'checkbox'
	),
	
	array(
		'label' => '',
		'desc'	=> 'Hide avatars on user reviews?',
		'id'	=> $wprs_prefix.'chk_user_avatar_hide',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label'=> '',
		'desc'	=> 'Order user aggregate reviews by?',
		'id'	=> $wprs_prefix.'drp_aggregate_pagination_order_by',
		'type'	=> 'select',
		'options' => array (
			'comment_date_gmt' => array (
				'label' => 'Date',
				'value'	=> 'comment_date_gmt'
			),
			'rating' => array (
				'label' => 'Rating',
				'value'	=> 'rating'
			)
		)
	),
	
	array(
		'label'=> '',
		'desc'	=> 'Number or user aggregate reviews per page?',
		'id'	=> $wprs_prefix.'drp_aggregate_pagination_per_page',
		'type'	=> 'select',
		'options' => array (
			'all' => array (
				'label' => 'All',
				'value'	=> ''
			),
			'5' => array (
				'label' => '5',
				'value'	=> 5
			),
			'10' => array (
				'label' => '10',
				'value'	=> 10
			),
			'20' => array (
				'label' => '20',
				'value'	=> 20
			),
			'50' => array (
				'label' => '50',
				'value'	=>50
			),
			'100' => array (
				'label' => '100',
				'value'	=> 100
			),
			'200' => array (
				'label' => '200',
				'value'	=> 200
			)
		)
	),
	
	array(
		'label' => '',
		'desc'	=> 'Enable user aggregate reviews pagination? <br /><br />If you have big number of user reviews you can enable pagination view.
					<br />However, this is not recommended for your page SEO, the recommended action is to display all.',
		'id'	=> $wprs_prefix.'chk_aggregate_pagination_enable',
		'type'	=> 'checkbox'
	),
	
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Other Display Settings',
		'desc'	=> '<i class="fa fa-exclamation-triangle"></i> Activating the below to not show the selected review details is NOT recommended, Google wants to show review details, so use them at your own risk',
		'id'	=> $wprs_prefix.'note',
		'type'	=> 'note'
	),
	
	/*
	array(
		'label' => '',
		'desc'	=> 'Hide Rating Box on all reviews? (Not Recommended!)',
		'id'	=> $wprs_prefix.'chk_rating_box_hide',
		'type'	=> 'checkbox'
	),
	*/
	array(
		'label' => '',
		'desc'	=> 'Hide author name on all reviews?',
		'id'	=> $wprs_prefix.'chk_reviewed_by_hide',
		'type'	=> 'checkbox'
	),
	array(
		'label' => '',
		'desc'	=> 'Hide date on all reviews?',
		'id'	=> $wprs_prefix.'chk_rating_date_hide',
		'type'	=> 'checkbox'
	),
	array(
		'label' => '',
		'desc'	=> 'Hide last modified date on all reviews?',
		'id'	=> $wprs_prefix.'chk_rating_modified_date_hide',
		'type'	=> 'checkbox'
	),
	array(
		'label' => '',
		'desc'	=> 'Hide the Price?',
		'id'	=> $wprs_prefix.'chk_price_hide',
		'type'	=> 'checkbox'
	),
	array(
		'label' => '',
		'desc'	=> 'Hide only the currency symbol?',
		'id'	=> $wprs_prefix.'chk_currency_symbol_hide',
		'type'	=> 'checkbox'
	),
	/*array(
		'label' => '',
		'desc'	=> 'Show "Mini" rating box below content?',
		'id'	=> $wprs_prefix.'chk_rating_box_below',
		'type'	=> 'checkbox'
	),*/
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label'=> 'Button Color',
		'desc'	=> 'Select button color.',
		'id'	=> $wprs_prefix.'drp_button_color',
		'type'	=> 'select',
		'options' => array (
			'blue' => array (
				'label' => 'Blue',
				'value'	=> 'blue'
			),
			'orange' => array (
				'label' => 'Orange',
				'value'	=> 'orange'
			),
			'green' => array (
				'label' => 'Green',
				'value'	=> 'green'
			),
			'red' => array (
				'label' => 'Red',
				'value'	=> 'red'
			),
			'yellow' => array (
				'label' => 'Yellow',
				'value'	=> 'yellow'
			),
			'white' => array (
				'label' => 'White',
				'value'	=> 'white'
			),
			'purple' => array (
				'label' => 'Purple',
				'value'	=> 'purple'
			),
			'gray' => array (
				'label' => 'Gray',
				'value'	=> 'gray'
			)
		)
	),
	array(
		'label' => 'Button Text',
		'desc'	=> 'Default (More Details)',
		'id'	=> $wprs_prefix.'more_details_btn_value',
		'type'	=> 'text'
	),
	array(
		'label' => 'Button Icon',
		'desc'	=> 'Example (fa-link) <br> Check more icons at <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">FontAwesome</a>.',
		'id'	=> $wprs_prefix.'btn_icon',
		'type'	=> 'text'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label'=> 'Demo Button Color',
		'desc'	=> 'Select button color.',
		'id'	=> $wprs_prefix.'drp_button_dcolor',
		'type'	=> 'select',
		'options' => array (
			'blue' => array (
				'label' => 'Blue',
				'value'	=> 'blue'
			),
			'orange' => array (
				'label' => 'Orange',
				'value'	=> 'orange'
			),
			'green' => array (
				'label' => 'Green',
				'value'	=> 'green'
			),
			'red' => array (
				'label' => 'Red',
				'value'	=> 'red'
			),
			'yellow' => array (
				'label' => 'Yellow',
				'value'	=> 'yellow'
			),
			'white' => array (
				'label' => 'White',
				'value'	=> 'white'
			),
			'purple' => array (
				'label' => 'Purple',
				'value'	=> 'purple'
			),
			'gray' => array (
				'label' => 'Gray',
				'value'	=> 'gray'
			)
		)
	),
	array(
		'label' => 'Demo Button Text',
		'desc'	=> 'Default (Demo)',
		'id'	=> $wprs_prefix.'demo_btn_value',
		'type'	=> 'text'
	),
	
	array(
		'label' => 'Demo Button Icon',
		'desc'	=> 'Example (fa-eye) <br> Check more icons at <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">FontAwesome</a>.',
		'id'	=> $wprs_prefix.'dbtn_icon',
		'type'	=> 'text'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Extras',
		'desc'	=> 'Disable WordPress featured images on Box?',
		'id'	=> $wprs_prefix.'chk_featured_img_disable',
		'type'	=> 'checkbox'
	),
	
	array(
		'label' => '',
		'desc'	=> 'Unlink images for better SEO?',
		'id'	=> $wprs_prefix.'chk_unlink_imgs',
		'type'	=> 'checkbox'
	),
	
	array(
		'label' => '',
		'desc'	=> 'Show (FREE) when price set to "0.00"?',
		'id'	=> $wprs_prefix.'chk_rating_box_free',
		'type'	=> 'checkbox'
	),
	
	array(
		'type'	=> 'tab_end'
	),
	/* -- /TAB 3 -- */
	
	/* -- TAB 4 -- */
	array(
		'id'	=> $wprs_prefix.'criteria', // Use data in $wprs_custom_tabs
		'type'	=> 'tab_start'
	),
	
	array(
		'label' => 'Default Criteria',
		'desc'	=> 'Enable default criteria fields?<br />Enable this option if you would like to use the default criteria fields within all your reviews.',
		'id'	=> $wprs_prefix.'chk_default_criteria',
		'type'	=> 'checkbox'
	),
	
	array(
		'label'	=> 'Default Criteria Fields',
		'desc'	=> 'Add default custom criteria to your reviews (tip: fields are sortable)<br /><br /><i class="fa fa-exclamation-circle" style="font-size:14px;line-height:14px;"></i> Important: Once you saved the settings, avoid editing the Unique ID.<br />Also, note that if you delete any criteria field, all user ratings assocated to its ID will Not be used anymore.',
		'id'	=> $wprs_prefix.'repeatable',
		'type'	=> 'repeatable'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Update Criteria',
		'desc'	=> 'Click on this button to add default criteria to all reviews (including old reviews).<br />(note: be careful with this option; all old reviews will be update, so you may lose old criteria data if you use differnt criteria ids)',
		'id'	=> $wprs_prefix.'update_user_rating',
		'type'	=> 'update_criteria'
	),
	
	array(
		'type'	=> 'tab_end'
	),
	/* -- /TAB 4 -- */

	/* -- TAB 5 -- */
	array(
		'id'	=> $wprs_prefix.'technical', // Use data in $wprs_custom_tabs
		'type'	=> 'tab_start'
	),
	
	/*
	array(
		'label' => 'More snippets',
		'desc'	=> 'Add more snippets? <br><br>Enable this option to add extra meta itemprop to the head section.
                    <br>(note: probably you will not need to enable this option, use it only when you are asked too)',
		'id'	=> $wprs_prefix.'chk_more_snippet',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	*/
	array(
		'label' => 'Stylesheet',
		'desc'	=> 'Disable loading of stylesheet? <br><br>Use this if you do not want to load the stylesheet and combine the style to your own global style sheet.
                        <br>(note: use the content of the <code>assets/css/style_front.css</code> file)',
		'id'	=> $wprs_prefix.'chk_no_css',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Bootstrap Styles',
		'desc'	=> 'Disable loading of Bootstrap styles? <br><br>Use this if you do not want to load the Twitter Bootstrap stylesheet and combine the style
					to your own global style sheet.
                    <br>(note: use the content of the <code>/assets/css/bootstrap.min.css</code> file)',
		'id'	=> $wprs_prefix.'no_bootstrap',
		'type'	=> 'checkbox'
	),
	
	/*
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Bootstrap Scripts',
		'desc'	=> 'Disable loading of Bootstrap scripts? <br><br>Use this if you do not want to load the Twitter Bootstrap scripts.',
		'id'	=> $wprs_prefix.'no_bootstrap_js',
		'type'	=> 'checkbox'
	),
	*/
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Font Awesome',
		'desc'	=> 'Disable loading of Font Awesome? <br><br>Use this if you do not want to load Font Awesome.
                         <br>(note: Font Awesome is required to show the rating stars, mostly keep this option unchcked)',
		'id'	=> $wprs_prefix.'no_fontawesome',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'jQuery',
		'desc'	=> 'Disable loading jQuery? <br><br>Use this if you do not want to load jQuery.
                         <br>(note: jQuery version 1.9.1 is required for user rating stars, mostly keep this option unchcked)',
		'id'	=> $wprs_prefix.'no_jquery',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'jQuery UI',
		'desc'	=> 'Disable loading jQuery UI? <br><br>Use this if you do not want to load jQuery UI.
                         <br>(note: jQuery UI version 3.4.1 is required for user rating slide range, mostly keep this option unchcked)',
		'id'	=> $wprs_prefix.'no_jquery_ui',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'jQuery UI Touch Punch',
		'desc'	=> 'Disable loading jQuery UI Touch Punch? <br><br>Use this if you do not want to load jQuery UI Touch Punch.
                         <br>(note: jQuery UI Touch Punch version 0.2.2 is required for user rating slide range,
						 it adds touch feature to tablets and mobile devices, mostly keep this option unchcked)',
		'id'	=> $wprs_prefix.'no_jquery_ui_touch_punch',
		'type'	=> 'checkbox'
	),
	
	array ('id'	=> '', 'label' => '', 'type' => 'spacer'),
	
	array(
		'label' => 'Reset',
		'id'	=> $wprs_prefix.'reset',
		'type'	=> 'reset_api'
	),
	
	array(
		'type'	=> 'tab_end'
	),
	/* -- /TAB 5 -- */
	
	/* -- TAB 6 -- */
	array(
		'id'	=> $wprs_prefix.'misc', // Use data in $wprs_custom_tabs
		'type'	=> 'tab_start'
	),
	
	array(
		'label' => '',
		'id'	=> $wprs_prefix.'misc',
		'type'	=> 'misc'
	),
	
	array(
		'type'	=> 'tab_end'
	),
	/* -- /TAB 6 -- */
);
