<?php

/* ----------------------------------------
* Plugin Globals
----------------------------------------- */

global $wprs_base_dir;
$wprs_base_dir = dirname(__FILE__);

global $wprs_prefix;
$wprs_prefix = 'wprs_';

if(!defined('WPRS_PLUGIN_DIR')) {
	define('WPRS_PLUGIN_DIR', plugin_dir_url( __FILE__ ));
}


/* ----------------------------------------
	Includes
----------------------------------------- */

if( isset($_GET['page']) AND $_GET['page'] == 'wprs' ) {
	include($wprs_base_dir . '/includes/styles.php');
	include($wprs_base_dir . '/includes/options.php');
	include($wprs_base_dir . '/includes/functions/wprs-functions.php');
	include($wprs_base_dir . '/includes/scripts.php');
	include($wprs_base_dir . '/includes/help.php');
}

include($wprs_base_dir . '/includes/shortcodes.php');

include($wprs_base_dir . '/includes/misc/wprs-footer-details.php');

include($wprs_base_dir . '/includes/misc/wprs-custom-post-meta.php');
include($wprs_base_dir . '/includes/misc/wprs-list-all.php');
include($wprs_base_dir . '/includes/misc/wprs-news.php');
include($wprs_base_dir . '/includes/misc/wprs-glance.php');
	
/* ----------------------------------------
* load plugin data
----------------------------------------- */

$wprs_options = get_option('wprs_options');


/* ----------------------------------------
* register the plugin settings
----------------------------------------- */

function wprs_register_settings() {

	// create whitelist of options
	register_setting( 'wprs_options_group', 'wprs_options' );
}
//call register settings function
add_action( 'admin_init', 'wprs_register_settings', 100 );


/* ------------------------------------------------------------------*/
/* GET AN IMAGE FROM GLOBAL STRING */
/* ------------------------------------------------------------------*/

function wprs_image($field_id,  $width = '', $height = '') {
	
	global $wprs_options;
	
	if( isset($field_id) ) {
	
		// Get attachment data
		$image_data = wp_get_attachment_image_src( $wprs_options["$field_id"], '' );
		
		//print_r( $image_data );
		
		// get URL
		$url = $image_data[0];
		
		// Height and width
		if( $height != '' && $width != '' ) {
			$height = $height;
			$width 	= $width;
		} else {
			$width = $image_data[1];
			$height = $image_data[2];
		}

		echo '<img src="'.$url.'" with="'.$width.'" height="'.$height.'"/>'; 
		
	}
}

/* ------------------------------------------------------------------*/
/* RETURN AN IMAGE URL FROM GLOBAL STRING */
/* ------------------------------------------------------------------*/

function wprs_get_image($field_id) {
	
	global $wprs_options;
	
	if( isset($field_id) ) {
	
		// Get attachment data
		$image_data = wp_get_attachment_image_src( $wprs_options["$field_id"], '' );
		
		// get URL
		$url = $image_data[0];
	
		return $url;
		
	}
}

/* ----------------------------------------
* function to retrieve the get_option() value
----------------------------------------- */

function wprs_get_option($option_name) {
	$wprs_options = get_option('wprs_options');
	return $wprs_options[$option_name];
}


/* ----------------------------------------
* function to retrieve an option
----------------------------------------- */

function wprs_get_an_option( $key = '', $default = false ) {
	global $wprs_options;
	$value = ! empty( $wprs_options[ $key ] ) ? $wprs_options[ $key ] : $default;
	$value = apply_filters( 'wprs_get_option', $value, $key, $default );
	return apply_filters( 'wprs_get_option_' . $key, $value, $key, $default );
}


/* ----------------------------------------
* create the settings page layout
----------------------------------------- */

function wprs_options_page() {
	
	global $wprs_options;
		
	?>
	<div class="wrap">
		<?php
        echo '<h2>'.WPRICHSNIPPETS_PLUGINNAME.' '.__('Settings','wprs').' <span style="font-size:10px;">'.__('Ver','wprs').' '.WPRICHSNIPPETS_VER.'</span></h2>';
		//echo '<p>'.__('Get more control over Google SERPs.','wprs').'</p>';
		if ( ! isset( $_REQUEST['settings-updated'] ) )
			$_REQUEST['settings-updated'] = false;
		if ( false !== $_REQUEST['settings-updated'] ) { ?>
			<div class="updated fade"><p><strong><?php _e( 'Options saved', 'wprs' ); ?></strong></p></div>
        <?php } else {
        
			if ( ! isset( $_REQUEST['update_rating'] ) )
				$_REQUEST['update_rating'] = false;
			
			if ( false !== $_REQUEST['update_rating'] ) : ?>
				<div class="updated fade updated_success"><p><strong><?php _e( 'Success! User Reviews has been fully updated', 'wprs' ); ?></strong></p></div>
		<?php endif;
		
		if ( ! isset( $_REQUEST['update_criteria'] ) )
				$_REQUEST['update_criteria'] = false;
			
			if ( false !== $_REQUEST['update_criteria'] ) : ?>
				<div class="updated fade updated_success"><p><strong><?php _e( 'Success! Criteria fields has been fully updated', 'wprs' ); ?></strong></p></div>
		<?php endif; } 
        
        if ( ! isset( $_REQUEST['reset_vote_ips'] ) )
				$_REQUEST['reset_vote_ips'] = false;
			
			if ( false !== $_REQUEST['reset_vote_ips'] ) : ?>
				<div class="updated fade updated_success"><p><strong><?php _e( 'Success! Vote IPs has been reset.', 'wprs' ); ?></strong></p></div>
		<?php endif; ?>
  
		<form method="post" action="options.php" class="wprs_options_form">

			<?php settings_fields( addslashes('wprs_options_group') ); ?>
			
			<?php wprs_show_custom_tabs(); ?>

			<?php wprs_show_custom_fields(); ?>
			
			<!-- save the options -->
			<p class="submit">
				<input type="submit" class="button-primary" value="<?php _e( 'Save Options', 'wprs' ); ?>" />
			</p>
			
		</form>
	</div><!--end .wrap-->
	<?php
}


/* ----------------------------------------
* create the settings page layout
----------------------------------------- */

function wprs_import_export_page() {

	$wprs_options = get_option( 'wprs_options' );
	$currentsettings = "";
	if ( isset( $_POST['import'] ) && trim($_POST['wprs_import_settings']) != "" ) {
		$currentsettings = $_POST['gpp_import_settings'];
	} elseif ( isset( $wprs_options ) && ( $wprs_options != "" ) ) {	
		$currentsettings = base64_encode( serialize( $wprs_options ) );		
	} 
		
	?>
	<div class="wrap">
		<?php
		echo '<h2>'.WPRICHSNIPPETS_PLUGINNAME.' '.__('Import / Export','wprs').' <span style="font-size:10px;">'.__('Ver','wprs').' '.WPRICHSNIPPETS_VER.'</span></h2>';
		if ( isset( $_POST['import'] ) && $_POST['wprs_import_settings'] != "" ) { ?>
		<div class="updated fade"><p><strong><?php _e('Settings imported successfully!', 'wprs'); ?></strong></p></div>
		<?php } ?>
		
	<div class="wrap" id="transport_settings">

		<p class="description"><?php _e('Here you can import and export settings from one installation to another.', 'wprs'); ?></p>
		<div class="option option-textarea">
			<div class="option-inner">
				<label class="titledesc"><h3><?php _e('Import Options', 'wprs'); ?></h3></label>
				<div class="formcontainer">
					<div class="forminp">
						<form id="impexp" method="post" action="#">
						<textarea rows="8" cols="60" id="wprs_import_settings" name="wprs_import_settings" class=""></textarea><br />
						<div class="desc"><?php _e('Paste the encoded plugin settings from export options field of your development site or another installation.', 'wprs'); ?></div>
						<input type="submit" value="<?php _e('Import', 'wprs'); ?>" id="import" name="import" class="button-primary" onClick="return confirm('<?php _e('Are you sure you want to import the settings?', 'wprs'); ?>')"> 
						</form>
					</div>
					
				</div>
			</div>
		</div>
		<div class="option option-textarea">
			<div class="option-inner">
				<label class="titledesc"><h3><?php _e('Export Options', 'wprs'); ?></h3></label>
				<div class="formcontainer">
					<div class="forminp">
						<textarea rows="8" cols="60" id="wprs_export_settings" name="wprs_export_settings" class="" readonly="readonly"><?php echo $currentsettings; ?></textarea>					
					</div>
					<div class="desc"><?php _e('Copy this encoded plugin settings to import settings into another installation.', 'wprs'); ?></div>
				</div>
			</div>
		</div>
	 </div>

	</div><!--end .wrap-->
	<?php
}

add_action( 'admin_menu', 'wprs_import_settings' );
function wprs_import_settings(){
	
	global $wprs_prefix;

	if ( isset( $_POST['import'] ) && trim($_POST['wprs_import_settings']) != "" ) {	
		update_option( 'wprs_options', unserialize(wprs_decode($_POST['wprs_import_settings'])) );
	}
}


/* ------------------------------------------------------------------*/
/* Helper function to return decoded strings
/* ------------------------------------------------------------------*/
function wprs_decode( $value ) {
  $func = 'base64' . '_decode';
  return $func( $value );
}

/* ------------------------------------------------------------------*/
/* UNINSTALL PLUGIN */
/* ------------------------------------------------------------------*/

function wprs_uninstall () 
{
    // Uncomment the line above to delete all data at plugin uninstall
    /* delete_option('wprs_options'); */
}

register_deactivation_hook( __FILE__, 'wprs_uninstall' );
