<?php
/*
	WPRichSnippets post meta box 
 
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	// set post meta prefix
	global $wprs_prefix;	
	$wprs_prefix = '_wprs_post_';

	// get options
	$options = get_option('wprs_options');
	// set more details button value
	if (isset($options['wprs_more_details_btn_value']) != ''){$rating_box_btn_value = $options['wprs_more_details_btn_value'];} else {$rating_box_btn_value = __('More Details','wprs');}


global $wprs_meta_box;
// meta box
$wprs_meta_box = array(
	'id' => 'wprs_plugin_meta_box',
	'title' => __('Schema', 'wprs'),
	'page' => 'post',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		
		// Snippets Types //////////////////////////////////////////////
		array(
			'name'		=>	__('Schema Type', 'wprs'),
			'id'		=>	$wprs_prefix . 'snippets_types',
			'type'		=>	'snippets_types',
			'options'	=>	array(
				''						=> 'Select',
				'Article'				=> 'Article',
				'Recipe'				=> 'Recipe',
				'Review'				=> 'Review',
				'Product'				=> 'Product',
				'Organization'			=> 'Organization',
				'Restaurant'			=> 'Restaurant',
				'SoftwareApplication'	=> 'SoftwareApplication',
				//'Video'					=> 'Video',
				//'Event'				=> 'Event',
				//'Movie'				=> 'Movie',
				//'Book'				=> 'Book',
				//'Person'				=> 'Person',
				//'Item'				=> 'Item',
			),
			'multiple'	=> false,
			'std'		=> array( 'Select' ),
			'desc'		=> ''
			),
			
		// Open tab 1	//////////////////////////////////////////////
		array(
			'name'	=> 'Main',
			'id'	=> $wprs_prefix . 'tab1',
			'type'	=> 'start',
			'std'	=> '',
		),
		
		// Open sub tab select	//////////////////////////////////////
		array(
			'name'	=> 'Type Select',
			'id'	=> $wprs_prefix . 'type_Select',
			'type'	=> 'sub_open',
			'std'	=> '',
		),
		
		array(
			'name'	=> 'No Schema has been selected yet!',
			'tip'	=> '',
			'desc'	=> 'To enable Schema, select a type from the drop list above.',
			'id'	=> $wprs_prefix . 'snippets_types_select',
			'type'	=> 'snippets_types_select',
			'std'	=> ''
		),
		
		// close sub tab select	//////////////////////////////////
		array(
			'name'	=> 'Type Select',
			'id'	=> $wprs_prefix . 'type_Select',
			'type'	=> 'sub_close',
			'std'	=> '',
		),
		
		// Open main sub tab //////////////////////////////////////
		array(
			'name'	=> 'Main Sub',
			'id'	=> $wprs_prefix . 'main',
			'type'	=> 'sub_main_open',
			'std'	=> '',
		),
		
		array (
			'name'	=> 'Review Type',
			'tip'	=> 'Select type',
			'desc'	=> '',
			'id'	=> $wprs_prefix.'review_type',
			'type'	=> 'radio_inline_types',
			'options' => array (
				'rating' 	=> array (
					'label' => 'Rating',
					'value'	=> 'rating',
				),
				'percentage'=> array (
					'label' => 'Percentage',
					'value'	=> 'percentage'
				),
				'votes' => array (
					'label' => 'Votes',
					'value'	=> 'votes'
				),
				'aggregate' => array (
					'label' => 'Aggregate',
					'value'	=> 'aggregate'
				),
				'none' 	=> array (
					'label' => 'None',
					'value'	=> 'none',
				),
			)
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'		=> 'Select Rating',
			'id'		=> $wprs_prefix . 'star_rating',
			'type'		=> 'rating',
			'options'	=> array(
				''		=> 'No Rating',
				'1'		=> '1',
				'1.5'	=> '1.5',
				'2'		=> '2',
				'2.5'	=> '2.5',
				'3'		=> '3',
				'3.5'	=> '3.5',
				'4'		=> '4',
				'4.5'	=> '4.5',
				'5'		=> '5'
			),
			'multiple'	=> false,
			'std'		=> array( 'No Rating' ),
			'desc'		=> 'Rate it!',
			'tip'		=> ''
		),
		
		array(
			'name'	=> __( 'Select Percentage', 'wprs' ),
			'tip'	=> __( 'Use this slider range to define a percentage. Set value to (1) to disable it', 'wprs' ),
			'desc'	=> __( 'Range description', 'wprs' ),
			'id'	=> $wprs_prefix . 'slider_percentage',
			'type'	=> 'slider',
			'min'	=> 0,
			'max'	=> 100,
			'step'	=> 5,
			'std'	=> 1,
		),

		array(
			'name'	=> 'Name <span class="required" title="Required">*</span>',
			'tip'	=> 'Enter the name',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'item_name',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Description <span class="required" title="Required">*</span>',
			'tip'	=> 'Enter a short description',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'item_description',
			'type'	=> 'textarea',
			'std'	=> ''
		),
		
		// close main sub tab //////////////////////////////////
		array(
			'name'	=> 'Main Sub',
			'id'	=> $wprs_prefix . 'main',
			'type'	=> 'sub_main_close',
			'std'	=> '',
		),
		
		// Open sub tab Article	//////////////////////////////////////
		array(
			'name'	=> 'Type Article Open',
			'id'	=> $wprs_prefix . 'type_Article',
			'type'	=> 'sub_open',
			'std'	=> '',
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'		=>	__('Article Type', 'wprs') . ' <span class="required" title="Required">*</span>',
			'tip'	=> 'Select more specific article type',
			'id'		=>	$wprs_prefix . 'article_type',
			'type'		=>	'select',
			'options'	=>	array(
				''							=> 'Select',
				'Article'					=> 'General',
				'BlogPosting'				=> 'BlogPosting',
				'NewsArticle'				=> 'NewsArticle',
				'ScholarlyArticle'			=> 'ScholarlyArticle',
				'TechArticle'				=> 'TechArticle'
			),
			'multiple'	=> false,
			'std'		=> array( 'Select' ),
			'desc'		=> 'Select more specific article type'
		),
		
		array(
			'name'	=> 'Alternative Headline <span class="required" title="Required">*</span>',
			'tip'	=> 'An alternative headline is essential for News articles. Enter the Alternative Headline for your article to be marked up as alternativeHeadline.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'alternativeHeadline',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Publisher Name',
			'tip'	=> 'The Organization/Author of this content.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'publisher_name',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Publisher URL',
			'tip'	=> 'The Organization/Author url.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'publisher_url',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Publisher Logo URL',
			'tip'	=> 'The Organization/Author logo url.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'publisher_logo_url',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		
		// close sub tab Article	//////////////////////////////////////
		array(
			'name'	=> 'Type Article Close',
			'id'	=> $wprs_prefix . 'type_Article',
			'type'	=> 'sub_close',
			'std'	=> '',
		),
		
		
		// Open subm tab Review //////////////////////////////////////
		array(
			'name'	=> 'Type Review Open',
			'id'	=> $wprs_prefix . 'type_Review',
			'type'	=> 'sub_open',
			'std'	=> '',
		),
		
		// close sub tab Review //////////////////////////////////
		array(
			'name'	=> 'Type Review Close',
			'id'	=> $wprs_prefix . 'type_Review',
			'type'	=> 'sub_close',
			'std'	=> '',
		),
		
		// Open sub tab Recipe	//////////////////////////////////////
		array(
			'name'	=> 'Type Recipe Open',
			'id'	=> $wprs_prefix . 'type_Recipe',
			'type'	=> 'sub_open',
			'std'	=> '',
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Ingredients',
			'tip'	=> 'One ingredient per line',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_ingredients',
			'type'	=> 'textarea',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Directions',
			'tip'	=> 'The steps to make the dish, enter one direction/instruction per line',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_instructions',
			'type'	=> 'textarea',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Prep Time',
			'tip'	=> 'The length of time it takes to prepare the recipe for dish. Enter time like: 10 or 10m  or 10 mins or 1h 30m or 1 hour 30 mins',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_prep_time',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Cook Time',
			'tip'	=> 'The time it takes to actually cook the dish. Enter time like: 10 or 10m  or 10 mins or 1h 30m or 1 hour 30 mins',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_cook_time',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Total Time',
			'tip'	=> 'The time it takes to prep and cook the dish. Enter time like: 10 or 10m  or 10 mins or 1h 30m or 1 hour 30 mins',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_total_time',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Serves',
			'tip'	=> 'The quantity produced by the recipe, number of people served, or number of servings, example: 1 Person, 2 Loaf',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_serves',
			'type'	=> 'text_small',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		// Nutrition
		array(
			'name'	=> 'Calories',
			'tip'	=> 'The number of calories in the recipe, example: 240 calories',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_nutrition_calories',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Fat',
			'tip'	=> 'The number of grams of fat in the recipe, example: 9 grams fat',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_nutrition_fatContent',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		// Extras
		array(
			'name'	=> 'Course',
			'tip'	=> 'The category of the recipe, example: appetizer, entree, etc.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_course',
			'type'	=> 'text_small',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Cuisine',
			'tip'	=> 'The cuisine of the recipe, example: French, Italian, Mexican, Ethiopian, etc.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'recipe_cuisine',
			'type'	=> 'text_small',
			'std'	=> ''
		),
		
		// close sub tab Recipe	//////////////////////////////////////
		array(
			'name'	=> 'Type Recipe Close',
			'id'	=> $wprs_prefix . 'type_Recipe',
			'type'	=> 'sub_close',
			'std'	=> '',
		),
		
		// Open sub tab Product	//////////////////////////////////////
		array(
			'name'	=> 'Type Product Open',
			'id'	=> $wprs_prefix . 'type_Product',
			'type'	=> 'sub_open',
			'std'	=> '',
		),
		
		// Extras
		array(
			'name'	=> __('Brand', 'wprs'),
			'tip'	=> __('The brand of the product.', 'wprs'),
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'brand_name',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		// close sub tab Product	//////////////////////////////////////
		array(
			'name'	=> 'Type Product Close',
			'id'	=> $wprs_prefix . 'type_Product',
			'type'	=> 'sub_close',
			'std'	=> '',
		),
		
		// Open sub tab Organization	//////////////////////////////////
		array(
			'name'	=> 'Type Organization Open',
			'id'	=> $wprs_prefix . 'type_Organization',
			'type'	=> 'sub_open',
			'std'	=> '',
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'		=>	__('Organization Type', 'wprs'),
			'tip'		=> __('Select a more specific Organization type', 'wprs'),
			'id'		=>	$wprs_prefix . 'organization_type',
			'type'		=>	'select',
			'options'	=>	array(
				''							=> 'Select',
				'Organization'				=> 'General',
				'Corporation'				=> 'Corporation',
				'EducationalOrganization'	=> 'EducationalOrganization',
				'GovernmentOrganization'	=> 'GovernmentOrganization',
				'LocalBusiness'				=> 'LocalBusiness',
				'NGO'						=> 'NGO',
				'PerformingGroup'			=> 'PerformingGroup',
				'SportsTeam'				=> 'SportsTeam'
			),
			'multiple'	=> false,
			'std'		=> array( 'Select' ),
			'desc'		=> 'Select more specific Organization type'
		),
		
		array(
			'name'	=> 'More Specific Type',
			'tip'	=> 'Use this field to define a more specific sub type.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'organization_type_sub',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		// close sub tab Organization	//////////////////////////////////
		array(
			'name'	=> 'Type Organization Close',
			'id'	=> $wprs_prefix . 'type_Organization',
			'type'	=> 'sub_close',
			'std'	=> '',
		),
		
		// Open sub tab Restaurant	//////////////////////////////////////
		array(
			'name'	=> 'Type Restaurant Open',
			'id'	=> $wprs_prefix . 'type_Restaurant',
			'type'	=> 'sub_open',
			'std'	=> '',
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Category 1',
			'tip'	=> 'Enter the cuisine category 1',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'cuisine_1',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Category 2',
			'tip'	=> 'Enter the cuisine category 2',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'cuisine_2',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Category 3',
			'tip'	=> 'Enter the cuisine category 3',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'cuisine_3',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Menu URL',
			'tip'	=> 'Enter the Menu page URL',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'restaurant_menu',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Reservations',
			'tip'	=> '',
			'desc'	=> 'Takes reservations?.',
			'id'	=> $wprs_prefix . 'reservations',
			'type'	=> 'checkbox',
			'std'	=> ''
		),
		
		// close sub tab Restaurant	//////////////////////////////////
		array(
			'name'	=> 'Type Restaurant Close',
			'id'	=> $wprs_prefix . 'type_Restaurant',
			'type'	=> 'sub_close',
			'std'	=> '',
		),
		
		// Open sub tab SoftwareApplication	//////////////////////////////////////
		array(
			'name'	=> 'Type SoftwareApplication Open',
			'id'	=> $wprs_prefix . 'type_SoftwareApplication',
			'type'	=> 'sub_open',
			'std'	=> '',
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Operating System',
			'tip'	=> 'Operating systems required (for example, Windows 7, OSX 10.6, Android 1.6)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'operatingSystem',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'		=>	__('Application Category', 'wprs'),
			'tip'	=> 'Select the Application Category type.',
			'id'		=>	$wprs_prefix . 'applicationCategory',
			'type'		=>	'select',
			'options'	=>	array(
				''									=> 'Select',
				'MobileApplication'					=> 'MobileApplication',
				'WebApplication'					=> 'WebApplication',
				'GameApplication'					=> 'GameApplication',
				'BusinessApplication'				=> 'BusinessApplication',
				'BrowserApplication'				=> 'BrowserApplication',
				'CommunicationApplication'			=> 'CommunicationApplication',
				'DesktopEnhancementApplication'		=> 'DesktopEnhancementApplication',
				'DesignApplication'					=> 'DesignApplication',
				'DeveloperApplication'				=> 'DeveloperApplication',
				'DriverApplication'					=> 'DriverApplication',
				'EducationApplication'				=> 'EducationApplication',
				'EntertainmentApplication'			=> 'EntertainmentApplication',
				'HealthApplication'					=> 'HealthApplication',
				'HomeApplication'					=> 'HomeApplication',
				'FinanceApplication'				=> 'FinanceApplication',
				'MultimediaApplication'				=> 'MultimediaApplication',
				'ReferenceApplication'				=> 'ReferenceApplication',
				'SecurityApplication'				=> 'SecurityApplication',
				'SocialNetworkingApplication'		=> 'SocialNetworkingApplication',
				'ShoppingApplication'				=> 'ShoppingApplication',
				'SportsApplication'					=> 'SportsApplication',	
				'TravelApplication'					=> 'TravelApplication',
				'UtilitiesApplication'				=> 'UtilitiesApplication',
				'OtherApplication'					=> 'OtherApplication',
			),
			'multiple'	=> false,
			'std'		=> array( 'Select' ),
			'desc'		=> ''
		),
		
		array(
			'name'	=> 'Software Version',
			'tip'	=> 'The version of the software (for example, V2.1)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'softwareVersion',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Requirements',
			'tip'	=> 'Component dependency requirements for application. This includes runtime environments and shared libraries that are not included in the application distribution package , but required to run the application (Examples: DirectX, Java or .NET runtime).',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'requirements',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'File Size',
			'tip'	=> 'The size of the application or software package, in bytes.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'fileSize',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'File Format',
			'tip'	=> 'The MIME format of the application or zip file.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'fileFormat',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Documentation URL',
			'tip'	=> 'Add the URL where software help or documentation page can be found.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'softwareHelp',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Release Notes',
			'tip'	=> 'Describes the changes for the most recent version. Can consist of a text string or a URL to a webpage containing this information.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'releaseNotes',
			'type'	=> 'textarea',
			'std'	=> ''
		),
		// close sub tab SoftwareApplication	//////////////////////////////////
		
		array(
			'name'	=> 'Type SoftwareApplication Close',
			'id'	=> $wprs_prefix . 'type_SoftwareApplication',
			'type'	=> 'sub_close',
			'std'	=> '',
		),
		// Open sub tab Article	//////////////////////////////////////
		array(
			'name'	=> 'Type Article Open',
			'id'	=> $wprs_prefix . 'type_Article',
			'type'	=> 'sub_open',
			'std'	=> '',
		),
		
		array(
			'name'	=> 'Enable User Snippets',
			'tip'	=> '',
			'desc'	=> 'Use user rating as rich snippets source, this will override the default plugin settings.',
			'id'	=> $wprs_prefix . 'user_snippets_enable',
			'type'	=> 'checkbox',
			'std'	=> ''
		),
		
		// close sub tab article	//////////////////////////////////
		array(
			'name'	=> 'Type Article Close',
			'id'	=> $wprs_prefix . 'type_Article',
			'type'	=> 'sub_close',
			'std'	=> '',
		),
		 
		// Close tab 1
		array(
			'name'	=> 'Main',
			'id'	=> $wprs_prefix . 'tab1',
			'type'	=> 'close',
			'std'	=> ''
			),

		// Open tab 2	//////////////////////////////////////////////
		array(
			'name'	=> 'Details',
			'id'	=> $wprs_prefix . 'tab2',
			'type'	=> 'start',
			'std'	=> ''
			),
		
		array(
			'name'	=> 'Pros',
			'tip'	=> 'Enter pros (You can use HTML List)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'pros',
			'type'	=> 'textarea',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Cons',
			'tip'	=> 'Enter cons (You can use HTML List)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'cons',
			'type'	=> 'textarea',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Pros & Cons Display',
			'tip'	=> 'Tick to stop dislay Pros & Cons automatically, and use shortcode [wprs-pros] or [wprs-cons] to display them anywhere in your post.',
			'desc'	=> 'Do not show Pros & Cons?',
			'id'	=> $wprs_prefix . 'display_pros_cons',
			'type'	=> 'checkbox',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Disclaimer',
			'tip'	=> '',
			'desc'	=> 'Is it a paid review?.',
			'id'	=> $wprs_prefix . 'disclaimer_enable',
			'type'	=> 'checkbox',
			'std'	=> ''
		),
		
		// Close tab 2
		array(
			'name'		=> 'Details',
			'id'		=> $wprs_prefix . 'tab2',
			'type'		=> 'close',
			'std' => ''
			),	
			
		// Open tab 3	//////////////////////////////////////////////
		array(
			'name'		=> 'Display',
			'id'		=> $wprs_prefix . 'tab3',
			'type'		=> 'start',
			'std' => ''
			),
		
		array(
			'name'	=> 'Box Position',
			'tip'	=> 'Tick to display the Box below content on this entry, by default the Box showes on top of page content.',
			'desc'	=> 'Show Box below content?',
			'id'	=> $wprs_prefix . 'display_box_below_content',
			'type'	=> 'checkbox',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		/*
		array (
			'name'	=> 'Layout',
			'tip'	=> 'Select box layout',
			'desc'	=> '',
			'id'	=> $wprs_prefix.'box_layout',
			'type'	=> 'radio_images',
			'options' => array (
				'sidebar_content' 	=> array (
					'label' => 'Default',
					'value'	=> 'default',
					'src'	=> ''
				),
				'percentage'=> array (
					'label' => 'Light',
					'value'	=> 'light',
					'src'	=> ''
				),
				'votes' => array (
					'label' => 'Dark',
					'value'	=> 'dark',
					'src'	=> ''
				),
				'aggregate' => array (
					'label' => 'Custom',
					'value'	=> 'custom',
					'src'	=> ''
				)
			)
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		*/
		
		array(
			'name'	=> 'HTML',
			'tip'	=> 'HTML code',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'html',
			'type'	=> 'textarea',
			'std'	=> ''
		),
		
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		
		array(
			'name'	=> 'Default Gallery Slider',
			'tip'	=> 'Tick to enable the image slider. (use the Media Uploader to upload a set of images)',
			'desc'	=> 'Display default gallery slider?',
			'id'	=> $wprs_prefix . 'gallery_slider',
			'type'	=> 'checkbox',
			'std'	=> ''
		),
		
		// Removed, use Embed instead
		// @since 1.3.8
		/*
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> '<span class="fa fa-youtube-play" style="font-size:14px;"></span> Video',
			'tip'	=> 'Add a short link to a YouTube video',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'youtube',
			'type'	=> 'text',
			'std'	=> ''
		),
		*/
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> '<i class="fa fa-cubes" aria-hidden="true" style="font-size:14px;"></i> Embed',
			'tip'	=> 'Add a link to any oEmbed provider supported by WordPress',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'embed',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Title',
			'tip'	=> 'Video title',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'embed_title',
			'type'	=> 'text',
			'std'	=> ''
		),
		array(
			'name'	=> 'Duration',
			'tip'	=> 'Video duration in seconds',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'embed_duration',
			'type'	=> 'text',
			'std'	=> ''
		),
		array(
			'name'	=> 'Upload Date',
			'tip'	=> 'Video uploaded date in this format 2015-02-05T08:00:00+08:00',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'embed_upload_date',
			'type'	=> 'text',
			'std'	=> ''
		),
		array(
			'name'	=> 'Description',
			'tip'	=> 'Video short description',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'embed_description',
			'type'	=> 'textarea',
			'std'	=> ''
		),
		
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> '<i class="fa fa-th-large" aria-hidden="true" style="font-size:14px;"></i> Gallery',
			'tip'	=> 'Use shortcode to display images slider generated by third-party plugin, example: [gallery]</span>',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'slider_shortcode',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Screenshot',
			'tip'	=> 'Use high quality images!',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'image', // here is a special case as we use id in js.
			'type'	=> 'image',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Screenshot ALT tag',
			'tip'	=> 'Enter the image alt tag. (if left empty, Name value will be used)',
			'desc'	=> '',
			'id' 	=> $wprs_prefix . 'image_alt',
			'type'	=> 'text_med',
			'std'	=> ''
		),
		
		// Close tab 3
		array(
			'name'	=> 'Display',
			'id'	=> $wprs_prefix . 'tab3',
			'type'	=> 'close',
			'std'	=> ''
			),
		
		// Open tab 4	//////////////////////////////////////////////
		array(
			'name'	=> 'Links',
			'id'	=> $wprs_prefix . 'tab4',
			'type'	=> 'start',
			'std'	=> ''
			),
			
		array(
			'name'	=> 'Link',
			'tip'	=> 'Enter a URL or Affiliate Link (including http://), This will display a button link in the Box',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'item_url',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Link Button Text',
			'tip'	=> 'Change the button text for this entry. (default is: '.$rating_box_btn_value.')',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'button_text',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Link Button Icon',
			'tip'	=> 'Set button icon for this entry (example: fa-link)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'button_icon',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Demo Link',
			'tip'	=> 'Enter demo link (including http://), this will display a button link in the Box',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'item_demo_url',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Demo Button Text',
			'tip'	=> 'Change the button text for this entry.',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'button_demo_text',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Demo Button Icon',
			'tip'	=> 'Set demo button icon for this entry (example: fa-eye)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'button_demo_icon',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Link Target',
			'tip'	=> 'By default, links open in a new window, tick to open links in the same window',
			'desc'	=> 'Open links in the same window?',
			'id'	=> $wprs_prefix . 'link_target',
			'type'	=> 'checkbox',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Dofollow Links',
			'tip'	=> 'By default, links has nofollow attribute, tick to remove nofollow attribute from the link. (not recommended for affiliate links)',
			'desc'	=> 'Enable?',
			'id'	=> $wprs_prefix . 'link_dofollow',
			'type'	=> 'checkbox',
			'std'	=> ''
		),

		// Close tab 4
		array(
			'name'	=> 'Links',
			'id'	=> $wprs_prefix . 'tab4',
			'type'	=> 'close',
			'std'	=> ''
		),
		
		// Open tab 5	//////////////////////////////////////////////
		array(
			'name'	=> 'Author',
			'id'	=> $wprs_prefix . 'tab5',
			'type'	=> 'start',
			'std'	=> ''
			),
		
		array(  
			'name'	=> 'Criteria',  
			'tip'	=> 'Add custom criteria to your review (tip: fields are sortable)',
			'desc'  => '',  
			'id'    => $wprs_prefix.'repeatable',  
			'type'  => 'repeatable',
			// Array of 'key' => 'value' pairs for select box
			'options'	=> array(
				''		=> 'No Rating',
				'1'		=> '1',
				'1.5'	=> '1.5',
				'2'		=> '2',
				'2.5'	=> '2.5',
				'3'		=> '3',
				'3.5'	=> '3.5',
				'4'		=> '4',
				'4.5'	=> '4.5',
				'5'		=> '5'
			) 
		),
		
		// Close tab 5
		array(
			'name'	=> 'Criteria',
			'id'	=> $wprs_prefix . 'tab5',
			'type'	=> 'close',
			'std'	=> ''
		),
		
		// Open tab 6	//////////////////////////////////////////////
		array(
			'name'	=> 'Address',
			'id'	=> $wprs_prefix . 'tab6',
			'type'	=> 'start',
			'std'	=> ''
			),
		
		array(
			'name'	=> 'Street Address',
			'tip'	=> 'Enter the address',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'streetAddress',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'P.O. Box',
			'tip'	=> 'Enter the post Office Box Number',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'postOfficeBoxNumber',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Locality/City',
			'tip'	=> 'Enter the Locality/City',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'addressLocality',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'State/Region',
			'tip'	=> 'Enter the State/Region',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'addressRegion',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Country',
			'tip'	=> 'Enter the Country',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'addressCountry',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'Postal Code',
			'tip'	=> 'Enter the Postal Code',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'postalCode',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Google Map',
			'tip'	=> 'Enter the Google maps ifram HTML code',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'map',
			'type'	=> 'textarea',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Phone',
			'tip'	=> 'Enter the telephone number',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'telephone',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		// Close tab 6
		array(
			'name'	=> 'Address',
			'id'	=> $wprs_prefix . 'tab6',
			'type'	=> 'close',
			'std'	=> ''
		),
		
		// Open tab 7	//////////////////////////////////////////////
		array(
			'name'	=> 'Author',
			'id'	=> $wprs_prefix . 'tab7',
			'type'	=> 'start',
			'std'	=> ''
			),
		
		array(
			'name'	=> 'Author Name',
			'tip'	=> 'Override the review author name (default is: post author)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'author_name',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		// Close tab 7
		array(
			'name'	=> 'Author',
			'id'	=> $wprs_prefix . 'tab7',
			'type'	=> 'close',
			'std'	=> ''
		),
		
		// Open tab 8	//////////////////////////////////////////////
		array(
			'name'	=> 'Price',
			'id'	=> $wprs_prefix . 'tab8',
			'type'	=> 'start',
			'std'	=> ''
			),
		
		array(
			'name'	=> 'Low Price',
			'tip'	=> 'Enter low price, if there is only one price, then enter only the low price field (only digits, example 0.00 for free products)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'lowprice',
			'type'	=> 'text_small',
			'std'	=> ''
		),
		
		array(
			'name'	=> 'High Price',
			'tip'	=> 'Enter high price. Leave empty if there is only one price! (only digits, example 0.00 for free products)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'highprice',
			'type'	=> 'text_small',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Price Range',
			'tip'	=> 'Enter price range when having multiple pricing (example: when reviewing a Restaurant, enter $$ for two digits pricing)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'price_range_digits',
			'type'	=> 'text_small',
			'std'	=> ''
		),
		
		array('name' => '', 'tip' => '', 'desc'	=> '', 'id'	=> $wprs_prefix . 'spacer',	'type'	=> 'spacer', 'std'	=> ''),
		
		array(
			'name'	=> 'Override Free Price',
			'tip'	=> 'Enter a text to show when you set low price to 0.00, as free, (defaut: Free)',
			'desc'	=> '',
			'id'	=> $wprs_prefix . 'price_free_text',
			'type'	=> 'text',
			'std'	=> ''
		),
		
		// Close tab 8
		array(
			'name'	=> 'Price',
			'id'	=> $wprs_prefix . 'tab8',
			'type'	=> 'close',
			'std'	=> ''
		),
		
		// Open tab 9	//////////////////////////////////////////////
		array(
			'name'	=> 'Hours',
			'id'	=> $wprs_prefix . 'tab9',
			'type'	=> 'start',
			'std'	=> ''
			),
		
		array(  
			'name'	=> 'Opening Hours',  
			'tip'	=> 'Enter opening hours (tip: fields are sortable)',
			'desc'  => '',  
			'id'    => $wprs_prefix.'openinghours',  
			'type'  => 'openinghours_repeatable',
			'days'	=>	array(
				''		=> '--',
				'Sun'	=> 'Su',
				'Mon'	=> 'Mo',
				'Tue'	=> 'Tu',
				'Wed'	=> 'We',
				'Thur'	=> 'Th',
				'Fri'	=> 'Fr',
				'Sat'	=> 'Sa',
			),
		),
		
		// Close tab 9
		array(
			'name'	=> 'Hours',
			'id'	=> $wprs_prefix . 'tab9',
			'type'	=> 'close',
			'std'	=> ''
		),

		
			
	)
);


// Add post meta box
function wprs_add_box() {
	global $wprs_meta_box;
	$options = get_option('wprs_options');
	// add to custom post types
	$post_types = wprs_get_post_types();
	foreach ( $post_types as $post_type ) {
		add_meta_box( $wprs_meta_box['id'], $wprs_meta_box['title'], 'wprs_show_box', $post_type, $wprs_meta_box['context'], $wprs_meta_box['priority'] );
	}
}

// Callback function to show fields in meta box
function wprs_show_box() {
	
	global  $wprs_meta_box, $post, $wprs_prefix;
	
	// Use nonce for verification
	echo '<input type="hidden" name="wprs_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
	echo '<div class="wprs-inside">';
	echo '<div class="wprs-tabs-back"></div>';
	echo '<ul class="wprs-metabox-tabs">
			<li class="wprs-tab '.$wprs_prefix.'tab1"><a class="active" href="javascript:void(null);"><span class="fa fa-code"></span> Main</a></li>
			<li class="wprs-tab '.$wprs_prefix.'tab2"><a href="javascript:void(null);"><span class="fa fa-info-circle"></span> Details</a></li>
			<li class="wprs-tab '.$wprs_prefix.'tab8"><a href="javascript:void(null);"><span class="fa fa-money"></span> Price</a></li>
			<li class="wprs-tab '.$wprs_prefix.'tab6"><a href="javascript:void(null);"><span class="fa fa-map-marker"></span> Address</a></li>
			<li class="wprs-tab '.$wprs_prefix.'tab9"><a href="javascript:void(null);"><span class="fa fa-clock-o"></span> Hours</a></li>
			<li class="wprs-tab '.$wprs_prefix.'tab3"><a href="javascript:void(null);"><span class="fa fa-desktop"></span> Display</a></li>
			<li class="wprs-tab '.$wprs_prefix.'tab4"><a href="javascript:void(null);"><span class="fa fa-link"></span> Link</a></li>
			<li class="wprs-tab '.$wprs_prefix.'tab5"><a href="javascript:void(null);"><span class="fa fa-sliders"></span> Criteria</a></li>
			<li class="wprs-tab '.$wprs_prefix.'tab7"><a href="javascript:void(null);"><span class="fa fa-user"></span> Author</a></li>
		</ul>';
	
	if(empty($wprs_meta_box)) return '';
	
	// @since 1.4.4
	// allow overriding post meta fields
	$wprs_meta_box = apply_filters( 'wprs_meta_box', $wprs_meta_box );
	
	foreach ($wprs_meta_box['fields'] as $field) {
		
		// get current post meta data
		$meta = get_post_meta($post->ID, $field['id'], true);
		// switching between field types
		switch ($field['type']) {
			
            case 'snippets_types':
				
				echo '<span class="wprs_type_box">';
				echo ' &mdash; ';
				echo '<label for="'.$field['id'].'">';
				echo '<select id="'.$field['id'].'" name="'.$field['id'].'">';
				echo '<optgroup label="'.$field['name'].'">';
				foreach ($field['options'] as $option) {
					echo '<option', $meta == $option ? ' selected="selected"' : '', '>', $option, '</option>';
				}
				echo '</optgroup>';
				echo '</select>';
				echo '</label>';
				echo '</span>';
				break;
                
			case 'start':
				
				echo '<div class="'.$field['id'].'">';
				echo '<h4 class="heading">'.$field['name'].'</h4>';
				echo '<div class="wprs-tab-content">';
				break;
				
			case 'close':
				
				echo '</div>';
				echo '</div>';
				break;
					
			
			case 'sub_main_open':
			
				echo '<div id="'.$field['id'].'" class="wprs_group_main">';
				break;
			
			case 'sub_main_close':
			
				echo '</div>';
				break;
				
			case 'sub_open':
			
				echo '<div id="'.$field['id'].'" class="wprs_group_arrow">';
				break;
			
			case 'sub_close':
			
				echo '</div>';
				break;
			
			case 'snippets_types_select':
				
				echo '<i class="fa fa-angle-double-up wprs_double_up"></i>';
				echo '<br />';
				echo '<p>';
				echo '<b>'.$field['name'] .'</b><br />';
				echo $field['desc'];
				echo '</p>';
				break;
			
			case 'info':
				
				echo '<p>';
				echo '<b>'.$field['name'] .'</b><br />';
				echo $field['desc'];
				echo '</p>';
				break;
				
			case 'spacer':
				
				echo '<hr />';
				break;
			
			case 'text':
				
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : $field['std'], '" size="30" />';
				echo '<br />', '<span class="description">'.$field['desc'].'</span>';
				echo '</p>';
				break;
			
			case 'text_small':
				
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : $field['std'], '" size="10" />';
				echo '<br />', '<span class="description">'.$field['desc'].'</span>';
				echo '</p>';
				break;
			
			case 'text_med':
				
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : $field['std'], '" size="20" />';
				echo '<br />', '<span class="description">'.$field['desc'].'</span>';
				echo '</p>';
				break;

			case 'textarea':
				
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				echo '<textarea name="', $field['id'], '" id="', $field['id'], '" cols="60" rows="4">', $meta ? $meta : $field['std'], '</textarea>';
				echo '';
				echo '<br />', '<span class="description">'.$field['desc'].'</span>';
				echo '</p>';
				break;
			
			case 'rating':
			
				$custom = get_post_custom();
				$rating = isset($custom[$wprs_prefix."star_rating"][0]) ? $custom[$wprs_prefix."star_rating"][0] : NULL;
				echo '<div id="wprs_group_rating" class="wprs_group_type">';
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				echo '<span id="'.$field['id'].'" data-score="'.$rating.'"></span>';
				echo '<span id="wprs_star_hint" class="wprs_star_hint"></span>';
				echo '</p>';
				echo '<hr />';
				echo '</div>';
				
				break;
			
			case 'slider':
				
				echo '<div id="wprs_group_percentage" class="wprs_group_type">';
				echo '<div class="wprs_slider_percentage">';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				echo '<div id="'.$field['id'].'_item_range"></div>';
				echo '<input type="hidden" name="'.$field['id'].'" id="'.$field['id'].'" value="', $meta ? $meta : $field['std'], '" />';
				echo '</div>';
				echo '<hr />';
				echo '</div>';
				break;
			
			
			case 'select':
				
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				
				echo '<select name="', $field['id'], '" id="', $field['id'], '">';
				foreach ($field['options'] as $option) {
					echo '<option', $meta == $option ? ' selected="selected"' : '', '>', $option, '</option>';
				}
				echo '</select>', ' ', '<span class="description">'.$field['desc'].'</span>';		
				echo '</p>';
				break;
			
			case 'radio':
				
				foreach ( $field['options'] as $option ) {
					echo '<input type="radio" name="', $field['id'], '" id="', $option['value'], '" value="'.$option['value'].'" ',$meta == $option['value'] ? ' checked="checked"' : '',' />
					<label for="'.$option['value'].'">'.$option['label'].'</label><br />';
				}
				echo '<span class="description">'.$field['desc'].'</span>';
				break;
					
			case 'radio_inline_types':
				
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				
				foreach ($field['options'] as $option) {
					echo '<label class="radio_inline" id="wprs_radio_type_'.$option['value'].'">';
					echo '<input type="radio" name="', $field['id'], '" value="', $option['value'], '"', $meta == $option['value'] ? ' checked="checked"' : '', ' />';
					echo $option['label'].'</label>';
				}
				echo '</p>';
				break;
			
			case 'radio_images':
				
				echo '<div>';
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				
				foreach ($field['options'] as $option) {
					echo '<label class="wprs_radio_image top-tip" data-tips="'.$option['label'].'" id="wprs_template_'.$option['value'].'">';
					echo '<img src="', $option['src'], '" alt="" />';
					echo '<br />';
					echo '<input type="radio" name="', $field['id'], '" value="', $option['value'], '"', $meta == $option['value'] ? ' checked="checked"' : '', ' />';
					echo '</label>';
				}
				echo '</p>';
				echo '</div>';
				break;
			
			case 'fontawesome':
				
				echo '<div>';
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				
				foreach ($field['options'] as $option) {
					echo '<label class="wprs_radio_fontawesome top-tip" data-tips="'.$option['label'].'" id="wprs_fa_'.$option['icon'].'">';
					echo '<i class="fa fa-', $option['icon'], '"></i>';
					echo '<br />';
					echo '<input type="radio" name="', $field['id'], '" value="', $option['icon'], '"', $meta == $option['icon'] ? ' checked="checked"' : '', ' />';
					echo '</label>';
				}
				echo '</p>';
				echo '</div>';
				break;
			
			case 'checkbox':
				
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				
				echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '"', $meta ? ' checked="checked"' : '', ' />', 
				' ', '<span class="description">'.$field['desc'].'</span>';
				
				echo '</p>';
				break;
			
			case 'repeatable':
	
				$title='title';
				$desc= 'desc';
				$item_rating = 'rating';
				$item_range = 'range';
				
				///////////////////////////////////////////////////////////////////////
				// check if default repeated criteria is enabled within plugin settings
				// @since 1.0.0
				$wprs_options = get_option('wprs_options');
				
				if( isset($wprs_options['wprs_chk_default_criteria']) !='' && isset($wprs_options['wprs_repeatable']) && empty($meta) ) {
					$repeated_meta = $wprs_options['wprs_repeatable'];
				
					//echo '<br />';
					//print_r($repeated_meta);
					//echo '<br /><br />';
				
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				echo '<span class="description">'.$field['desc'].'</span>';
				echo '<br />';
				echo '<div>';
				echo '<ul id="wprs_options['.$field['id'].']-repeatable" class="wprs_custom_repeatable">';
				$i = 0;
				if ( isset($repeated_meta) && $repeated_meta ) {
					foreach($repeated_meta as $row) {
						echo '<li><span class="sort hndle fa fa-arrows"></span>';	
						echo '<input type="text" name="'.$field['id'].'['.$i.']['.$title.']" id="'.$field['id'].'" value="'.$row['title'].'" placeholder=" Enter Unique ID" size="20" />';
                    	echo '<input type="text" name="'.$field['id'].'['.$i.']['.$desc.']" id="'.$field['id'].'" value="'.$row['desc'].'" placeholder=" Enter Title (best fit one word)" size="20" />';
						echo '<input type="text" name="'.$field['id'].'['.$i.']['.$item_rating.']" id="'.$field['id'].'" value="'.$row['rating'].'" placeholder=" Rating" size="6" />';
						echo '<span>%</span>';
						echo '<a class="wprs-repeatable-remove fa fa-trash-o" title="Delete"></a></li>';
					$i++;
					}
				}
				echo '</ul>';
				echo '<a class="wprs-repeatable-add button" href="#">+ Add</a>';
				echo '<br /><br /> <span class="fa fa-info-cirlce" style="font-size:14px;"></span> Important: Once your saved the post, avoid editing the Unique ID.';
				echo '</div>';
				echo '</p>';
				/////////////////////
				} else {
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				echo '<span class="description">'.$field['desc'].'</span>';
				echo '<br />';
				echo '</p>';
            	echo '<div>';
				echo '<ul id="'.$field['id'].'-repeatable" class="wprs_custom_repeatable">'; 
				$i = 0;  
				if ($meta) {
					foreach($meta as $row) {
						echo '<li><span class="sort hndle fa fa-arrows"></span>';
						echo '<input type="text" name="'.$field['id'].'['.$i.']['.$title.']" id="'.$field['id'].'" value="'.$row['title'].'" placeholder=" Enter Unique ID" size="20" />';
             			echo '<input type="text" name="'.$field['id'].'['.$i.']['.$desc.']" id="'.$field['id'].'" value="'.$row['desc'].'" placeholder=" Enter Title (best fit one word)" size="20" />';
						echo '<input type="text" name="'.$field['id'].'['.$i.']['.$item_rating.']" id="'.$field['id'].'" value="'.$row['rating'].'" placeholder=" Rating" size="6" />';
						echo '<span>%</span>';
						echo "<a class='wprs-repeatable-remove fa fa-trash-o' title='Delete'></a></li>";  
                		$i++;
            		}  
        		} else {
					// add new
            		echo '<li><span class="sort hndle fa fa-arrows"></span>';
					echo '<input type="text" name="'.$field['id'].'['.$i.']['.$title.']" id="'.$field['id'].'" value="" placeholder=" Enter Unique ID" size="20" />';
					echo '<input type="text" name="'.$field['id'].'['.$i.']['.$desc.']" id="'.$field['id'].'" value="" placeholder=" Enter Title (best fit one word)" size="20" />';
					echo '<input type="text" name="'.$field['id'].'['.$i.']['.$item_rating.']" id="'.$field['id'].'" value="" placeholder=" Rating" size="6" />';
					echo '<span>%</span>';
					echo '<a class="wprs-repeatable-remove fa fa-trash-o"></a></li>';  
        		}  
        		echo '</ul>';
				echo '</div>';
				echo '<p>';
				echo '<a class="wprs-repeatable-add button" href="#">+ Add</a>';
				echo '<br /><br /> <span class="fa fa-info-circle" style="font-size:14px;"></span> Important: Once your saved the post, avoid editing the Unique ID.';
				
				// debug array output
				//echo '<br />';
				//print_r($meta);
				//echo '<br /><br />';
				//echo 'count: '.count($meta);
				//echo '<br />';
	 
				echo '</p>';
				}
				break;
			
			// opening hours repeatable
			case 'openinghours_repeatable':
			
				$from_day = 'from_day';
				$to_day = 'to_day';
				$from_time = 'from_time';
				$to_time = 'to_time';
				
				echo '<p>';
				echo '<label for="', $field['id'], '">'.$field['name'] ;
				if ($field['tip'] !='') {echo '<span class="top-tip" data-tips="'.$field['tip'].'"><span class="fa fa-question-circle"></span></span>';}
				echo '</label>';
				echo '</p>';
				
				echo '<span class="description">'.$field['desc'].'</span>';
				echo '<br />';
				echo '<ul id="'.$field['id'].'-repeatable" class="openinghours_repeatable">';
				
				$i = 0;
				
				// create an empty array
				//if ( $meta == '' || $meta == array() ) {
				//	$keys = wp_list_pluck( $meta, 'id' );
				//	$meta = array ( array_fill_keys( $keys, null ) );
				//}
				
				//$meta = array_values( $meta );
				
				if (empty($meta)) $meta = array();
				
				if (!empty($meta)) {
					
					$key = array_keys($meta);
					
					foreach($meta as $row) {
						
						echo '<li><span class="sort hndle fa fa-arrows"></span>';
							
							// debug
							//echo '<pre>';
							//print_r($meta);
							//echo '</pre>';
							
							// from day
							echo '<select name="'.$field['id'].'['.$key[$i].']['.$from_day.']" id="'.$field['id'].'">';
							foreach ($field['days'] as $day) {
								echo '<option', $meta[$key[$i]]['from_day'] == $day ? ' selected="selected"' : '', '>', $day, '</option>';
							}
							echo '</select>';
							
							// to day
							echo '<select name="'.$field['id'].'['.$key[$i].']['.$to_day.']" id="'.$field['id'].'">';
							foreach ($field['days'] as $day) {
								echo '<option', $meta[$key[$i]]['to_day'] == $day ? ' selected="selected"' : '', '>', $day, '</option>';
							}
							echo '</select>';
							
							// from time
							echo '<select name="'.$field['id'].'['.$key[$i].']['.$from_time.']" id="'.$field['id'].'">';
								echo '<option value="-1">--</option>';
								$start = strtotime('00:00');
								$end = strtotime('23:30');
								for ($halfhour=$start;$halfhour<=$end;$halfhour=$halfhour+30*60) {
									$selected = $meta[$key[$i]]['from_time'] == date('H:i',$halfhour) ? ' selected="selected"' : '';
									printf('<option %s value="%s">%s</option>',$selected,date('H:i',$halfhour),date('g:i a',$halfhour));
								}
							echo '</select>';
							
							// to time
							echo '<select name="'.$field['id'].'['.$key[$i].']['.$to_time.']" id="'.$field['id'].'">';
								echo '<option value="-1">--</option>';
								$start=strtotime('00:00');
								$end=strtotime('23:30');
								for ($halfhour=$start;$halfhour<=$end;$halfhour=$halfhour+30*60) {
									$selected = $meta[$key[$i]]['to_time'] == date('H:i',$halfhour) ? ' selected="selected"' : '';
									printf('<option %s value="%s">%s</option>',$selected,date('H:i',$halfhour),date('g:i a',$halfhour));
								}
							echo '</select>';
									
							echo'<a class="openinghours-repeatable-remove fa fa-trash-o" href="#"></a></li>';
						$i++;
					}
				} else {
					echo '<li><span class="sort hndle fa fa-arrows"></span>';
					
						// from day
						echo '<select name="'.$field['id'].'['.$i.']['.$from_day.']" id="'.$field['id'].'">';
							foreach ($field['days'] as $day) {
								echo '<option', '>', $day, '</option>';
							}
						echo '</select>';
					
						// to day	
						echo '<select name="'.$field['id'].'['.$i.']['.$to_day.']" id="'.$field['id'].'">';
							foreach ($field['days'] as $day) {
								echo '<option', '>', $day, '</option>';
							}
						echo '</select>';
						
						// from time
						echo '<select name="'.$field['id'].'['.$i.']['.$from_time.']" id="'.$field['id'].'">';
							echo '<option value="-1">--</option>';
							$start=strtotime('00:00');
							$end=strtotime('23:30');
							for ($halfhour=$start;$halfhour<=$end;$halfhour=$halfhour+30*60) {
								printf('<option value="%s">%s</option>',date('H:i',$halfhour),date('g:i a',$halfhour));
							}
						echo '</select>';
						
						// to time
						echo '<select name="'.$field['id'].'['.$i.']['.$to_time.']" id="'.$field['id'].'">';
							echo '<option value="-1">--</option>';
							$start=strtotime('00:00');
							$end=strtotime('23:30');
							for ($halfhour=$start;$halfhour<=$end;$halfhour=$halfhour+30*60) {
								printf('<option value="%s">%s</option>',date('H:i',$halfhour),date('g:i a',$halfhour));
							}
						echo '</select>';
							
                    	echo '<a class="openinghours-repeatable-remove fa fa-trash-o" href="#"></a></li>';
				}
				echo '</ul>';
				echo '<p>';
				echo '<a class="openinghours-repeatable-add button" href="#">+ Add</a>';
				echo '</p>';
				break;
			
			case 'image':	
				echo '<p>';
				echo '<lable>Upload an Image</lable>';
				$tab = '';
				$id = $field['id'];
				$label = '';
				$tabindex = '';
				$url = $meta ? $meta : $field['std'];
				$upload_label = !empty($field['upload_label']) ? $field['upload_label'] : __('Upload an Image', 'wprs');
				$verb = !empty($field['verb']) ? esc_attr($field['verb']) : __('<span class=\"wprs-media-buttons-icon\"></span> Add Image', 'wprs');
				$theoutput =
					"$tab\t<p class=\"upload_field\">\n".
					"$tab\t\t<a href=\"#\" class=\"wprs_media_upload button\"><span class=\"fa fa-camera\"></span>$verb</a>\n".
					"$tab\t</p>\n".
					"$tab\t<p class=\"current_image\"". (empty($url) ? ' style="display: none;"' : ''). ">\n".
					"$tab\t\t<img src=\"$url\" alt=\"". __('Uploaded image', 'wprs'). "\" title=\"\" />\n".
					"$tab\t\t<span>". __('<strong><br>Note:</strong> Image shown here may not be to scale (limited to 460px wide)', 'wprs'). "</span>\n".
					"$tab\t</p>\n".
					"$tab\t<p class=\"upload_field wprs_add_media\">\n".
					"$tab\t\t<input type=\"text\" id=\"$id\" name=\"$id\" tabindex=\"$tabindex\" value=\"$url\" size=\"60\"/>\n".
					"$tab\t</p>";

				echo $theoutput;
				echo'</p>';	
		}
	}
	echo '</div>';
}

// Save data from meta box
function wprs_save_data($post_id) {
	
	global $wprs_meta_box, $wprs_prefix;
	
	// verify nonce
	if (!isset($_POST['wprs_nonce']) || !wp_verify_nonce($_POST['wprs_nonce'], basename(__FILE__))) return $post_id;
	
	// skip auto save
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}

	// check permissions
	if ( !current_user_can( 'edit_post', $post_id ) ) {
        return;
    }
	
	foreach ($wprs_meta_box['fields'] as $field) {
		
		$old = get_post_meta($post_id, $field['id'], true);
		
		// get rid of the empty and unset fields, which cause php notices 
		if ( isset($_POST[$field['id']]) ) { $new = $_POST[$field['id']];} else { $new =''; }
		
		// deal with "Select", so it won't create an unwanted custom field value ...
		if ( $new == 'Select') {$new ='';}
		
		// deal with "No Rating" and slider percentage = 1, so it won't create an unwanted custom field value...
		if ( $new == 'No Rating' ) $new ='';
		if ( $new == 1 && $field['id'] == $wprs_prefix.'slider_percentage' ) $new ='';
		
		// deal with "defaul" value in Templates select box, so it won't create an unwanted custom field value...
		if ( $new == 'default') {$new ='';}
		
		// deal with repeated
		if ( is_array($new) && $field['id'] == $wprs_prefix.'repeatable' ) {
			
			/*
			
			*** I've commented this, it cause issues when order fields and save them.
			
			if (count($new) == 1 && $new[0]['rating'] == 'No Rating' || $new[0]['rating'] == '') {
				//if ($new[0]['title'] == '' && $new[0]['desc'] == '') {$new ='';}
			} else {
				// prepare repeated array before saving
				$i=0;
				foreach($new as $key => $element){
					$new[$i]['title'] = wprs_str_replace($element['title']); 
					$i++;
				}
			}*/
		}
		
		// deal with openinghours
		if ( is_array($new) && $field['id'] == $wprs_prefix.'openinghours' ) {
			if ($new[0]['from_day'] == '--' && $new[0]['to_day'] == '--') {$new ='';}
		}
		
		// things are good, let's update, or delete empty fields
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	}
}
	
	
	
	/*
    	deal with repeatable, remove spaces, dashes, and more...
		@since 1.0.0
		*/
	function wprs_str_replace($string) {
		//lower case everything
		//$string = strtolower($string);
		//make alphaunermic
		//$string = preg_replace("/[^a-z0-9_\s-]/", "", $string);
		//Clean multiple dashes or whitespaces
		$string = preg_replace("/[\s-]+/", " ", $string);
		//Convert whitespaces and underscore to dash
		$string = preg_replace("/[\s_]/", "-", $string);
		return $string;
	}


	/*
    	enqueue scripts and styles to post editor page
		@since 1.0.0
		*/
	function wprs_enqueue() {
		wp_enqueue_style(	'wprs-metabox-tabs',	WPRS_CSS_URL.'metabox-tabs.css'										);
		wp_enqueue_style(	'jquery-ui-theme',		WPRS_CSS_URL.'smoothness/jquery-ui-1.10.3.custom.min.css'			);
		wp_enqueue_style(	'font-awesome-styles',	WPRS_INC_URL.'extras/font-awesome/assets/css/font-awesome.min.css' 	);
		wp_enqueue_script(	'wprs-metabox-tabs',	WPRS_JS_URL.'metabox-tabs.js', 'jquery'								);
		wp_enqueue_script(	'wprs-image-upload',	WPRS_JS_URL.'image-upload.js', 'jquery'								);
		wp_enqueue_script(	'wprs-raty',			WPRS_JS_URL.'user-rating/jquery.raty.min.js'						);
		
		//wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'jquery-ui-slider' );
	}
	
		
	/*
    	add raty to the footer
		@since 1.0.0
		*/
	function wprs_raty_scripts() {
		global $wprs_prefix, $pagenow;
		
		// load the scripts on only the new post and edit post pages
		if (!is_admin()) return;
		if ( $pagenow=='post-new.php' OR $pagenow=='post.php') {
		
			$path = plugins_url( '')  . '/wp-rich-snippets/assets/images/raty/stars';
			$meta = wprs_get_meta();
			$slider_percentage = isset($meta[$wprs_prefix.'slider_percentage']) ? $meta[$wprs_prefix.'slider_percentage'] : 1;
			?>
			<script type="text/javascript">
	    		jQuery(document).ready(function($) {
	
					$('#<?php echo $wprs_prefix; ?>star_rating').raty({
						path		: '<?php echo $path; ?>',
						cancel		: true,
						cancelHint	: 'Cancel this rating!',
						half		: true,
						space		: false,
						target		: '#wprs_star_hint',
						targetType	: 'number',
						targetKeep	: true,
						score		: function() {return $(this).attr('data-score');},
						scoreName	: '<?php echo $wprs_prefix; ?>star_rating'
					});
				
					$( '#<?php echo $wprs_prefix; ?>slider_percentage_item_range' ).slider({
						range: "min",
						value: <?php echo $slider_percentage ?>,
						min: 1,
						max: 100,
						slide: function( event, ui ) {
							$( "#amount" ).val( ui.value );
							$(this).find('.ui-slider-handle').text(ui.value);
							$( "#<?php echo $wprs_prefix; ?>slider_percentage" ).val( ui.value );
						},
						create: function(event, ui) {
							var v=$(this).slider('value');
							$(this).find('.ui-slider-handle').text(v);
						}
					});
				
					$( "#<?php echo $wprs_prefix; ?>slider_percentage" ).val( $( "#<?php echo $wprs_prefix; ?>slider_percentage_item_range" ).slider( "value" ) );
				
				});
			</script>
			<?php
		}
	}
