<?php
/*
	Integrations that is required by the plugin
	
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
    */
	
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/*
	Views plugin integration
	use shortcode [wprs-raw-content] to replace wpr-raw-content
	this to avoid duplicate rating box when using Views
	@since 1.0.0
*/
	add_shortcode('wprs-raw-content', 'wprs_raw_content_shortcode');
		function wprs_raw_content_shortcode() {
		global $post;
		return wpautop(wptexturize(do_shortcode($post->post_content)));
	}
	
	// check the current post for the existence of a short code
	function wprs_has_shortcode( $shortcode = '' ) {
     
    	$post_to_check = get_post(get_the_ID());
     
    	// false because we have to search through the post content first
    	$found = false;
     
    	// if no short code was provided, return false
    	if (!$shortcode) {
        	return $found;
    	}
    	// check the post content for the short code
    	if ( stripos($post_to_check->post_content, '[' . $shortcode) !== false ) {
        	// we have found the short code
        	$found = true;
    	}
     
    	// return our final results
    	return $found;
	}

	
	add_filter( 'comments_template' , 'wprs_disable_disqus', 1);
	/*
		Try to disable Disqus comments on aggregate 
		@since 1.0.0
		*/
	function wprs_disable_disqus($file) {
		global $post;
		
		// get review type
		$type = wprs_get_type();
		
 		// Detect plugin. For use on Front End only.
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		$plugin = 'disqus-comment-system/disqus.php';
		// check for plugin using plugin name
		if ( is_plugin_active( $plugin ) ) {
  			// Disqus is active, so start with removing Disqus filter at this early stage
			remove_filter('comments_template', 'dsq_comments_template');
			// If WPRS is not enabled, or it's not an aggregate review... add back Disqus filter
			if ( !wprs_is_enabled($post->ID) || $type != 'aggregate' ) {
				add_filter('comments_template', 'dsq_comments_template');
			}
		}
		// return regular comments template
		return $file;
	}
	
	/*
		Remove Disqus check
		@since 1.2.5
		*/ 
	if (function_exists('dsq_pre_comment_on_post')) {
		remove_action('pre_comment_on_post', 'dsq_pre_comment_on_post');
	}
	
