<?php
/*
	WPRS image slider
	
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
    */
	
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	
	add_action( 'wp_enqueue_scripts', 'wprs_slider_scripts', 100 );	    
    /*
    	Load slider script
		@since 1.0.0
		*/
	function wprs_slider_scripts() {
		
		global $post, $wprs_prefix;
		
		if ( is_admin() ) return;
		if ( !is_singular() ) return;
		if ( is_archive() ) return;
		if ( is_404() ) return;
		
		// register the script
		wp_register_script( 'wprs-flexslider', WPRS_JS_URL.'slider/jquery.flexslider-min.js', true);
		
		if ( get_post_meta($post->ID, $wprs_prefix.'gallery_slider', TRUE) ) {
			// enqueue the script
			wp_enqueue_script( 'jquery' );
			wp_enqueue_script( 'wprs-flexslider' );
		}
	}
	
	
		

	add_action( 'wp_enqueue_scripts', 'wprs_slider_styles', 1 );		    
    /*
    	Load slider styles
		@since 1.0.0
		*/
	function wprs_slider_styles() {
		
		global $post, $wprs_prefix;
		
		if ( is_admin() ) return;
		if ( !is_singular() ) return;
		if ( is_archive() ) return;
		if ( is_404() ) return;
		
		// register the style
		wp_register_style ( 'wprs-flexslider', WPRS_CSS_URL.'slider/flexslider.css' );
		
		if (  get_post_meta($post->ID, $wprs_prefix.'gallery_slider', TRUE) ) {
			// enqueue the style
			wp_enqueue_style( 'wprs-flexslider' );
		}
		
		
	}
	


	add_shortcode('wprs_slider', 'wprs_gallery_slider');		    
    /*
    	Slider shortcode
		@since 1.0.0
		*/
	
	function wprs_gallery_slider($atts) {

		// grab attachments
		global $post;
		$output = '';
	
		extract(shortcode_atts(array(
												'post_id' => 1,
   		), $atts));
	
		if(!$atts){	$post_id = $post->ID; }
	
		$attachments = get_children( array(
												'post_parent' => $post_id,
												'post_status' => 'inherit',
												'post_type' => 'attachment',
												'post_mime_type' => 'image',
												'order' => 'ASC',
												'orderby' => 'menu_order ID'
		) );
	
		$first_value = reset($attachments);
		
		if ( empty($attachments) ) return '';
		
		$output .= '<div class="flexslider loading">';
		$output .= '<ul class="slides">';
		
		$title ='';
		
		foreach ( $attachments as $id => $attachment ){
			$img_src_array = wp_get_attachment_image_src($id, 'full' );
			$image_src = $img_src_array[0];
			$output .= '<li>';
			$output .= '<img itemprop="image" class="photo" src="' . $image_src . '" alt="' . $title .'" />';
			$output .= '</li>';
		}
		
		$output .= '</ul>';
		
		$output .= '</div>'; // end of slider
		
		return $output;
	}
	
	
	add_action('wp_footer', 'wprs_SliderScript', 100);	    
	/*
    	Appends the script require for slider
		@since 1.0.0
		*/
	function wprs_SliderScript() {
		global $post, $wprs_prefix;
		if ( !is_admin() && get_post_meta($post->ID, $wprs_prefix.'gallery_slider', TRUE) ) {
		?>
<script type="text/javascript" charset="utf-8">
	jQuery(window).load(function() {
	jQuery('.flexslider').flexslider({
		directionNav: true, 
		controlNav: false,
		animation: "slide",
		touch: true,
		slideshowSpeed: 7000, 
		animationSpeed: 600,
		
		start: function ( slider ) {
			jQuery( '.flexslider' ).removeClass( 'loading' );
		}
		
	});
});
</script>
<?php }
	}

