<?php
/*
	WPRichSnippets - Recipe votes template
 
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


function wprs_template_Recipe_votes( $id = null ) {
	
	global $post;
    
	If ( ! isset($id) ) $id = $post->ID;
		
	// define $box
	$box = '';
	
	// get box settings
	$template = wprs_template($id);
	
	$box .= '<div class="wprs_container">';
	$box .= '<div class="row">';
		
		$box .= '<div id="wprs_square">';
			
			$box .= $template['media'];
			
			$box .= '<div class="row">';
				$box .= '<div class="col-xs-3 col-sm-2 col-md-2">';
					$box .= '<span class="wprs-star-rating-mini">'.$template['user_star_rating_mini'].'</span>';
				$box .= '</div>';
				
				$box .= '<div class="col-xs-3 col-sm-2 col-md-2">';
					$box .= '<span class="wprs_headline_light">'. __('Serves', 'wprs') .'</span><br />';
					$box .= $template['recipe_serves'];
				$box .= '</div>';
				
				$box .= '<div class="col-xs-3 col-sm-2 col-md-2">';
					$box .= '<span class="wprs_headline_light">'. __('Cuisine', 'wprs') .'</span><br />';
					$box .= $template['recipe_cuisine'];
				$box .= '</div>';
				
				$box .= '<div class="col-xs-6 col-sm-2 col-md-2">';
					$box .= '<span class="wprs_headline_light">'. __('Course', 'wprs') .'</span><br />';
					$box .= $template['recipe_course'];
				$box .= '</div>';
				
				$box .= '<div class="col-xs-6 col-sm-4 col-md-4">';
					$box .= '<ul class="al-right">';
						$box .= '<li><h4><span>'. apply_filters('wprs_text_your_rating', __('Your Rating', 'wprs')) .'</span></h4></li>';
						$box .= '<li>'.$template['user_rating_stars'].'</li>';
					$box .= '</ul>';
				$box .= '</div>';
			$box .= '</div>';
			
			
			$box .= '<hr />';
			
			$box .= '<div class="row">';
				$box .= $template['description_raw'];
			$box .= '</div>';
			
			$box .= '<br />';
			
			$box .= '<h3>'. __('Nutrition', 'wprs') .'</h3>';
			$box .= '<hr />';
			$box .= $template['recipe_nutrition'];
			
			$box .= '<br />';
			
			$box .= '<h3>'. __('Ingredients', 'wprs') .'</h3>';
			$box .= '<hr />';
			
			$box .= '<div class="row">';
				$box .= $template['recipe_ingredients'];
			$box .= '</div>';
			
			$box .= '<br />';
				
			$box .= '<h3>'. __('Directions', 'wprs') .'</h3>';
			$box .= '<hr />';
					
			$box .= '<div class="row">';
			
				$box .= '<div class="col-xs-2 col-sm-2 col-md-2">';
					$box .= '<i class="fa fa-clock-o fa-3x wprs_recipe_clock" aria-hidden="true"></i>';
				$box .= '</div>';
				$box .= '<div class="col-xs-2 col-sm-2 col-md-2">';
				$box .= '<span class="wprs_headline_light">'. __('Prep', 'wprs') .'</span><br />';
					$box .= $template['recipe_prep_time'];
				$box .= '</div>';
				$box .= '<div class="col-xs-2 col-sm-2 col-md-2">';
				$box .= '<span class="wprs_headline_light">'. __('Cook', 'wprs') .'</span><br />';
					$box .= $template['recipe_cook_time'];
				$box .= '</div>';
				$box .= '<div class="col-xs-2 col-sm-2 col-md-2">';
				$box .= '<span class="wprs_headline_light">'. __('Ready In', 'wprs') .'</span><br />';
					$box .= $template['recipe_total_time'];
				$box .= '</div>';
			$box .= '</div>';
			
			
			$box .= '<br />';
			
			
			$box .= '<div class="row">';
				$box .= $template['recipe_instructions'];
			$box .= '</div>';
					
			
		$box .= '</div>';
			
	$box .= '</div>';
	$box .= '</div>';
	
	// remove links filter
	// it has been added already via the template
	remove_filter('wprs_box_footer', 'wprs_display_links');
	
	return apply_filters('wprs_template_Recipe_votes', $box);
	
}
