<?php
/*
	Box main function
	
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
    */
	
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	/*
		The Box
		@since 1.3
		*/
	function wprs_box( $id = null) {
		
		global $post, $wprs_prefix;
		
		If ( ! isset($id) ) $id = $post->ID;
		
		$options = get_option('wprs_options');
		$custom = get_post_custom($id);
    	
		// Define $box
		$box = '';
		
		// Runs on posts and pages
		// @since 1.0.0
		//if (is_single($id) || is_page($id)) {
		
			// Get meta data
			$meta = wprs_get_meta_by_id($id);
			//echo $meta['wprs_post_star_rating'];
			
			// Get box settings
			$template = wprs_template($id);
			
			// Get schema path
			//$schema = 'http://schema.org/';
			$schema = wprs_schema_path();
			
			switch ($template['snippets_type']) {
				
				
				// Case type Article
				case 'Article':
					switch ($template['review_type']) {
						
						case 'votes':
						
							$box = wprs_template_Article_votes($id);	
							break;
						
						case 'aggregate':
							
							$box = wprs_template_Article_aggregate($id);
							break;
						
						case 'none':

							$box = wprs_template_Article_none($id);
							break;
					}
					break;
					
				// Case type Review
				case 'Review':
					switch ($template['review_type']) {
						
						case 'rating':

							$box = wprs_template_review_rating($id);	
							break;
							
						case 'percentage':

							$box = wprs_template_review_percentage($id);
							break;

					}
					break;
				
				// Case type Recipe
				case 'Recipe':
					switch ($template['review_type']) {
						
						case 'votes':
						
							$box = wprs_template_Recipe_votes($id);	
							break;
						
						case 'aggregate':
							
							$box = wprs_template_Recipe_aggregate($id);
							break;
					}
					break;
					
				// Case type Product
				case 'Product':
					
					switch ($template['review_type']) {
						
						case 'rating':

							$box = wprs_template_product_rating($id);
							break;
							
						case 'percentage':
							
							$box = wprs_template_product_percentage($id);
							break;
						
						case 'votes':
						
							$box = wprs_template_product_votes($id);	
							break;
						
						case 'aggregate':
							
							$box = wprs_template_product_aggregate($id);
							break;
						
						case 'none':

							$box = wprs_template_product_none($id);
							break;
								
					}
					break;
					
				// Case type LocalBusiness
				case 'Organization':
					
					switch ($template['review_type']) {
								
						case 'votes':
						
							$box = wprs_template_organization_votes($id);	
							break;
						
						case 'aggregate':
							
							$box = wprs_template_organization_aggregate($id);
							break;
						
						case 'none':

							$box = wprs_template_organization_none($id);
							break;
								
					}
					break; 
				
				// Case type Restaurant
				case 'Restaurant':
					
					switch ($template['review_type']) {
						
						case 'votes':
						
							$box = wprs_template_restaurant_votes($id);	
							break;
						
						case 'aggregate':
							
							$box = wprs_template_restaurant_aggregate($id);
							break;
						
						case 'none':

							$box = wprs_template_restaurant_none($id);
							break;
								
					}
					break;
				
				// Case type Product
				case 'SoftwareApplication':
					
					switch ($template['review_type']) {
						
						case 'votes':
						
							$box = wprs_template_SoftwareApplication_votes($id);	
							break;
						
						case 'aggregate':
							
							$box = wprs_template_SoftwareApplication_aggregate($id);
							break;
							
					}
					break;
						

				// Case type Book
				case 'Book':
					
					$type = 'Book';
					break;
				
				// Case type Movie
				case 'Movie':
					
					$type = 'Movie';
					break;
				
				// case type Person
				case 'Person':
					
					$type = 'Person';
					break;
					
			//}
		
			
		}
	
		// Returns the box.
    	return apply_filters( 'wprs_box', $box );
	}
	

