<?php
/*
	Schema build main function
	
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
    */
	
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	
	/*
		Box template
		@since 1.0.0
		*/
	function wprs_template( $id = null ) {
	
		global $post, $wprs_prefix;
		
		$options = get_option('wprs_options');
		//$meta = wprs_get_meta();
		
		// Set post ID
		If ( ! isset($id) && isset($post->ID) ) $id = $post->ID;
		
		// Get meta values
		// @since 1.0.0
		$meta = wprs_get_meta_by_id($id);
	
		$box_settings = array();
	
		// Schema and review types
		$snippets_type = isset($meta[$wprs_prefix.'snippets_types']) ? $meta[$wprs_prefix.'snippets_types'] : '';
		$review_type = isset($meta[$wprs_prefix.'review_type']) ? $meta[$wprs_prefix.'review_type'] : 'rating';
		
		// User reviews	
		$user_reviews = wprs_get_user_reviews();
		
		// Get item name & thing
		$item_name = isset($meta[$wprs_prefix.'item_name']) ? $meta[$wprs_prefix.'item_name'] : '';
		$brand_name = isset($meta[$wprs_prefix.'brand_name']) ? $meta[$wprs_prefix.'brand_name'] : '';
		$itemprop_name = wprs_get_itemprop_name($id);
		$thing = wprs_get_Thing($id);
	
		// Ratings
		$review_rating = isset($meta[$wprs_prefix.'star_rating']) ? $meta[$wprs_prefix.'star_rating'] : '';
		$slider_percentage = isset($meta[$wprs_prefix.'slider_percentage']) ? $meta[$wprs_prefix.'slider_percentage'] : '';
		//$slider_value = isset($meta[$wprs_prefix.'slider_percentage']) ? $meta[$wprs_prefix.'slider_percentage'] : '';
		$user_rating = isset($meta[$wprs_prefix.'user_rating']) ? $meta[$wprs_prefix.'user_rating'] : '';
		$userrating_average = isset($meta[$wprs_prefix.'userrating_average']) ? $meta[$wprs_prefix.'userrating_average'] : '';
		$userrating_count = isset($meta[$wprs_prefix.'userrating_count']) ? $meta[$wprs_prefix.'userrating_count'] : 0;
		$userrating_review_count = wprs_get_user_reviews_count($userrating_count). wprs_get_add_your_review();
		
		$editor_star_rating = wprs_get_star_rating($review_rating);
		$user_star_rating = wprs_get_user_star_rating($id);
		$user_star_rating_array = wprs_get_user_vote_array_display($id);
		$user_star_rating_mini = wprs_get_user_star_rating_mini($id);
		$user_star_aggregate = wprs_get_user_star_aggregate($id);
		$user_star_aggregate_raw = wprs_get_user_star_aggregate_raw($id);
		$user_star_aggregate_mini = wprs_get_user_star_aggregate_mini($id);
		$user_rating_stars = wprs_get_user_rating_stars($id);
		
		// Rating stars no markups
		$editor_star_rating_no_markup = wprs_get_star_rating_no_markup($review_rating);
		
		// User star rating with no markup
		$user_star_rating_raw = wprs_get_user_star_rating_raw($id);
		
		// $progressbar
		$progressbar_editor = wprs_get_progressbar($slider_percentage, 'editor');
		//$progressbar_user = wprs_get_progressbar($settings['slider_percentage'], 'editor');
		
		// Score
		$score_editor = wprs_get_score($review_rating, 'editor');
		$score_user = wprs_get_score($user_rating, 'user');
		
		// Criteria
		$criteria_editor = wprs_get_criteria($id, 'editor');
		$criteria_user = wprs_get_criteria($id, 'user');
		$criteria_all = wprs_get_criteria($id, 'all');
		
		// Percentage
		$percentage_editor = wprs_get_rating_percentage($review_rating, 'editor');
		$percentage_editor_slider = wprs_get_rating_percentage($slider_percentage, 'editor', true);
		$percentage_user = wprs_get_rating_percentage($user_rating, 'user');
		$percentage_user_average = wprs_get_rating_percentage($userrating_average, 'user');
		
		// Price
		$currency = isset($options['wprs_currency']) ? $options['wprs_currency'] : 'USD';
		$currency_sympol = wprs_get_currency_symbol($currency);
		$price = wprs_get_price($id, $currency_sympol);
		$price_raw = wprs_get_price_raw($id, $currency_sympol);
		
		// Media
		$media = wprs_get_media($id);
		$img_url = wprs_get_img_url($id);
		$screenshot = isset($meta[$wprs_prefix.'image']) ? $meta[$wprs_prefix.'image'] : '';
		
		// Address & Maps
		$phone = wprs_get_phone($id);
		$address = wprs_get_address($id);
		$map = wprs_get_map($id);
		
		// Author
		$author = wprs_get_author_name_person($id, get_the_author());
		$author_raw = get_the_author();
		
		// Description
		$description = wprs_get_description($id);
		$description_raw = wprs_get_description_raw($id);
		$description_raw_wpautop = wprs_get_description_raw_wpautop($id);
		
		// Dates
		$date_published = wprs_get_dtreviewed();
		$date_modified = wprs_get_dtmodified();
		$datePublished = get_the_time('c', $id);
		$dateModified = get_the_modified_time('c', $id);
		
		// Links
		$links = wprs_getReviewLinks($id);
		$links_mini = wprs_getReviewLinksMini($id);
		$link = wprs_getReviewLink($id);
		$link_demo = wprs_getReviewLinkDemo($id);
		
		// Cons & Pros
		$cons = wprs_cons($id);
		$pros = wprs_pros($id);
		
		// Restaurant details
		$cuisine = wprs_get_cuisine($id);
		$openhours = wprs_get_openhours($id);
		$reservations = wprs_get_reservations($id);
		$restaurant_menu = wprs_get_restaurant_menu($id);
		
		// Articles
		$alternativeHeadline = isset($meta[$wprs_prefix.'alternativeHeadline']) ? $meta[$wprs_prefix.'alternativeHeadline'] : '';
		
		// Recipe
		$recipe_ingredients 	= wprs_get_recipe_ingredients($id);
		$recipe_instructions 	= wprs_get_recipe_instructions($id);
		$recipe_prep_time 		= wprs_get_recipe_prep_time($id);
		$recipe_cook_time 		= wprs_get_recipe_cook_time($id);
		$recipe_total_time 		= wprs_get_recipe_total_time($id);
		$recipe_serves 			= wprs_get_recipe_serves($id);
		$recipe_nutrition		= wprs_get_recipe_nutrition($id);
		$recipe_course 			= isset($meta[$wprs_prefix.'recipe_course']) ? $meta[$wprs_prefix.'recipe_course'] : '';
		$recipe_cuisine 		= isset($meta[$wprs_prefix.'recipe_cuisine']) ? $meta[$wprs_prefix.'recipe_cuisine'] : '';
						
		// SoftwareApplication
		$operatingSystem = isset($meta[$wprs_prefix.'operatingSystem']) ? $meta[$wprs_prefix.'operatingSystem'] : '';
		$applicationCategory = isset($meta[$wprs_prefix.'applicationCategory']) ? $meta[$wprs_prefix.'applicationCategory'] : '';
		$softwareVersion = isset($meta[$wprs_prefix.'softwareVersion']) ? $meta[$wprs_prefix.'softwareVersion'] : '';
		$fileSize = isset($meta[$wprs_prefix.'fileSize']) ? $meta[$wprs_prefix.'fileSize'] : '';
		$fileFormat = isset($meta[$wprs_prefix.'fileFormat']) ? $meta[$wprs_prefix.'fileFormat'] : '';
		$requirements = isset($meta[$wprs_prefix.'requirements']) ? $meta[$wprs_prefix.'requirements'] : '';
		$softwareHelp = isset($meta[$wprs_prefix.'softwareHelp']) ? $meta[$wprs_prefix.'softwareHelp'] : '';
		$releaseNotes = isset($meta[$wprs_prefix.'releaseNotes']) ? $meta[$wprs_prefix.'releaseNotes'] : '';
		
		// Comments count
		$comments_count = wp_count_comments($id);
		$comments_count_total = $comments_count->total_comments;
		
		// Set hide/show class
		$reviewed_by_class = isset($options['wprs_chk_reviewed_by_hide']) ? ' wprs_magic' : '';
		$review_date_class = isset($options['wprs_chk_rating_date_hide']) ? ' wprs_magic' : '';
		$review_dmodified_class = isset($options['wprs_chk_rating_modified_date_hide']) ? ' wprs_magic' : '';
	
		// Set rating box width
		if (isset($options['wprs_box_width']) != '') {$rating_box_width = $options['wprs_box_width'];} else {$rating_box_width = '300';}
				
		// Set image alignment
		if (isset($options['wprs_img_alignment']) != '') {$rating_img_alignment = $options['wprs_img_alignment'];} else {$rating_img_alignment = 'left';}
				
	
		// All done!
		// now...
		// build our array of settings to be used in templates
		$wprs_template = array(
						'snippets_type'					=> $snippets_type,
						'review_type'					=> $review_type,
						'user_reviews'					=> $user_reviews,
						'item_name'						=> $item_name,
						'itemprop_name'					=> $itemprop_name,
						'brand_name'					=> $brand_name,
						'alternativeHeadline'			=> $alternativeHeadline,
						'thing'							=> $thing,
						'review_rating'					=> $review_rating,
						'editor_star_rating'			=> $editor_star_rating,
						'editor_star_rating_no_markup'	=> $editor_star_rating_no_markup,
						'slider_percentage'				=> $slider_percentage,
						'user_rating'					=> $user_rating,
						'userrating_average'			=> $userrating_average,
						'userrating_count'				=> $userrating_count,
						'userrating_review_count'		=> $userrating_review_count,
						'user_star_rating'				=> $user_star_rating,
						'user_star_rating_array'		=> $user_star_rating_array,
						'user_star_rating_mini'			=> $user_star_rating_mini,
						'user_star_rating_raw'			=> $user_star_rating_raw,
						'user_star_aggregate'			=> $user_star_aggregate,
						'user_star_aggregate_mini'		=> $user_star_aggregate_mini,
						'user_star_aggregate_raw'		=> $user_star_aggregate_raw,
						'user_rating_stars'				=> $user_rating_stars,
						'progressbar_editor'			=> $progressbar_editor,
						//'progressbar_user'			=> $progressbar_user,
						'score_editor'					=> $score_editor,
						'percentage_editor_slider'		=> $percentage_editor_slider,
						'score_user'					=> $score_user,
						'percentage_editor'				=> $percentage_editor,
						'percentage_user'				=> $percentage_user,
						'percentage_user_average'		=> $percentage_user_average,
						'criteria_editor'				=> $criteria_editor,
						'criteria_user'					=> $criteria_user,
						'criteria_all'					=> $criteria_all,
						
						'media'							=> $media,
						'img_url'						=> $img_url,
						'screenshot'					=> $screenshot,
						
						'phone'							=> $phone,
						'address'						=> $address,
						'map'							=> $map,
						'currency'						=> $currency,
						'currency_sympol' 				=> $currency_sympol,
						'price' 						=> $price,
						'price_raw' 					=> $price_raw,
						'author'						=> $author,
						'author_raw'					=> $author_raw,
						'description'					=> $description,
						'description_raw'				=> $description_raw,
						'description_raw_wpautop'		=> $description_raw_wpautop,
						
						'date_published' 				=> $date_published,
						'date_modified' 				=> $date_modified,
						'datePublished' 				=> $datePublished,
						'dateModified' 					=> $dateModified,
						
						'reviewed_by_class'				=> $reviewed_by_class,
						'review_date_class'				=> $review_date_class,
						'review_dmodified_class'		=> $review_dmodified_class,
						'links'							=> $links,
						'links_mini'					=> $links_mini,
						'link'							=> $link,
						'link_demo'						=> $link_demo,
						'cons'							=> $cons,
						'pros'							=> $pros,
						'cuisine'						=> $cuisine,
						'openhours'						=> $openhours,
						'reservations'					=> $reservations,
						'restaurant_menu'				=> $restaurant_menu,
						
						'recipe_ingredients'			=> $recipe_ingredients,
						'recipe_instructions'			=> $recipe_instructions,
						'recipe_prep_time'				=> $recipe_prep_time,
						'recipe_cook_time'				=> $recipe_cook_time,
						'recipe_total_time'				=> $recipe_total_time,
						'recipe_serves'					=> $recipe_serves,
						'recipe_nutrition'				=> $recipe_nutrition,
						'recipe_course'					=> $recipe_course,
						'recipe_cuisine'				=> $recipe_cuisine,
						
						'operatingSystem'				=> $operatingSystem,
						'applicationCategory'			=> $applicationCategory,
						'softwareVersion'				=> $softwareVersion,
						'fileFormat'					=> $fileFormat,
						'fileSize'						=> $fileSize,
						'requirements'					=> $requirements,
						'softwareHelp'					=> $softwareHelp,
						'releaseNotes'					=> $releaseNotes,
						
						'comments_count_total'			=> $comments_count_total
						
					);
					
		// debug
		//echo '<pre>';
		//print_r($wprs_template );
		//echo '</pre>';
		
		return apply_filters( 'wprs_template', $wprs_template );
	
	}

	
	/*
		Schema
		@since 1.0.0
		*/
	function wprs_schema($content, $id = null) {
		
		global $post, $wprs_prefix;
		
		If ( ! isset($id) ) $id = $post->ID; 
		
		$options = get_option('wprs_options');
		$custom = get_post_custom($id);
    	
		// Define $box
		// @since 1.3
		$box = wprs_box($id);
		
		// Runs on posts and pages
		// @since 1.0.0
		if (is_single($id) || is_page($id)) {
		
			// Get meta data
			$meta = wprs_get_meta_by_id($id);
			//echo $meta['wprs_post_star_rating'];
			
			// Get box settings
			$template = wprs_template($id);
			
			// Schema is enabled on this entry
			// Let's start...
			///////////////////////////////////
			
			// Get schema path
			//$schema = 'http://schema.org/';
			$schema = wprs_schema_path();
			
			// Get Snippets Type
			$type = $template['snippets_type'];
		
			// Define
			$article_type = '';
			$wprs_before = '';
			$wprs_after = '';			
			$reviewBody_before = '';
			$reviewBody_after = '';
			
			// Prepare main divs & containers
			switch ($type) {
				
				case 'Article':
					
					// Set article type
					if (isset($meta[$wprs_prefix.'article_type'])) {
						$article_type = $meta[$wprs_prefix.'article_type'] == 'General' ? 'Article' : $meta[$wprs_prefix.'article_type'];
					}
					
					$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $article_type . '">';
					$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="headline">';
					$wprs_before .= '<meta content="'.$template['alternativeHeadline'].'" itemprop="alternativeHeadline">';
					$wprs_before .= '<meta content="'.$template['datePublished'].'" itemprop="datePublished">';
					$wprs_before .= '<meta content="UserComments:'.$template['comments_count_total'].'" itemprop="interactionCount">';
					$reviewBody_before = '<div itemprop="articleBody">';
					$reviewBody_after = '</div>';
					$wprs_after = '</div>';
					
					if ($template['review_type'] == 'votes') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $article_type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="headline">';
						$wprs_before .= '<meta content="'.$template['alternativeHeadline'].'" itemprop="alternativeHeadline">';
						$wprs_before .= '<meta content="'.$template['author_raw'].'" itemprop="author">';
						$wprs_before .= wprs_get_publisher_markup($id);
						$wprs_before .= '<meta content="'.$template['datePublished'].'" itemprop="datePublished">';
						$wprs_before .= '<meta content="'.$template['dateModified'].'" itemprop="dateModified">';
						$wprs_after = '</div>';
					}
					
					if ($template['review_type'] == 'aggregate') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $article_type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="headline">';
						$wprs_before .= '<meta content="'.$template['alternativeHeadline'].'" itemprop="alternativeHeadline">';
						$wprs_before .= '<meta content="'.$template['datePublished'].'" itemprop="datePublished">';
						$wprs_after = '</div>';
					}
					
					if ($template['review_type'] == 'none') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $article_type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="headline">';
						$wprs_before .= '<meta content="'.$template['alternativeHeadline'].'" itemprop="alternativeHeadline">';
						$wprs_before .= '<meta content="UserComments:'.$template['comments_count_total'].'" itemprop="interactionCount">';
						$wprs_before .= '<meta content="'.$template['author_raw'].'" itemprop="author">';
						$wprs_before .= wprs_get_publisher_markup($id);
						$wprs_before .= '<meta content="'.$template['datePublished'].'" itemprop="datePublished">';
						$wprs_before .= '<meta content="'.$template['dateModified'].'" itemprop="dateModified">';
						$wprs_after = '</div>';
					}
					break;
					
				case 'Review':
					
					$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
					$reviewBody_before = '<div itemprop="reviewBody">';
					$reviewBody_after = '</div>';
					$wprs_after = '</div>';
					break;
				
				case 'Recipe':
					
					$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
					$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
					$wprs_before .= '<meta content="'.$template['author_raw'].'" itemprop="author">';
					$wprs_before .= '<meta content="UserComments:'.$template['comments_count_total'].'" itemprop="interactionCount">';
					$reviewBody_before = '';
					$reviewBody_after = '';
					$wprs_after = '</div>';
					
					if ($template['review_type'] == 'votes' || $template['review_type'] == 'aggregate') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
						$wprs_before .= '<meta content="'.$template['author_raw'].'" itemprop="author">';			
						$wprs_after = '</div>';
					}
					break;
				
				case 'Product':
					
					$product_name = '';
					$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
					$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
					$wprs_before .= '<meta content="'.$template['brand_name'].'" itemprop="brand">';
					$wprs_before .= '<div itemprop="review" itemscope itemtype="'.wprs_schema_path().'Review">';
					$reviewBody_before = '';
					$reviewBody_after = '';
					$wprs_after = '</div></div>';
					
					if ($template['review_type'] == 'votes' || $template['review_type'] == 'aggregate') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
						$wprs_before .= '<meta content="'.$template['brand_name'].'" itemprop="brand">';
						$wprs_after = '</div>';	
					}
					
					if ($template['review_type'] == 'none') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
						$wprs_before .= '<meta content="'.$template['brand_name'].'" itemprop="brand">';
						$wprs_after = '</div>';
					}
					break;
				
				case 'Organization':
					
					if (isset($meta[$wprs_prefix.'organization_type'])) {
						$organization_type = $meta[$wprs_prefix.'organization_type'] == 'General' ? 'Organization' : $meta[$wprs_prefix.'organization_type'];
					} else {
						$organization_type = 'Organization';
					}
					
					if (isset($meta[$wprs_prefix.'organization_type_sub']) && $meta[$wprs_prefix.'organization_type_sub'] != '' ) {
						$organization_type = $meta[$wprs_prefix.'organization_type_sub'];
					}
					
					$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $organization_type . '">';
					$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
					$wprs_before .= '<div itemprop="review" itemscope itemtype="'.wprs_schema_path().'Review">';
					$reviewBody_before = '';
					$reviewBody_after = '';
					$wprs_after = '</div></div>';
					
					if ($template['review_type'] == 'votes' || $template['review_type'] == 'aggregate') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $organization_type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
						$wprs_after = '</div>';
					}
					
					if ($template['review_type'] == 'none') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
						$wprs_after = '</div>';
					}
					break;
				
				case 'Restaurant':
					
					$product_name = '';
					$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
					$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
					$wprs_before .= '<div itemprop="review" itemscope itemtype="'.wprs_schema_path().'Review">';
					$reviewBody_before = '';
					$reviewBody_after = '';
					$wprs_after = '</div></div>';
					
					if ($template['review_type'] == 'votes' || $template['review_type'] == 'aggregate') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
						$wprs_after = '</div>';	
					}
					
					if ($template['review_type'] == 'none') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
						$wprs_after = '</div>';
					}
					break;
				
				case 'SoftwareApplication':
					
					$product_name = '';
					$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
					$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
					$wprs_before .= '<meta content="'.$template['operatingSystem'].'" itemprop="operatingSystem">';
					$wprs_before .= '<meta content="'.$template['applicationCategory'].'" itemprop="applicationCategory">';
					$wprs_before .= '<meta content="'.$template['softwareVersion'].'" itemprop="softwareVersion">';
					$wprs_before .= '<meta content="'.$template['fileFormat'].'" itemprop="fileFormat">';
					$wprs_before .= '<meta content="'.$template['fileSize'].'" itemprop="fileSize">';
					$wprs_before .= '<meta content="'.$template['requirements'].'" itemprop="requirements">';
					$wprs_before .= '<meta content="'.$template['softwareHelp'].'" itemprop="softwareHelp">';
					$wprs_before .= '<meta content="'.$template['releaseNotes'].'" itemprop="releaseNotes">';
					$wprs_before .= '<meta content="'.$template['screenshot'].'" itemprop="screenshot">';
					$wprs_before .= '<div itemprop="review" itemscope itemtype="'.wprs_schema_path().'Review">';
					$reviewBody_before = '';
					$reviewBody_after = '';
					$wprs_after = '</div></div>';
					
					if ($template['review_type'] == 'votes' || $template['review_type'] == 'aggregate') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
						$wprs_before .= '<meta content="'.$template['operatingSystem'].'" itemprop="operatingSystem">';
						$wprs_before .= '<meta content="'.$template['applicationCategory'].'" itemprop="applicationCategory">';
						$wprs_before .= '<meta content="'.$template['softwareVersion'].'" itemprop="softwareVersion">';
						$wprs_before .= '<meta content="'.$template['fileFormat'].'" itemprop="fileFormat">';
						$wprs_before .= '<meta content="'.$template['fileSize'].'" itemprop="fileSize">';
						$wprs_before .= '<meta content="'.$template['requirements'].'" itemprop="requirements">';
						$wprs_before .= '<meta content="'.$template['softwareHelp'].'" itemprop="softwareHelp">';
						$wprs_before .= '<meta content="'.$template['releaseNotes'].'" itemprop="releaseNotes">';
						$wprs_before .= '<meta content="'.$template['screenshot'].'" itemprop="screenshot">';
						$wprs_after = '</div>';
					}
					
					if ($template['review_type'] == 'none') {
						$wprs_before = '<div itemscope="itemscope" itemtype="' . $schema . $type . '">';
						$wprs_before .= '<meta content="'.$template['item_name'].'" itemprop="name">';
						$wprs_before .= '<meta content="'.$template['operatingSystem'].'" itemprop="operatingSystem">';
						$wprs_before .= '<meta content="'.$template['applicationCategory'].'" itemprop="applicationCategory">';
						$wprs_before .= '<meta content="'.$template['softwareVersion'].'" itemprop="softwareVersion">';
						$wprs_before .= '<meta content="'.$template['fileFormat'].'" itemprop="fileFormat">';
						$wprs_before .= '<meta content="'.$template['fileSize'].'" itemprop="fileSize">';
						$wprs_before .= '<meta content="'.$template['requirements'].'" itemprop="requirements">';
						$wprs_before .= '<meta content="'.$template['softwareHelp'].'" itemprop="softwareHelp">';
						$wprs_before .= '<meta content="'.$template['releaseNotes'].'" itemprop="releaseNotes">';
						$wprs_before .= '<meta content="'.$template['screenshot'].'" itemprop="screenshot">';
						$wprs_after = '</div>';
					}
					break;
				
			}
			
			// Check if WooCommerce is active and has been used on entry
			// Turn off schema
			// @since 1.3.6
			if ( class_exists( 'WooCommerce' ) ) {
				// If on a page which uses WooCommerce templates
				if ( is_woocommerce() ) {
					$wprs_before = '';
					$wprs_after = '';
				}
			}
					
			// Add filters	
			$entry_before = '';
			$entry_before = apply_filters( 'wprs_entry_before', '');
			$entry_after = '';
			$entry_after = apply_filters( 'wprs_entry_after', '' );
			$content_before = '';
			$content_before = apply_filters( 'wprs_content_before', '');
			$content_after = '';
			$content_after = apply_filters( 'wprs_content_after', '' );
			
			// Final content output
			// Decide where to display the Box
			if ( isset($options['wprs_chk_display_box_below_content']) != '' || isset($meta[$wprs_prefix.'display_box_below_content']) != '' ) {
				$content = $wprs_before
								. $reviewBody_before 
									. $entry_before 
										. $content_before 
											. $content 
										. $content_after 
										. $box 
									.$entry_after
								. $reviewBody_after 
							.  $wprs_after;
			} else {
				$content = $wprs_before 
								. $entry_before 
									. $box 
									. $reviewBody_before 
										.  $content_before 
											. $content 
										. $content_after 
									. $reviewBody_after 
								. $entry_after 
							. $wprs_after;
			}
			
		}
	
		// Returns the content.
    	return $content;
	}
