<?php
/*
	User aggregate template
 
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


function wprs_list_comment($comment, $args, $depth) {
	
	global $wprs_prefix;
	
	$options = get_option('wprs_options');
	
	$GLOBALS['comment'] = $comment;
	
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'div';
		$add_below = 'div-comment';
	}
	
	$post_id = get_the_ID();
	$comment_id = $comment->comment_ID;
	
	// Get SoftwareApplication details to complete the markup
	// @since 1.2.1
	$software_operatingSystem = get_post_meta( $post_id, '_wprs_post_operatingSystem', true );
	$software_applicationCategory = get_post_meta( $post_id, '_wprs_post_applicationCategory', true );
	
	$content = '<div class="wprs_user_reviews" itemprop="review" itemscope itemtype="'.wprs_schema_path().'Review">';
	
	// Add itemReviewed
	// @since 1.1
	$snippets_types = get_post_meta( $post_id, '_wprs_post_snippets_types', true );
	$item_name = get_post_meta( $post_id, '_wprs_post_item_name', true );
	
	// Avoid on Recipe
	// This should be added to all schema type excpet Recipe
	// @since 1.3.7
	if ( $snippets_types != "Recipe" ) {
		
		$content .= '<span itemprop="itemReviewed" itemscope itemtype="'.wprs_schema_path().$snippets_types.'">';
		$content .= '<meta itemprop="name" content="'.$item_name.'">';
	}
		// For SoftwareApplication
		// @since 1.3.6
		if ( $snippets_types == "SoftwareApplication" ) {
			$content .= '<meta itemprop="operatingSystem" content="'.$software_operatingSystem.'">';
			$content .= '<meta itemprop="applicationCategory" content="'.$software_applicationCategory.'">';
		}
	$content .= '</span>';
	
	//$software = get_post_meta( $post_id, '_wprs_post_applicationCategory', true );
	
				// get gravatar
				$gravatar_img ='';
				if( !isset($options['wprs_chk_user_avatar_hide'])) {
					if ( !isset($options['wprs_chk_wp_avatars']) !='' ) {
						$gravatar_hash = md5( strtolower( trim( $comment->comment_author_email ) ) );
						$gravatar_img = '<img itemprop="image" class="avatar avatar-60 photo" src="http://www.gravatar.com/avatar/'.$gravatar_hash.'?d=mm&r=g" alt="'.get_comment_author($comment_id).'" width="60" height="60" />';
					} else {
						$gravatar_img = get_avatar( $comment->comment_author_email, 60, '', get_comment_author($comment_id) ) ;	
					}
				}
				
				$content .= '<div class="col-sm-4 wprs_user_reviews_info_block">';
				$content .= '<div class="wprs_user_reviews_info_block_inside">';
				$content .= $gravatar_img;
				// get star rating
				$userrating = get_comment_meta( $comment_id , 'rating', true );
					
				$content .='<div class="wprs_user_rating" itemprop="reviewRating" itemscope itemtype="'.wprs_schema_path().'Rating">';
						
						$content .= do_action( 'wprs_user_review_inside_before');
						
						$content .= '<div class="clr"></div>';
      					$content .= '<span class="sr-only">'. __('Rating', 'wprs') .': ' .$userrating.'</span>';
						$content .= '<span class="wprs_rating rating-user r-'.$userrating.'" title="'. __('Rating', 'wprs') .': ' . $userrating . '"></span>';
						$content .= '<br />';
						$content .= '<meta itemprop="worstRating" content="1">';
						$content .= '<span itemprop="ratingValue">'.$userrating.'</span> /';
						$content .= '<span itemprop="bestRating">5</span> stars';
						$content .= '<div class="clr"></div>';
				$content .= '</div>';
				
				
				
				$content .= '<div class="clr"><br /></div>';
				
				// get criteria
				if ( !isset($options['wprs_chk_user_criteria_to_author_display']) !='' ) {
					$content .= wprs_get_criteria_single($post_id, $comment_id);
				}
				
				$content .= '<div class="clr"></div>';
				$content .= '</div>';
				
				$content .= '</div>';
	
				$content .= '<div class="col-sm-8 wprs_user_reviews_info_block">';
				$content .= '<div class="wprs_user_reviews_info_block_inside">';
					
					$headline = get_comment_meta( $comment_id , 'wprs_headline', true );
					$content .= '<h4><span itemprop="name">'.$headline.'</span></h4>';
					
					$content .= '<span itemprop="author">' . wprs_comment_author_profile_link($comment_id, $comment->user_id) . '</span>';
					$content .= '<meta itemprop="datePublished" content="'.$comment->comment_date.'">';
					$content .= ' <span class="date">'.__('on', 'wprs').' '.$comment->comment_date.'</span>';
					
					if ( current_user_can( 'edit_comment', $comment_id ) )
						$content .= ' <a class="wprs-comment-edit-link" href="'.get_edit_comment_link($comment_id).'" rel="nofollow">'. __( 'Edit', 'wprs' ).'</a>';					
						
					
					// filter before user review content
					$content .= apply_filters( 'wprs_user_review_content_before', '');
					
					//$content .= '<p><span itemprop="description">' . wpautop($comment->comment_content) . '</span></p>';
					$content .= '<div itemprop="description">' . wpautop($comment->comment_content) . '</div>';
					
					// filter after user review content
					$content .= apply_filters( 'wprs_user_review_content_after', '');
					
				$content .= '</div>';
				$content .= '</div>';
				
				/*
				$content .= '<div class="reply">';
				$content .= get_comment_reply_link( array_merge( $args, array( 
																				'add_below' => $add_below,
																				'depth'		=> $depth,
																				'max_depth' => $args['max_depth']
																				) ) );
				$content .='</div>';
				*/
				
				$content .= '<div class="clr"></div>';
				
				// after single review hook
				$content .= apply_filters( 'wprs_user_review_after', '');
				$content .= '<br /><hr />';
			
			$content .= '</div>';
			$content .= '<div class="clr"></div>';
			
			echo $content;
			
			// debug
			//echo '<pre>';
			//print_r($options);
			//echo '</pre>';
}

