<?php
	/* 
	user rating custom column preview
	@since 2.0.0.0
	*************************/

	// filters
	add_filter( 'manage_edit-comments_columns', 'wprs_userrating_comment_columns' );
	add_filter( 'manage_comments_custom_column', 'wprs_userrating_comment_column', 10, 2 );

	function wprs_userrating_comment_columns( $columns ) {
		// check if user rating system is enabled
		$options = get_option('wprs_options');
		if (isset($options['wprs_chk_user_rating_enable']) != '') {
			$columns['userrating'] = __( 'Rating' );
		}
		return $columns;
	}
	
	function wprs_userrating_comment_column( $column, $comment_ID ) {
		// check if user rating system is enabled
		$options = get_option('wprs_options');
		if (!isset($options['wprs_chk_user_rating_enable']) != '') return;
		if ( 'userrating' == $column ) {
			//echo 'Custom Data for ID: ' . $comment_ID;
			if ( $meta = get_comment_meta( $comment_ID, $column , true ) ) {
				//echo '<br />'.$meta;
				$rating_display = round($meta * 2) / 2;
				$rating_display = str_replace('.', '', $rating_display);
				$output = '<div class="wprs_rating rating-user r-'.$rating_display.'" title="Rated ' . $meta . '"></div>';
				echo $output;
			}	
		}
	}	
