<?php
/*
	Vote script functions
	
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
    */
	
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	/*
    	Vote scripts by post ID
		@since 1.3
    	*/
	function wprs_vote_rating_scripts_by_id( $post_id = null, $already_vote = null, $path = '') {
		
		if ($already_vote) {
			
		?>
		<script type="text/javascript">
			
			jQuery(document).ready(function($) {
				
				$.fn.raty.defaults.path = '<?php echo $path; ?>';
				$.fn.raty.defaults.cancel = false;
				$.fn.raty.defaults.cancelHint = 'Cancel this rating!';
				$.fn.raty.defaults.half = true;
				$.fn.raty.defaults.size = 16;
				$.fn.raty.defaults.space = false;
				$.fn.raty.defaults.hints = ['Bad', 'Poor', 'Good', 'Outstanding', 'Spectacular'];
			
				$('.wprs_rating_star_class_<?php echo $post_id; ?>').raty({
					path		: '<?php echo $path; ?>/stars-blue',
					target		: '#wprs_rating_star_hint_<?php echo $post_id; ?>',
					targetFormat: '{score} Stars!',
					targetType	: 'number',
					targetKeep	: true,
					readOnly	: true,
					score		: <?php echo $already_vote ?>,
					scoreName: function(){
                    				return $(this).attr('class');
                				}
				});
			});
		
        </script>
		<?php
		
		} else {
	
		?>
		<script type="text/javascript">
			
			var wprs26789_data = {
				action: 'wprs_rate_action',
				post_id: '<?php echo absint( $post_id ); ?>',
				nonce: '<?php echo wp_create_nonce( 'wprs_rate_nonce' ); ?>',
			}
			
			jQuery(document).ready(function($) {
				
				$.fn.raty.defaults.path = '<?php echo $path; ?>';
				$.fn.raty.defaults.cancel = false;
				$.fn.raty.defaults.cancelHint = 'Cancel this rating!';
				$.fn.raty.defaults.half = true;
				$.fn.raty.defaults.size = 16;
				$.fn.raty.defaults.space = false;
				$.fn.raty.defaults.hints = ['Bad', 'Poor', 'Good', 'Outstanding', 'Spectacular'];
				
			$('.wprs_rating_star_class_<?php echo $post_id; ?>').each(function(){
    				var tid = $(this).attr('rel'); 
   				 $(this).raty({
					path		: '<?php echo $path; ?>/stars-blue',
					//target		: '#wprs_rating_star_hint_<?php echo $post_id; ?>',
					
					//targetFormat: '{score} Stars!',
					//targetType	: 'number',
					//targetKeep	: true,
					readOnly	: false,
					score		: function() {
									return $(this).attr('data-score');
								},
			
					scoreName: function(){
                    				return $(this).attr('class');
                				},
					
					click 		: function(score, evt) {
									
									var wprs26789_data = {
										action: 'wprs_rate_action',
										post_id: '<?php echo absint( $post_id ); ?>',
										nonce: '<?php echo wp_create_nonce( 'wprs_rate_nonce' ); ?>',
										score: score
									}
									
									$( 'span#wprs_user_rating_wait_<?php echo $post_id; ?>' ).html( '<span class="fa fa-refresh fa-spin"></span>' );
			
            						$.get( 
										'<?php echo site_url( 'wp-admin/admin-ajax.php' ); ?>', 
										wprs26789_data, 
										function( data ){
											if( '-1' != data ) {
												$( 'span#wprs_user_rating_success_<?php echo $post_id; ?>' ).html( '<span class="fa fa-check"></span> Thanks!' );
												$( 'span#wprs_user_rating_wait_<?php echo $post_id; ?>' ).html( '' );
												$( 'span#wprs_user_rating_count_<?php echo $post_id; ?>' ).html( '<span><?php echo wprs_get_user_rating_counter($post_id); ?></span>' );
											}
										}
									);
									
									// reset
									$('.wprs_rating_star_class_<?php echo $post_id; ?>').raty('set', {
										readOnly	: true,
										score		: score,
									});
									
        						}
				});
				});
				
			});
		
        </script>
		<?php
		
		}
	}
		

	/*
    	Vote scripts 
		@since 1.3
    	*/
	function wprs_vote_rating_scripts( $post_id = null, $already_vote = null, $path = '') {
		
		if ($already_vote) {
			
			?>
		<script type="text/javascript">
			
			jQuery(document).ready(function($) {
				
				$.fn.raty.defaults.path = '<?php echo $path; ?>';
				$.fn.raty.defaults.cancel = false;
				$.fn.raty.defaults.cancelHint = 'Cancel this rating!';
				$.fn.raty.defaults.half = true;
				$.fn.raty.defaults.size = 16;
				$.fn.raty.defaults.space = false;
				$.fn.raty.defaults.hints = ['Bad', 'Poor', 'Good', 'Outstanding', 'Spectacular'];
			
				$("span[class^=wprs_rating_star_class_]").raty({
					path		: '<?php echo $path; ?>/stars-blue',
					//target		: '#wprs_rating_star_hint_<?php echo $post_id; ?>',
					//targetFormat: '{score} Stars!',
					//targetType	: 'number',
					//targetKeep	: true,
					readOnly	: true,
					score		: <?php echo $already_vote ?>,
	
					scoreName: function(){
                    				return $(this).attr('class');
                				}
				});
			});
		
        </script>
		<?php
		
		} else {
	
		?>
		<script type="text/javascript">
			
			var wprs26789_data = {
				action: 'wprs_rate_action',
				post_id: '<?php echo absint( $post_id ); ?>',
				nonce: '<?php echo wp_create_nonce( 'wprs_rate_nonce' ); ?>',
			}
			
			jQuery(document).ready(function($) {
				
				$.fn.raty.defaults.path = '<?php echo $path; ?>';
				$.fn.raty.defaults.cancel = false;
				$.fn.raty.defaults.cancelHint = 'Cancel this rating!';
				$.fn.raty.defaults.half = true;
				$.fn.raty.defaults.size = 16;
				$.fn.raty.defaults.space = false;
				$.fn.raty.defaults.hints = ['Bad', 'Poor', 'Good', 'Outstanding', 'Spectacular'];
				
				$('span[class^="wprs_rating_star_class_"]').each(function(){
    				var tid = $(this).attr('rel'); 
   				 $(this).raty({
					path		: '<?php echo $path; ?>/stars-blue',
					//target		: '#wprs_rating_star_hint_<?php echo $post_id; ?>',
					
					//targetFormat: '{score} Stars!',
					//targetType	: 'number',
					//targetKeep	: true,
					readOnly	: false,
					score		: function() {
									return $(this).attr('data-score');
								},
					
					scoreName: function(){
                    				return $(this).attr('id');
                				},
					
					click 		: function(score, evt) {
									
									var wprs26789_data = {
										action: 'wprs_rate_action',
										post_id: '<?php echo absint( $post_id ); ?>',
										nonce: '<?php echo wp_create_nonce( 'wprs_rate_nonce' ); ?>',
										score: score
									}
									
									$( 'span#wprs_user_rating_wait_<?php echo $post_id; ?>' ).html( '<span class="fa fa-refresh fa-spin"></span>' );
			
            						$.get( 
										'<?php echo site_url( 'wp-admin/admin-ajax.php' ); ?>', 
										wprs26789_data, 
										function( data ){
											if( '-1' != data ) {
												$( 'span#wprs_user_rating_success_<?php echo $post_id; ?>' ).html( '<span class="fa fa-check"></span> Thanks!' );
												$( 'span#wprs_user_rating_wait_<?php echo $post_id; ?>' ).html( '' );
												$( 'span#wprs_user_rating_count_<?php echo $post_id; ?>' ).html( '<span><?php echo wprs_get_user_rating_counter($post_id); ?></span>' );
											}
										}
									);
									
									// reset
									$('.wprs_rating_star_class_<?php echo $post_id; ?>').raty('set', {
										readOnly	: true,
										score		: score,
									});
									
        						}
				});
				});
				
			});
		
        </script>
		<?php
		}
	}
		
