<?php
/*
	User rating stars vote functions
	
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
    */
	
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


	/*
    	Return user rating stars
		@since 1.0.0
    	*/
	function wprs_get_user_rating_stars( $post_id = null) {
		
		global $post, $wprs_prefix;
		
		if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
		
		$count = get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true );
		$rating = get_post_meta( $post_id, $wprs_prefix.'user_rating', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating', true ) : 0;
		$rating = 0;
		$id = 'wprs_user_rating_stars_'.$post_id;
		$class = 'wprs_rating_star_class_'.$post_id;
		$hint = 'wprs_rating_star_hint_'.$post_id;
		$content = '';
		
		$content .= '<div>';
		$content .= '<span id="wprs_user_rating_wait_'.$post_id.'" style="float: left; margin-right: 5px; display: block;"></span>';
		$content .= '<span class="wprs_user_rating_stars">';
		$content .= '<span id="'.$id .'" class="'.$class.'" rel="'.$hint.'" data-score="'.$rating.'"></span>';		
		$content .= '</span>';
		$content .= '</div>';
		
		//$content .= '<span id="'.$hint.'" class="'.$hint.'"></span>';
		$content .= '<br>';
		$content .= '<span id="wprs_user_rating_success_'.$post_id.'" class="wprs_user_rating_success"></span>';
		
		return $content;
		
	}
	
	
	add_action( 'wp_enqueue_scripts', 'wprs_user_rating_scripts', 5 );
	/*
    	Load user rating scripts and styles
		@since 1.0.0
    	*/
	function wprs_user_rating_scripts() {
		
		global $post;
		
		if ( is_admin() ) return;
		if ( !is_singular() ) return;
		if ( is_archive() ) return;
		if ( is_404() ) return;
		
		// Check for WooCommerce
		// @since 1.4.1
		if ( ! class_exists( 'WPRS_WOO' ) ) {
			if ( class_exists( 'WooCommerce' ) ) {
				if ( function_exists( 'is_product') ) {
					if ( is_product() ) return;
				}
			}
		}
		// End of WooCommerce check
		
		if (!wprs_is_enabled($post->ID)) return;

		if (wprs_get_type() != 'votes') return;
			
		// Register scripts
		wp_register_script(	'wprs-raty', WPRS_JS_URL.'user-rating/jquery.raty-fa.js');

		// Enqueue the script
		wp_enqueue_script('jquery');
		wp_enqueue_script( 'wprs-raty' );

	}
	
	
	add_action('wp_footer','wprs_user_rating_raty_scripts');
	/*
    	Add raty to the footer
		@since 1.0.0
    	*/
	function wprs_user_rating_raty_scripts() {
		
		global $post, $wprs_prefix;
		
		if (is_admin()) return;
		
		// Check for WooCommerce
		// @since 1.4.1
		if ( ! class_exists( 'WPRS_WOO' ) ) {
			if ( class_exists( 'WooCommerce' ) ) {
				if ( function_exists( 'is_product') ) {
					if ( is_product() ) return;
				}
			}
		}
		// End of WooCommerce check
		
		$path = plugins_url( '')  . '/wp-rich-snippets/assets/images/raty';
		
		// Get shortcode attributes out of post content
		// @since 1.3
		$out = wprs_get_shortcode_attributes( $post->ID, 'wprs-element');
		
		if ( ! empty($out)) {
			$vote_active_posts[] = array();
			foreach ($out as $attribute) {

				if( wprs_get_type_by_id($attribute['id']) == 'votes' ) {
					
					$post_id = $attribute['id'];
					
					$already_vote = wprs_user_already_voted($post_id);
			
					// Get the raty scripts by id
					wprs_vote_rating_scripts_by_id($post_id, $already_vote, $path);
						
				}	
			}
			
		} else {
			
			if (!wprs_is_enabled($post->ID)) return;

			if (wprs_get_type() != 'votes') return;
		
			$meta = wprs_get_meta();
			$slider_percentage = isset($meta[$wprs_prefix.'slider_percentage']) ? $meta[$wprs_prefix.'slider_percentage'] : 1;
		
			if( ! is_singular() ) return;
		
			$post_id = get_queried_object_id();

			$already_vote = wprs_user_already_voted($post_id);
		
			// Get the raty scripts
			wprs_vote_rating_scripts($post_id, $already_vote, $path);
		
		
		}
	}
	


///////////////////////////
//////////////////////////

add_action( 'wp_ajax_nopriv_wprs_rate_action', 'wprs_rate_ajax_cb' );
add_action( 'wp_ajax_wprs_rate_action', 'wprs_rate_ajax_cb' );
function wprs_rate_ajax_cb() {
	
	global $wprs_prefix;
	
	// Verify the nonce to make sure the request came from an actual page...
	if( !isset( $_REQUEST['nonce'] ) || ! wp_verify_nonce( $_REQUEST['nonce'], 'wprs_rate_nonce' ) ) die( '-1' );
	
	$post_id = isset( $_REQUEST['post_id'] ) ? absint( $_REQUEST['post_id'] ) : 0;
	$rating = isset( $_REQUEST['score'] ) ? $_REQUEST['score'] : 0;
	
	if( ! $post_id ) die( '-1' );
	
	// Check & update IP
	if (!wprs_user_vote_update_ip ($post_id, $rating)) die();
	
	$rating_all = get_post_meta( $post_id, $wprs_prefix.'user_rating_all', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating_all', true ) : 0;
	
	$counter = get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true );
	$counter = absint( $counter );
	
	if( $counter )
	{
		$counter++;
	}
	else
	{
		$counter = 1;
	}
	
	wprs_user_vote_array_update($post_id, $rating);
	
	$rating_new = $rating_all + $rating;
	$rating = round($rating_new / $counter, 1);
	
	update_post_meta( $post_id, $wprs_prefix.'user_rating_count', $counter );
	update_post_meta( $post_id, $wprs_prefix.'user_rating_all', $rating_new );
	update_post_meta( $post_id, $wprs_prefix.'user_rating', $rating );
	
	
		
	die();
}

	
	
	function wprs_user_already_voted($post_id) {
		
		global $wprs_prefix;
		
		// Check IP
		$ip = wprs_get_ip();
		$ips = array();
		$ips = get_post_meta( $post_id, $wprs_prefix.'user_rating_ips', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating_ips', true ) : array();
		
		if (empty($ips)) return false;
		
		//if (in_array($ip, $ips)) {
		if (array_key_exists($ip, $ips)) {
			$rating = $ips[$ip];
			return $rating;
		}
		return false;
		
	}
	
	function wprs_user_vote_update_ip ($post_id, $rating) {
		
		global $wprs_prefix;
		
		// Check IP
		$ip = wprs_get_ip();
		$ips = array();
		$ips = get_post_meta( $post_id, $wprs_prefix.'user_rating_ips', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating_ips', true ) : array();
		
		if ( empty($ips) || !in_array($ip, $ips) ) {
			$ips[$ip] = $rating;
			update_post_meta( $post_id, $wprs_prefix.'user_rating_ips', $ips );
			return true;
		}
		return false;
	}

	
	function wprs_get_user_rating_counter($post_id) {
		global $wprs_prefix;
		$counter = get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true ) : 0;
		return intval($counter) + 1;
	}
	

	/*
    	Update user rating array
		@since 1.3.4
    	*/
	function wprs_user_vote_array_update($postid, $userrating) {
		
		global $wprs_prefix;
		
		$userrating = intval($userrating);
		$ratings = array();
		
		if (get_post_meta($postid, $wprs_prefix.'user_rating_array', true)) {
			$ratings = get_post_meta($postid, $wprs_prefix.'user_rating_array', true);
		} else {
			$ratings = array(
						5	=>	0,
						4	=>	0,
						3	=>	0,
						2	=>	0,
						1	=>	0
					);
		}
	
		$ratings[$userrating] = $ratings[$userrating] + 1;
		
		update_post_meta($postid, $wprs_prefix.'user_rating_array', $ratings);
		
		// Debug
		// echo '<pre>';
		// var_dump($ratings);
		// echo '</pre>';
		
	}
	

/*
    	Get user votes array display
		@since 1.3.4
    	*/
	function wprs_get_user_vote_array_display($postid) {
		
		global $wprs_prefix;
		
		if (get_post_meta($postid, $wprs_prefix.'user_rating_array', true)) {
			$ratings = get_post_meta($postid, $wprs_prefix.'user_rating_array', true);
		} else {
			$ratings = null;
		}
		
		if (!$ratings) return '';
		
		$count = get_post_meta($postid, $wprs_prefix.'user_rating_count', true);
		
		//$permalink = get_permalink( $postid ) . '#reviews';
		
		$content = '';
		
		if ($count == 0) return;
		
		$content .= '<div id="wprs_square">';
		
		foreach(  $ratings as $k => $v ) {
			
			$p = ($v / $count) * 100;
			$p = round($p * 2) / 2 ;
			
			//$content .= '<div class="wprs_container">';			
			$content .= '<div class="wprs_user_votes_wrap" style="text-align:center;">';
			//$content .= '<div>';
			//$content .= '<a href="' . add_query_arg( 'filter', $k, $permalink ).'">';
			
			$content .= '<div class="col-xs-4">';
			$content .= '<span>' . $k . ' ' . __( 'stars', 'wprs' ) . '</span>';
			$content .= '</div>';
			
			$content .= '<div class="col-xs-6">';
			$content .= '<div class="progress">';
			$content .= '<div class="progress-bar progress-bar-info" role="progressbar" title="'.$p.'%" aria-valuenow="'.$p.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$p.'%">';
			$content .= '<span class="sr-only">User: '.$p.'%</span>';
			$content .= '<div class="bar" style="width: '.$p.'%;"></div>';
			$content .= '</div>';
			$content .= '</div>';
			$content .= '</div>';
			
			$content .= '<div class="col-xs-2">';
			$content .= '<span class="wprs_ml_5">' . $v . '</span>';
			$content .= '</div>';
			
			//$content .= '</a>';
			$content .= '</div>';
			
		}
		
		$content .= '</div>';
		
		return $content;
		
	}