<?php
/*

 WPRS Widget - Rich Snippets Entries
 
 WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
 this file under any circumstances.
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



function WPRS_Widget_Register() {
    register_widget( 'WPRS_Widget' );
}
add_action( 'widgets_init', 'WPRS_Widget_Register' );


	
class WPRS_Widget extends WP_Widget {

    function __construct() {
        $widget_ops = array('classname' => 'widget_wprs', 'description' => __( 'Display WPRichSnippets reviews', 'wprs') );
        parent::__construct('wprs-widget', __('Reviews', 'wprs'), $widget_ops);
        $this->alt_option_name = 'widget_wprs';

        add_action( 'save_post', array($this, 'flush_widget_cache') );
        add_action( 'deleted_post', array($this, 'flush_widget_cache') );
        add_action( 'switch_theme', array($this, 'flush_widget_cache') );
    }

    function widget($args, $instance) {
        
		global $post, $wprs_prefix;
		
		$cache = wp_cache_get('wprs_widget_posts', 'widget');

        if ( !is_array($cache) )
            $cache = array();

        if ( ! isset( $args['widget_id'] ) )
            $args['widget_id'] = $this->id;

        if ( isset( $cache[ $args['widget_id'] ] ) ) {
            echo $cache[ $args['widget_id'] ];
            return;
        }
		
		ob_start();
        extract($args);
		
		$html				= '';
		
        $title 				= ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Reviews', 'wprs' );
        $title 				= apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$before_title 		= ( ! empty( $instance['before_title'] ) ) ? $instance['before_title'] : '';
		$after_title 		= ( ! empty( $instance['after_title'] ) ) ? $instance['after_title'] : '';
		
		$ptype 				= ( isset($instance['ptype']) ) ? $instance['ptype'] : 'post';
		$cat 				= ( isset($instance['cat']) ) ? $instance['cat'] : '';
		$review_type		= ( isset($instance['review_type']) ) ? $instance['review_type'] : 'rating';
		$number 			= ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		$order 				= ( isset($instance['order']) ) ? 'meta_value_num' : 'date';
		$excerpt			= ( isset($instance['excerpt']) ) ? true	 : false;
		$length				= ( isset($instance['length']) ) ? $instance['length'] : 10;
		$readmore			= ( isset($instance['readmore']) ) ? true	 : false;
		$thumb				= ( isset($instance['thumb']) ) ? true	 : false;
		$thumb_width		= ( isset($instance['thumb_width']) ) ? $instance['thumb_width'] : 45;
		$thumb_height		= ( isset($instance['thumb_height']) ) ? $instance['thumb_height'] : 45;
		$thumb_align		= ( isset($instance['thumb_align']) ) ? $instance['thumb_align'] : 'wprs-widget-alignleft';
		$thumb_default		= ( isset($instance['thumb_default']) ) ? $instance['thumb_default'] : 'http://placehold.it/45x45/f0f0f0/ccc';
		$style				= ( isset($instance['style']) ) ? $instance['style'] : 'default';
		$exclude_current 	= ( isset($instance['exclude_current']) ) ? $instance['exclude_current'] : false;
		
		switch ( $review_type ) {
			case 'rating'		: $review_type_meta_key = '_wprs_post_star_rating'; break;
			case 'percentage'	: $review_type_meta_key = '_wprs_post_slider_percentage'; break;
			case 'votes'		: $review_type_meta_key = '_wprs_post_user_rating'; break;
			case 'aggregate'	: $review_type_meta_key = '_wprs_post_userrating_average'; break;
		}
		
		// set cat based on category page
		if ( isset($instance['cat_check']) && is_category() ) {
			$catName = single_cat_title("",false);
			$catID = get_cat_ID($catName);
			$cat = $catID;
		}
		
		// show on widget when view post, if enabled
		// @since 1.6.4
		$this_post_id  = array();
		if ( ! empty( $instance['exclude_current'] ) ) {
			$this_post_id = (isset($post->ID)) ? array( $post->ID ) : array();
		}
		
		$posts = new WP_Query(array(	
									'post_type' => $ptype,
									'posts_per_page' =>	$number,
									'no_found_rows' => true,
									'cat' => $cat,
									'post_status' => 'publish',
									'meta_key'=> $review_type_meta_key,
									'meta_query' => array( array( 'key' => '_wprs_post_review_type', 'value' => $review_type ) ),
									'post__not_in' => $this_post_id, 
									'ignore_sticky_posts' => true,
									'orderby'=> $order,
									'order'=> 'DESC',
								));
		
        if ($posts->have_posts()) :
?>
		
		<?php wprs_widget_custom_styles(); ?>
		
		<?php echo $args['before_widget']; ?>
		
        <?php 
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}
		?>
		
		<?php
		// wrapper
		$html .= '<div class="wprs-widget-block">';

			$html .= '<ul class="wprs-widget-ul">';

				while ( $posts->have_posts() ) : $posts->the_post();
					
					if ( wprs_is_enabled( get_the_ID() ) ) {
					
						$template = wprs_template( get_the_ID() );
						
						// look for video thumb
						$embed_attachment_id = get_post_meta( get_the_ID(), '_wprs_post_embed_attachment_id', true );
						$wprs_img_url 		 = get_post_meta( get_the_ID(), '_wprs_post_image', true );
						$wprs_img_url 		 = $template['img_url'];
						
						if ( isset($embed_attachment_id) && $embed_attachment_id != '' ) {
							
							$img_url = wp_get_attachment_url( $embed_attachment_id );
						
						} elseif ( isset($wprs_img_url) && $wprs_img_url !='' ) {
							//WPRS Image
							$img_url = $wprs_img_url;
						} else {
							// Thumbnails
							$thumb_id = get_post_thumbnail_id(); // Get the featured image id.
							$img_url  = wp_get_attachment_url( $thumb_id, 'full' ); // Get img URL.
						}
						
						// Display the image url and crop using the resizer.
						$crop 	= true; // resize but retain proportions
						$single = true; // false return single url, true return an array
						$image  = (isset($img_url) && $img_url !='' ) ? wprs_image_resize( $img_url, (int)$thumb_width, (int)$thumb_height, $crop, $single ) : false;
						//echo '<br><br>'.$image;
						
						
					// Start recent posts markup.
					$html .= '<li class="wprs-widget-li wprs-widget-clearfix">';

						if ( $thumb && $image) :
							
							// Check if post has embed video, get thumbnail.
							if ( $embed_attachment_id ) :
								$html .= '<a class="wprs-widget-img" href="' . esc_url( get_permalink() ) . '"  rel="bookmark">';
									if ( $image ) :
										$html .= '<img class="' . esc_attr( $thumb_align ) . ' wprs-widget-thumb" src="' . esc_url( $image ) . '" alt="' . esc_attr( get_the_title() ) . '" width="'.(int) $thumb_width.'" height="'.(int) $thumb_height.'">';
									
									endif;
								$html .= '</a>';
								
							// Check if post has WPRS image url, get thumbnail.
							elseif ( $wprs_img_url && ! $embed_attachment_id ) :
								$html .= '<a class="wprs-widget-img" href="' . esc_url( get_permalink() ) . '"  rel="bookmark">';
									if ( $image ) :
										$html .= '<img class="' . esc_attr( $thumb_align ) . ' wprs-widget-thumb" src="' . esc_url( $image ) . '" alt="' . esc_attr( get_the_title() ) . '" width="'.(int) $thumb_width.'" height="'.(int) $thumb_height.'">';
									
									endif;
								$html .= '</a>';

							// Check if post has post thumbnail.
							elseif ( has_post_thumbnail() ) :
								$html .= '<a class="wprs-widget-img" href="' . esc_url( get_permalink() ) . '"  rel="bookmark">';
									if ( $image ) :
										$html .= '<img class="' . esc_attr( $thumb_align ) . ' wprs-widget-thumb" src="' . esc_url( $image ) . '" alt="' . esc_attr( get_the_title() ) . '" width="'.(int) $thumb_width.'" height="'.(int) $thumb_height.'">';
									else :
										$html .= get_the_post_thumbnail( get_the_ID(),
											array( $thumb_width, $thumb_height ),
											array(
												'class' => $thumb_align . ' wprs-widget-thumb the-post-thumbnail',
												'alt'   => esc_attr( get_the_title() )
											)
										);
									endif;
								$html .= '</a>';

							// If no post thumbnail found, check if Get The Image plugin exist and display the image.
							elseif ( function_exists( 'get_the_image' ) ) :
								$html .= get_the_image( array(
									'height'        => (int) $thumb_height,
									'width'         => (int) $thumb_width,
									'image_class'   => esc_attr( $thumb_align ) . ' wprs-widget-thumb get-the-image',
									'image_scan'    => true,
									'echo'          => false,
									'default_image' => esc_url( $thumb_default )
								) );

							// Display default image.
							elseif ( ! empty( $thumb_default ) ) :
								$html .= sprintf( '<a class="wprs-widget-img" href="%1$s" rel="bookmark"><img class="%2$s wprs-widget-thumb wprs-widget-default-thumb" src="%3$s" alt="%4$s" width="%5$s" height="%6$s"></a>',
									esc_url( get_permalink() ),
									esc_attr( $thumb_align ),
									esc_url( $thumb_default ),
									esc_attr( get_the_title() ),
									(int) $thumb_width,
									(int) $thumb_height
								);

							endif;

						endif;

						$html .= '<h3 class="wprs-widget-title"><a href="' . esc_url( get_permalink() ) . '" title="' . sprintf( esc_attr__( 'Permalink to %s', 'recent-posts-widget-extended' ), the_title_attribute( 'echo=0' ) ) . '" rel="bookmark">' . esc_attr( get_the_title() ) . '</a></h3>';
						
						//$html .= '<span class="wprs_widget_rating">'.wprs_get_display_rating_output( get_the_ID() ) .'</span>';
						$html .= '<span class="wprs_widget_rating">'.wprs_get_display_rating_output( get_the_ID(), $style ) .'</span>';
						
						/*
						if ( $args['date'] ) :
							$date = get_the_date();
							if ( $args['date_relative'] ) :
								$date = sprintf( __( '%s ago', 'recent-posts-widget-extended' ), human_time_diff( get_the_date( 'U' ), current_time( 'timestamp' ) ) );
							endif;
							$html .= '<time class="wprs-widget-time published" datetime="' . esc_html( get_the_date( 'c' ) ) . '">' . esc_html( $date ) . '</time>';
						elseif ( $args['date_modified'] ) : // if both date functions are provided, we use date to be backwards compatible
							$date = get_the_modified_date();
							if ( $args['date_relative'] ) :
								$date = sprintf( __( '%s ago', 'recent-posts-widget-extended' ), human_time_diff( get_the_modified_date( 'U' ), current_time( 'timestamp' ) ) );
							endif;
							$html .= '<time class="wprs-widget-time modfied" datetime="' . esc_html( get_the_modified_date( 'c' ) ) . '">' . esc_html( $date ) . '</time>';
						endif;

						if ( $args['comment_count'] ) :
							if ( get_comments_number() == 0 ) {
									$comments = __( 'No Comments', 'recent-posts-widget-extended' );
								} elseif ( get_comments_number() > 1 ) {
									$comments = sprintf( __( '%s Comments', 'recent-posts-widget-extended' ), get_comments_number() );
								} else {
									$comments = __( '1 Comment', 'recent-posts-widget-extended' );
								}
							$html .= '<a class="wprs-widget-comment comment-count" href="' . get_comments_link() . '">' . $comments . '</a>';
						endif;
						*/
						if ( $excerpt ) :
							
							// Get full content to trim it, to avoid any content filtering
							// @since 1.4.2
							$content_post	 = get_post( get_the_ID() );
							$content_excerpt = $content_post->post_content;
							
							$html .= '<div class="wprs-widget-summary">';
								$html .= wp_trim_words( apply_filters( 'wprs_widget_excerpt', $content_excerpt ), $length, ' &hellip;' );
								if ( $readmore ) :
									$html .= '<a href="' . esc_url( get_permalink() ) . '" class="more-link">' . __('Read more','wprs') . '</a>';
								endif;
							$html .= '</div>';
						endif;
						

					$html .= '</li>';
					}

				endwhile;

			$html .= '</ul>';

		$html .= '</div><!-- Generated by WPRichSnippets plugin - https://wprichsnippets.com -->';
	
		// echo widget output
		echo $html;
		
		echo $args['after_widget'];
		
		// Restore original Post Data.
		wp_reset_postdata();
		
		endif; 
        
		$cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('wprs_widget_posts', $cache, 'widget');
		
    }

   	function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance;
		
		$instance['title']				= strip_tags($new_instance['title']);
		$instance['ptype']				= strip_tags($new_instance['ptype']);
		$instance['review_type']		= $new_instance['review_type'];
		$instance['cat']				= strip_tags($new_instance['cat']);
		$instance['cat_check']			= $new_instance['cat_check'];
		$instance['order']				= $new_instance['order'];
		$instance['number']				= (int) $new_instance['number'];
		$instance['excerpt']			= $new_instance['excerpt'];
		$instance['length']				= $new_instance['length'];
		$instance['readmore']			= $new_instance['readmore'];
		$instance['thumb']				= $new_instance['thumb'];
		$instance['thumb_width']		= $new_instance['thumb_width'];
		$instance['thumb_height']		= $new_instance['thumb_height'];
		$instance['thumb_align']		= $new_instance['thumb_align'];
		$instance['thumb_default']		= $new_instance['thumb_default'];
		$instance['style']				= $new_instance['style'];
		$instance['exclude_current']	= $new_instance['exclude_current'];
		
		$this->flush_widget_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_recent_entries']) )
			delete_option('widget_recent_entries');

		return $instance;
	}

    function flush_widget_cache() {
		
        wp_cache_delete('wprs_widget_posts', 'widget');
    
	}

  	function form( $instance ) {
		
		$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$ptype = isset($instance['ptype']) ? esc_attr($instance['ptype']) : 'post';
		$review_type = isset($instance['review_type']) ? esc_attr($instance['review_type']) : 'rating';
		$cat = isset($instance['cat']) ? esc_attr($instance['cat']) : '';
		$cat_check = isset($instance['cat_check']) ? (bool) $instance['cat_check'] : false;
		$number = isset($instance['number']) ? absint($instance['number']) : 5;
		$order = isset($instance['order']) ? (bool) $instance['order'] : false;
		$excerpt = isset($instance['excerpt']) ? (bool) $instance['excerpt'] : false;
		$length = isset($instance['length']) ? absint($instance['length']) : 10;
		$readmore = isset($instance['readmore']) ? esc_attr($instance['readmore']) : false;
		$thumb = isset($instance['thumb']) ? (bool) $instance['thumb'] : false;
		$thumb_width = isset($instance['thumb_width']) ? absint($instance['thumb_width']) : 45;
		$thumb_height = isset($instance['thumb_height']) ? absint($instance['thumb_height']) : 45;
		$thumb_align = isset($instance['thumb_align']) ? esc_attr($instance['thumb_align']) : 'wprs-widget-alignleft';
		$thumb_default = isset($instance['thumb_default']) ? esc_attr($instance['thumb_default']) : 'http://placehold.it/45x45/f0f0f0/ccc';
		$style = isset($instance['style']) ? esc_attr($instance['style']) : 'default';
		$exclude_current = isset($instance['exclude_current']) ? (bool) $instance['exclude_current'] : false;
		
?>
		<p>
        <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'wprs') .':'; ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        
        <p>
		<label for="<?php echo $this->get_field_id('review_type'); ?>"><select id="<?php echo $this->get_field_id('review_type'); ?>" name="<?php echo $this->get_field_name('review_type'); ?>" >
		<option value=""> - <?php echo __( 'Select Review Type', 'wprs' ); ?> - </option>
		<?php
		// get review type
		$reviews_types = array (
									'rating'		=> 'Rating',
								 	'percentage'	=> 'Percentage',
									'votes'			=> 'Votes',
									'aggregate'		=> 'Aggregate'
								);
		//array ('rating', 'percentage', 'votes', 'aggregate');
		foreach ( (array) $reviews_types as $review_type => $review_type_title ) { ?>
			<option value="<?php echo $review_type; ?>" <?php if (isset($instance['review_type']) && $instance['review_type'] == $review_type) { echo 'selected="selected"'; } ?>><?php echo $review_type_title;?></option>
		<?php } ?>
		</select></label>
		</p>
        
        <p>
        <label for="<?php echo $this->get_field_id('style'); ?>"><select id="<?php echo $this->get_field_id('style'); ?>" name="<?php echo $this->get_field_name('style'); ?>" >
		<option value=""> - <?php echo __( 'Select Review Style', 'wprs' ); ?> - </option>
		<?php
		// get review type
		$reviews_styles = array (
									'default'	=> 'Default',
								 	'mini'		=> 'Mini'
								);
		foreach ( (array) $reviews_styles as $review_style => $review_style_title ) { ?>
			<option value="<?php echo $review_style; ?>" <?php if (isset($instance['style']) && $instance['style'] == $review_style) { echo 'selected="selected"'; } ?>><?php echo $review_style_title;?></option>
		<?php } ?>
		</select></label>
		</p>
        
        <p>
		<label for="<?php echo $this->get_field_id('ptype'); ?>"><select id="<?php echo $this->get_field_id('ptype'); ?>" name="<?php echo $this->get_field_name('ptype'); ?>" >
		<option value=""> - <?php echo __( 'Select Post Type', 'wprs' ); ?> - </option>
		<?php
		// get custom post types
		$post_types = wprs_get_post_types();
		if ( !empty($post_types) ) {
		foreach ( (array) $post_types as $post_type ) { ?>
			<option value="<?php echo $post_type; ?>" <?php if (isset($instance['ptype']) && $instance['ptype'] == $post_type) { echo 'selected="selected"'; } ?>><?php echo $post_type;?></option>
		<?php }	} ?>
		</select></label>
	</p>
		
        <p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'cat' ) ); ?>"></label>
			<?php wp_dropdown_categories( array( 'name' => $this->get_field_name( 'cat' ), 'show_option_all' => '- '. __( 'All categories' , 'wprs' ) .' -', 'hide_empty' => 1, 'hierarchical' => 1, 'selected' => $cat ) ); ?>
		</p>
        
         <p>
       <label for="<?php echo $this->get_field_id('cat_check'); ?>">
 			<input type="checkbox" class="checkbox" <?php checked( $cat_check ); ?> id="<?php echo $this->get_field_id('cat_check'); ?>" name="<?php echo $this->get_field_name('cat_check'); ?>" /><?php _e('Category based?', 'wprs'); ?></label>
		</p>
        
		<p>
        <label for="<?php echo $this->get_field_id('number'); ?>">
		<input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="number" step="1" min="0" value="<?php echo $number; ?>" class="small-input" size="3" /> <?php _e('Number of entries to show', 'wprs') .':'; ?></label>
        </p>
        
                
		<p>
       <label for="<?php echo $this->get_field_id('thumb'); ?>">
 			<input type="checkbox" class="checkbox" <?php checked( $thumb); ?> id="<?php echo $this->get_field_id('thumb'); ?>" name="<?php echo $this->get_field_name('thumb'); ?>" /><?php _e('Display Thumb?', 'wprs'); ?></label>
		</p>
        
        <p>
        <label for="<?php echo $this->get_field_id('thumb_width'); ?>">
		<input id="<?php echo $this->get_field_id('thumb_width'); ?>" name="<?php echo $this->get_field_name('thumb_width'); ?>" type="number" step="1" min="45" value="<?php echo $thumb_width; ?>" class="small-input" size="3" /> <?php _e('Width', 'wprs') .':'; ?></label>
        </p>
        
        <p>
        <label for="<?php echo $this->get_field_id('thumb_height'); ?>">
		<input id="<?php echo $this->get_field_id('thumb_height'); ?>" name="<?php echo $this->get_field_name('thumb_height'); ?>" type="number" step="1" min="45" value="<?php echo $thumb_height; ?>" class="small-input" size="3" /> <?php _e('Height', 'wprs') .':'; ?></label>
        </p>
        
        <p>
        <label for="<?php echo $this->get_field_id('thumb_align'); ?>"><select id="<?php echo $this->get_field_id('thumb_align'); ?>" name="<?php echo $this->get_field_name('thumb_align'); ?>" >
		<option value=""> - <?php echo __( 'Select Thumb Alignment', 'wprs' ); ?> - </option>
		<?php
		// get review type
		$thumbs_alignments = array (
									'wprs-widget-alignleft'		=> 'Left',
								 	'wprs-widget-alignright'	=> 'Right',
									'wprs-widget-aligncenter'	=> 'Center'
									);
		foreach ( (array) $thumbs_alignments as $thumbs_align => $thumbs_align_title ) { ?>
			<option value="<?php echo $thumbs_align; ?>" <?php if (isset($instance['thumb_align']) && $instance['thumb_align'] == $thumbs_align) { echo 'selected="selected"'; } ?>><?php echo $thumbs_align_title;?></option>
		<?php } ?>
		</select></label>
		</p>
        
        <p>
        <label for="<?php echo $this->get_field_id('excerpt'); ?>">
 			<input type="checkbox" class="checkbox" <?php checked($excerpt); ?> id="<?php echo $this->get_field_id('excerpt'); ?>" name="<?php echo $this->get_field_name('excerpt'); ?>" /><?php _e('Display excerpt?', 'wprs'); ?></label>
		</p>
        
        <p>
        <label for="<?php echo $this->get_field_id('length'); ?>">
		<input id="<?php echo $this->get_field_id('length'); ?>" name="<?php echo $this->get_field_name('length'); ?>" type="text" value="<?php echo $length; ?>" size="3" /> <?php _e('Excerpt length', 'wprs') .':'; ?></label>
        </p>
        
        <p>
        <label for="<?php echo $this->get_field_id('readmore'); ?>">
 			<input type="checkbox" class="checkbox" <?php checked($readmore); ?> id="<?php echo $this->get_field_id('readmore'); ?>" name="<?php echo $this->get_field_name('readmore'); ?>" /><?php _e('Display Read more?', 'wprs'); ?></label>
		</p>
        
		<p>
        <label for="<?php echo $this->get_field_id('order'); ?>">
 			<input type="checkbox" class="checkbox" <?php checked($order); ?> id="<?php echo $this->get_field_id('order'); ?>" name="<?php echo $this->get_field_name('order'); ?>" /><?php _e('Order by best rating?', 'wprs'); ?></label>
		</p>
        
        <p>
        <label for="<?php echo $this->get_field_id('exclude_current'); ?>">
 			<input type="checkbox" class="checkbox" <?php checked($exclude_current); ?> id="<?php echo $this->get_field_id('exclude_current'); ?>" name="<?php echo $this->get_field_name('exclude_current'); ?>" /><?php _e('Exclude current review?', 'wprs'); ?></label>
		</p>

<?php
	}
}


/**
 * Custom Styles.
 *
 * @since  0.8
 */
function wprs_widget_custom_styles() {
	?>
<style>
.wprs-widget-block ul{list-style:none!important;margin-left:0!important;padding-left:0!important;}.wprs-widget-block li{border-bottom:1px solid #eee;margin-bottom:10px;padding-bottom:10px;list-style-type: none;}.wprs-widget-block a{display:inline!important;text-decoration:none;}.wprs-widget-block h3{background:none!important;clear:none;margin-bottom:0!important;margin-top:0!important;font-weight:400;font-size:12px!important;line-height:1.5em;}.wprs-widget-thumb{border:1px solid #EEE!important;box-shadow:none!important;margin:2px 10px 2px 0;padding:3px!important;}.wprs-widget-summary{font-size:12px;color:#999;}.wprs-widget-time{color:#bbb;font-size:11px;}.wprs-widget-comment{color:#bbb;font-size:11px;padding-left:5px;}.wprs-widget-alignleft{display:inline;float:left;}.wprs-widget-alignright{display:inline;float:right;}.wprs-widget-aligncenter{display:block;margin-left: auto;margin-right: auto;}.wprs-widget-clearfix:before,.wprs-widget-clearfix:after{content:"";display:table !important;}.wprs-widget-clearfix:after{clear:both;}.wprs-widget-clearfix{zoom:1;}.wprs_widget_rating .wprs_rating_mini{display:inline-block;padding: 2px 4px; font-size:11.844px;font-weight:bold;line-height:14px;color:#ffffff;text-shadow:0 -1px 0 rgba(0, 0, 0, 0.25);white-space:nowrap;vertical-align:baseline;background-color:#999999;-webkit-border-radius:3px;-moz-border-radius:3px;border-radius:3px;}
</style>
	<?php
}
