<?php
/*
	Global filters that is required by the plugin
	
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
    */
	
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	
	add_filter ( 'the_content', 'wprs_schema_content' );
	/*
		filter the main content and display the schema Box output
		@since 1.0.0
		*/
	function wprs_schema_content( $content ) {
		
		global $post;
		
		// make sure the filter do not run on the main query or main loop
		// this will eliminate filtering sidebar content and widgets
		// @since 1.0.0
		if ( ! in_the_loop() || ! is_main_query() ) return $content;
		
		// apply only on singular pages
		//if( ! is_singular() ) return $content;
		
		// if WPRichSnippets is not enable, return content
		if ( ! wprs_is_enabled($post->ID) ) return $content;
		
		// if Box shortcode add-on is active and shortcode is used, return content
		// an integration for the Box shortcode add-on
		if ( isset($GLOBALS['wprs_box_shortcode'] ) && $GLOBALS['wprs_box_shortcode'] == true) return $content;
		
		// apply schema to $content
		$content = wprs_schema($content);
		
		// return the awesome content ;)
		return $content;
		
	}


	add_filter('the_content','wprs_do_pros_and_cons', 1);
	/*
		do cons & pros
		@since 1.0.0
		*/
	function wprs_do_pros_and_cons($content) {
		global $post;
		
		if ( ! is_singular() ) return $content;
	
		//if ( is_main_query() ) return $content;
		if ( is_front_page() || is_home() ) return $content;
		
		if ( is_admin() ) return $content;
		if ( !is_singular() ) return $content;
		if ( is_archive() ) return $content;
		if ( is_404() ) return $content;
		
		$pros = wprs_pros($post->ID);
		$cons = wprs_cons($post->ID);
		return $content . $pros . $cons;
	}


	add_filter('wprs_entry_after', 'wprs_display_user_reviews', 99);
	/*
		display user reviews below content
		@since 1.0.0
		*/
	function wprs_display_user_reviews($content) {
		global $post;
		
		//if ( ! in_the_loop() || ! is_main_query() ) return $content;
		//if ( is_front_page() || is_home() ) return $content;
		
		// Check for WooCommerce
		// @since 1.4.1
		if ( ! class_exists( 'WPRS_WOO' ) ) {
			if ( class_exists( 'WooCommerce' ) ) {
				if ( function_exists( 'is_product') ) {
					if ( is_product() ) return $content;
				}
			}
		}
		// End of WooCommerce check
		
		if (!wprs_is_enabled($post->ID)) return $content;
		if (wprs_get_type() != 'aggregate') return $content;
		$template = wprs_template();
		$content = $content . $template['user_reviews'];
		return $content;	
	}
	
	
	//add_filter('wprs_box_head', 'wprs_display_media');
	/*
		display media
		@since 1.2.1
		*/
	function wprs_display_media($content) {
		global $post;
		if (!wprs_is_enabled($post->ID)) return $content;
		//if (wprs_get_type() != 'aggregate') return $content;
		$template = wprs_template();
		$content = $content . $template['media'];
		return $content;
	}
	
	
	add_filter('wprs_box_media', 'wprs_media_to_imageObject');
	/*
    	Filter media to ImageObject
		this special case is needed on Article Votes.
		@since 1.3.1
    	*/
	function wprs_media_to_imageObject($media_content) {
		
		global $post, $wprs_prefix;
		
		$id = $post->ID;
		
		$ImageObject = '';
		$image_src = '';
		$alt = '';
		
		if (get_post_meta($id, $wprs_prefix.'image', TRUE)) {
			
			$snippets_type = get_post_meta( $id, $wprs_prefix.'snippets_types', TRUE );
			$review_type = get_post_meta( $id, $wprs_prefix.'review_type', TRUE );
			
			//if ( $snippets_type == 'Article' ) {
			
				// Get image url	
				$image_src = stripslashes (get_post_meta( $id, $wprs_prefix.'image', TRUE ));
				
				// Get image alt
				if (get_post_meta($id, $wprs_prefix.'image_alt', TRUE)) {
					$alt = get_post_meta($id, $wprs_prefix.'image_alt', TRUE);
				} else { // If no value, then...
					if (get_post_meta($id, $wprs_prefix.'item_name', TRUE)) {
						$alt = get_post_meta($id, $wprs_prefix.'item_name', TRUE); // Set to review name
					} else {$alt = '';}
				}

				$size = 'full';
				$attachment_id = wprs_get_image_id($image_src);
				$img_srcset = wp_get_attachment_image_srcset( $attachment_id, $size );
				$img_sizes  = wp_get_attachment_image_sizes( $attachment_id, $size );
				$image_data = wp_get_attachment_image_src( $attachment_id, $size );
				$image_width = $image_data[1];
				$image_height = $image_data[2];
		
				$ImageObject .= '<div itemprop="image" itemscope itemtype="https://schema.org/ImageObject">';
				$ImageObject .= '<img src="'.$image_src.'" srcset="'.esc_attr( $img_srcset ).'" sizes="'.$img_sizes.'" alt="'.$alt.'"/>';
				$ImageObject .= '<meta itemprop="url" content="'.$image_src.'">';
				$ImageObject .= '<meta itemprop="width" content="'.$image_width.'">';
				$ImageObject .= '<meta itemprop="height" content="'.$image_height.'">';
				$ImageObject .= '</div>';
				
				return $ImageObject;
				
			//}
		
		}
		
		return $media_content;
		
	}
	
	
	//add_filter('wprs_entry_after', 'wprs_display_summarys');
	/*
		display summary
		@since 1.2.1
		*/
	function wprs_display_summarys($content) {
		global $post;
		if (!wprs_is_enabled($post->ID)) return $content;
		//if (wprs_get_type() != 'aggregate') return $content;
		$template = wprs_template();
		$content = $template['description'] != '' ? $content . $template['description'] : '';
		return $content;
	}
	
	add_filter('wprs_entry_before', 'wprs_meta_description');
	/*
		Add meta for description
		@since 1.2.1
		*/
	function wprs_meta_description($content) {
		global $post;
		if (!wprs_is_enabled($post->ID)) return $content;
		$template = wprs_template();
		$description = $template['description_raw'] != '' ? '<meta content="'.$template['description_raw'].'" itemprop="description">': ''; 
		$content = $description . $content;
		return $content;
	}

	
	add_filter('wprs_box', 'wprs_box_description_show');
	/*
		Display raw description below the Box
		@since 1.3.4
		*/
	function wprs_box_description_show($content) {
		global $post;
		$options = get_option('wprs_options');
		if (!wprs_is_enabled($post->ID)) return $content;
		if (!isset($options['wprs_chk_display_description_in_box'])) return $content;
		$template = wprs_template();
		$description = $template['description_raw_wpautop'] != '' ? '<p>'.$template['description_raw_wpautop'].'</p>' : '';
		$content = $content . $description;
		return $content;
	}
	
	add_filter('wprs_box', 'wprs_display_links');
	/*
		display links
		@since 1.2.1
		*/
	function wprs_display_links($content) {
		global $post;
		if (!wprs_is_enabled($post->ID)) return $content;
		$template = wprs_template();
		if ( $template['links'] != '' ) $content = $content . '<div class="wprs_box_links">'.$template['links'].'</div>';
		return $content;
	}
	
	//add_filter('wprs_price_free', 'wprs_price_free_custom_text_4321xxoo');
	/*
		Example of how to override "Free" price text,
		@since 1.2.4
		*/
	function wprs_price_free_custom_text_4321xxoo($content) {
		$content = 'Free Trial'; // edit "Free" to any other text
		return $content;
	}



	//add_filter('wprs_template', 'wprs_dates_remove_4321xxoo', 99);
	/*
		Remove plublished and modified dates from WPRichSnippets Box template
		*/
	function wprs_dates_remove_4321xxoo( $template ) {
		
		$template['date_published'] = '';
		$template['date_modified'] = '';
		$template['datePublished'] = '';
		$template['dateModified'] = '';
		
		return $template;
	}
	

//add_filter('wprs_box', 'wprs_add_toc_4321xxooxx');
/*
	Use shortcode to display Table Of Content
	This is a simple fix for Table Of Content Plus Plugin
	No need for this filter!
*/
function wprs_add_toc_4321xxooxx($box) {
		
	if ( shortcode_exists( 'toc' ) ) {
		$toc = do_shortcode('[toc wrapping="left"]');
		$box = $box .$toc; 
	}
		
	return $box;
}


add_filter('wprs_box', 'wprs_on_products_if_no_wprs_woo_addon_installed');
/*
	Solve conflicts with WooCommerce plugin
	
	Do not run on product pages if WPRS Woo Add-on plugin is not activated, and
	try to respect WooCommerce unless WPRS Woo add-on is installed and activated
	
	@since 1.4.1
*/
function wprs_on_products_if_no_wprs_woo_addon_installed($box) {
	
	if ( ! class_exists( 'WPRS_WOO' ) ) {
		if ( class_exists( 'WooCommerce' ) ) {
			if ( function_exists( 'is_product') ) {
				if ( is_product() ) return;
			}
		}
	}
	
	return $box;
}


add_filter('wprs_box_media', 'wprs_do_display_html');
/*
   	Filter media content if HTML embed is provided in post meta
	@since 1.4.2
*/
function wprs_do_display_html( $media_content ) {
		
	global $post, $wprs_prefix;
		
	$id = $post->ID;
		
	if (get_post_meta($id, $wprs_prefix.'html', TRUE)) {
			
		$html = '<div class="wprs_iframe">' . get_post_meta($id, $wprs_prefix.'html', TRUE) . '</div>';			
		return $html;
		
	}
		
	return $media_content;
}


add_filter('wprs_user_reviews_before', 'wprs_do_display_user_aggregate_reviews_details');
/*
   	Display user aggregate reviews details before user reviews section
	@since 1.4.7
*/
function wprs_do_display_user_aggregate_reviews_details( $user_reviews ) {
		
	$user_reviews .= wprs_get_user_aggregate_reviews_details();
	return $user_reviews;
}
