<?php
/*
	Global functions that is required by the plugin
	
	WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
	this file under any circumstances.
    */
	
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	
	/*
    	Check if WPRichSnippets is enabled on an entry, example wprs_is_enabled($id);
		@since 1.0.0
    	*/
	function wprs_is_enabled( $post_id = null ) {
		
		global $post, $wprs_prefix;
		
		if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
		
		if ( get_post_meta( $post_id, $wprs_prefix.'snippets_types', TRUE) == null )	{ 
			return '';
		} else {
			return true;
		}
	}
	
	
	/*
		Get post meta
		Scan meta data, and return an array of values
		@since 1.0.0
		*/
	function wprs_get_meta( $post_id = null ) {
		
		global $post, $wprs_prefix;
		
		if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
		
		if ( ! wprs_is_enabled($post_id) ) return;
		
		//if (is_admin()) return;
		
		$custom_fields = get_post_custom( $post_id );
		
		$wprs_array = array();
		
		foreach ( $custom_fields as $key => $fields ) {
    		if ( strpos( $key, $wprs_prefix ) !== false ) {
        		if ( isset( $fields[0] ) ) {
					$wprs_array[$key] = $fields[0];
        		}
    		}
		}

		// debug
		// echo '<pre>';
		// var_dump($wprs_array);
		// var_dump($custom_fields);
		// echo '</pre>';
		
		return $wprs_array;
	}

	/*
		Get post meta by ID
		Scan meta data, and return an array of values
		@since 1.3
		*/
	function wprs_get_meta_by_id( $post_id = null) {
		
		global $post, $wprs_prefix;
		
		If ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
		
		if ( ! wprs_is_enabled($post_id) ) return;
		
		//if (is_admin()) return;
		
		$custom_fields = get_post_custom( $post_id );
		
		$wprs_array = array();
		
		foreach ( $custom_fields as $key => $fields ) {
    		if ( strpos( $key, $wprs_prefix ) !== false ) {
        		if ( isset( $fields[0] ) ) {
					$wprs_array[$key] = $fields[0];
        		}
    		}
		}

		// debug
		// echo '<pre>';
		// var_dump($wprs_array);
		// var_dump($custom_fields);
		// echo '</pre>';
		
		return $wprs_array;
	}	
	
	/*
		Get entry type
		Scan meta data, and return the type
		@since 1.0.0
		*/
	function wprs_get_type() {
		global $post, $wprs_prefix;
		
		$post_id = get_the_ID();
		
		$type = get_post_meta( $post_id, $wprs_prefix.'review_type', true ) ? get_post_meta( $post_id, $wprs_prefix.'review_type', true ) : '';
		return $type;
	}
	
	
	/*
		Get entry type by post id
		scan meta data, and return the type
		@since 1.0.0
		*/
	function wprs_get_type_by_id( $post_id ) {
		global $wprs_prefix;
		$type = get_post_meta( $post_id, $wprs_prefix.'review_type', true ) ? get_post_meta( $post_id, $wprs_prefix.'review_type', true ) : '';
		return $type;
	}
	
	
	/*
		check for SSL,
		if a website is using SSL, return the secured schema path.
		@since 1.0.0
		*/
	function wprs_schema_path() {
		
		$wprs_schema_path = '';
		
		if ( !empty( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] !== 'off' ) {
			// SLL
			$wprs_schema_path = 'https://schema.org/';
		} else {
			// no SLL
			$wprs_schema_path = 'http://schema.org/';
		}
		
		return $wprs_schema_path;
	}
	
	
	/*
 		wprs_is_edit_page('new') 
		function to check if the current page is a post edit page
 		@param  string  $new_edit what page to check for accepts new - new post page ,edit - edit post page, null for either
		@return boolean
		@since 1.0.0
 		*/
	function wprs_is_edit_page( $new_edit = null ){
	
		global $pagenow;

		if ( ! is_admin() ) return false;

		if($new_edit == "edit")
			return in_array( $pagenow, array( 'post.php',  ) );
		elseif($new_edit == "new") //check for new post page
			return in_array( $pagenow, array( 'post-new.php' ) );
		else //check for either new or edit
			return in_array( $pagenow, array( 'post.php', 'post-new.php' ) );
	}
	
	
	/*
    	Check if logged in user is review author, example wprs_is_user_author();
		@since 1.0.0
		*/
	function wprs_is_user_author() {
		
		if ( ! is_single() ) return;
		
		global $post;
		
		$current_user = wp_get_current_user();
		
		if ( isset($post->post_author) && $post->post_author == $current_user->ID && is_single() ) {return true;} else {return false;}
	}
	
		
	/*
		Get author
		@since 1.0.0
	*/
	function wprs_get_author() {
		global $post;
		$author_id = $post->post_author;
		$author = get_the_author_meta( 'display_name', $author_id );
		return $author;
	}
	
	
	/*
    	Return author name with itemprop author, example: wprs_author_name_person($id);
		@since 1.0.0
		*/
	function wprs_get_author_name_person( $post_id, $author ) {
		global $wprs_prefix;
		$content = '';
		// get the author name
		if (get_post_meta($post_id, $wprs_prefix.'author_name', TRUE) !='') {
			$review_author = get_post_meta($post_id, $wprs_prefix.'author_name', TRUE);
		} else {
			 $review_author = $author;
		}
		$content .= __('Reviewed by:', 'wprs') . ' ';
		$content .= '<span itemprop="author" itemscope itemtype="'.wprs_schema_path().'Person">';
		$content .= '<span class="reviewer byline vcard hcard">';
		$content .= '<span class="me fn" itemprop="name">' . $review_author .'</span>';
		$content .= '</span>';
		$content .= '</span>';
		return $content;
	}
	
	
	/*
    	Get description, example wprs_get_description($id);
		@since 1.0.0
		*/
	function wprs_get_description( $post_id ) {
		
		global $wprs_prefix;
		
		$description = get_post_meta($post_id, $wprs_prefix.'item_description', TRUE); 
		// auto paragraphs 
		$description = wpautop($description);
		
		$desc = '';
		$desc .= '<div class="description">';
		$desc .= '<p><b>' . __('Summary', 'wprs') . ':</b> ';
		$desc .= '<span itemprop="description">'.wprs_get_disclaimer($post_id).' '. $description . '</span>';
		$desc .= '</p>';
		$desc .= '</div>';
	
		return $desc;
	}
	
	/*
    	Get description raw value, example wprs_get_description_raw($id);
		@since 1.3.4
		*/
	function wprs_get_description_raw_wpautop( $post_id ) {
		global $wprs_prefix;
		$description = get_post_meta($post_id, $wprs_prefix.'item_description', TRUE);
		// auto paragraphs 
		$description = wpautop($description);
		return $description;
	}
	
	/*
    	Get description raw value, example wprs_get_description_raw($id);
		@since 1.2.3
		*/
	function wprs_get_description_raw( $post_id )  {
		global $wprs_prefix;
		$description = get_post_meta($post_id, $wprs_prefix.'item_description', TRUE); 
		return $description;
	}

	/*
		Get Paid Review Disclaimer, example: wprs_get_disclaimer($id)
		used in wprs_get_description() function
		@since 1.0.0.0
		*/
	function wprs_get_disclaimer( $post_id ) {
		global $wprs_prefix;
		$options = get_option('wprs_options');
		//$custom = get_post_custom($id);
		if (get_post_meta($post_id, $wprs_prefix.'disclaimer_enable', TRUE) == null ) return '';
		$disclaimer_title = $options['wprs_disclaimer_title'];
		$disclaimer_url = $options['wprs_disclaimer_url'];
		if ( !$disclaimer_url ) return '';
		return '<span class="wprs_disclaimer"><a href="'.$disclaimer_url.'" title="Disclaimer"><span class="fa fa-exclamation-circle"></span> '.$disclaimer_title.'</a></span>';
	}
	

	/*
    	Return published date, example: wprs_get_dtreviewed();
		@since 1.0.0
		*/
	function wprs_get_dtreviewed() {
		$date_published = get_the_time(get_option('date_format'));
		$date_published = apply_filters( 'wprs_post_date_published', $date_published );
		//$date_published = '2015-03-08T11:36:43+00:00';
		$content = '';
		$content .= '<div>' . __('Published on', 'wprs') . ': <span class="dtreviewed rating_date">';
		$content .= '<span itemprop="datePublished" class="" title="' . $date_published . '">' . $date_published;
		$content .= '</span></span>';
		$content .= '</div>';
		return apply_filters( 'wprs_date_published', $content );
	}
	
	
	/*
    	Return modified date, example: wprs_get_dtmodified();
		@since 1.0.0
		*/
	function wprs_get_dtmodified() {
		$date_modified 	= get_the_modified_time(get_option('date_format'));
		$date_modified 	= apply_filters( 'wprs_post_date_modified', $date_modified );
		$content = '';
		$content .= '<div>' . __('Last modified', 'wprs') . ': ';
		$content .= '<span class="dtmodified rating_date" itemprop="dateModified">';
		$content .= '<span title="'. $date_modified  . '">' . $date_modified . '</span></span>';
		$content .= '</div>';
		return apply_filters( 'wprs_date_modified', $content );
	}
	
	
	/*
    	Return user aggregate rating stars with no markups, example wprs_get_userrating_stars($post_id);
		@since 1.0.0
    	*/
	function wprs_get_userrating_stars( $post_id ) {
		global $wprs_prefix;
		$count = get_post_meta( $post_id, $wprs_prefix.'userrating_count', true ) ? get_post_meta( $post_id, $wprs_prefix.'userrating_count', true ) : 0;
		$rating = get_post_meta( $post_id, $wprs_prefix.'userrating_average', true ) ? get_post_meta( $post_id, $wprs_prefix.'userrating_average', true ) : 0;
		
		// If rating = 0 , do not output schema markups, instead get a raw markup
		// @since 1.3.9
		if ( $rating =='' || $rating == 0 ) {
			
			$content = '<span class="sr-only">' . __('No Rating Yet!', 'wprs') . '</span>';
			$content .= '<span class="wprs_rating rating-user r-0" title="' . __('No Rating Yet!', 'wprs') . '"></span>';
			
			return $content;
		}
		
		$rating_round = strval( (round($rating * 2) / 2) );
		$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
		$rating_display = str_replace('.', '', $rating_round);
		$content .= '<span class="wprs_rating rating-user r-'.$rating_display.'" title="'. __('Rated', 'wprs') .' '. $rating . '"></span>';
		$content .= '<br />';
		$content .= '<span><nobr><span id="wprs_user_rating">'.$rating.'</span> / 5</nobr> <nobr>(<span id="wprs_user_rating_count_'.$post_id.'" class="wprs_user_rating_count">'.strip_tags( $count ).'</span> <span class="hidden-xs">'.__('Reviewers', 'wprs').'</span>)</nobr></span>';
		$content .= '</span>';
		return $content;
	}
	
	
	/*
    	Return star rating, example wprs_get_star_rating($rating);
		@since 1.0.0
    	*/
	function wprs_get_star_rating( $rating ) {
		$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
		$content .= '<span itemprop="reviewRating" itemscope itemtype="'.wprs_schema_path().'Rating">';
		$content .= '<meta content="1" itemprop="worstRating">';
		$content .= '<meta content="' . $rating . '" itemprop="ratingValue">';
		$content .= '<meta content="5" itemprop="bestRating">';
		$rating_display = str_replace('.', '', $rating);
		$content .= '<span class="wprs_rating rating-editor r-'.$rating_display.'" title="'. __('Rated', 'wprs') .' '. $rating . '"></span>';
		$content .= '</span>';
		return $content;
	}
	
	
	/*
    	Return star rating with no markup, example wprs_get_star_rating_no_markup($rating);
		@since 1.0.0
    	*/
	function wprs_get_star_rating_no_markup( $rating ) {
		$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
		$rating_display = str_replace('.', '', $rating);
		$content .= '<span class="wprs_rating rating-editor r-'.$rating_display.'" title="'. __('Rated', 'wprs') .' '. $rating . '"></span>';
		return $content;
	}
	
	
	/*
    	Return user star rating, example wprs_get_user_star_rating($post_id);
		@since 1.0.0
    	*/
	function wprs_get_user_star_rating( $post_id ) {
		global $wprs_prefix;
		$count = get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true ) : 0;
		$rating = get_post_meta( $post_id, $wprs_prefix.'user_rating', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating', true ) : 0;
		
		// If rating = 0 , do not output schema markups, instead get a raw markup
		// @since 1.3.9
		if ( $rating =='' || $rating == 0 ) {
			
			$content = '<span class="sr-only">' . __('No Rating Yet!', 'wprs') . '</span>';
			$content .= '<span class="wprs_rating rating-user r-0" title="' . __('No Rating Yet!', 'wprs') . '"></span>';
			
			return $content;
		}
		
		$rating_round = strval( (round($rating * 2) / 2) );
		$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
		$content .= '<span itemprop="aggregateRating" itemscope itemtype="'.wprs_schema_path().'AggregateRating">';
		$content .= '<meta content="1" itemprop="worstRating">';
		$content .= '<meta content="' . $rating . '" itemprop="ratingValue">';
		$content .= '<meta content="5" itemprop="bestRating">';
		$rating_display = str_replace('.', '', $rating_round);
		$content .= '<span class="wprs_rating rating-user r-'.$rating_display.'" title="'. __('Rated', 'wprs') .' '. $rating . '"></span>';
		$content .= '<br />';
		$content .= '<span><nobr><span id="wprs_user_rating">'.$rating.'</span> / 5</nobr> <nobr>(<span itemprop="ratingCount" id="wprs_user_rating_count_'.$post_id.'" class="wprs_user_rating_count">'.strip_tags( $count ).'</span> <span class="hidden-xs">'.__('Reviewers', 'wprs').'</span>)</nobr></span>';
		$content .= '</span>';
		return $content;
	
	}
	
	/*
    	Return user star rating minimal layout, example wprs_get_user_star_rating_mini($post_id);
		@since 1.3.3
    	*/
	function wprs_get_user_star_rating_mini( $post_id ) {
		global $wprs_prefix;
		$count = get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true ) : 0;
		$rating = get_post_meta( $post_id, $wprs_prefix.'user_rating', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating', true ) : 0;
		
		//$rating_round = strval( (round($rating * 2) / 2) );
		
		if ($rating == 0) {
			
			$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
			$content .= '<span id="wprs_user_rating">'.$rating.'</span>';
			
		} else {

			$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
			$content .= '<span itemprop="aggregateRating" itemscope itemtype="'.wprs_schema_path().'AggregateRating">';
		
			$content .= '<meta content="1" itemprop="worstRating">';
			$content .= '<meta content="'.$rating.'" itemprop="ratingValue">';
			$content .= '<meta content="5" itemprop="bestRating">';
			$content .= '<meta content="'.strip_tags( $count ).'" itemprop="ratingCount">';
			
			$content .= '<span id="wprs_user_rating">'.$rating.'</span>';
			$content .= '</span>';

		}
		
		return $content;
	
	}
	
	
	/*
    	Return user star rating with no markup, example wprs_get_user_star_rating_raw($post_id);
		@since 1.2.6
    	*/
	function wprs_get_user_star_rating_raw($post_id) {
		global $wprs_prefix;
		$count = get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating_count', true ) : 0;
		$rating = get_post_meta( $post_id, $wprs_prefix.'user_rating', true ) ? get_post_meta( $post_id, $wprs_prefix.'user_rating', true ) : 0;
		$rating_round = strval( (round($rating * 2) / 2) );
		$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
		//$content .= '<span itemprop="aggregateRating" itemscope itemtype="'.wprs_schema_path().'AggregateRating">';
		//$content .= '<meta content="1" itemprop="worstRating">';
		//$content .= '<meta content="' . $rating . '" itemprop="ratingValue">';
		//$content .= '<meta content="5" itemprop="bestRating">';
		$rating_display = str_replace('.', '', $rating_round);
		$content .= '<span class="wprs_rating rating-user r-'.$rating_display.'" title="'. __('Rated', 'wprs') .' '. $rating . '"></span>';
		$content .= '<br />';
		$content .= '<span><nobr><span id="wprs_user_rating">'.$rating.'</span> / 5</nobr> <nobr>(<span id="wprs_user_rating_count_'.$post_id.'" class="wprs_user_rating_count">'.strip_tags( $count ).'</span> <span class="hidden-xs">'.__('Reviewers', 'wprs').'</span>)</nobr></span>';
		$content .= '</span>';
		return $content;
	
	}

	/*
    	Return user aggregate rating, example wprs_get_user_star_rating_aggregate($post_id);
		@since 1.0.0
    	*/
	function wprs_get_user_star_aggregate($post_id) {
		global $wprs_prefix;
		$count = get_post_meta( $post_id, $wprs_prefix.'userrating_count', true ) ? get_post_meta( $post_id, $wprs_prefix.'userrating_count', true ) : 0;
		$rating = get_post_meta( $post_id, $wprs_prefix.'userrating_average', true ) ? get_post_meta( $post_id, $wprs_prefix.'userrating_average', true ) : 0;
		
		// If rating = 0 , do not output schema markups, instead get a raw markup
		// @since 1.3.9
		if ( $rating =='' || $rating == 0 ) {
			
			$content = '<span class="sr-only">' . __('No Rating Yet!', 'wprs') . '</span>';
			$content .= '<span class="wprs_rating rating-user r-0" title="' . __('No Rating Yet!', 'wprs') . '"></span>';
			
			return $content;
		}
		
		$rating_round = strval( (round($rating * 2) / 2) );
		$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
		$content .= '<span itemprop="aggregateRating" itemscope itemtype="'.wprs_schema_path().'AggregateRating">';
		$content .= '<meta content="1" itemprop="worstRating">';
		$content .= '<meta content="' . $rating . '" itemprop="ratingValue">';
		$content .= '<meta content="5" itemprop="bestRating">';
		$rating_display = str_replace('.', '', $rating_round);
		$content .= '<span class="wprs_rating rating-user r-'.$rating_display.'" title="'. __('Rated', 'wprs') .' '. $rating . '"></span>';
		$content .= '<br />';
		$content .= '<span><nobr><span id="wprs_user_rating">'.$rating.'</span> / 5<nobr> </nobr>(<span itemprop="reviewCount" id="wprs_user_rating_count">'.strip_tags( $count ).'</span> <span class="hidden-xs">'.__('Reviewers', 'wprs').'</span>)</nobr></span>';
		$content .= '</span>';
		return $content;
	}
	
	/*
    	Return user aggregate rating raw, only stars with no markup. Example wprs_get_user_star_aggregate_raw($post_id);
		@since 1.0.0
    	*/
	function wprs_get_user_star_aggregate_raw($post_id) {
		global $wprs_prefix;
		$count = get_post_meta( $post_id, $wprs_prefix.'userrating_count', true ) ? get_post_meta( $post_id, $wprs_prefix.'userrating_count', true ) : 0;
		$rating = get_post_meta( $post_id, $wprs_prefix.'userrating_average', true ) ? get_post_meta( $post_id, $wprs_prefix.'userrating_average', true ) : 0;
		$rating_round = strval( (round($rating * 2) / 2) );
		$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
		$rating_display = str_replace('.', '', $rating_round);
		$content .= '<span class="wprs_rating rating-user r-'.$rating_display.'" title="'. __('Rated', 'wprs') .' '. $rating . '"></span>';
		return $content;
	}
	
	/*
    	Return user aggregate rating with minimal layout, example wprs_get_user_star_aggregate_mini($post_id);
		@since 1.3.7
    	*/
	function wprs_get_user_star_aggregate_mini($post_id) {
		global $wprs_prefix;
		$count = get_post_meta( $post_id, $wprs_prefix.'userrating_count', true ) ? get_post_meta( $post_id, $wprs_prefix.'userrating_count', true ) : 0;
		$rating = get_post_meta( $post_id, $wprs_prefix.'userrating_average', true ) ? get_post_meta( $post_id, $wprs_prefix.'userrating_average', true ) : 0;
		$rating_round = strval( (round($rating * 2) / 2) );
		$content = '<span class="sr-only">'. __('Rated', 'wprs').' '.$rating.' '. __('stars', 'wprs').'</span>';
		$content .= '<span itemprop="aggregateRating" itemscope itemtype="'.wprs_schema_path().'AggregateRating">';
		
		$content .= '<meta content="1" itemprop="worstRating">';
		$content .= '<meta content="' . $rating . '" itemprop="ratingValue">';
		$content .= '<meta content="5" itemprop="bestRating">';
		$content .= '<meta content="'.strip_tags( $count ).'" itemprop="ratingCount">';
			
		$content .= '<span id="wprs_user_aggregate_rating_mini">'.$rating.'</span>';
		$content .= '</span>';
		return $content;
	}
	
	
	/*
    	Return editor/user rating percentage, example wprs_get_progressbar($slider_percentage, $ratingsource = 'editor');
		@since 1.0.0
		*/
	function wprs_get_progressbar($slider_percentage, $ratingsource = 'editor') {
		$content = '';
		if(!isset($slider_percentage)) return '';
		
		$content .= '<div class="progress">';
		$content .= '<div class="progress-bar progress-bar-warning" role="progressbar" aria-valuenow="'.$slider_percentage.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$slider_percentage.'%;">';
		$content .= '<span>'.$slider_percentage.'%</span>';
		$content .= '<span class="sr-only"'. __('Rated', 'wprs').$slider_percentage.'%</span>';
		$content .= '</div>';
		$content .= '</div>';	
		return $content;
	}
	

	/*
    	Return editor/user rating percentage, example wprs_get_rating_percentage($rating, $ratingsource);
		@since 1.0.0
		*/
	function wprs_get_rating_percentage($rating, $ratingsource = 'editor', $percentage = false) {
		$content = '';
		if(!isset($rating)) return '';
		if (!$percentage) $rating =  ( (int)$rating / 5) * 100;
		if ($ratingsource == 'editor') {
			$content = '<span class="editorrating_average"><span>' . $rating .'%</span></span>';
		} else {
			$content = '<span class="userrating_average"><span>' . $rating .'%</span></span>';
		}
		return $content;
	}
	
	
	/*
    	Return item name, example: wprs_item_name($id);
		@since 1.0.0
		*/
	function wprs_get_item_name($id) {
		global $wprs_prefix;
		$content = '';
		//check if there is a url link
		if (get_post_meta($id, $wprs_prefix.'item_url', TRUE)) {
			$content .= '<a rel="nofollow" href="' . get_post_meta($id, $wprs_prefix.'item_url', TRUE) .'" title="' . get_post_meta(id, $wprs_prefix.'item_name', TRUE) .'"'.wprs_getWindowTarget().wprs_getDofollow($id).'>' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) . '</a>';
		} else {
			// if there is no url link, just print the name
			$content .= get_post_meta($id, $wprs_prefix.'item_name', TRUE);
		}
		return $content;
	}


	/*
    	Return item name, example: wprs_item_name($id);
		@since 1.0.0
		*/
	function wprs_get_itemprop_name($id) {
		global $wprs_prefix;
		$content = '';
		//check if there is a url link
		if (get_post_meta($id, $wprs_prefix.'item_url', TRUE)) {
			$content .= '<span itemprop="name">';
			$content .= '<a rel="nofollow" href="' . get_post_meta($id, $wprs_prefix.'item_url', TRUE) .'" title="' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) .'"'.wprs_getWindowTarget().wprs_getDofollow($id).'>' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) . '</a>';
			$content .= '</span>';
		} else {
			// if there is no url link, just print the name
			$content .= '<span itemprop="name">';
			$content .= get_post_meta($id, $wprs_prefix.'item_name', TRUE);
			$content .= '</span>';
		}
		return $content;
	}
	
	
	/*
    	Return item name wraped in Thing schema, example: wprs_get_Thing($id);
		@since 1.0.0
		*/	
	function wprs_get_Thing($id) {
		global $wprs_prefix;
		$content = '';
		if (get_post_meta($id, $wprs_prefix.'item_name', TRUE) !='') {
			//check if there is a url link
			if (get_post_meta($id, $wprs_prefix.'item_url', TRUE)) {
				$content .= '<span class="item title fn" itemprop="itemReviewed" itemscope itemtype="'.wprs_schema_path().'Thing">';
				$content .= '<a rel="nofollow" href="' . get_post_meta($id, $wprs_prefix.'item_url', TRUE) .'" title="' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) .'"'.wprs_getWindowTarget().wprs_getDofollow($id).'><span itemprop="name">' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) . '</span></a>';
				$content .= '</span>';
			} else {
				// if there is no url link, just print the name
				$content .= '<span class="item title fn" itemprop="itemReviewed" itemscope itemtype="'.wprs_schema_path().'Thing">';
				$content .= '<span itemprop="name">'.get_post_meta($id, $wprs_prefix.'item_name', TRUE).'</span>';
				$content .= '</span>';
			}
		}
		return $content;
	}
	
	
	/*
    	Return phone
		@since 1.0.0
		*/
	function wprs_get_phone($id) {
		global $wprs_prefix;
		$phone = '';
		$phone_number = get_post_meta($id, $wprs_prefix.'telephone', TRUE) ? get_post_meta($id, $wprs_prefix.'telephone', TRUE) : '';
		if ($phone_number) $phone = '<span itemprop="telephone"><i class="fa fa-phone"></i> '.$phone_number.'</span>';
		return $phone;

	}
	
	/*
    	Return address
		@since 1.0.0
		*/
	function wprs_get_address($id) {
		global $wprs_prefix;
		
		$meta = wprs_get_meta();
		$address = '';
		$spacer = ' ';
		$s_spacer = ', ';
		
		$streetAddress = isset($meta[$wprs_prefix.'streetAddress']) ? $meta[$wprs_prefix.'streetAddress'] : '';
		$postOfficeBoxNumber = isset($meta[$wprs_prefix.'postOfficeBoxNumber']) ? $meta[$wprs_prefix.'postOfficeBoxNumber'] : '';
		$addressLocality = isset($meta[$wprs_prefix.'addressLocality']) ? $meta[$wprs_prefix.'addressLocality'] : '';
		$addressRegion = isset($meta[$wprs_prefix.'addressRegion']) ? $meta[$wprs_prefix.'addressRegion'] : '';
		$postalCode = isset($meta[$wprs_prefix.'postalCode']) ? $meta[$wprs_prefix.'postalCode'] : '';
		$addressCountry = isset($meta[$wprs_prefix.'addressCountry']) ? $meta[$wprs_prefix.'addressCountry'] : '';
		
		// if streetAddress is empty, return!
		if ($streetAddress == '') return '';
		
		// put it all together
		$address = '<div class="wprs_address" itemprop="address" itemscope itemtype="'.wprs_schema_path().'PostalAddress">';
		$address .= '<i class="fa fa-map-marker"></i> ';
		if ($streetAddress != '') {$address .= '<span itemprop="streetAddress">'.$streetAddress.'</span>'.$s_spacer;}
		if ($postOfficeBoxNumber != '') {$address .= '<span itemprop="postOfficeBoxNumber">'.$postOfficeBoxNumber.'</span>'.$s_spacer;}
		if ($addressLocality != '') {$address .= '<span itemprop="addressLocality">'.$addressLocality.'</span>'.$s_spacer;}
		if ($addressRegion != '') {$address .= '<span itemprop="addressRegion">'.$addressRegion.'</span>'.$spacer;}
		if ($postalCode != '') {$address .= '<span itemprop="postalCode">'.$postalCode.'</span>'.$s_spacer;}
		if ($addressCountry != '') {$address .= '<span itemprop="addressCountry">'.$addressCountry.'</span>';}
		$address .= '</div>';
		
		return $address;

	}
	
	
	/*
		Return Google maps
		@since 1.0.0
		*/
	function wprs_get_map($id){
		global $wprs_prefix;
		$map = get_post_meta( $id, $wprs_prefix.'map', true ) ? get_post_meta( $id, $wprs_prefix.'map', true ) : '';
		if ($map != '') $map = '<div class="wprs_map">'.$map.'</div>';
		return $map;
	}
	
	
	/*
    	Return currancy symbol,	transform USA to $
		@since 1.0.0
		*/
	function wprs_get_currency_symbol($code = 'USD') {
		$currencies = array(
			'AED' => array('name' => "United Arab Emirates Dirhams", 'symbol' => "AED", 'ASCII' => ""),
			'AUD' => array('name' => "Australian Dollar", 'symbol' => "A$", 'ASCII' => "A&#36;"),
			'BTC' => array('name' => "Bitcoin", 'symbol' => "฿", 'ASCII' => ""),
			'BRL' => array('name' => "Brazilian Real", 'symbol' => "R$", 'ASCII' => ""),
			'CAD' => array('name' => "Canadian Dollar", 'symbol' => "CA$", 'ASCII' => ""),
			'CZK' => array('name' => "Czech Koruna", 'symbol' => "Kč", 'ASCII' => ""),
			'DKK' => array('name' => "Danish Krone", 'symbol' => "Kr", 'ASCII' => ""),
			'EUR' => array('name' => "Euro", 'symbol' => "€", 'ASCII' => "&#128;"),
			'HKD' => array('name' => "Hong Kong Dollar", 'symbol' => "$", 'ASCII' => "&#36;"),
			'HUF' => array('name' => "Hungarian Forint", 'symbol' => "Ft", 'ASCII' => ""),
			'IRR' => array('name' => "Iranian Rial", 'symbol' => "﷼", 'ASCII' => ""),
			'INR' => array('name' => "Indian Rupee", 'symbol' => "₹", 'ASCII' => ""),
			'ILS' => array('name' => "Israeli New Sheqel", 'symbol' => "₪", 'ASCII' => "&#8361;"),
			'JPY' => array('name' => "Japanese Yen", 'symbol' => "¥", 'ASCII' => "&#165;"),
			'MYR' => array('name' => "Malaysian dollar", 'symbol' => "MYR", 'ASCII' => ""),
			'MXN' => array('name' => "Mexican Peso", 'symbol' => "$", 'ASCII' => "&#36;"),
			'NGN' => array('name' => "Nigerian Naira", 'symbol' => "₦", 'ASCII' => "&#8358;"),
			'NOK' => array('name' => "Norwegian Krone", 'symbol' => "Kr", 'ASCII' => ""),
			'NZD' => array('name' => "New Zealand Dollar", 'symbol' => "$", 'ASCII' => "&#36;"),
			'PHP' => array('name' => "Philippine Peso", 'symbol' => "₱", 'ASCII' => ""),
			'PLN' => array('name' => "Polish Zloty", 'symbol' => "zł", 'ASCII' => ""),
			'GBP' => array('name' => "Pound Sterling", 'symbol' => "£", 'ASCII' => "&#163;"),
			'PRL' => array('name' => "Brazilian Reais", 'symbol' => "R$", 'ASCII' => "&#82;"),
			'SGD' => array('name' => "Singapore Dollar", 'symbol' => "$", 'ASCII' => "&#36;"),
			'SEK' => array('name' => "Swedish Krona", 'symbol' => "kr", 'ASCII' => ""),
			'CHF' => array('name' => "Swiss Franc", 'symbol' => "CHF", 'ASCII' => ""),
			'TWD' => array('name' => "Taiwan New Dollar", 'symbol' => "NT$", 'ASCII' => "NT&#36;"),
			'THB' => array('name' => "Thai Baht", 'symbol' => "฿", 'ASCII' => "&#3647;"),
			'USD' => array('name' => "U.S. Dollar", 'symbol' => "$", 'ASCII' => "&#36;"),
			'ZAR' => array('name' => "South African Rand", 'symbol' => "R", 'ASCII' => "")
		);
		if (!empty($currencies[$code]['ASCII'])) {
			return (string) $currencies[$code]['ASCII'];
		}
		return (string) $currencies[$code]['symbol'];
	}
	
	
	/*
    	Return price, example wprs_get_price($id, $currency_sympol);
		@since 1.0.0
		*/
	function wprs_get_price($id, $currency_sympol) {	
		
		global $wprs_prefix;
		
		$options = get_option('wprs_options');
		
		// if price set to hide, then return nothing!
		if (isset($options['wprs_chk_price_hide'])) return;
		
		// if snippets type LocalBusiness or Article, then return nothing (price is not part of schema
		// @since 1.2.1
		if (get_post_meta($id, $wprs_prefix.'snippets_types', TRUE) == 'Organization') return;
		if (get_post_meta($id, $wprs_prefix.'snippets_types', TRUE) == 'Article') return;
		
		// get currency
		$price_content = '';
		$currency = isset($options['wprs_currency']) != '' ? $options['wprs_currency'] : 'USD';
		
		$lowPrice = get_post_meta($id, $wprs_prefix.'lowprice', TRUE) ? get_post_meta($id, $wprs_prefix.'lowprice', TRUE) : '';
		$highPrice = get_post_meta($id, $wprs_prefix.'highprice', TRUE) ? get_post_meta($id, $wprs_prefix.'highprice', TRUE) : '';
			
		if ($lowPrice !='' && $highPrice !='') {
			$price_content = '<span class="price" itemprop="offers" itemscope itemtype="'.wprs_schema_path().'AggregateOffer">';
			//$lowPrice = get_post_meta($id, $wprs_prefix.'lowprice', TRUE);
			//$highPrice = get_post_meta($id, $wprs_prefix.'highprice', TRUE);
		} else {
			if ($lowPrice !='') {
				$price_content = '<span class="price" itemprop="offers" itemscope itemtype="'.wprs_schema_path().'Offer">';
			}
		}
		
		// add filter to override Free" price text
		// @since 1.2.4
		$free_text = get_post_meta($id, $wprs_prefix.'price_free_text', TRUE) ? get_post_meta($id, $wprs_prefix.'price_free_text', TRUE) : __('FREE', 'wprs');
		$free = apply_filters( 'wprs_price_free', $free_text );
		
		if ($lowPrice !='') {
			$price = $lowPrice;
			// check if currency sympol is disabled
			if (isset($options['wprs_chk_currency_symbol_hide'])) {$currency_sympol='';}
			// check price
			if ($price == '0.00' && isset($options['wprs_chk_rating_box_free'])) {
				$price_content .= '<span class="free_price">';
				$price_content .= '<span class="free">'. $free .'</span>';
				$price_content .= '</span>';
			} else {
				$price_content .= '<span>';
				if ($currency_sympol) $price_content .= '<sup>'.$currency_sympol.'</sup>';
				$price_content .= get_post_meta($id, $wprs_prefix.'lowprice', TRUE);
				$price_content .= '</span>';
			}
		}
		
		if ($highPrice !='') {
			$price = $highPrice;
			// check if currency sympol is disabled
			if (isset($options['wprs_chk_currency_symbol_hide'])) {$currency_sympol='';}
			// check price
			if ($price == '0.00' && isset($options['wprs_chk_rating_box_free'])) {
				$price_content .= '<span class="highprice">';
				$price_content .= '<span class="free_price"> '.__('to','wprs').' ';
				$price_content .= '<span class="free">'. $free .'</span>';
				$price_content .= '</span>';
				$price_content .= '</span>';
			} else {
				$price_content .= '<span class="highprice">';
				$price_content .= '<span> '.__('to', 'wprs').' ';
				if ($currency_sympol) $price_content .= '<sup>'.$currency_sympol.'</sup>';
				$price_content .= $highPrice;
				$price_content .= '</span>';
				$price_content .= '</span>';
			}
		}
		
		// Make sure that price fields are set
		if ($lowPrice !='' || $highPrice !='') {
			if ($lowPrice !='' && $highPrice !='') {
				$price_content .= '<meta itemprop="lowPrice" content="'.$lowPrice.'">';
				$price_content .= '<meta itemprop="highPrice" content="'.$highPrice.'">';
			} else {
				$price_content .= '<meta itemprop="price" content="' . $lowPrice .'">';
			}
		
			$price_content .= '<meta itemprop="priceCurrency" content="'.$currency.'" />';
		}
		
		//$price_content .= '<link itemprop="availability" href="'.wprs_schema_path().'InStock" /><sup class="in_stock">In stock</sup>';
		$price_content .= '</span>';
		
		// For Restaurant
		if (get_post_meta($id, $wprs_prefix.'snippets_types', TRUE) == 'Restaurant') {
			$price_content = '<span class="price_range_digits">';
			$price_content .= '<span itemprop="priceRange">' . get_post_meta($id, $wprs_prefix.'price_range_digits', TRUE) . '</span>';
			$price_content .= '</span>';
			if ($lowPrice !='' && $highPrice !='') {
				$price_content .= '<span class="price_range">';
				$price_content .= '<span>' . $currency_sympol . $lowPrice . '-' . $highPrice . '</span>';
				$price_content .= '</span>';
			}
			//$price_content .= '</span>';
		}
		
		return $price_content;
		
	}
	
	
	
	/*
    	Return price raw (with no markups), example wprs_get_price_raw($id, $currency_sympol);
		@since 1.2.7
		*/
	function wprs_get_price_raw($id, $currency_sympol) {	
		
		global $wprs_prefix;
		
		$options = get_option('wprs_options');
		
		// If price set to hide, then return nothing!
		if (isset($options['wprs_chk_price_hide'])) return;
		
		// If snippets type LocalBusiness or Article, then return nothing (price is not part of schema
		// @since 1.2.1
		if (get_post_meta($id, $wprs_prefix.'snippets_types', TRUE) == 'Organization') return;
		if (get_post_meta($id, $wprs_prefix.'snippets_types', TRUE) == 'Article') return;
		
		// Get currency
		$price_content = '';
		$currency = isset($options['wprs_currency']) != '' ? $options['wprs_currency'] : 'USD';
		
		$lowPrice = get_post_meta($id, $wprs_prefix.'lowprice', TRUE) ? get_post_meta($id, $wprs_prefix.'lowprice', TRUE) : '';
		$highPrice = get_post_meta($id, $wprs_prefix.'highprice', TRUE) ? get_post_meta($id, $wprs_prefix.'highprice', TRUE) : '';
			
		if ($lowPrice !='' && $highPrice !='') {
			$price_content = '<span class="price">';
			//$lowPrice = get_post_meta($id, $wprs_prefix.'lowprice', TRUE);
			//$highPrice = get_post_meta($id, $wprs_prefix.'highprice', TRUE);
		} else {
			if ($lowPrice !='') {
				$price_content = '<span class="price">';
			}
		}
		
		// Add filter to override Free" price text
		// @since 1.2.4
		$free_text = get_post_meta($id, $wprs_prefix.'price_free_text', TRUE) ? get_post_meta($id, $wprs_prefix.'price_free_text', TRUE) : __('FREE', 'wprs');
		$free = apply_filters( 'wprs_price_free', $free_text );
		
		if ($lowPrice !='') {
			$price = $lowPrice;
			// Check if currency sympol is disabled
			if (isset($options['wprs_chk_currency_symbol_hide'])) {$currency_sympol='';}
			// Check price
			if ($price == '0.00' && isset($options['wprs_chk_rating_box_free'])) {
				$price_content .= '<span class="free_price">';
				$price_content .= '<span class="free">'. $free .'</span>';
				$price_content .= '</span>';
			} else {
				$price_content .= '<span>';
				if ($currency_sympol) $price_content .= '<sup>'.$currency_sympol.'</sup>';
				$price_content .= get_post_meta($id, $wprs_prefix.'lowprice', TRUE);
				$price_content .= '</span>';
			}
		}
		
		if ($highPrice !='') {
			$price = $highPrice;
			// Check if currency sympol is disabled
			if (isset($options['wprs_chk_currency_symbol_hide'])) {$currency_sympol='';}
			// Check price
			if ($price == '0.00' && isset($options['wprs_chk_rating_box_free'])) {
				$price_content .= '<span class="highprice">';
				$price_content .= '<span class="free_price"> '.__('to','wprs').' ';
				$price_content .= '<span class="free">'. $free .'</span>';
				$price_content .= '</span>';
				$price_content .= '</span>';
			} else {
				$price_content .= '<span class="highprice">';
				$price_content .= '<span> '.__('to', 'wprs').' ';
				if ($currency_sympol) $price_content .= '<sup>'.$currency_sympol.'</sup>';
				$price_content .= $highPrice;
				$price_content .= '</span>';
				$price_content .= '</span>';
			}
		}
		
		
		//$price_content .= '<link itemprop="availability" href="'.wprs_schema_path().'InStock" /><sup class="in_stock">In stock</sup>';
		$price_content .= '</span>';
		
		return $price_content;
		
	}
	
	
	/*
    	Return score
		@since 1.0.0
		*/
	function wprs_get_score($rating = '1', $ratingsource = 'editor') {
		
		$scores = array(
			'1'		=> array(	'score' => __('Really Bad', 'wprs'),	'icon' => "fa fa-thumbs-down"),
			'1.5'	=> array(	'score' => __('Bad', 'wprs'),			'icon' => "fa fa-thumbs-down"),
			'2'		=> array(	'score' => __('Poor', 'wprs'),			'icon' => "fa fa-thumbs-down"),
			'2.5'	=> array(	'score' => __('OK', 'wprs'),			'icon' => "fa fa-thumbs-up"),
			'3'		=> array(	'score' => __('Good', 'wprs'),			'icon' => "fa fa-thumbs-up"),
			'3.5'	=> array(	'score' => __('Very Good', 'wprs'),		'icon' => "fa fa-thumbs-up"),
			'4'		=> array(	'score' => __('Excellent', 'wprs'),		'icon' => "fa fa-thumbs-up"),
			'4.5'	=> array(	'score' => __('Outstanding', 'wprs'),	'icon' => "fa fa-thumbs-up"),
			'5'		=> array(	'score' => __('Spectacular', 'wprs'),	'icon' => "fa fa-thumbs-up"),
		);
		
		$output = '';
		
		if ($ratingsource == 'editor' && $rating != 0) {
			$rating = strval( (round($rating * 2) / 2) );
			$output = '<span class="'.$scores[$rating]['icon'].'"></span><span class="hidden-xs"> '.$scores[$rating]['score'].'</span>';
		}
		if ($ratingsource == 'user' && $rating != 0) {
			$rating = strval( (round($rating * 2) / 2) );
			$output = '<span class="'.$scores[$rating]['icon'].'"></span><span class="hidden-xs"> '.$scores[$rating]['score'].'</span>';
		}
		return $output;
	}
	
	
	/*
    	Criteria, example: wprs_get_criteria($id, $type);
		$type = (editr, user, all)
		@since 1.0.0
		*/
	function wprs_get_criteria($id, $source_type='editor'){
		
		global $wprs_prefix;

		// If there are no comments and source = user, get out!
		//if ( $source_type == 'user' && get_comments_number() == 0 ) return;
		
		if (get_post_meta($id, $wprs_prefix.'star_rating', TRUE)) { $editor_star_rating = 'on';} else {$editor_star_rating = '';}	
	
		if (get_post_meta($id, $wprs_prefix.'repeatable', TRUE)) {
			$myarray = get_post_meta($id, $wprs_prefix.'repeatable', TRUE);
			//if (!isset($source_type)) $source_type = '';
			$criteria = '<ul>';
				foreach($myarray as $key => $element){
					$criteria .= '<li>';
					$criteria .= '<div class="row">';
					$criteria .= '<div class="col-md-6 progress_title">';			
						// Check if desc is presented,
						// if not, then use title instead
						// modified to check editor/user rating
						// @since 1.0.0
						//if ( get_post_meta($id, $wprs_prefix.'star_rating', TRUE) != null || get_post_meta($id, $wprs_prefix.'userrating_criteria_'.$element['title'], TRUE)) {
							
							if ($element['desc'] !='') {
								$criteria .= '<span title="'.$element['desc'].'">'.$element['desc'].'</span>';
							} else {
								$criteria .= '<span title="'.$element['title'].'">'.$element['title'].'</span>';
							}
						//}
						$criteria .= '</div>';
						$rating_display = $element['rating'];  
						if ($element['rating'] != 'No Rating' && $element['rating'] != '' ) {
							// Editor criteria
							// Display only if author rating is not empty
							// @since 1.0.0
									
							// Open div
							$criteria .= '<div class="col-md-6">';
							// Editor criteria
							//if (get_post_meta($id, $wprs_prefix.'star_rating', TRUE) != null) {
								if ($source_type == 'editor' || $source_type == 'all') {
									$criteria .= '<div class="progress">';
									$criteria .= '<div class="progress-bar progress-bar-warning" role="progressbar" title="'.$rating_display.'%" aria-valuenow="'.$rating_display.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$rating_display.'%">';
									//$criteria .= '<span>'.$rating_display.'%</span>';
									$criteria .= '<span class="sr-only">'. __('Editor', 'wprs').': '.$rating_display.'%</span>';
									$criteria .= '</div>';
									$criteria .= '</div>';
								}
							//}
							// User criteria
								//if (get_post_meta($id, $wprs_prefix.'userrating_criteria_'.$element['title'], TRUE)) {				
									$user_rating_display = get_post_meta($id, $wprs_prefix.'userrating_criteria_'.$element['title'], TRUE);
									if ($source_type == 'user' || $source_type == 'all') {
										//if ($editor_star_rating == 'on') $user_rating_display = 0;
										$criteria .= '<div class="progress">';
										$criteria .= '<div class="progress-bar progress-bar-info" role="progressbar" title="'.$user_rating_display.'%" aria-valuenow="'.$user_rating_display.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$user_rating_display.'%">';if ($editor_star_rating == 'on') $user_rating_display = 0;
   										$criteria .= '<span class="sr-only">'. __('User', 'wprs').': '.$user_rating_display.'%</span>';
										$criteria .= '<div class="bar" style="width: '.$user_rating_display.'%;"></div>';
   				 						$criteria .= '</div>';
										$criteria .= '</div>';
									}
								//}
							// Close div
			 		$criteria .= '</div>';
				}
				$criteria .= '</div>';
				$criteria .= '</li>';
			}
			$criteria .= '</ul>';
			return $criteria;
		}
		return;
	}
	
	
	/*
    	Review criteria in single comment, example wprs_review_criteria_single($id, $comment_id);
		@since 1.0.0
		*/
	function wprs_get_criteria_single($id, $comment_id) {
		
		global $wprs_prefix;
		
		if (get_post_meta($id, $wprs_prefix.'repeatable', TRUE)) {
			$myarray = get_post_meta($id, $wprs_prefix.'repeatable', TRUE);
			$criteria = '<ul class="wprs_userrating_criteria">';
				foreach($myarray as $key => $element){
					$criteria .= '<li>';
						$rating_display = $element['rating'];
						if ( $element['rating'] != 'No Rating' ) {
							// User criteria
							if (get_post_meta($id, $wprs_prefix.'userrating_criteria_'.$element['title'], TRUE)) {	
								
								if ( get_post_meta($id, $wprs_prefix.'star_rating', TRUE) != null || get_post_meta($id, $wprs_prefix.'userrating_criteria_'.$element['title'], TRUE)) {
									if ($element['desc'] !== '') {
										$criteria .= '<span title="'.$element['desc'].'">'.$element['desc'].'</span>';
									} else {
										$criteria .= '<span title="'.$element['title'].'">'.$element['title'].'</span>';
									}
								}			
								$user_rating_display = get_post_meta($id, $wprs_prefix.'userrating_criteria_'.$element['title'], TRUE);
								$user_rating_display = get_comment_meta( $comment_id, 'item_range_'.$element['title'], TRUE);

								$criteria .= '<div class="progress">';
								$criteria .= '<div class="progress-bar progress-bar-info" role="progressbar" title="'.$user_rating_display.'%" aria-valuenow="'.$user_rating_display.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$user_rating_display.'%">';
   								$criteria .= '<span class="sr-only">'. __('User', 'wprs').': '.$user_rating_display.'%</span>';
								$criteria .= '<div class="bar" style="width: '.$user_rating_display.'%;"></div>';
							}
				}
				$criteria .= '</li>';
			}
			/*
			$userrating = get_comment_meta( $comment_id, 'rating', true );
			// Display rating stars
			$criteria .= '<li class="wprs_align_center">';
			$criteria .= '<span class="sr-only">'. __('Rated', 'wprs').' '.$userrating.' '. __('stars', 'wprs').'</span>';
			$criteria .= '<span class="wprs_rating rating-comment r-'.$userrating.'" title="'. __('Rating:', 'wprs') .' ' . $userrating . '"></span>';
			$criteria .= '</li>';
			*/
			$criteria .= '</ul>';
			return $criteria;
		}
		return;
	}
	

	/*
    	Get Links
		@since 1.0.0
    	*/
	function wprs_getReviewLinks($id) {
		
		global $wprs_prefix;
		
		$options = get_option('wprs_options');
		
		// Get button color
		if ($options['wprs_drp_button_color'] != '') {$rating_box_btn_color = $options['wprs_drp_button_color'];} else {$rating_box_btn_color = 'blue';}
		// Get more details button value
		if ($options['wprs_more_details_btn_value'] != '') {$rating_box_btn_value = $options['wprs_more_details_btn_value'];} else {$rating_box_btn_value = __('More Details', 'wprs');}
		// Get more details button icon value
		if (isset($options['wprs_btn_icon']) != '') {$box_btn_icon = $options['wprs_btn_icon'];} else {$box_btn_icon = '';}
		// Get demo button color
		if ($options['wprs_drp_button_dcolor'] != '') {$rating_box_btn_dcolor = $options['wprs_drp_button_dcolor'];} else {$rating_box_btn_dcolor = 'orange';}
		// Get demo button value
		if ($options['wprs_demo_btn_value'] != '') {$review_text_dbutton = $options['wprs_demo_btn_value'];} else {$review_text_dbutton = __('Demo', 'wprs');}
		// Get demo button icon value
		if (isset($options['wprs_dbtn_icon']) != '') {$box_dbtn_icon = $options['wprs_dbtn_icon'];} else {$box_dbtn_icon = '';}
		
	
		$button = '';
		
		// Check if there is a url link			
		if (get_post_meta($id, $wprs_prefix.'item_url', TRUE)) {
								
			// Check button text
			if (get_post_meta($id, $wprs_prefix.'button_text', TRUE) == null) {
				$review_text_button = $rating_box_btn_value; // use default 'More Details', or global
			} else {
				$review_text_button = get_post_meta($id, $wprs_prefix.'button_text', TRUE);
			}
			
			// Check button icon
			if (get_post_meta($id, $wprs_prefix.'button_icon', TRUE) == null) {
				$btn_icon = $box_btn_icon ? '<i class="fa '.$box_btn_icon.'"></i> ' : ''; // use from plugin settings
			} else {
				$btn_icon = get_post_meta($id, $wprs_prefix.'button_icon', TRUE);
				$btn_icon = '<i class="fa '.$btn_icon.'"></i> ';
			}
			
			// Check demo button text
			if (get_post_meta($id, $wprs_prefix.'button_demo_text', TRUE) == null) {
				// Do nothing!
				//$review_text_dbutton = $review_text_dbutton; // use default 'More Details', or global
			} else {
				$review_text_dbutton = get_post_meta($id, $wprs_prefix.'button_demo_text', TRUE);
			}
			
			// Check demo button icon
			if (get_post_meta($id, $wprs_prefix.'button_demo_icon', TRUE) == null) {
				$dbtn_icon = $box_dbtn_icon ? '<i class="fa '.$box_dbtn_icon.'"></i> ' : ''; // use from plugin settings
			} else {
				$dbtn_icon = get_post_meta($id, $wprs_prefix.'button_demo_icon', TRUE);
				$dbtn_icon = '<i class="fa '.$dbtn_icon.'"></i> ';
			}
		
			//$button .= '<ul class="wprs_links">';					
			//$button .= '<li>';
			//$button .= '<div class="clr"></div>';
			$button .= '<div class="" align="center">';
			
			// Review link
			$button .= '<a itemprop="url" class="ar_button ar_' . $rating_box_btn_color . '" href="' . get_post_meta($id, $wprs_prefix.'item_url', TRUE) . '" title="' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) . '"'.wprs_getWindowTarget().wprs_getDofollow($id).'><nobr>'.$btn_icon.$review_text_button.'</nobr></a>';
			
			// Demo link
			if (get_post_meta($id, $wprs_prefix.'item_demo_url', TRUE) != null) {				
				$button .= ' '; // Add a space between buttons
				$button .= '<a itemprop="url" class="ar_button ar_' . $rating_box_btn_dcolor . ' ar_button_demo" href="' . get_post_meta($id, $wprs_prefix.'item_demo_url', TRUE) . '" title="' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) . '"'.wprs_getWindowTarget().wprs_getDofollow($id).'><nobr>'.$dbtn_icon.$review_text_dbutton.'</nobr></a>';
			}
			
			$button .= '</div>';
			//$button .= '<div class="clr"></div>';
			//$button .= '</li>';
			//$button .= '</ul>';
		}
		
		return apply_filters('wprs_links', $button);
	}
	



	/*
    	Get Review Links Mini
		@since 1.0.0
		*/
	
	function wprs_getReviewLinksMini($id) {
		
		global $wprs_prefix;
		
		$options = get_option('wprs_options');
		//if (isset($options['wprs_chk_link_window']) != true ) return '';
		
		// Get button color
		if ($options['wprs_drp_button_color'] != '') {$rating_box_btn_color = $options['wprs_drp_button_color'];} else {$rating_box_btn_color = 'blue';}
		// Get more details button value
		if ($options['wprs_more_details_btn_value'] != '') {$rating_box_btn_value = $options['wprs_more_details_btn_value'];} else {$rating_box_btn_value = __('More Details', 'wprs');}
		// Get more details button icon value
		if (isset($options['wprs_btn_icon']) != '') {$box_btn_icon = $options['wprs_btn_icon'];} else {$box_btn_icon = '';}
		// Get demo button color
		if ($options['wprs_drp_button_dcolor'] != '') {$rating_box_btn_dcolor = $options['wprs_drp_button_dcolor'];} else {$rating_box_btn_dcolor = 'orange';}
		// Get demo button value
		if ($options['wprs_demo_btn_value'] != '') {$review_text_dbutton = $options['wprs_demo_btn_value'];} else {$review_text_dbutton = __('Demo', 'wprs');}
		// Get demo button icon value
		if (isset($options['wprs_dbtn_icon']) != '') {$box_dbtn_icon = $options['wprs_dbtn_icon'];} else {$box_dbtn_icon = '';}
	
		$button = '';
		
		// Check if there is a url link			
		if (get_post_meta($id, $wprs_prefix.'item_url', TRUE)) {
			
			// Check button text
			if (get_post_meta($id, $wprs_prefix.'button_text', TRUE) == null) {
				$review_text_button = $rating_box_btn_value; // Use default 'More Details', or global
			} else {
				$review_text_button = get_post_meta($id, $wprs_prefix.'button_text', TRUE);
			}
			
			// Check button icon
			if (get_post_meta($id, $wprs_prefix.'button_icon', TRUE) == null) {
				$btn_icon = $box_btn_icon ? '<i class="fa '.$box_btn_icon.'"></i> ' : ''; // Use from plugin settings
			} else {
				$btn_icon = get_post_meta($id, $wprs_prefix.'button_icon', TRUE);
				$btn_icon = '<i class="fa '.$btn_icon.'"></i> ';
			}
			
			// Check demo button text
			if (get_post_meta($id, $wprs_prefix.'button_demo_text', TRUE) == null) {
				// Do nothing!
				//$review_text_dbutton = $review_text_dbutton; // use default 'More Details', or global
			} else {
				$review_text_dbutton = get_post_meta($id, $wprs_prefix.'button_demo_text', TRUE);
			}
			
			// Check demo button icon
			if (get_post_meta($id, $wprs_prefix.'button_demo_icon', TRUE) == null) {
				$dbtn_icon = $box_dbtn_icon ? '<i class="fa '.$box_dbtn_icon.'"></i> ' : ''; // Use from plugin settings
			} else {
				$dbtn_icon = get_post_meta($id, $wprs_prefix.'button_demo_icon', TRUE);
				$dbtn_icon = '<i class="fa '.$dbtn_icon.'"></i> ';
			}
								
			$button .= '<ul class="wprs_links">';					
			$button .= '<li>';
			$button .= '<div class="clr"></div>';
			$button .= '<div class="min_btn">';
			
			// Review link
			$button .= '<a itemprop="url" class="ar_button ar_' . $rating_box_btn_color . '" href="' . get_post_meta($id, $wprs_prefix.'item_url', TRUE) . '" title="' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) . '"'.wprs_getWindowTarget().wprs_getDofollow($id).'><nobr>'.$btn_icon.$review_text_button.'</nobr></a>';
			
			// Demo link
			if (get_post_meta($id, $wprs_prefix.'item_demo_url', TRUE) != null) {				
				$button .= ' '; // Add a space between buttons
				$button .= '<br />'; // Add space break between buttons
				$button .= '<a itemprop="url" class="ar_button ar_' . $rating_box_btn_dcolor . ' ar_button_demo" href="' . get_post_meta($id, $wprs_prefix.'item_demo_url', TRUE) . '" title="' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) . '"'.wprs_getWindowTarget().wprs_getDofollow($id).'><nobr>'.$dbtn_icon.$review_text_dbutton.'</nobr></a>';
			}
			
			$button .= '</div>';
			$button .= '<div class="clr"></div>';
			$button .= '</li>';
			$button .= '</ul>';
		}
		
		return apply_filters('wprs_links_mini', $button);
	}
	
	
	/*
    	Get Link
		@since 1.0.0
    	*/
	function wprs_getReviewLink($id) {
		
		global $wprs_prefix;
		
		$options = get_option('wprs_options');
		
		// Get button color
		if ($options['wprs_drp_button_color'] != '') {$rating_box_btn_color = $options['wprs_drp_button_color'];} else {$rating_box_btn_color = 'blue';}
		// Get more details button value
		if ($options['wprs_more_details_btn_value'] != '') {$rating_box_btn_value = $options['wprs_more_details_btn_value'];} else {$rating_box_btn_value = __('More Details', 'wprs');}
		// Get more details button icon value
		if (isset($options['wprs_btn_icon']) != '') {$box_btn_icon = $options['wprs_btn_icon'];} else {$box_btn_icon = '';}

		$button = '';
		
		// Check if there is a url link			
		if (get_post_meta($id, $wprs_prefix.'item_url', TRUE)) {
								
			// Check button text
			if (get_post_meta($id, $wprs_prefix.'button_text', TRUE) == null) {
				$review_text_button = $rating_box_btn_value; // Use default 'More Details', or global
			} else {
				$review_text_button = get_post_meta($id, $wprs_prefix.'button_text', TRUE);
			}
			
			// Check button icon
			if (get_post_meta($id, $wprs_prefix.'button_icon', TRUE) == null) {
				$btn_icon = $box_btn_icon ? '<i class="fa '.$box_btn_icon.'"></i> ' : ''; // Use from plugin settings
			} else {
				$btn_icon = get_post_meta($id, $wprs_prefix.'button_icon', TRUE);
				$btn_icon = '<i class="fa '.$btn_icon.'"></i> ';
			}
			
			//$button .= '<ul class="wprs_links">';					
			//$button .= '<li>';
			//$button .= '<div class="clr"></div>';
			//$button .= '<div class="" align="center">';
			
			// review link
			$button .= '<a itemprop="url" class="ar_button ar_' . $rating_box_btn_color . '" href="' . get_post_meta($id, $wprs_prefix.'item_url', TRUE) . '" title="' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) . '"'.wprs_getWindowTarget().wprs_getDofollow($id).'><nobr>'.$btn_icon.$review_text_button.'</nobr></a>';
			
			//$button .= '</div>';
			//$button .= '<div class="clr"></div>';
			//$button .= '</li>';
			//$button .= '</ul>';
		}
		
		return apply_filters('wprs_link', $button);
	}
	


	/*
    	Get Link
		@since 1.0.0
    	*/
	function wprs_getReviewLinkDemo($id) {
		
		global $wprs_prefix;
		
		$options = get_option('wprs_options');
		
		// Get demo button color
		if ($options['wprs_drp_button_dcolor'] != '') {$rating_box_btn_dcolor = $options['wprs_drp_button_dcolor'];} else {$rating_box_btn_dcolor = 'orange';}
		// Get demo button value
		if ($options['wprs_demo_btn_value'] != '') {$review_text_dbutton = $options['wprs_demo_btn_value'];} else {$review_text_dbutton = __('Demo', 'wprs');}
		// Get demo button icon value
		if (isset($options['wprs_dbtn_icon']) != '') {$box_dbtn_icon = $options['wprs_dbtn_icon'];} else {$box_dbtn_icon = '';}
		
	
		$button = '';
		
		// Check if there is a url link			
		if (get_post_meta($id, $wprs_prefix.'item_demo_url', TRUE)) {
			
			
			// Check demo button text
			if (get_post_meta($id, $wprs_prefix.'button_demo_text', TRUE) == null) {
				// Do nothing!
				//$review_text_dbutton = $review_text_dbutton; // Use default 'More Details', or global
			} else {
				$review_text_dbutton = get_post_meta($id, $wprs_prefix.'button_demo_text', TRUE);
			}
			
			// Check demo button icon
			if (get_post_meta($id, $wprs_prefix.'button_demo_icon', TRUE) == null) {
				$dbtn_icon = $box_dbtn_icon ? '<i class="fa '.$box_dbtn_icon.'"></i> ' : ''; // Use from plugin settings
			} else {
				$dbtn_icon = get_post_meta($id, $wprs_prefix.'button_demo_icon', TRUE);
				$dbtn_icon = '<i class="fa '.$dbtn_icon.'"></i> ';
			}
		
			//$button .= '<ul class="wprs_links">';					
			//$button .= '<li>';
			//$button .= '<div class="clr"></div>';
			//$button .= '<div class="" align="center">';
			
			// Demo link
			if (get_post_meta($id, $wprs_prefix.'item_demo_url', TRUE) != null) {				
				$button .= ' '; // Add a space between buttons
				$button .= '<a itemprop="url" class="ar_button ar_' . $rating_box_btn_dcolor . ' ar_button_demo" href="' . get_post_meta($id, $wprs_prefix.'item_demo_url', TRUE) . '" title="' . get_post_meta($id, $wprs_prefix.'item_name', TRUE) . '"'.wprs_getWindowTarget().wprs_getDofollow($id).'><nobr>'.$dbtn_icon.$review_text_dbutton.'</nobr></a>';
			}
			
			//$button .= '</div>';
			//$button .= '<div class="clr"></div>';
			//$button .= '</li>';
			//$button .= '</ul>';
		}
		
		return apply_filters('wprs_link_demo', $button);
	}
	

			
	/*
    	Get Review Link Target
		@since 1.0.0
    	*/
	function wprs_getWindowTarget() {
		global $post, $wprs_prefix;
		$options = get_option('wprs_options');
		if(!get_post_meta($post->ID, $wprs_prefix.'link_target', TRUE) == null) return;
		if (!isset($options['wprs_chk_link_window']) != true) return;
		return 'target="_blank"';
	}
	
			
	/*
    	Get Review Link Dofollow
		@since 1.0.0
    	*/
	function wprs_getDofollow($id) {
		global $wprs_prefix;
		if (get_post_meta($id, $wprs_prefix.'link_dofollow', TRUE) == null) return 'rel="nofollow"';
		return;
	}
	

	/*
    	Return 0, review, reviews, example wprs_get_user_reviews_count($count);
		@since 1.0.0
		*/
	function wprs_get_user_reviews_count ($count) {
		$icon = '<span class="fa fa-user"></span> ';
		if ($count == 0) return '('.$count.') '.$icon.__('No reviews yet!', 'wprs');
		if ($count == 1) return '('.$count.') '.$icon.__('Review', 'wprs');
  		return '('.$count.') '.$icon.'<span class="hidden-xs">' . __('Reviews', 'wprs').'</span>';
	}
	
	
	/*
    	Return add review link, example wprs_get_add_your_review();
		@since 1.0.0
		*/
	function wprs_get_add_your_review() {
		
		// If user review is submitted, return nothing!
		// @since 1.3.4
		if ( isset($_GET['updated']) ) return '';
		
		$options = get_option('wprs_options');
		$my_theme = wp_get_theme();
		$classes = 'wprs_submit_review';
		
		// Check user is review author, do not display respond icon (if logged in)
		if (wprs_is_user_author()) return '';
		
		if (!isset($options['wprs_chk_user_rating_popup_enable']) != '') {
			// Check if Thesis theme is active
			if ( $my_theme->get( 'Name' ) == 'Thesis') {
				$respond_url = get_permalink() . '#commentform';
			} else {
				$respond_url = get_permalink() . '#respond';
			}
		} else {
			$respond_url = '#inline_content';
			$classes .= ' inline';
		}
			
		$respond_link = ' <a class="'.$classes.'" href="'.$respond_url.'" title="'.__('Add Your Review', 'wprs').'" rel="nofollow"><i class="fa fa-plus-circle"></i></a>';

		return apply_filters( 'wprs_add_your_review', $respond_link );
	}
	
	
	/*
    	Return add review link button, example wprs_get_add_your_review_button();
		To be used with aggregate reviews
		@since 1.0.0
		*/
	function wprs_get_add_your_review_button() {
		
		// If user review is submitted, return nothing!
		// @since 1.3.4
		if ( isset($_GET['updated']) ) return '';
			
		$options = get_option('wprs_options');
		$my_theme = wp_get_theme();
		$classes = 'wprs_submit_review';
		
		// Check user is review author, do not display respond icon (if logged in)
		if (wprs_is_user_author()) return '';
		
		if (!isset($options['wprs_chk_user_rating_popup_enable']) != '') {
			// Check if Thesis theme is active
			if ( $my_theme->get( 'Name' ) == 'Thesis') {
				$respond_url = get_permalink() . '#commentform';
			} else {
				$respond_url = get_permalink() . '#respond';
			}
		} else {
			$respond_url = '#inline_content';
			$classes .= ' inline';
		}
			
		$respond_link = '<div class="wprs_add_review">';
		$respond_link .= '<p>';
		$respond_link .= '<a class="'.$classes.' ar_button ar_blue" href="'.$respond_url.'" title="'.__('Add Your Review','wprs').'">';
		$respond_link .= '<i class="fa fa-plus-circle"></i>';
		$respond_link .= ' '.__('Add Review','wprs');
		$respond_link .= '</a>';
		$respond_link .= '</p>';
		$respond_link .= '</div>';

		return apply_filters( 'wprs_add_your_review_button', $respond_link );
	}
	
		
	add_action('admin_bar_menu', 'wprs_admin_bar_menu_items', 99);
	/*
    	Add Google Rich Snippet Test Tool link to admin bar menu 
		@since 1.0.0
		*/
	function wprs_admin_bar_menu_items($admin_bar) {
		
		/* This print_r will show you the current contents of the admin menu bar, use it if you want to examine the $admin_bar array
		* echo "<pre>";
		* print_r($admin_bar);
		* echo "</pre>";
		*/
		
		// If it's admin page, then get out!
		if (is_admin()) return;
		// If front, home or archive, then get out!
		if (is_front_page() || is_home() || is_archive() ) return;
		// Get global post
		global $post;
		// Get post id
		$id = get_the_ID();
		// If it's not a review, then get out!
		if (!wprs_is_enabled($id)) return;
		// If user can't, then get out
		if ( !current_user_can( 'edit_post', $id ) ) return;
		// Get post permalink
		$permalink = get_permalink( $id );
		// Add menu item
		$admin_bar->add_menu( array(
			'id'	=> 'wprs-test-item',
			'title'	=> __('Test', 'wprs'),
			'href'	=> 'https://developers.google.com/structured-data/testing-tool/?url='.$permalink,
			'meta'	=> array(
				'title'		=> __('Structured Data Testing Tool', 'wprs'),
				'class'		=> 'wprs_google_developers',
				'target'	=> __('_blank')
			),
		) );
	}
	
	
	/*
    	Get custom post types
		@since 1.0.0
		*/
	function wprs_get_post_types() {
		$options = get_option('wprs_options');
		$active_post_types = array();
		$args = array('public'   => true,
				'_builtin' => false
			);
		$output = 'names'; // Names or objects, note names is the default
		$operator = 'and'; // 'and' or 'or'
		$post_types = get_post_types($args,$output,$operator);
		foreach ( $post_types as $post_type ) {
			// Check if custom post type is enabled
			if (isset($options['wprs_chk_post_type_'.$post_type])) {
				// Add active custom post types to array
				$active_post_types[] = $post_type;
			}
		}

		// Add post if it's enabled within the plugin settings
		if (isset($options['wprs_chk_post_type_post'])) {
			$active_post_types[] = 'post';
		}
		// Add post if it's enabled within the plugin settings
		if (isset($options['wprs_chk_post_type_page'])) {
			$active_post_types[] = 'page';
		}
		
		return $active_post_types;
	}


	/*
    	Shorten content, example wprs_short_content ($text, $limit);
		@since 1.0.0
		*/
	function wprs_short_content ($text, $limit) {
  		$text_array = explode(' ', $text, $limit - 1);
  		$short_text = implode(' ', $text_array);
  		// Manipulate the string if you need to
  		return $short_text;
	}


			
	/*
    	Get media, example wprs_review_media($id);
		@since 1.0.0
		*/
	function wprs_get_media($id) {
		
		global $wprs_prefix;
		
		$options = get_option('wprs_options');
		
		$media_content = '';
		$image_src = '';
		$video = '';
		$media = '';
		$embed = '';
		$title = '';
		$img = '';
		$alt = '';
		$url = '';
		
		// Get stuff
		if ( get_post_meta($id, $wprs_prefix.'item_name', TRUE) ) {$title = get_post_meta($id, $wprs_prefix.'item_name', TRUE);}
		if ( get_post_meta($id, $wprs_prefix.'item_url', TRUE) ) {$url = get_post_meta($id, $wprs_prefix.'item_url', TRUE);}
		if ( get_post_meta($id, $wprs_prefix.'embed', TRUE) ) {$embed = get_post_meta($id, $wprs_prefix.'embed', TRUE);}
		
		// Get image alt
		// @since 1.0.0.8.8
		if (get_post_meta($id, $wprs_prefix.'image_alt', TRUE)) {
			$alt = get_post_meta($id, $wprs_prefix.'image_alt', TRUE);
		} else { // If no value, then...
			if (get_post_meta($id, $wprs_prefix.'item_name', TRUE)) {
				$alt = get_post_meta($id, $wprs_prefix.'item_name', TRUE); // Set to review name
			} else {$alt = '';}
		}
		
		// Featured image
		// This will override review image field
		if ( !isset($options['wprs_chk_featured_img_disable']) ) {
			if ( has_post_thumbnail($id) ) { // Check if the post has a Post Thumbnail assigned to it.
				$featured_img = wp_get_attachment_image_src( get_post_thumbnail_id($id), 'single-post-thumbnail' );
				$image_src = $featured_img[0];
			}
		}
		
		
		// Review image	
		if (get_post_meta($id, $wprs_prefix.'image', TRUE)) {
			// Get image url	
			$image_src = stripslashes (get_post_meta( $id, $wprs_prefix.'image', TRUE ));
			// Check is auto-resize is enabled in plugin settings
			if ( isset($options['wprs_chk_img_size_enable']) && $options['wprs_chk_img_size_enable'] != '' ) {
				$image_src = wprs_resize($image_src, 320, 120, true);
			}
		}
		
		// @since 1.3.1
		$size = 'medium_large';
		$attachment_id = wprs_get_image_id($image_src);
		$img_srcset = wp_get_attachment_image_srcset( $attachment_id, $size );
		$img_sizes  = wp_get_attachment_image_sizes( $attachment_id, $size );
		
		// Check if there is a url link
		if ( $url != null && $image_src !='' && !isset($options['wprs_chk_unlink_imgs']) ) {
			
			$media = '<a class="media" href="' . $url . '" title="' . $title . '"' . wprs_getWindowTarget() . wprs_getDofollow($id). '>';
			$media .= '<img itemprop="image" class="photo" src="' . $image_src . '" srcset="'.esc_attr( $img_srcset ).'" sizes="'.$img_sizes.'" alt="' . $alt .'" />';
			$media .= '</a>';
		} else { // No link
			if ( $image_src !='' ) {
				$media = '<img itemprop="image" class="photo" src="' . $image_src . '" srcset="'.esc_attr( $img_srcset ).'" sizes="'.$img_sizes.'" alt="' . $alt .'" />';
			}
		}

		// Slider shortcode
		// This will override other ways to display review image
		if (get_post_meta($id, $wprs_prefix.'slider_shortcode', TRUE)) {
			$shortcode = get_post_meta($id, $wprs_prefix.'slider_shortcode', TRUE);
			$media = '<div class="media">';
			$media .= do_shortcode( $shortcode );
			$media .= '</div>';
		}
		
		// Gallery slider shortcode
		// Use the default built-in slider
		if (get_post_meta($id, $wprs_prefix.'gallery_slider', TRUE)) {
			$shortcode = '[wprs_slider]';
			$media = '<div class="media">';
			$media .= do_shortcode( $shortcode );
			$media .= '</div>';
		}
		
		// Youtube video was replaced with Embed, to support other video types
		// @since 1.3.8
		// This will override other ways to display review image
		if ( $embed ) {
			$media = '<div class="media">';
			$media .= wp_oembed_get( $embed );
			$media .= '</div>';
		}
		
		// Display media
		if ( !empty($media) ) {
			// Before
			//$media_content .= '<div class="col-md-12">';
			// Add image 
			$media_content .= $media;
			// After
			//$media_content .= '</div>';
			// Return media
			return apply_filters( 'wprs_box_media', $media_content );
		}
		// Return nothing
		return;
	}
	
	
	/*
    	Get media, example wprs_review_media_extend($id);
		Mostly this will be used via widgets
		@since 1.0.0
    	*/
	function wprs_review_media_extend($id, $width=320, $height=120) {
		
		global $wprs_prefix;
		
		// Get options
		$options = get_option('wprs_options');
		$media_content = '';
		$image_src = '';
		$embed = '';
		$media = '';
		$title = '';
		$img = '';
		$alt = '';
		$url = '';
		
		// Get stuff
		$url = get_permalink($id);
		if ( get_post_meta($id, $wprs_prefix.'image', TRUE) ) {$title = get_post_meta($id, $wprs_prefix.'image', TRUE);}
		if ( get_post_meta($id, $wprs_prefix.'embed', TRUE) ) {$embed = get_post_meta($id, $wprs_prefix.'embed', TRUE);}
		// Get image alt
		if (get_post_meta($id, $wprs_prefix.'image_alt', TRUE)) {
			$alt = get_post_meta($id, $wprs_prefix.'image_alt', TRUE);
		} else { // If no value, then...
			if (get_post_meta($id, $wprs_prefix.'item_name', TRUE)) {
				$alt = get_post_meta($id, $wprs_prefix.'item_name', TRUE); // Set to review name
			} else {$alt = '';}
		}
		
		// Featured image
		// This will override review image field
		if ( has_post_thumbnail($id) ) { // Check if the post has a Post Thumbnail assigned to it.
			$featured_img = wp_get_attachment_image_src( get_post_thumbnail_id($id), 'single-post-thumbnail' );
			$image_src = $featured_img[0];
			$image_src = wprs_resize($featured_img[0], $width, $height, true);
		}
		
		// Post image	
		if (get_post_meta($id, $wprs_prefix.'image', TRUE)) {
			// Get image url	
			$image_src = stripslashes (get_post_meta( $id, $wprs_prefix.'image', TRUE ));
			// Check if auto-resize is enabled in plugin settings
			if ( isset($options['wprs_chk_img_size_enable']) && $options['wprs_chk_img_size_enable'] != '' ) {
				$image_src = wprs_resize($image_src, $width, $height, true);
			}
		}
		
		// Get image from galley & slider
		if (get_post_meta($id, $wprs_prefix.'gallery_slider', TRUE) || get_post_meta($id, $wprs_prefix.'slider_shortcode', TRUE)) {
			$image_src = wprs_resize(wprs_first_image($id), $width, $height, true);
		}
		
		// Get image from a video
		if ( $embed ) {
			// @since 1.3.8
			$image_src = wprs_get_WP_oEmbed( $embed, 'thumbnail_url' );
		}
		
		// @since 1.3.1
		//$size = 'medium';
		$size = 'wprs-image';
		$attachment_id = wprs_get_image_id($image_src);
		$img_srcset = wp_get_attachment_image_srcset( $attachment_id, $size );
		$img_sizes  = wp_get_attachment_image_sizes( $attachment_id, $size );
		
		// Check if there is a url link
		if ( $url != null && $image_src !='' ) {
			//$media = '<a href="' . $url . '" title="' . $title . '"' . wprs_getWindowTarget() . wprs_getDofollow($id). '>';
			$media = '<a href="' . $url . '" title="' . $title . '">';
			$media .= '<img itemprop="image" class="widget_review_screenshot_img photo" src="'.$image_src.'" srcset="'.esc_attr( $img_srcset ).'" sizes="'.$img_sizes.'" alt="'.$alt.'" />';
			$media .= '</a>';
			
		} else { // No link
			if ( $image_src !='' ) {
				$media = '<img itemprop="image" class="widget_review_screenshot_img photo" src="' . $image_src . '" srcset="'.esc_attr( $img_srcset ).'" sizes="'.$img_sizes.'" alt="' . $alt .'" />';
			}
		}
		
		// Display media
		if ( isset($media) ) {
			$media_content .= $media;
			return $media_content;
		}
		return;
	}

	
	
	/*
    	Get image url, example wprs_get_img_url($id);
		@since 1.3.1
    	*/
	function wprs_get_img_url($id) {
		
		global $wprs_prefix;
		
		$image_src = '';
		
		if (get_post_meta($id, $wprs_prefix.'image', TRUE)) {
			// Get image url	
			$image_src = stripslashes (get_post_meta( $id, $wprs_prefix.'image', TRUE ));
		}
		
		return $image_src;
		
	}

	
	/*
    	Get the first image in WP gallery, example wprs_first_image($id);
		To be used by widgets
		@since 1.0.0
    	*/
	function wprs_first_image( $id ) {
		
		$args = array(
			'numberposts' => 1,
			'order' => 'ASC',
			'post_mime_type' => 'image',
			'post_parent' => $id,
			'post_status' => null,
			'post_type' => 'attachment',
		);
		$img ='';
		$attachments = get_children( $args );

		if ( $attachments ) {
			foreach ( $attachments as $attachment ) {
				$image_attributes = wp_get_attachment_image_src( $attachment->ID, 'thumbnail' )  ? wp_get_attachment_image_src( $attachment->ID, 'thumbnail' ) : wp_get_attachment_image_src( $attachment->ID, 'full' );

				$img = wp_get_attachment_thumb_url( $attachment->ID, 'full');
				//$img = wp_get_attachment_thumb_url( $attachment->ID, 'wprs-thumb');
				//$img = wp_get_attachment_image_src( $attachment->ID, 'wprs-thumb', false );
				
				return $img;
			}
		}
		
	}


	/*
		Get youtube video ID from URL, example wprs_youtube_id_from_url($url);
		@since 1.0.0
		*/
	function wprs_youtube_id_from_url($url) {
		
		$pattern = 
					'%^# Match any youtube URL
					(?:https?://)?  # Optional scheme. Either http or https
					(?:www\.)?      # Optional www subdomain
					(?:             # Group host alternatives
					youtu\.be/    # Either youtu.be,
					| youtube\.com  # or youtube.com
					(?:           # Group path alternatives
					/embed/     # Either /embed/
					| /v/         # or /v/
					| /watch\?v=  # or /watch\?v=
					)             # End path alternatives.
					)               # End host alternatives.
					([\w-]{10,12})  # Allow 10-12 for 11 char youtube id.
					$%x';
		
		$result = preg_match($pattern, $url, $matches);
		
		if (false !== $result) {
			return $matches[1];
		}
		
		return false;
		
	}





	/*
    	Resize images, example wprs_resize($img_url, 100, 75, true);
		@since 1.0.0
		Note: not sure if I am going to use this function!
    	*/

	/**
	* Title : Aqua Resizer
	* Description : Resizes WordPress images on the fly
	* Version : 1.1.6
	* Author : Syamil MJ
	* Author URI : http://aquagraphite.com
	* License : WTFPL - http://sam.zoy.org/wtfpl/
	* Documentation : https://github.com/sy4mil/Aqua-Resizer/
	*
	* @param string $url - (required) must be uploaded using wp media uploader
	* @param int $width - (required)
	* @param int $height - (optional)
	* @param bool $crop - (optional) default to soft crop
	* @param bool $single - (optional) returns an array if false
	* @uses wp_upload_dir()
	* @uses image_resize_dimensions() | image_resize()
	* @uses wp_get_image_editor()
	*
	* @return str|array
	*/

	function wprs_resize( $url, $width, $height = null, $crop = null, $single = true ) {
		//validate inputs
		if(!$url OR !$width ) return false;

		//define upload path & dir
		$upload_info = wp_upload_dir();
		$upload_dir = $upload_info['basedir'];
		$upload_url = $upload_info['baseurl'];

		//check if $img_url is local
		if(strpos( $url, $upload_url ) === false) return false;

		//define path of image
		$rel_path = str_replace( $upload_url, '', $url);
		$img_path = $upload_dir . $rel_path;

		//check if img path exists, and is an image indeed
		if( !file_exists($img_path) OR !getimagesize($img_path) ) return false;

		//get image info
		$info = pathinfo($img_path);
		$ext = $info['extension'];
		list($orig_w,$orig_h) = getimagesize($img_path);

		//get image size after cropping
		$dims = image_resize_dimensions($orig_w, $orig_h, $width, $height, $crop);
		$dst_w = $dims[4];
		$dst_h = $dims[5];

		//use this to check if cropped image already exists, so we can return that instead
		$suffix = "{$dst_w}x{$dst_h}";
		$dst_rel_path = str_replace( '.'.$ext, '', $rel_path);
		$destfilename = "{$upload_dir}{$dst_rel_path}-{$suffix}.{$ext}";

		if(!$dst_h) {
			//can't resize, so return original url
			$img_url = $url;
			$dst_w = $orig_w;
			$dst_h = $orig_h;
		}
		//else check if cache exists
		elseif(file_exists($destfilename) && getimagesize($destfilename)) {
			$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
		}
		//else, we resize the image and return the new resized image url
		else {

			// Note: This pre-3.5 fallback check will edited out in subsequent version
			if(function_exists('wp_get_image_editor')) {

				$editor = wp_get_image_editor($img_path);

				if ( is_wp_error( $editor ) || is_wp_error( $editor->resize( $width, $height, $crop ) ) )
				return false;

				$resized_file = $editor->save();

				if(!is_wp_error($resized_file)) {
					$resized_rel_path = str_replace( $upload_dir, '', $resized_file['path']);
					$img_url = $upload_url . $resized_rel_path;
				} else {
					return false;
				}

			} else {

				$resized_img_path = image_resize( $img_path, $width, $height, $crop ); // Fallback foo
				if(!is_wp_error($resized_img_path)) {
					$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
					$img_url = $upload_url . $resized_rel_path;
				} else {
					return false;
				}

			}

		}

		//return the output
		if($single) {
			//str return
			$image = $img_url;
		} else {
			//array return
			$image = array (
				0 => $img_url,
				1 => $dst_w,
				2 => $dst_h
			);
		}

		return $image;
	}


	
	/*
		Retrieves the attachment ID from the file URL
		
		@link http://wordpress.stackexchange.com/questions/6645/turn-a-url-into-an-attachment-post-id
		@since 1.3.1
		@updated 1.4.2
		*/
	function wprs_get_image_id($url) {
		
		$dir = wp_upload_dir();

        // baseurl never has a trailing slash
        if ( false === strpos( $url, $dir['baseurl'] . '/' ) ) {
            // URL points to a place outside of upload directory
            return false;
        }

        $file  = basename( $url );
        $query = array(
            'post_type'  => 'attachment',
            'fields'     => 'ids',
            'meta_query' => array(
                array(
                    'key'     => '_wp_attached_file',
                    'value'   => $file,
                    'compare' => 'LIKE',
                ),
            )
        );

        // query attachments
        $ids = get_posts( $query );

        if ( ! empty( $ids ) ) {

            foreach ( $ids as $id ) {

                // first entry of returned array is the URL
				$try_url = wp_get_attachment_image_src( $id, 'full' );
                if ( $url === array_shift( $try_url ) )
                    return $id;
            }
        }

        $query['meta_query'][0]['key'] = '_wp_attachment_metadata';

        // query attachments again
        $ids = get_posts( $query );

        if ( empty( $ids) )
            return false;

        foreach ( $ids as $id ) {

            $meta = wp_get_attachment_metadata( $id );
			
			if ( ! empty($meta['sizes']) ) {
            	
				foreach ( $meta['sizes'] as $size => $values ) {
					
					$attachment_image_src = wp_get_attachment_image_src( $id, $size );
            	    
					if ( $values['file'] === $file && $url === array_shift( $attachment_image_src ) )
            	        return $id;
            	}
			
			}
        }

        return false;
		
		/*
		if ( empty( $image_url ) ) return null;
		
		global $wpdb;
		
		$prefix = $wpdb->prefix;
		//$attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM " . $prefix . "posts" . " WHERE guid='%s';", $image_url ));
		$attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid='%s';", $image_url )); 
		return $attachment[0]; 
        return !empty( $attachment ) ? $attachment[0] : null;
		*/
	}
	

	/*
		Add image sizes
		@since 1.0.0
		Note: to be used in widgets and by add-ones
		*/
	add_action( 'after_setup_theme', 'wprs_add_image_sizes' );
	function wprs_add_image_sizes() {
		add_image_size( 'wprs-image', 728, 300, array( 'center', 'center' ) );
		add_image_size( 'wprs-thumb', 320, 180, false );
	}

	add_filter('image_size_names_choose', 'wprs_show_image_sizes');
	function wprs_show_image_sizes($sizes) {
		$sizes['wprs-image'] = __( 'WPRS Image', 'wprs' );
		$sizes['wprs-thumb'] = __( 'WPRS Thumb', 'wprs' );
		return $sizes;
	}


	/*
		Return cons
		@since 1.0.0
		*/
	function wprs_cons($id){	
		global $wprs_prefix;
		
		$display = get_post_meta( $id, $wprs_prefix.'display_pros_cons', true ) ? true : false;
		if ($display) return;
		
		$cons = get_post_meta( $id, $wprs_prefix.'cons', true ) ? get_post_meta( $id, $wprs_prefix.'cons', true ) : '';
		$content ='';
		
		if ($cons !='') {
			$content .= '<div class="wprs_cons">';
			$content .= '<h3><i class="fa fa-thumbs-down"></i> '. __('Cons', 'wprs') .'</h3>';
			$content .= '<p>' . $cons . '</p>';
			$content .= '</div>';
		}
		
		return apply_filters( 'wprs_cons', $content );

	}
	
	
	/*
		Return pros
		@since 1.0.0
		*/
	function wprs_pros($id){	
		global $wprs_prefix;
		
		$display = get_post_meta( $id, $wprs_prefix.'display_pros_cons', true ) ? true : false;
		if ($display) return;
		
		$pros = get_post_meta( $id, $wprs_prefix.'pros', true ) ? get_post_meta( $id, $wprs_prefix.'pros', true ) : '';
		$content ='';
		
		if ($pros !='') {
			$content .= '<div class="wprs_pros">';
			$content .= '<h3><i class="fa fa-thumbs-up"></i> '. __('Pros', 'wprs') .'</h3>';
			$content .= '<p>' . $pros . '</p>';
			$content .= '</div>';
		}
		
		return apply_filters( 'wprs_pros', $content );

	}
		
	
	/*
		Return restaurant cuisine categories
		@since 1.0.0
		*/
	function wprs_get_cuisine($id){
		global $wprs_prefix;
		
		$cuisine = '';
		
		$cuisine_1 = get_post_meta( $id, $wprs_prefix.'cuisine_1', true ) ? get_post_meta( $id, $wprs_prefix.'cuisine_1', true ) : '';
		$cuisine_2 = get_post_meta( $id, $wprs_prefix.'cuisine_2', true ) ? get_post_meta( $id, $wprs_prefix.'cuisine_2', true ) : '';
		$cuisine_3 = get_post_meta( $id, $wprs_prefix.'cuisine_3', true ) ? get_post_meta( $id, $wprs_prefix.'cuisine_3', true ) : '';
		
		if ($cuisine_1) { $cuisine .= '<span itemprop="servesCuisine">'.$cuisine_1.'</span>'; }
		if ($cuisine_2) { $cuisine .= ', <span itemprop="servesCuisine">'.$cuisine_2.'</span>'; }
		if ($cuisine_3) { $cuisine .= ', <span itemprop="servesCuisine">'.$cuisine_3.'</span>'; }
		
		if ($cuisine) {
			$cuisine = '<div class="wprs_cuisine"><i class="fa fa-tags"></i> ' . $cuisine . '</div>';
		}
		
		return $cuisine;
		
	}
	
	/*
		Return openning hours
		@since 1.0.0
		*/
	function wprs_get_openhours($id){
		global $wprs_prefix;
		$openhours = '';
		$myarray = array();
		$myarray = get_post_meta( $id, $wprs_prefix.'openinghours', true ) ? get_post_meta( $id, $wprs_prefix.'openinghours', true ) : '';
		
		$days = array(
					'Su' => 'Sun',
					'Mo' => 'Mon',
					'Tu' => 'Tue',
					'We' => 'Wed',
					'Th' => 'Thu',
					'Fr' => 'Fri',
					'Sa' => 'Sat'
				);
		
		if (!empty($myarray)) {
			$openhours .= '<div class="wprs_opentime">';
			$openhours .= '<ul>';
			foreach($myarray as $key => $element){
				$from_day = isset($days[$element['from_day']]) ? $days[$element['from_day']] : '';
				$to_day = isset($days[$element['to_day']]) ? $days[$element['to_day']] : '';
				$openhours .= '<li><i class="fa fa-clock-o"></i> ';
				$openhours .= '<meta itemprop="openingHours" content="'.$element['from_day'].'-'.$element['to_day'].' '.$element['from_time'].'-'.$element['to_time'].'">';
				$openhours .= '<span><b>'.$from_day.' - '.$to_day.'</b></span> ';
				$openhours .= '<span>'.date("g:ia", strtotime($element['from_time'])).' - '.date("g:ia", strtotime($element['to_time'])).'</span>';
				$openhours .= '</li>';
			}
			$openhours .= '</ul>';
			$openhours .= '</div>';
		}
		
		return $openhours;
		
	}
	

	/*
		Return take reservation
		@since 1.0.0
		*/
	function wprs_get_reservations($id){
		global $wprs_prefix;
		$reservations = get_post_meta( $id, $wprs_prefix.'reservations', true ) ? true : false;
		if ($reservations) return '<div class="wprs_reservations"><span>Take Reservations: Yes!</span></div>';
		
		return;
		
	}
	
	
	/*
		Return take reservation
		@since 1.0.0
		*/
	function wprs_get_restaurant_menu($id){
		global $wprs_prefix;
		$menu_url = get_post_meta( $id, $wprs_prefix.'restaurant_menu', true ) ? get_post_meta( $id, $wprs_prefix.'restaurant_menu', true ) : '';
		if ($menu_url) return '<div class="wprs_restaurant_menu"><span>'.__('View','wprs').' <a itemprop="menu" href="'.$menu_url.'" rel="nofollow">menu</a></span></div>';
		
		return;
		
	}
	

	/*
 		Grab all attributes for a given shortcode in a text
 	
 		@uses get_shortcode_regex()
		@uses shortcode_parse_atts()
		@param  string $tag   Shortcode tag
		@param  string $id  post ID
 		@return array  $out   Array of attributes
		@since 1.3
 		*/
	function wprs_get_shortcode_attributes( $id, $tag) {
		
		$content_post = get_post($id);
		$text = $content_post->post_content;
		//$text = apply_filters('the_content', $content);
		//$text = str_replace(']]>', ']]&gt;', $content);
		
		preg_match_all( '/' . get_shortcode_regex() . '/s', $text, $matches );
		$out = array();
		if( isset( $matches[2] ) ) {
			foreach( (array) $matches[2] as $key => $value ) {
				if( $tag === $value ) $out[] = shortcode_parse_atts( $matches[3][$key] );  
			}
		}
	
		return $out;
	
	}

	
	/*
 		Get publisher markup
		@since 1.3.1
 		*/
	function wprs_get_publisher_markup( $id ) {
		
		global $wprs_prefix;
		
		$snippets_type = get_post_meta( $id, $wprs_prefix.'snippets_types', TRUE );
		$review_type = get_post_meta( $id, $wprs_prefix.'review_type', TRUE );
		
		$out = '';
		
		if ( $snippets_type == 'Article' ) {
			
			$options = get_option('wprs_options');
			
			$context = 'http://schema.org/';
			$type = 'Organization';
			
			// get values from plugn settings
			// @since 1.4.2
			$publisher_name 	= (isset($options['wprs_publisher_name']) && $options['wprs_publisher_name'] !='') ? $options['wprs_publisher_name'] : get_bloginfo('name');
			$publisher_url 		= (isset($options['wprs_publisher_url']) && $options['wprs_publisher_url'] !='') ? $options['wprs_publisher_url'] : get_bloginfo('url');
			$publisher_logo_url = (isset($options['wprs_publisher_logo_url']) && $options['wprs_publisher_logo_url'] !='') ? $options['wprs_publisher_logo_url'] : get_header_image('url');
			
			// use post meta to override plugin settings if user set thier values
			// @since 1.4.2
			$publisher_name_meta = get_post_meta( $id, $wprs_prefix.'publisher_name', TRUE );
			if ( isset($publisher_name_meta) && $publisher_name_meta !='' ) $publisher_name = $publisher_name_meta;
			
			$publisher_url_meta = get_post_meta( $id, $wprs_prefix.'publisher_url', TRUE );
			if ( isset($publisher_url_meta) && $publisher_url_meta !='' ) $publisher_url = $publisher_url_meta;
			
			$publisher_logo_url_meta = get_post_meta( $id, $wprs_prefix.'publisher_logo_url', TRUE );
			if ( isset($publisher_logo_url_meta) && $publisher_logo_url_meta !='' ) $publisher_logo_url = $publisher_logo_url_meta;
			
			// Get entity canonical link
			$entity_url = get_permalink ($id);
			
			$image_width = '';
			$image_height = '';
		
			$out .= '<div itemprop="publisher" itemscope itemtype="'.$context.$type.'">';
			$out .= '<meta itemprop="url" content="'.$publisher_url.'">';
			$out .= '<div itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">';
			$out .= '<meta itemprop="url" content="'.$publisher_logo_url.'">';
			$out .= '<meta itemprop="width" content="'.$image_width.'">';
			$out .= '<meta itemprop="height" content="'.$image_height.'">';
			$out .= '</div>';
			$out .= '<meta itemprop="name" content="'.$publisher_name.'">';
			$out .= '</div>';
			$out .= '<meta itemscope itemprop="mainEntityOfPage"  itemType="https://schema.org/WebPage" itemid="'.$entity_url.'">';
		}
		
		return $out;
		
	}


/*
	Get ImageObject for a video thumb, by video thumb url
	this special case is needed on Article Votes.
	@since 1.3.9
*/
function wprs_get_video_thumb_mageObject( $img_url ) {
		
	if ( ! isset($img_url) ) return;
		
	$ImageObject = '';
		
	list( $width, $height, $type, $attr ) = getimagesize( $img_url );

	$ImageObject .= '<div itemprop="image" itemscope itemtype="https://schema.org/ImageObject">';
	$ImageObject .= '<meta itemprop="url" content="'.$img_url.'">';
	$ImageObject .= '<meta itemprop="width" content="'.$width.'">';
	$ImageObject .= '<meta itemprop="height" content="'.$height.'">';
	$ImageObject .= '</div>';
	
	//echo $ImageObject; exit;
				
	return $ImageObject;	
}

	
	/*
 		Get rating stars display
		@since 1.3.4
 		*/	
	function wprs_get_display_rating( $id, $type ) {
		
		global $post;
		
		// Set post id
		if ( ! isset($id) && isset($post->ID) ) $id = $post->ID;
		
		// Set rating display type
		if ( ! isset($type)) $type = '';
		
		//if ( ! wprs_is_enabled($post->ID) ) return;
		
		// Get WPRS template 
		$template = wprs_template($id);
	
		// Check if WPRS is active on entry, if not then return $content
		if ($template['snippets_type'] == '') return;
	
		// Define
		$display = '';
		
		switch ($type) {
			
			case 'mini':
				
				// Get display from template based on type
				switch ($template['review_type']) {
	
					case 'rating':

						$display = '<div class="wprs_dr_rating">' . $template['editor_star_rating'] . '</div>';
						break;
							
					case 'percentage':

						$display = '<div class="wprs_dr_percentage">' . $template['progressbar_editor'] . '</div>';
						break;
			
					case 'votes':

						$display = '<div class="wprs_dr_votes">' . $template['user_star_rating'] . '</div>';	
						break;
							
					case 'aggregate':

						$display = '<div class="wprs_dr_aggregate">' . $template['user_star_aggregate'] . '</div>';
						break;
				}
				break;
			
			case '': // Default
				
				// Get display from template based on type
				switch ($template['review_type']) {
	
					case 'rating':
						
						$display .= '<div class="wprs_display_rating">';
						$display .= '<ul>';
						$display .= '<li><h4><span>'. apply_filters('wprs_text_editor_rating', __('Editor Rating', 'wprs')) .'</span></h4></li>';
						$display .= '<li>'.$template['editor_star_rating'].'</li>';
						$display .= '<li>'.$template['score_editor'].'</li>';
						$display .= '</ul>';
						$display .= '</div>';
					
						break;
							
					case 'percentage':
						
						$display .= '<div class="wprs_display_percentage">';
						$display .= '<ul>';
						$display .= '<li><h4><span>'. apply_filters('wprs_text_editor_rating', __('Editor Rating', 'wprs')) .'</span></h4></li>';
						$display .= '<li>'.$template['progressbar_editor'].'</li>';
						$display .= '</ul>';
					
						break;
			
					case 'votes':
						
						$display .= '<div class="wprs_display_votes">';
						$display .= '<ul>';
						$display .= '<li><h4><span>'. apply_filters('wprs_text_readers_rating', __('Readers Rating', 'wprs')) .'</span></h4></li>';
						$display .= '<li>'.$template['user_star_rating'].'</li>';
						$display .= '<li>'.$template['score_user'].'</li>';
						$display .= '</ul>';
						$display .= '</div>';
						
						$display = '<div class="wprs_display_votes">' . $template['user_star_rating'] . '</div>';	
						break;
							
					case 'aggregate':
						
						$display .= '<div class="wprs_display_aggregate">';
						$display .= '<ul>';
						$display .= '<li><h4><span>'. __('User Rating', 'wprs') .'</span></h4></li>';
						$display .= '<li>'.$template['user_star_aggregate'].'</li>';
						$display .= '<li>'.$template['score_user'].'</li>';
						$display .= '</ul>';
						$display .= '</div>';
						
						break;
				}

		}
		
		return $display;	
	}




	/*
 		Get rating stars display with no markups
		@since 1.4
 		*/	
	function wprs_get_display_rating_output( $id = null, $type = '' ) {
		
		global $post;
		
		// Set post id
		if ( ! isset($id) && isset($post->ID) ) $id = $post->ID;
		
		// Set rating display type
		if ( ! isset($type)) $type = 'stars';
		
		//if ( ! wprs_is_enabled($post->ID) ) return;
		
		// Get WPRS template 
		$template = wprs_template($id);
	
		// Check if WPRS is active on entry, if not then return $content
		if ($template['snippets_type'] == '') return;
	
		// Define
		$display = '';
		$fa_star = '<i class="fa fa-star" aria-hidden="true"></i> ';
		switch ($type) {
			
			case 'mini':
				
				// Get display from template based on type
				switch ($template['review_type']) {
	
					case 'rating':
						
						//$review_rating = $template['review_rating'];
						$review_rating = get_post_meta($id,'_wprs_post_star_rating', true);
						$display = '<span class="wprs_dr_rating wprs_rating_mini">' . $fa_star . $review_rating . '</span>';
						break;
							
					case 'percentage':
						$review_rating = get_post_meta($id,'_wprs_post_slider_percentage', true);
						$display = '<span class="wprs_dr_percentage wprs_rating_mini">' . $review_rating . ' %</span>';
						break;
			
					case 'votes':
						$review_rating = get_post_meta($id,'_wprs_post_user_rating', true);
						$display = '<span class="wprs_dr_votes wprs_rating_mini">' . $fa_star . $review_rating . '</span>';	
						break;
							
					case 'aggregate':
						$review_rating = get_post_meta($id,'_wprs_post_userrating_average', true);
						$display = '<span class="wprs_dr_aggregate wprs_rating_mini">' . $fa_star . $review_rating . '</span>';
						break;
				}
				break;
			
			case 'default': // Default
				
				// Get display from template based on type
				switch ($template['review_type']) {
	
					case 'rating':
						$display = '<span class="wprs_dr_rating">' . $template['editor_star_rating_no_markup'] . '</span>';
						break;
							
					case 'percentage':
						$display = '<span class="wprs_dr_percentage">' . $template['progressbar_editor'] . '</span>';
						break;
			
					case 'votes':
						$display = '<span class="wprs_dr_votes">' . $template['user_star_rating_raw'] . '</span>';	
						break;
							
					case 'aggregate':
						$display = '<span class="wprs_dr_aggregate">' . $template['user_star_aggregate_raw'] . '</span>';
						break;
				}

		}
		
		return $display;	
	}


/**
 * Get recipe nutrition
 *
 * @param string $post_id
 * @since 1.3.7
 * @return string
 */
function wprs_get_recipe_nutrition( $post_id = null ) {
		
	global $post, $wprs_prefix;
		
	// Set post id
	if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
		
	// Get meta values
	$meta = wprs_get_meta_by_id( $post_id );
		
	// Get Recipe ingredients
	$recipe_nutrition_calories = isset($meta[$wprs_prefix.'recipe_nutrition_calories']) ? $meta[$wprs_prefix.'recipe_nutrition_calories'] : '';
	$recipe_nutrition_fatContent = isset($meta[$wprs_prefix.'recipe_nutrition_fatContent']) ? $meta[$wprs_prefix.'recipe_nutrition_fatContent'] : '';
		
	// Define
	$display = '';
		
	$display .= '<div class="row wprs_recipe_nutrition" itemprop="nutrition" itemscope itemtype="http://schema.org/NutritionInformation">';
	//$display .= __('Nutrition:', 'wprs');
     		
	if ( $recipe_nutrition_calories != '' ) {
		
		$display .= '<div class="col-xs-6 col-sm-6 col-md-6">';	
		$display .= '<i class="fa fa-circle-thin" aria-hidden="true"></i><span itemprop="calories">' . $recipe_nutrition_calories . '</span>';
		$display .= '</div>';
	}
		
	if ( $recipe_nutrition_fatContent != '' ) {
		
		$display .= '<div class="col-xs-6 col-sm-6 col-md-6">';	
		$display .= '<i class="fa fa-circle-thin" aria-hidden="true"></i><span itemprop="fatContent">' . $recipe_nutrition_fatContent . '</span>';
		$display .= '</div>';
	}
		
	$display .= '</div>';
		
	return $display;	
}


	/*
 		Get Recipe ingredients 
		@since 1.3.7
 		*/	
	function wprs_get_recipe_ingredients( $post_id = null ) {
		
		global $post, $wprs_prefix;
		
		// Set post id
		if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
		
		// Get meta values
		$meta = wprs_get_meta_by_id( $post_id );
		
		// Get Recipe ingredients
		$recipe_ingredients = isset($meta[$wprs_prefix.'recipe_ingredients']) ? $meta[$wprs_prefix.'recipe_ingredients'] : '';
		
		if ( $recipe_ingredients == '' ) return '';
		
		// Define
		$display = '';
		
		$list = explode("\n", $recipe_ingredients); // or use PHP PHP_EOL constant
		
		if ( !empty($list) ) {
			
			$display .= '<div class="row wprs_recipe_ingredients">';
			
			foreach ( $list as $item ) {
				$display .= '<div class="col-xs-6 col-sm-6 col-md-6">';
				
					$display .= '<div class="col-xs-2 col-sm-1 col-md-1">';
						$display .= '<i class="fa fa-circle-thin" aria-hidden="true"></i>';
					$display .= '</div>';
					
					$display .= '<div class="col-xs-10 col-sm-11 col-md-11">';
						$display .= '<span itemprop="recipeIngredient">'.trim( $item ) .'</span>';
					$display .= '</div>';
				
				//$display .= '<span itemprop="recipeIngredient">';
				//$display .= '<i class="fa fa-circle-thin" aria-hidden="true"></i>';
				//$display .= trim( $item ) .'</span>';
				$display .= '</div>';
			}
			
			$display .= '</div>';
		}
		
	
		return $display;	
	}



	/*
 		Get Recipe instructions 
		@since 1.3.7
 		*/	
	function wprs_get_recipe_instructions( $post_id = null ) {
		
		global $post, $wprs_prefix;
		
		// Set post id
		if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
		
		// Get meta values
		$meta = wprs_get_meta_by_id( $post_id );
		
		// Get Recipe instructions
		$recipe_instructions = isset($meta[$wprs_prefix.'recipe_instructions']) ? $meta[$wprs_prefix.'recipe_instructions'] : '';
		
		// Define
		$display = '';
		
		$list = explode("\n", $recipe_instructions); // or use PHP PHP_EOL constant
		
		if ( !empty($list) ) {
			
			$display .= '<ol class="wprs_recipe_instructions">';
			
			$i = 1;
			
			foreach ( $list as $item ) {
				$display .= '<li><span itemprop="recipeInstructions">'. trim( $item ) .'</span></li>';
				$i++;
			}
			
			$display .= '</ol>';
		}
		
		return $display;	
	}
	
	
/*
	Get Recipe serves 
	@since 1.3.7
*/	
function wprs_get_recipe_serves( $post_id = null ) {
		
	global $post, $wprs_prefix;
		
	// Set post id
	if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
		
	// Get meta values
	$meta = wprs_get_meta_by_id( $post_id );
		
	// Get Recipe serves
	$recipe_serves = isset($meta[$wprs_prefix.'recipe_serves']) ? $meta[$wprs_prefix.'recipe_serves'] : '';
		
	// Define
	$display = '';
		
	if ( $recipe_serves != '' ) {
			
		$display .= '<span itemprop="recipeYield"><nobr>' . $recipe_serves . '</nobr></span>';
	}
		
	return $display;	
}

	
	
/**
 * Get recipe prep time
 *
 * @param string $post_id
 * @since 1.3.7
 * @return string
 */
function wprs_get_recipe_prep_time( $post_id = null ) {
		
	global $post, $wprs_prefix;
		
	// Set post id
	if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
	
	// Get meta values
	$meta = wprs_get_meta_by_id( $post_id );
		
	// Get Recipe ingredients
	$recipe_prep_time = isset($meta[$wprs_prefix.'recipe_prep_time']) ? $meta[$wprs_prefix.'recipe_prep_time'] : '';
		
	// Define
	$display = '';
	
	if ( $recipe_prep_time != '' ) {
		$pt = wprs_get_time_to_iso8601_duration ( $recipe_prep_time );
		$display .= '<meta itemprop="prepTime" content="'.$pt.'">'.$recipe_prep_time;
	}
		
	return $display;	
}


/**
 * Get recipe cook time
 *
 * @param string $post_id
 * @since 1.3.7
 * @return string
 */
function wprs_get_recipe_cook_time( $post_id = null ) {
		
	global $post, $wprs_prefix;
		
	// Set post id
	if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
	
	// Get meta values
	$meta = wprs_get_meta_by_id( $post_id );
		
	// Get Recipe ingredients
	$recipe_cook_time = isset($meta[$wprs_prefix.'recipe_cook_time']) ? $meta[$wprs_prefix.'recipe_cook_time'] : '';
		
	// Define
	$display = '';
	
	if ( $recipe_cook_time != '' ) {
		$pt = wprs_get_time_to_iso8601_duration ( $recipe_cook_time );
		$display .= '<meta itemprop="cookTime" content="'.$pt.'">'.$recipe_cook_time;
	}
	
	return $display;	
}



/**
 * Get recipe total time
 *
 * @param string $post_id
 * @since 1.3.7
 * @return string
 */
function wprs_get_recipe_total_time( $post_id = null ) {
		
	global $post, $wprs_prefix;
		
	// Set post id
	if ( ! isset($post_id) && isset($post->ID) ) $post_id = $post->ID;
	
	// Get meta values
	$meta = wprs_get_meta_by_id( $post_id );
		
	// Get Recipe ingredients
	$recipe_total_time = isset($meta[$wprs_prefix.'recipe_total_time']) ? $meta[$wprs_prefix.'recipe_total_time'] : '';
		
	// Define
	$display = '';
	
	if ( $recipe_total_time != '' ) {
		$pt = wprs_get_time_to_iso8601_duration ( $recipe_total_time );
		$display .= '<meta itemprop="totalTime" content="'.$pt.'">'.$recipe_total_time;
	}
	
	return $display;	
}



/**
 * Get time in ISO format
 *
 * @param string $timeString
 * @since 1.3.7
 * @return string The time in ISO format if we can recognise a time, else an empty string
 */
function wprs_get_time_to_iso8601_duration($timeString) {
	if (empty($timeString)) return '';

	$timeString = preg_replace('/(hours?|hrs?|h)/', 'H', $timeString);
    $timeString = preg_replace('/(minutes?|mins?|mi|m)/', 'M', $timeString);
    $timeString = str_replace(' ', '', $timeString);
    if (!preg_match('/^(?:(\d+)H)?(?:(\d+)M)?$/', $timeString, $regs)) {
    	return '';
    }
    $time = $regs[1] * 60 + $regs[2];
    $minutes = $time % 60;
    $hours = floor(($time - $minutes) / 60);
    return sprintf("PT%dH%dM", $hours, $minutes);
}


/**
 * Get time Seconds in ISO format
 *
 * @link http://stackoverflow.com/questions/13301142/php-how-to-convert-string-duration-to-iso-8601-duration-format-ie-30-minute
 * @param string $time
 * @since 1.3.8
 * @return string The time Seconds in ISO format
 */
function wprs_get_time_second_to_iso8601_duration( $time ) {
	$units = array(
        "Y" => 365*24*3600,
        "D" =>     24*3600,
        "H" =>        3600,
        "M" =>          60,
        "S" =>           1,
    );

    $str = "P";
    $istime = false;

    foreach ($units as $unitName => &$unit) {
        $quot  = intval($time / $unit);
        $time -= $quot * $unit;
        $unit  = $quot;
        if ($unit > 0) {
            if (!$istime && in_array($unitName, array("H", "M", "S"))) { // There may be a better way to do this
                $str .= "T";
                $istime = true;
            }
            $str .= strval($unit) . $unitName;
        }
    }

    return $str;
}




/**
 * Get WP_oEmbed by key
 *
 * @param string $url, $key
 * @since 1.3.8
 * @return string|array
 */
function wprs_get_WP_oEmbed( $url, $key) {
	
	$return = '';
	
	if ( ! class_exists('WP_oEmbed')) {
		require_once( ABSPATH . WPINC . '/class-oembed.php' );
	}
	
	$WP_oEmbed = new WP_oEmbed();
	$provider = $WP_oEmbed->discover( $url );
	$data = $WP_oEmbed->fetch( $provider, $url );
	$return = $data->$key;
	
	return $return;
}
