<?php
/*
 WARNING: This file is part of the core WPRichSnippets plugin. DO NOT edit
 this file under any circumstances.
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// actions
add_action( 'admin_init', 'wprs_admin_init' );							// to register admin styles and scripts
add_action( 'wp_enqueue_scripts', 'wprs_stylesheet' );					// load styles

// filters
//add_filter( 'plugin_action_links', 'wprs_add_settings_link', 10, 2 );	// add setting link in plugins page


	// ------------------------------------------------------------------------
	// add admin init 
	// load Font Awesome 
	// @since 1.0.0                                        
	// ------------------------------------------------------------------------
	function wprs_admin_init() {
		wp_enqueue_style ( 'wprs-admin',	WPRS_CSS_URL.'style_admin.css'								);
		//wp_enqueue_style ( 'font-awesome',	WPRS_INC_URL.'extras/font-awesome/assets/css/font-awesome.min.css');
	}

	// ------------------------------------------------------------------------
	// load our css                                           
	// ------------------------------------------------------------------------
	function wprs_stylesheet() {
		
		if (is_admin()) return;
		
		$options = get_option('wprs_options');
		// load CSS file
		// only if it's not disabled within the plugin settings
		// @since 1.0.0
		if ( isset($options['wprs_chk_no_css']) != true ) {
			wp_register_style('wprs', WPRS_CSS_URL.'style_front.css');
            wp_enqueue_style( 'wprs');
        }
		
		// load Bootstrap
		// only if it's not disabled within the plugin settings
		// @since 1.0.0
		if ( isset($options['wprs_no_bootstrap']) != true ) {
			wp_register_style('wprs-bootstrap', WPRS_CSS_URL.'bootstrap.min.css');
       		wp_enqueue_style( 'wprs-bootstrap');
		}
    }
	
	

	// ------------------------------------------------------------------------
	// add settings link to plugins page                                              
	// ------------------------------------------------------------------------
	function wprs_add_settings_link($links, $file) {
		static $this_plugin;
		if (!$this_plugin) $this_plugin = plugin_basename(__FILE__);
 
		if ($file == $this_plugin){
			$settings_link = '<a href="admin.php?page=wprs">'.__("Settings", "wprs").'</a>';
			array_unshift($links, $settings_link);
		}
	
		return $links;
	}



add_action( 'wprs_init', 'wprs_load_me' );
/**
 * Loads all the files and features.
 *
 * @since 1.0
 */
function wprs_load_me() {

	/** Load */
	
	
	//* settings & options & post meta
	include_once( WPRICHSNIPPETS_ADMIN_URL . 'wprs-settings.php' );
	include_once( WPRICHSNIPPETS_ADMIN_URL . 'wprs-options.php' );
	include_once( WPRICHSNIPPETS_ADMIN_URL . 'wprs-post-meta.php' );
	//* post meta class
	include_once( WPRICHSNIPPETS_ADMIN_URL . 'meta/class-meta.php' );
	//* filters
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'wprs-filters.php' );
	//* includes
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'wprs-functions.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'schema/wprs-box.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'schema/wprs-schema.php' );
	
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'extras/wprs-slider.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'extras/wprs-video.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'extras/wprs-video-featured.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'extras/wprs-integration.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'extras/font-awesome/load-font-awesome.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'extras/resizer.php' );
	
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'user-rating/wprs-user-rating-functions.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'user-rating/wprs-votes.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'user-rating/wprs-votes-script.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'user-rating/wprs-aggregate.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'user-rating/wprs-aggregate-template.php' );
	//* admin notices
	include_once( WPRICHSNIPPETS_ADMIN_URL 	  . 'includes/admin-notices.php' );
	//* widgets
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'widgets/wprs-widget.php' );
	//* shortcodes
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'shortcodes/wprs-cons-shortcode.php' );
	include_once( WPRICHSNIPPETS_INCLUDES_URL . 'shortcodes/wprs-pros-shortcode.php' );
	//* templates
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'Article/wprs-Article-rating.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'Article/wprs-Article-percentage.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'Article/wprs-Article-votes.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'Article/wprs-Article-aggregate.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'Article/wprs-Article-none.php' );
	
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'review/wprs-review-rating.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'review/wprs-review-percentage.php' );
	
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'Recipe/wprs-Recipe-votes.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'Recipe/wprs-Recipe-aggregate.php' );
	
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'product/wprs-product-rating.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'product/wprs-product-percentage.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'product/wprs-product-votes.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'product/wprs-product-aggregate.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'product/wprs-product-none.php' );
	
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'organization/wprs-organization-votes.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'organization/wprs-organization-aggregate.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'organization/wprs-organization-none.php' );

	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'restaurant/wprs-restaurant-votes.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'restaurant/wprs-restaurant-aggregate.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'restaurant/wprs-restaurant-none.php' );

	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'SoftwareApplication/wprs-SoftwareApplication-votes.php' );
	include_once( WPRICHSNIPPETS_TEMPLATES_URL . 'SoftwareApplication/wprs-SoftwareApplication-aggregate.php' );
	
}
 
/** Run the wprs_init hook */
do_action( 'wprs_init' );
