<?php
/*
	Plugin Name: WP Rich Snippets
	Plugin URI: https://wprichsnippets.com/
	Description: Add Schema Structured Markup for Better WordPress SEO.
	Version: 1.4.8
    Author: Hesham Zebida
    Author URI: http://zebida.com
    Last Version update : 10 October 2017
	Text Domain: wprs
	Domain Path: /lib/languages
	
	@author   WPRichSnippets
	@license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
	@link     https://wprichsnippets.com/
	*/


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

add_action( 'wprs_init', 'wprs_constants' );
/**
 * This function defines the WPRichSnippets constants
 *
 * @since 1.0
 */
function wprs_constants() {
	
	define( 'WPRICHSNIPPETS_PLUGINNAME', 'WP Rich Snippets' );
	// plugin version
	define( 'WPRICHSNIPPETS_VER', '1.4.8' );
	// plugin website
	define( 'WPRICHSNIPPETS_WEBSITE_URL', 'http://wprichsnippets.com' );


	// define plugin URLs
	if ( ! defined( 'WPRICHSNIPPETS_URL' ) )
		define( 'WPRICHSNIPPETS_URL', plugin_dir_path( __FILE__ ) );
	define( 'WPRICHSNIPPETS_LIB_URL', trailingslashit( WPRICHSNIPPETS_URL . 'lib' ) );
	define( 'WPRICHSNIPPETS_ASSETS_URL', trailingslashit( WPRICHSNIPPETS_URL . 'assets' ) );
	//* admin
	define( 'WPRICHSNIPPETS_ADMIN_URL', trailingslashit( WPRICHSNIPPETS_LIB_URL . 'admin' ) );
	//* includes
	define( 'WPRICHSNIPPETS_INCLUDES_URL', trailingslashit( WPRICHSNIPPETS_LIB_URL . 'includes' ) );
	define( 'WPRICHSNIPPETS_MISC_URL', trailingslashit( WPRICHSNIPPETS_INCLUDES_URL . 'misc' ) );
	define( 'WPRICHSNIPPETS_TEMPLATES_URL', trailingslashit( WPRICHSNIPPETS_INCLUDES_URL . 'schema/templates' ) );
	//* assets
	define( 'WPRICHSNIPPETS_JS_URL', trailingslashit( WPRICHSNIPPETS_ASSETS_URL . 'js' ) );
	define( 'WPRICHSNIPPETS_CSS_URL', trailingslashit( WPRICHSNIPPETS_ASSETS_URL . 'css' ) );
	define( 'WPRICHSNIPPETS_IMG_URL', trailingslashit( WPRICHSNIPPETS_ASSETS_URL . 'images' ) );
	
	// define plugin URLs, for fast enqueuing scripts and styles
	if ( ! defined( 'WPRS_URL' ) )
		define( 'WPRS_URL', plugin_dir_url( __FILE__ ) );
	define( 'WPRS_INC_URL', trailingslashit( WPRS_URL . 'lib/includes' ) );
	define( 'WPRS_JS_URL', trailingslashit( WPRS_URL . 'assets/js' ) );
	define( 'WPRS_CSS_URL', trailingslashit( WPRS_URL . 'assets/css' ) );

}

 
add_action('init', 'wprs_localization_init');
/**
 * Localization: Load the WPRichSnippets textdomain for internationalization.
 *
 * @uses load_plugin_textdomain()
 *
 * @since 1.0
 */
function wprs_localization_init() {
	
	$path = dirname(plugin_basename( __FILE__ )) . '/lib/languages/';
	$loaded = load_plugin_textdomain('wprs', false, $path);
	if(isset($_GET['page'])) {
		if ($_GET['page'] == basename(__FILE__) && !$loaded) {          
			echo '<div class="error">WPRichSnippets Localization: ' . __('Could not load the localization file: ' . $path, 'wprs') . '</div>';
			return;
		}
	}
}


add_action( 'admin_init', 'wprs_requires_wordpress_version' );
/**
 * Require minimum version of WordPress 4.0+
 *
 * @since 1.0
 */
function wprs_requires_wordpress_version() {
		global $wp_version;
		$plugin = plugin_basename( __FILE__ );
		$plugin_data = get_plugin_data( __FILE__, false );

		if ( version_compare($wp_version, "4.0", "<" ) ) {
			if( is_plugin_active($plugin) ) {
				deactivate_plugins( $plugin );
				wp_die(
					"'".$plugin_data['Name']."' requires WordPress 4.0 or higher, and has been deactivated! Please upgrade WordPress and try again.<br /><br />Back to <a href='".admin_url()."'>WordPress admin</a>."
				);
				exit;
		}
		
	}
}

add_action( 'admin_init', 'wprs_sl_updater', 0 );
/**
 * Check for plugin updates
 *
 * @uses wprs_sl_updater()
 *
 * @since 1.0
 */
function wprs_sl_updater() {
	
	if( ! is_admin() ) {
			return;
		}
		
	// Retrieve our license key from the DB
	$license = get_option( 'wprs_license_key' );
	
	// If license is not set, then exit
	if (!isset($license)) return;
	
	$license = trim( $license );
	
	// Setup the updater
	$edd_updater = new WPRS_SL_Plugin_Updater( WPRICHSNIPPETS_WEBSITE_URL, __FILE__, array( 
			'version' 	=> WPRICHSNIPPETS_VER, 			// current version number
			'license' 	=> $license, 					// license key (used get_option above to retrieve from DB)
			'item_name' => WPRICHSNIPPETS_PLUGINNAME, 	// name of this plugin
			'item_id'   => 118,							// add-on post ID
			'author' 	=> 'Hesham Zebida',  			// author of this plugin
			'url'		=> home_url(),
			'beta'		=> false 
		)
	);
}




//register_activation_hook( __FILE__,		'wprs_activation_hook' );
/*
	Plugin activation 
	*/
	function wprs_activation_hook(){
		
	// this will run when the plugin is activated
	// @todo setup the database
	//do_action( 'wprs_plugin_activate' );
		
	// Report plugin activation to the site
	$url = 'http://wprichsnippets.com/';
	$url .= '?wprs-software-activate=true';
	$url .= '&site-name='.str_replace(" ", "-", get_bloginfo('name'));
	$url .= '&site-url='.get_bloginfo('url');
	$url .= '&software-name=wprs';
	$url .= '&software-version=1-4-8';
	$args = array(
		'body'      => array(), // no body sent!
		'blocking'  => false,
		'sslverify' => false,
		);
	$wprs_activation = wp_remote_post( $url, $args );
		
	if( ! function_exists('curl_exec')) {
		// Deactivate the plugin
        deactivate_plugins(__FILE__);

        // Show the error page, Maybe this shouldn't happen?
        wp_die(
           	__('You must enable cURL support to use the '.WPRICHSNIPPETS_PLUGINNAME.' plugin!'),
            __('Error')
        );
    }
		
}
	

//register_deactivation_hook( __FILE__,	'wprs_deactivation_hook' );
/*
	Plugin deactivation 
	*/
function wprs_deactivation_hook(){
	// this will run when the plugin is deactivated
	// @todo use to delete the plugin settings from database if chosen by user
		 
	// Report plugin activation to the site
	$url = 'http://wprichsnippets.com/';
	$url .= '?wprs-software-deactivate=true';
	$url .= '&site-name='.str_replace(" ", "-", get_bloginfo('name'));
	$url .= '&site-url='.get_bloginfo('url');
	$url .= '&software-name=wprs';
	$url .= '&software-version=1-4-8';
	$args = array(
		'body'      => array(), // no body sent!
		'blocking'  => false,
		'sslverify' => false,
		);
	
	$wprs_activation = wp_remote_post( $url, $args );
		
}

	

/**
 * Start the engine
 *
 * @since 1.0
 */
include_once( 'lib/init.php' );
