<?php

namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Setup_Wizard\Api;
use Barn2\Plugin\Password_Protected_Categories\Dependencies\Setup_Wizard\Step;
use Barn2\Plugin\Password_Protected_Categories\Dependencies\Setup_Wizard\Util;
use Barn2\Plugin\Password_Protected_Categories\PPC_Util;

/**
 * Password_Protection step.
 *
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Password_Protection extends Step {

	/**
	 * Configure the step.
	 */
	public function __construct() {
		$this->set_id( 'password-protection' );
		$this->set_name( __( 'Password protection', 'password-protected-categories' ) );
		$this->set_description( __( 'Customize the login form for your protected categories', 'password-protected-categories' ) );
		$this->set_title( __( 'Password protection', 'password-protected-categories' ) );
		$this->set_tooltip( __( 'The password login form appears if someone tries to access a password protected category. You can also insert login forms anywhere using the shortcode [category_login]', 'password-protected-categories' ) );
		$this->set_hidden( true );
	}

	/**
	 * {@inheritdoc}
	 */
	public function setup_fields() {
		$fields = [];

		$pages = PPC_Util::get_pages( true );

		$selected_page = PPC_Util::get_option( 'central_login_page' );

		$fields['password_expires'] = [
			'type'        => 'number',
			'label'       => esc_html__( 'Password expiry (days)', 'password-protected-categories' ),
			'description' => esc_html__( 'How long the category stays unlocked before the password expires.', 'password-protected-categories' ),
			'value'       => absint( PPC_Util::get_option( 'password_expires' ) ),
		];

		$fields['central_login_page'] = [
			'type'        => 'select',
			'label'       => __( 'Central login page', 'password-protected-categories' ),
			'alt_label'   => esc_html__( 'Select page', 'password-protected-categories' ),
			'description' => __( "Optional: set this if you want a central password entry page, where users can 'unlock' their category. You can also add a password form anywhere using the shortcode [category_login].", 'password-protected-categories' ),
			'options'     => Util::parse_array_for_dropdown( $pages ),
			'value'       => $selected_page,
		];

		$fields['form_title'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Title', 'password-protected-categories' ),
			'description' => esc_html__( 'The title of the login page. You can use the placeholder {title} to show the name of the current post or category.', 'password-protected-categories' ),
			'value'       => PPC_Util::get_option( 'form_title' ),
		];

		$fields['form_message'] = [
			'type'        => 'textarea',
			'label'       => esc_html__( 'Login message', 'password-protected-categories' ),
			'description' => esc_html__( 'The message for the login form. You can use HTML here.', 'password-protected-categories' ),
			'value'       => PPC_Util::get_option( 'form_message' ),
		];

		return $fields;
	}

	/**
	 * {@inheritdoc}
	 */
	public function submit( array $values ) {
		$options     = PPC_Util::get_options();
		$request     = $this->get_request();
		$pure_values = $request->get_param( 'values' );

		$password_expires   = isset( $values['password_expires'] ) && $values['password_expires'] !== 0 ? $values['password_expires'] : false;
		$central_login_page = isset( $values['central_login_page'] ) ? $values['central_login_page'] : false;

		$form_title = $values['form_title'];

		// Get the form message from the request, as it may contain HTML.
		$form_message = isset( $pure_values['form_message'] ) ? wp_kses_post( $pure_values['form_message'] ) : $values['form_message'];

		$options['password_expires']   = $password_expires;
		$options['central_login_page'] = $central_login_page;
		$options['form_title']         = $form_title;
		$options['form_message']       = $form_message;

		if ( $central_login_page ) {
			PPC_Util::save_category_login_page( $central_login_page, PPC_Util::get_central_login_page_id() );
		}

		PPC_Util::update_options( $options );

		return Api::send_success_response();
	}
}
