<?php

namespace Barn2\Plugin\Password_Protected_Categories;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Lib\Registerable;

/**
 * The class implements the category login shortcode.
 *
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Login_Shortcode implements Registerable {

	const SHORTCODE = 'category_login';

	public function register() {
		// Register shortcode
		\add_shortcode( self::SHORTCODE, [ $this, 'login_shortcode' ] );
	}

	public function login_shortcode( $atts = [] ) {
		$atts = \shortcode_atts(
			[
				'message' => PPC_Util::get_login_form_message()
			],
			$atts,
			self::SHORTCODE
		);

		$password_form = new Password_Form();
		return $password_form->get_password_form( $atts['message'] );
	}

}
