<?php

namespace Barn2\Plugin\Password_Protected_Categories;

/**
 * Factory to create/return the shared plugin instance.
 *
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Plugin_Factory {

	private static $plugin = null;

	/**
	 * Create/return the shared plugin instance.
	 *
	 * @param string $file The main plugin file.
	 * @param string $version The current version.
	 * @return Plugin The plugin instance.
	 */
	public static function create( $file, $version = '1.0' ) {
		if ( null === self::$plugin ) {
			self::$plugin = new Plugin( $file, $version );
		}
		return self::$plugin;
	}

}
