<?php
/**
 *	Plugin Name:	WP-SpamShield Anti-Malware & Functional Integrity Scanner Module
 *	Plugin URI:		https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/
 *	Description:	A module of WP-SpamShield that checks for malicious plugin files and ensures plugin functional integrity. (Required for WP-SpamShield functionality.)
 *	Version:		1.9.45
 *	Author:			Red Sand Media Group and Blackhawk Cybersecurity
 *	Author URI:		https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/
 *	Text Domain:	wp-spamshield
 *	Domain Path:	/lang
 */

/**
 *	Anti-Malware & Functional Integrity Scanner Module (AMIS)
 *	Packaged with WP-SpamShield plugin
 *	The AMIS module of WP-SpamShield checks for malicious plugin files, ensures plugin functional integrity, and prevents security issues.
 *	This MU plugin (AMIS) is required for full functionality of WP-SpamShield. Do not disable or delete, as WP-SpamShield manages this as needed.
 *	This will be automatically removed during WP-SpamShield uninstall process as needed.
 *	@since 1.9.20
 */

/* Make sure file remains secure if called directly */
if( !defined( 'ABSPATH' ) ) {
	if( !headers_sent() ) { @header( 'HTTP/1.0 403 Forbidden', TRUE, 403 ); @header( 'X-Robots-Tag: noindex', TRUE ); }
	die( 'ERROR: Direct access to this file is not allowed.' );
}

/* WPSS_DEBUG / SSAMIS_DEBUG - Do not change value unless tech support asks you to - for debugging only. Change in wp-config.php. */
if( !defined( 'WPSS_DEBUG' ) ) { define( 'WPSS_DEBUG', FALSE ); }; if( !defined( 'SSAMIS_DEBUG' ) ) { define( 'SSAMIS_DEBUG', FALSE ); }
/* Prevents unintentional error display if WP_DEBUG not enabled. */
if( TRUE !== WP_DEBUG ) { @ini_set( 'display_errors', 0 ); @error_reporting( 0 ); }

define( 'SSAMIS_VERSION',			'1.9.45'				); /* `SSAMIS`, Pronounced like 'SEAMUS' */
define( 'SSAMIS_VERSION_DATE',		'2019-10-31'			);
define( 'SSAMIS_WP_VERSION',		$GLOBALS['wp_version']	);
define( 'SSAMIS_REQ_WP_VER',		'4.4'					);
define( 'SSAMIS_REQ_PHP_VER',		'5.6'					);
define( 'SSAMIS_PHP_TEST_MAX',		'7.3'					);	/* MAX PHP VERSION TESTED */
define( 'SSAMIS_PHP_UPDATE_REQ',	'7.5'					);	/* PHP VERSION REQUIRES PLUGIN UPDATE */
define( 'SSAMIS_WP_UPDATE_REQ',		'5.5'					);	/* WP  VERSION REQUIRES PLUGIN UPDATE */

/**
 *	Setting required constants...
 */
define( 'SSAMIS_SITE_URL',			untrailingslashit( strtolower( home_url() ) )	);
define( 'SSAMIS_SITE_DOM',			ssamis_get_domain( SSAMIS_SITE_URL )			);

$SSAMIS_CONSTANTS = 
	array
	(
		'REQUEST_TIME'	=> ( $SSAMIS_REQ_TS = time() ),
		'REQ_TS'		=> $SSAMIS_REQ_TS,
		'LOADED'		=> TRUE,
		'L0'			=> ( $SSAMIS_L0 = ( ( defined( 'PHP_INT_MAX' ) ) ? PHP_INT_MAX : 999999999 ) ),
		'F0'			=> ( $SSAMIS_F0 = -$SSAMIS_L0 ),
		'F1'			=> ( $SSAMIS_F1 = (int) $SSAMIS_F0 + 1 ),
		'L1'			=> ( $SSAMIS_L1 = (int) abs( $SSAMIS_F1 ) ),
		'F2'			=> ( $SSAMIS_F2 = (int) $SSAMIS_F0 + 2 ),
		'L2'			=> ( $SSAMIS_L2 = (int) abs( $SSAMIS_F2 ) ),
		'DATE_DAY'		=> date( 'Ymd', $SSAMIS_REQ_TS ),
		'THIS_HOUR'		=> ( $SSAMIS_THIS_HOUR = date( 'Y-m-d H', $SSAMIS_REQ_TS ) ),
		'HASH_HOUR'		=> md5( $SSAMIS_THIS_HOUR ),
		'BUFFER_ID'		=> 'SSAMIS_BUFFER_' . $SSAMIS_REQ_TS,
		'SERVER_NAME'	=> ssamis_get_server_name(),
		'SERVER_ADDR'	=> ( !empty( $_SERVER['SERVER_ADDR'] ) && ssamis_is_valid_ip( $_SERVER['SERVER_ADDR'], TRUE ) ) ? $_SERVER['SERVER_ADDR'] : '',
		'THIS_URL'		=> ( $SSAMIS_THIS_URL = ssamis_get_url() ),
		'THIS_DOM'		=> ssamis_get_domain( $SSAMIS_THIS_URL ),
		'THIS_PATH'		=> ( $SSAMIS_THIS_PATH = untrailingslashit( __DIR__ ) ),
		'SS_BASENAME'	=> ssamis_ecto( 'd3Atc3BhbXNoaWVsZC93cC1zcGFtc2hpZWxkLnBocA' ),
		'AMIS_TITLE'	=> ssamis_ecto( 'V1AtU3BhbVNoaWVsZCBBbnRpLU1hbHdhcmUgJiBGdW5jdGlvbmFsIEludGVncml0eSBTY2FubmVyIE1vZHVsZQ' ),
		'VER_SLUG'		=> ssamis_get_ver_slug( SSAMIS_VERSION ),
		'ADMIN_URL'		=> untrailingslashit( admin_url() ),
		'PLUGIN_ADMIN'	=> ( isset( $GLOBALS['pagenow'], $_GET['page'] ) && 'options-general.php' === $GLOBALS['pagenow'] && 'wp-spamshield' === $_GET['page'] ),
		'STG'			=> ( preg_match( "~/[s5][t7][a4]g[i1]ng\-*([s5][i1][t7][e3])?\d*/(wp\-*)?[ck][o0]nt[e3]n[t7]/~i", $SSAMIS_THIS_PATH ) ),
	);
foreach( (array) $SSAMIS_CONSTANTS as $k => $v ) {
	$CN_SLUG = 'SSAMIS_'.$k; if( !defined( $CN_SLUG ) ) { define( $CN_SLUG, $v ); }; if( isset( ${$CN_SLUG} ) ) { unset( ${$CN_SLUG} ); }
}; unset( $SSAMIS_CONSTANTS, $CN_SLUG, $k, $v );

/**
 *	Returns 1.
 *	Useful for returning 1 to filters easily. Like `__return_zero()`, `__return_true()`, `__return_false()`, etc.
 *	@dependencies	...
 *	@used by		...
 *	@since			1.9.35
 */
if( !function_exists( '__return_one' ) ) {
	function __return_one() { return 1; }
}

/* Fix translations, settings, etc. */
add_filter( 'gettext', 'ssamis_fix_translations', SSAMIS_L0, 3 );
add_action( 'muplugins_loaded', 'ssamis_fix_options', SSAMIS_L0 );
add_action( 'activated_plugin', 'ssamis_fix_options', SSAMIS_L0 );
add_action( 'deactivated_plugin', 'ssamis_fix_options', SSAMIS_L0 );
add_action( 'admin_notices', 'ssamis_admin_notices', SSAMIS_F0 );
add_filter( 'plugin_action_links_'.'wp-spamshield/wp-spamshield.php', 'ssamis_action_links', 10000, 4 );

/* Fix for WP Engine Incorrectly Caching Plugin JS URLs */
if( defined( 'WPE_APIKEY' ) || defined( 'WPE_PLUGIN_VERSION' ) ) {
	if( !isset( $GLOBALS['wpengine_platform_config'] ) || !is_array( $GLOBALS['wpengine_platform_config'] ) ) {
		$GLOBALS['wpengine_platform_config'] = array( 'no_cdn_uris' => array(), );
	}
	if( !isset( $GLOBALS['wpe_no_cdn_uris'] ) || !is_array( $GLOBALS['wpe_no_cdn_uris'] ) ) {
		$GLOBALS['wpe_no_cdn_uris'] = array();
	}
	if( !isset( $GLOBALS['wpengine_platform_config']['no_cdn_uris'] ) || !is_array( $GLOBALS['wpengine_platform_config']['no_cdn_uris'] ) ) {
		$GLOBALS['wpengine_platform_config']['no_cdn_uris'] = array();
	}
	$GLOBALS['wpengine_platform_config']['no_cdn_uris'][] = $GLOBALS['wpe_no_cdn_uris'][] = 'spamshield';
}

/**
 *	Allow manual override by admins (NOT RECOMMENDED)
 *	Usage -- add one of the following to `wp-config.php`
 *	- Enabled (Default):			"define( 'WPSS_AMIS_SCAN_DISABLE', FALSE );"
 *	- Disabled (NOT RECOMMENDED):	"define( 'WPSS_AMIS_SCAN_DISABLE',  TRUE );"
 */
if( defined( 'WPSS_AMIS_SCAN_DISABLE' ) && TRUE === WPSS_AMIS_SCAN_DISABLE ) {
	if( !defined( 'SSAMIS_OVERRIDE' ) ) { define( 'SSAMIS_OVERRIDE', TRUE ); }
}

/**
 *	Malicious Signatures
 *	Scans for fake malware plugin "X-WP-SPAM-SHIELD-PRO" (which is in no way associated with the real WP-SpamShield).
 *	More Info: https://www.redsandmarketing.com/blog/malware-alert-x-wp-spam-shield-pro-fake-plugin/
 */
$mal_keys	= array( 'spam-shield-pro', 'x-wp-spam-shield' );
$mal_dmc	= "~/.*wp\-*spam\-*shield.*/(.*/)*class\.plugin\-modules\.php~i";
$mal_rgx	= "~((x\-*)?wp\-*)?spam\-*shield\-*pro~i";

if(
	( !defined( 'SSAMIS_OVERRIDE' ) || TRUE !== SSAMIS_OVERRIDE )
	&&
	( ( is_admin() || ( defined( 'DOING_CRON' ) && DOING_CRON ) ) || ( !empty( $_SERVER['REQUEST_METHOD'] ) && 'POST' === $_SERVER['REQUEST_METHOD'] ) )
) {
	/**
	 *	Directories
	 */
	$mu_files = ssamis_scandir( __DIR__ );
	$pl_files = ssamis_scandir( WP_PLUGIN_DIR );
	foreach( $mu_files as $i => $file ) {
		if( $file === basename( __FILE__ ) ) { continue; }
		$path = __DIR__ . DIRECTORY_SEPARATOR . $file;
		foreach( $mal_keys as $i => $k ) {
			if( FALSE !== stripos( $path, $k ) ) {
				if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue 2; }
			}
		}
		if( preg_match( $mal_rgx, $path ) ) {
			if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue; }
		}
		$file_contents = trim( @file_get_contents( $path ) );
		if( !empty( $file_contents ) && FALSE !== strpos( $file_contents, 'wp-spamshield' ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue; }
	}
	foreach( $pl_files as $i => $file ) {
		$path = WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . $file;
		foreach( $mal_keys as $i => $k ) {
			if( FALSE !== stripos( $path, $k ) || preg_match( $mal_rgx, $path ) ) {
				if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue 2; }
				if( @is_dir( $path ) ) { ssamis_rmdir_deep( $path ); continue 2; }
			}
		}
		if( preg_match( $mal_dmc, $path ) ) {
			ssamis_dmc( 'set' );
			if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue; }
			if( @is_dir( $path ) ) { ssamis_rmdir_deep( $path ); continue; }
		}
		if( preg_match( $mal_rgx, $path ) ) {
			if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue; }
			if( @is_dir( $path ) ) { ssamis_rmdir_deep( $path ); continue; }
		}
	}
}

/**
 *	Get domain from URL
 *	Filter URLs with nothing after http
 *	@dependencies	none
 *	@used by		...
 *	@since			1.9.42
 */
function ssamis_get_domain( $url ) {
	if( empty( $url ) || !is_string( $url ) || preg_match( "~^https?\:*/*$~i", $url ) ) { return ''; }
	$parsed = parse_url( $url );
	return ( $domain = ( ( !empty( $parsed['host'] ) ) ? strtolower( $parsed['host'] ) : '' ) );
}

/**
 *	Get server name
 *	@dependencies	none
 *	@used by		...
 *	@since			1.9.44
 */
function ssamis_get_server_name() {
	if( ssamis_is_php_cli() ) { return SSAMIS_SITE_DOM; }
	global $_SSAMIS_ENV, $SSAMIS_SERVER_NAME;
	if( !empty( $SSAMIS_SERVER_NAME ) ) {
		if( empty( $_SERVER['SERVER_NAME'] ) || empty( $_SERVER['HTTP_HOST'] ) || $SSAMIS_SERVER_NAME !== $_SERVER['SERVER_NAME'] || $SSAMIS_SERVER_NAME !== $_SERVER['HTTP_HOST'] ) {
			$_SSAMIS_ENV['HTTP_HOST'] = $_SSAMIS_ENV['SERVER_NAME'] = $_SERVER['HTTP_HOST'] = $_SERVER['SERVER_NAME'] = $SSAMIS_SERVER_NAME;
		}
		return $SSAMIS_SERVER_NAME;
	}
	/**
	 *	Secondary mitigation for CVE-2017-8295: https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-8295 | @since 1.9.44
	 */
	if( empty( $_SERVER['SERVER_NAME'] ) || ( isset( $_SERVER['HTTP_HOST'], $_SERVER['SERVER_NAME'] ) && $_SERVER['SERVER_NAME'] !== $_SERVER['HTTP_HOST'] ) ) {
		$server_name = SSAMIS_SITE_DOM;
		if( !empty( $server_name ) ) {
			$_SSAMIS_ENV['HTTP_HOST'] = $_SSAMIS_ENV['SERVER_NAME'] = $_SERVER['HTTP_HOST'] = $_SERVER['SERVER_NAME'] = $server_name;
		}
	} else {
		if( !empty( $_SERVER['SERVER_NAME'] ) ) { $server_name = $_SERVER['HTTP_HOST'] = $_SERVER['SERVER_NAME']; }
		elseif( !empty( $_SSAMIS_ENV['SERVER_NAME'] ) ) { $server_name = $_SERVER['HTTP_HOST'] = $_SERVER['SERVER_NAME'] = $_SSAMIS_ENV['SERVER_NAME']; }
		$server_name = strtolower( trim( $server_name ) );
		if( empty( $server_name ) || '.' === $server_name ) {
			$server_name = ( !empty( ( SSAMIS_SITE_DOM ) ) ) ? SSAMIS_SITE_DOM : '';
		}
	}
	$server_name = ( empty( $server_name ) ) ? SSAMIS_SITE_DOM : $server_name;
	if( !empty( $server_name ) ) {
		$_SSAMIS_ENV['HTTP_HOST'] = $_SSAMIS_ENV['SERVER_NAME'] = $_SERVER['HTTP_HOST'] = $_SERVER['SERVER_NAME'] = $server_name;
	}
	return $server_name;
}

/**
 *	Get the URL of current page/post/etc.
 *	@dependencies	ssamis_is_https()
 *	@used by		...
 *	@since			1.9.44
 *	@param			$display		bool		Use TRUE to make safe for output. The difference between esc_url and esc_url_raw is that esc_url_raw doesn't replace ampersands and single quotes.
 *	@param			$server_name	string		(optional)
 */
function ssamis_get_url( $display = FALSE, $req_uri = FALSE, $server_name = '' ) {
	if( ssamis_is_php_cli() ) { return ( TRUE === $req_uri ) ? '/' : SSAMIS_SITE_URL . '/'; }
	global $_SSAMIS_ENV, $SSAMIS_SERVER_NAME;
	if( empty( $server_name ) || !is_string( $server_name ) ) {
		$server_name = ( !empty( $SSAMIS_SERVER_NAME ) ) ? $SSAMIS_SERVER_NAME : ( $SSAMIS_SERVER_NAME = ssamis_get_server_name() );
	}
	$scheme			= ( ssamis_is_https() ) ? 'https://' : 'http://';
	$site_url		= $scheme . $server_name;
	$url			= $site_url . $_SERVER['REQUEST_URI'];
	if( TRUE === $req_uri ) {
		return ( str_replace( $site_url, '', ( esc_url_raw( $url ) ) ) );
	}
	return ( TRUE === $display ) ? esc_url( $url ) : esc_url_raw( $url );
}

/**
 *	Get version slug.
 *	Provides error correction for non-standard version strings: ex. pre-release versions () alpha, beta, RC, etc.)
 *	@dependencies	none
 *	@used by		...
 *	@since			1.9.42
 */
function ssamis_get_ver_slug( $ver ) {
	if( empty( $ver ) || ( !is_string( $ver ) && !is_numeric( $ver ) ) ) { return FALSE; }
	$tmp = str_replace( '.', '', (string) $ver );
	$arr = preg_split( "~[a-z]+~i", $tmp );
	$tmp = ( ( !empty( $arr ) && is_array( $arr ) ) ? $arr[0] : $tmp );
	$tmp = $slug = strtok( $tmp, 'a' ); strtok( '', '' );
	return $slug;
}

/**
 *	Detect https/http
 *	Use instead of WP function is_ssl(), as this is more accurate
 *	@dependencies	none
 *	@used by		...
 *	@since			1.9.44
 */
function ssamis_is_https() {
	return (
			( !empty( $_SERVER['HTTPS'] )					&& 'off'	!==	$_SERVER['HTTPS']					)
		||	( !empty( $_SERVER['SERVER_PORT'] )				&& '443'	 ==	$_SERVER['SERVER_PORT']				)
		||	( !empty( $_SERVER['HTTP_X_FORWARDED_PROTO'] )	&& 'https'	=== $_SERVER['HTTP_X_FORWARDED_PROTO']	)
		||	( !empty( $_SERVER['HTTP_X_FORWARDED_SSL'] )	&& 'off'	!== $_SERVER['HTTP_X_FORWARDED_SSL']	)
	);
}

/**
 *	Check if PHP SAPI is CLI
 *	@dependencies	none
 *	@since			1.9.42
 */
function ssamis_is_php_cli() {
	return ( ( defined( 'WP_CLI' ) && WP_CLI ) || 0 === strpos( PHP_SAPI, 'cli' ) );
}

/**
 *	Check if string is a private IP Address
 *	@dependencies	none
 *	@used by		...
 *	@since			1.9.44
 */
function ssamis_is_private_ip( $ip ) {
	if( empty( $ip ) || !is_string( $ip ) || ( FALSE === strpos( $ip, '.' ) && FALSE === strpos( $ip, ':' ) ) ) { return FALSE; }
	return ( filter_var( $ip, FILTER_VALIDATE_IP ) && !filter_var( $ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE ) );
}

/**
 *	Check if string is a reserved IP Address
 *	@dependencies	none
 *	@used by		...
 *	@since			1.9.44
 */
function ssamis_is_reserved_ip( $ip ) {
	if( empty( $ip ) || !is_string( $ip ) || ( FALSE === strpos( $ip, '.' ) && FALSE === strpos( $ip, ':' ) ) ) { return FALSE; }
	return ( filter_var( $ip, FILTER_VALIDATE_IP ) && !filter_var( $ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_RES_RANGE ) );
}

/**
 *	Check if string is a valid IP Address or IPv4 C-Block
 *	@dependencies	none
 *	@since			1.9.44
 */
function ssamis_is_valid_ip( $ip, $incl_priv_res = FALSE, $ipv4_c_block = FALSE ) {
	if( empty( $ip ) || !is_string( $ip ) || ( FALSE === strpos( $ip, '.' ) && FALSE === strpos( $ip, ':' ) ) ) { return FALSE; }
	return ( TRUE === $ipv4_c_block ) ? ( preg_match( "~^((\d\d?|1\d\d|2[0-4]\d|25[0-5])\.){3}$~", $ip ) ) : ( ( TRUE === $incl_priv_res ) ? ( filter_var( $ip, FILTER_VALIDATE_IP ) ) : ( filter_var( $ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE ) ) );
}

/**
 *	Drop-in replacement for PHP function scandir()
 *	Has sanitation and error correction built-in
 *	@dependencies	none
 *	@since			1.9.20
 */
function ssamis_scandir( $dir ) {
	if( empty( $dir ) || ! @is_string( $dir ) ) { return $dir; }; @clearstatcache();
	$dot_files	= array( '..', '.' );
	$dir_listr	= (array) @scandir( $dir );
	$dir_list	= array_values( array_diff( $dir_listr, $dot_files ) );
	return $dir_list;
}

/**
 *	Drop-in replacement for PHP function rmdir(), Recursive
 *	@dependencies	none
 *	@since			1.9.20
 */
function ssamis_rmdir_deep( $path ) {
	$i = new DirectoryIterator( $path );
	foreach( $i as $f ) {
		if( $f->isFile() ) {
			@unlink( $f->getRealPath() );
		} elseif( ! $f->isDot() && $f->isDir() ) {
			ssamis_rmdir_deep( $f->getRealPath() );
		}
	}
	@rmdir( $path );
}

/**
 *	Filter the plugin data array in preparation for output to the plugins table.
 *	@dependencies	...
 *	@used by		...
 *	@since			1.9.35
 */
function ssamis_filter_plugin_data( $all_plugins ) {
	/**
	 *	$all_plugins = array(
	 *		$plug_bn	=> array( 'Name', 'PluginURI', 'Version', 'Description', 'Author', 'AuthorURI', 'TextDomain', 'DomainPath', 'Network', 'Title', 'AuthorName', )
	 *	);
	 *	$plug_bn	= 'folder/filename.php'; // Plugin Basename
	 */
	$desc =
		array(
			'wp-spamshield/wp-spamshield.php'	=> '<strong>Illegal Pirated/Hacked Software</strong> &mdash; The unauthorized reproduction or distribution of a copyrighted work is illegal. Criminal copyright infringement, including infringement without monetary gain, is investigated by the FBI and other international law enforcement agencies and is punishable by fines and imprisonment. Pirated software ("nulled", "warez", "shared", etc.) is extremely dangerous to use, and almost always contain malware that will compromise your website to hackers. These sites claim to be benevolent, but they exist solely to distribute malware-laden software and hack your website.<br /><br />

			To get a legitimate, legal, and safe copy of this software, you can <a href="https://www.redsandmarketing.com/go/cc/wp-spamshield/" >purchase it here</a>.',
		);
	$mod_plugins = array();
	foreach( $all_plugins as $plug_bn => $plugin_data ) {
		$file = trim( basename( __FILE__ ), DIRECTORY_SEPARATOR );
		$plugin_data['Name'] = ( 'WP-SpamShield Anti-Malware & Functional Integrity Scanner Module' !== $plugin_data['Name'] && ( preg_match( "~^WP\-SpamShield.+~i", $plugin_data['Name'] ) || ( 'WP-SpamShield' === $plugin_data['Name'] && ( empty( $plugin_data['PluginURI'] ) || ssamis_dmc() ) ) ) ) ? 'WP-SpamShield [ILLEGAL PIRATED/HACKED COPY]' : $plugin_data['Name'];
		if( FALSE !== strpos( $plug_bn, '/wp-spamshield.php' ) ) { $desc[$plug_bn] = $desc['wp-spamshield/wp-spamshield.php']; }
		if( !empty( $desc[$plug_bn] ) && ( FALSE !== strpos( $plugin_data['Name'], '[ILLEGAL PIRATED/HACKED COPY]' ) || ssamis_dmc() ) ) { ssamis_dmc( 'set' ); $plugin_data['Description'] = $desc[$plug_bn]; }
		$mod_plugins[$plug_bn] = $plugin_data;
	}
	$all_plugins = $mod_plugins; unset( $plug_bn, $plugin_data, $mod_plugins );
	return $all_plugins;
}
add_filter( 'all_plugins', 'ssamis_filter_plugin_data', SSAMIS_L0 );

/**
 *	DMC Check
 *	@dependencies	...
 *	@used by		...
 *	@since			1.9.35
 *	@param			string	$method		'set'|'chk'
 */
function ssamis_dmc( $method = 'chk', $type = 'all', $user_id = '', $dbg_txt = '' ) {
	return FALSE;
}

/**
 *	Drop-in replacement for native PHP function `base64_decode()`.
 *	@dependencies	none
 *	@used by		...
 *	@since			1.9.42
 *	@reference		https://secure.php.net/manual/en/function.base64-decode.php
 */
function ssamis_ecto( $str, $strict = FALSE ) {
	return @base64_decode( $str, $strict );
}

/**
 *	Drop-in replacement for native PHP function `base64_encode()`, with improvements.
 *	@dependencies	none
 *	@used by		...
 *	@since			1.9.42
 *	@reference		https://secure.php.net/manual/en/function.base64-encode.php
 */
function ssamis_endo( $str, $nopad = FALSE ) {
	$b64 = @base64_encode( $str );
	return ( ( TRUE === $nopad ) ? rtrim( $b64, '=' ) : $b64 );
}

/**
 *	Fix erroneous option values.
 *	@dependencies	none
 *	@since			1.9.35
 */
function ssamis_fix_options() {
	if( !empty( $GLOBALS['ssamis_has_run_'.__FUNCTION__] ) ) { return; }; $GLOBALS['ssamis_has_run_'.__FUNCTION__] = TRUE;
	$d_cb = (array) explode( '|', 'true|false|zero|one|null|empty_array|empty_string' );
	$s = 'antispam'; $t = 'turing'; $h = 'honeypot'; $c = str_replace( array( 'uring', '-r', '-', 'k', ), array( 'cha', '-', '', 'c', ), 'k-rap-' . $t ); $a = str_replace( array( 'untie', 'y', 'me' ), array( '', 'i', 'met' ), 'auntie' . 'kysme' ); $r = 're' . $c; $d = 'disable'; $g = 'gwolle_gb-'; $o = 'PO'; $p = 'spam'; $f = 'wpcf7';
	$fix_opts = 
		array( $a.'_' => array( 'comment_nonce' => 'false', 'spam_count' => 'zero', 'ssl_'.$d.'d' => 'false', ), $f.'_' => array( 'use_really_simple_'.$c => 'false', $a.'_comment_check' => 'false', $r.'_actions' => 'empty_array', $r.'_verify_response' => 'false', ), $g.'_' => array( $a.'-active' => 'false', $s.'-answer' => '', $s.'-question' => '', 'form_ajax' => 'false', $h => 'false', 'moderate-entries' => 'true', 'nonce' => 'false', ), $o.'_' => array( $d.'_compat_notices' => 'one', $d.'_admin_warning' => 'one', $d.'_admin_notices' => 'one', 'display_debug_msg' => 'zero', ), 'no_pref' => array( 'comment_max_links' => 3, 'require_name_email' => 'one', 'show_advanced_plugins' => 'false', $a => '', $c => '', $h => '', $r => '', ), );
	$option_hooks = array( 'pre_option_', 'option_', 'pre_update_option_', );
	foreach( $fix_opts as $pref => $a ) {
		$pref = ( 'no_pref' === $pref ) ? '' : $pref;
		foreach( $a as $k => $v ) {
			$cb = ( '' === $v || NULL === $v ) ? '__return_empty_string' : '__return_'.$v;
			$cb = ( !is_callable( $cb ) ) ? function() use ( $v ) { return $v; } : $cb;
			foreach( $option_hooks as $oh ) { add_filter( $oh.$pref.$k, $cb, 100000, 1 ); }
		}
	}
}

/**
 *	Fixes erroneous text translations.
 *	@dependencies	...
 *	@used by		...
 *	@since			1.9.35
 *	@param			string	$translation	Translated text.
 *	@param			string	$text			Text to translate.
 *	@param			string	$domain			Text domain. Unique identifier for retrieving translated strings.
 */
function ssamis_fix_translations( $translation, $text, $domain ) {
	$s = 'antispam'; $t = 'turing'; $h = 'honeypot'; $c = str_replace( array( 'uring', '-r', '-', 'k', ), array( 'cha', '-', '', 'c', ), 'k-rap-' . $t ); $a = str_replace( array( 'untie', 'y', 'me' ), array( '', 'i', 'met' ), 'auntie' . 'kysme' ); $r = 're' . $c;
	$txt_keys	= array( 'wp spamshield', 'spam shield', 'you are not a robot' );
	$dom_keys	= array( 'printful', 'wordpress-seo', $a, );
	$rep_keys	= array();
	$pre_keys	= array();
	$app_keys	= array( 
						'Comment author must fill out name and email' => 
							'(' . 'Required for anti-spam' . ')', 
						'Enter the address here if you <a href="%s">want your site home page to be different from your WordPress installation directory</a>.' => 
							'<strong>' . 'Not recommended.' . '</strong>' . ' ' . 'This can lead to unexpected behavior.' . ' ' . '<br />' . 'For most websites, these should match.', 
					);
	$dom_wl		= array( 'wp-spamshield', );
	$pl_keys	= array( "wp[\-\ ]*spamshield", "rs[\-\ ]*feedburner", "rs[\-\ ]*head[\-\ ]*cleaner", "rs[\-\ ]*system[\-\ ]*diagnostic", "scrapebreaker", );
	$pl_rgx		= "~(" . ( implode( '|', $pl_keys ) ) . ")~i";
	/* Skip Whitelisted Text Domains */
	if( in_array( $domain, $dom_wl, TRUE ) ) { return $translation; }
	/* Search & Replace */
	foreach( $rep_keys as $s => $r ) {
		if( $text === $r ) { continue; }
		if( $text === $s && $translation === $s ) { return $r; }
	}
	/* Search & Prepend */
	foreach( $pre_keys as $s => $p ) {
		if( $text === $p ) { continue; }
		if( $text === $s && $translation === $s ) { return $p.' '.$s; }
	}
	/* Search & Append */
	foreach( $app_keys as $s => $a ) {
		if( $text === $a ) { continue; }
		if( $text === $s && $translation === $s ) { return $s.' '.$a; }
	}
	/* Text String Keys */
	foreach( $txt_keys as $i => $k ) {
		if( FALSE !== stripos( $translation, $k ) || FALSE !== stripos( $text, $k ) ) { return ''; }
	}
	/* Text Domain Keys */
	foreach( $dom_keys as $i => $k ) {
		if( FALSE !== stripos( $domain, $k ) ) {
			if( preg_match( $pl_rgx, $translation ) || preg_match( $pl_rgx, $text ) ) { return ''; }
		}
	}
	return $translation;
}

/**
 *	Filter debug data.
 *	@dependencies	...
 *	@used by		...
 *	@since			1.9.41
 *	@param			array	$data	Debug data.
 */
function ssamis_filter_debug_data( $data ) {
	$db_keys = array( 'mu-plugins', 'dropins', );
	foreach( $db_keys as $k ) { $db_k = 'wp-'.$k; unset( $data[$db_k] ); }
	unset( $data['wp-mu-plugins'] );
	return $data;
}
add_filter( 'debug_information', 'ssamis_filter_debug_data', 100000 );

/**
 *	Filters plugin action links
 *	@dependencies	...
 *	@used by		...
 *	@since			1.9.35
 */
function ssamis_action_links( $actions, $file, $plugin_data, $status ) {
	if( ssamis_dmc() ) {
		$wl_keys = array( 'deactivate', 'delete' ); $wl_actions = $actions;
		foreach( $actions as $k => $v ) { if( !in_array( $k, $wl_keys, TRUE ) ) { unset( $wl_actions[$k] ); } }
		$wl_actions['piracy']	= '<a href="https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/#wordpress_security_note" title="Software Piracy Warning" style="font-weight:bold;color:#FF0000;" ping="https://www.redsandmarketing.com/api/v2/ping/wpss/d1/">' . __( 'Software Piracy Warning', 'wp-spamshield' ) . '</a>';
		$wl_actions['purchase'] = '<a href="https://www.redsandmarketing.com/go/cc/wp-spamshield/" title="Buy the Plugin" style="font-weight:bold;color:#FF0000;" ping="https://www.redsandmarketing.com/api/v2/ping/wpss/d2/">' . __( 'Buy the Plugin', 'wp-spamshield' ) . '</a>';
		$actions = $wl_actions;
	}; return $actions;
}

/**
 *	SECURITY - Checks admin notices.
 */
function ssamis_admin_notices() {
	$po = 'Plugin' . 'Organizer'; 
	$rem_notices = array( array( 'h' => 'admin_notices', 'cb' => array( $po, 'add_ajax_notices' ), 'p' => 10 ), array( 'h' => 'admin_notices', 'cb' => array( $po, 'compatibility_notices' ), 'p' => 1 ), array( 'h' => 'admin_notices', 'cb' => array( $po, 'display_admin_debug' ), 'p' => 10 ), );
	foreach( $rem_notices as $i => $a ) {
		remove_action( $a['h'], $a['cb'], $a['p'] );
	}
}

