<?php
/**
 * Plugin Name: Shipping Details for WooCommerce
 * Plugin URI: http://www.patsatech.com/shop/shipping-details-plugin-for-woocommerce
 * Description: WooCommerce Plugin for Displaying Shipping Tracking Number.
 * Version: 1.8.0.7
 * Author: PatSaTECH
 * Author URI: http://www.patsatech.com
 * Contributors: patsatech
 * Requires at least: 4.5
 * Tested up to: 6.0
 * WC requires at least: 3.0.0
 * WC tested up to: 6.5.1
 *
 * Text Domain: wshipinfo-patsatech
 * Domain Path: /lang/
 *
 * @package Shipping Details for WooCommerce
 * @author PatSaTECH
 */


if(!defined('ABSPATH')){
 exit;
}

$WOOSHIPPINGDETAILSNAME = 'Shipping Details for WooCommerce';
$WOOSHIPPINGDETAILSDIR = basename(__DIR__); $WOOSHIPPINGDETAILSFILE = basename(__FILE__); $WOOSHIPPINGDETAILSABSPATH = __FILE__; $WOOSHIPPINGDETAILSV = '1.8.0.7';

define('SDURL', WP_PLUGIN_URL."/".dirname( plugin_basename( __FILE__ ) ) );

if ( ! class_exists( 'wooshippinginfo' ) ) {

	load_plugin_textdomain('wshipinfo-patsatech', false, dirname( plugin_basename( __FILE__ ) ) . '/lang');

	class wooshippinginfo {

		function __construct() {

			add_action( 'add_meta_boxes', array( $this, 'wshipinfo_metaboxes' ) );

			add_action( 'woocommerce_process_shop_order_meta', array( $this, 'wshipinfo_process_shop_ordermeta' ), 5, 2 );

			add_action( 'woocommerce_order_items_table', array( $this, 'wshipinfo_track_page_shipping_details' ) );

			add_action( 'woocommerce_email_before_order_table', array( $this, 'wshipinfo_email_shipping_details' ) );

			add_action( 'admin_menu', array( $this, 'wshipinfo_select_menu'));

			add_action( 'admin_init', array( $this, 'wshipinfo_register_settings'));

			add_action( 'manage_edit-shop_order_columns', array( $this, 'wshipinfo_add_shipping_column' ), 20, 1 );

			add_action( 'manage_shop_order_posts_custom_column', array( $this, 'wshipinfo_add_shipping_column_details'));

		}

		function wshipinfo_add_shipping_column_details($column){
			global $post, $woocommerce, $the_order;

			if ( empty( $the_order ) || $the_order->id != $post->ID )
				$the_order = new WC_Order( $post->ID );

			switch ( $column ) {
				case "tracking_number" :
				$order_meta = get_post_custom( $the_order->id );
				for ($i=0; $i<=4; $i++){
					if($i == 0){
						if(isset($order_meta['_order_trackno']) && isset($order_meta['_order_trackurl'])){
								$this->admin_shipping_details( $order_meta['_order_trackno'], $order_meta['_order_trackurl'] , $the_order->id);
						}
					}else{
						if(isset($order_meta['_order_trackno'.$i]) && isset($order_meta['_order_trackurl'.$i])){
								$this->admin_shipping_details($order_meta['_order_trackno'.$i] , $order_meta['_order_trackurl'.$i] , $the_order->id);
						}
					}
				}
				break;
			}

		}

		function wshipinfo_add_shipping_column($columns){

			$columns["tracking_number"] = esc_html__('Tracking Number', 'wshipinfo-patsatech');
			return $columns;

		}

		function shipping_details_options($data, $options, $part){

			if ($part == '0' || $part == '' ) {
				$part = '';
			}

			$shipping_companies = $this->get_shipping_list();

			echo '<pre>'.print_r($options,true).'</pre>';

			foreach( $shipping_companies as $k => $v ){

				if (isset($options[$k]) == '1') {
					echo '<option value="'.$k.'" ';
					if ( (isset($data['_order_trackurl'.$part][0]) && $data['_order_trackurl'.$part][0] == $k) || (isset($options['codecanyon_default_courier']) && $options['codecanyon_default_courier'] == $k)) {
						echo 'selected="selected"';
					}
					echo '>'.$v.'</option>';
				}

			}

		}

		function wshipinfo_order_shippingdetails($post) {

			$data = get_post_custom( $post->ID );

			$options = get_option( 'woo_ship_options' );

			$num = 0;

			$tracking_number = '';
			$tracking_courier = '';

			$jsvalues = '';

			foreach ($data as $key => $value) {

				if( strpos($key, '_order_trackno') !== false ){

					if( $num == 0 ){
						$tracking_number = $data['_order_trackno'][0];
						$tracking_courier = $data['_order_trackurl'][0];
					}else{
						$tracking_number = $data['_order_trackno'.$num][0];
						$tracking_courier = $data['_order_trackurl'.$num][0];
						if( $tracking_number != '' ){
							$jsvalues .= 'addShippingDetailsFields("'.$tracking_number.'","'.$tracking_courier.'");';
						}	
					}
					
					$num++;
				}

			}

			$default_courier_js = "javascript:addShippingDetailsFields('','NOTRACK');";

			if( isset($options['codecanyon_default_courier']) ){
				$default_courier_js = "javascript:addShippingDetailsFields('','".$options['codecanyon_default_courier']."');";	
			}
			
			
			?>


			<div id="sdetails-elements">
				<div id="sdetails">
					<ul class="totals">
						<li>
							<label><?php esc_html_e('Tracking Number:', 'wshipinfo-patsatech'); ?></label>
							<br />
							<input type="text" id="_order_trackno" name="_order_trackno" placeholder="Enter Tracking No" value="<?php if (isset($data['_order_trackno'][0])) echo $data['_order_trackno'][0]; ?>" class="first" />
						</li>
						<li>
							<label><?php esc_html_e('Shipping Company:', 'wshipinfo-patsatech'); ?></label><br />
							<select id="_order_trackurl" name="_order_trackurl" onselect="javascript:toggle(this.id);" onclick="javascript:toggle(this.id);" >
								<option value="NOTRACK" <?php if ( isset($data['_order_trackurl'][0]) && $data['_order_trackurl'][0] == 'NOTRACK') {
									echo 'selected="selected"';
								} ?>><?php esc_html_e('No Tracking', 'wshipinfo-patsatech'); ?></option>
								<?php $this->shipping_details_options( $data, $options, '' ); ?>
							</select>
						</li>
						<li id="shownzcourierinfo" style="display: none">
						<h4><?php esc_html_e('Enter the Tracking Number as', 'wshipinfo-patsatech'); ?> <b style="color:red;">LH-14148561</b>.</h4>
						<img src="<?php echo SDURL.'/img/lab1.jpg'; ?>"/>
						</li>
						<li id="showpostnllinfo" style="display: none">
						<h4><?php esc_html_e('Enter the Tracking Number as', 'wshipinfo-patsatech'); ?> <br><b style="color:red;"><?php esc_html_e('TrackingNo-PostalCode', 'wshipinfo-patsatech'); ?></b>.</h4>
						</li>
						<li id="showapcovernight" style="display: none">
						<h4><?php esc_html_e('Enter the Tracking Number as', 'wshipinfo-patsatech'); ?> <br><b style="color:red;"><?php esc_html_e('PostalCode-TrackingNo', 'wshipinfo-patsatech'); ?></b>.</h4>
						</li>
					</ul>
					<input type="button" class="button button-primary" name="save" value="Add More" id="add" onclick="<?php echo $default_courier_js; ?>" />
					<input type="button" class="button button-primary" name="remove" value="Remove" id="remove" style="display:none;" onclick="javascript:removeShippingDetailsFields();" />

					<p id="sdetails-linebreak" style="display:none;">----------------------------------------------</p>
				</div>
			</div>
			<input id="sdetails-current-elements" type="hidden"  value="" />
			<div class="clear"></div>
			<?php

			if( $jsvalues != '' ){

				echo '<script type="text/javascript">
						window.addEventListener("load", function(){
							'.$jsvalues.'
						});
					</script>';

			}

		}

		function wshipinfo_process_shop_ordermeta( $post_id, $post ) {

			global $wpdb, $woocommerce;

			$data = get_post_custom( $post_id );

			$woocommerce_errors = array();

			foreach ($data as $key => $value) {

				if( strpos($key, '_order_trackno') !== false ){

					if( !isset($_POST[$key]) ){

						delete_post_meta( $post_id, $key );

					}

				}

				if( strpos($key, '_order_trackurl') !== false ){

					if( !isset($_POST[$key]) ){

						delete_post_meta( $post_id, $key );

					}

				}

			}
			
			add_post_meta( $post_id, '_order_key', uniqid('order_') );

			$num = 0;

			foreach ($_POST as $key => $value) {

				$tracking_number = '';
				$tracking_courier = '';

				if( strpos($key, '_order_trackno') !== false ){

					if( $num == 0 ){
						$tracking_number = $_POST['_order_trackno'];
						$tracking_courier = $_POST['_order_trackurl'];
						if( $tracking_number != '' ){
							update_post_meta( $post_id, '_order_trackno', stripslashes( $tracking_number ));
				
							update_post_meta( $post_id, '_order_trackurl', stripslashes( $tracking_courier ));
						}
					}else{
						$tracking_number = $_POST['_order_trackno'.$num];
						$tracking_courier = $_POST['_order_trackurl'.$num];
						if( $tracking_number != '' ){
							update_post_meta( $post_id, '_order_trackno'.$num, stripslashes( $tracking_number ));
				
							update_post_meta( $post_id, '_order_trackurl'.$num, stripslashes( $tracking_courier ));
						}
					}
					
					$num++;
				}

			}





		}

		function wshipinfo_metaboxes() {

			add_meta_box( 'woocommerce-order-ship', esc_html__('Shipping Details', 'wshipinfo-patsatech'), array( $this, 'wshipinfo_order_shippingdetails' ), 'shop_order', 'side', 'high');

		}

		function wshipinfo_select_menu(){

			if (!function_exists('current_user_can') || !current_user_can('manage_options') ){
				return;
			}

			if ( function_exists( 'add_options_page' ) ){
				add_submenu_page(
					'woocommerce',
					esc_html__('Shipping Details Settings', 'wshipinfo-patsatech'),
					esc_html__('Shipping Details', 'wshipinfo-patsatech'),
					'manage_options',
					'woo_ship_buttons',
					array( $this, 'admin_options' )
				);
			}
		}

		function wshipinfo_register_settings(){

			$options = get_option( 'woo_ship_options' );

		 	add_settings_section(
				'woo_ship_setting_section',
				'Select default Tracker and enter default Message below.',
				'',
				'woo_ship_group'
			);
			
			add_settings_field(
				'woo_ship_options[codecanyon_default_message]',
				'User Display Message',
				array( $this, 'codecanyon_default_message_callback_function' ),
				'woo_ship_group',
				'woo_ship_setting_section'
		 	);
			add_settings_field(
				'woo_ship_options[codecanyon_default_courier]',
				'Select Default Courier',
				array( $this, 'codecanyon_default_courier_callback_function' ),
				'woo_ship_group',
				'woo_ship_setting_section'
			);

			if(!empty($options["codecanyon_purchase_code"])){

			 	add_settings_section(
					'woo_ship_shipper_section',
					'Select Shipping Company that you will be using to ship the Products.',
					'',
					'woo_ship_group'
				);

			}

			register_setting('woo_ship_group','woo_ship_options');
			wp_enqueue_script('shippingdetails-js', SDURL.'/js/shippingdetails.js', array('jquery'));

		}

		function codecanyon_default_message_callback_function() {
			 
			$options = get_option( 'woo_ship_options' );

			if( !isset($options["codecanyon_default_message"]) || $options["codecanyon_default_message"] == '' ){
				$options["codecanyon_default_message"] = esc_html('If you are checking Tracking Number within first 24 hrs. It might show it as invalid or display no information. So please check it after 24 hours.', 'wshipinfo-patsatech');
			}
 
			echo '<textarea name="woo_ship_options[codecanyon_default_message]" id="codecanyon_default_message" placeholder="Enter your Message Here." >'.$options["codecanyon_default_message"].'</textarea>  <br> <span class="description">Display\'s Custom Message when customer clicks the Tracking URL link. If you don\'t want to display the message leave this blank.</span>';
		}

		function codecanyon_default_courier_callback_function() {
			 
			$options = get_option( 'woo_ship_options' );
 		
			?>
			<select name="woo_ship_options[codecanyon_default_courier]">
				<option value="NOTRACK" <?php if ( isset($options['codecanyon_default_courier']) && $options['codecanyon_default_courier'] == 'NOTRACK') {
					echo 'selected="selected"';
				} ?>><?php esc_html_e('No Tracking', 'wshipinfo-patsatech'); ?></option>
				<?php 
				
				
				$shipping_companies = $this->get_shipping_list();

				foreach( $shipping_companies as $k => $v ){
	
					if (isset($options[$k]) == '1') {
						echo '<option value="'.$k.'" ';
						if (isset($options['codecanyon_default_courier']) && $options['codecanyon_default_courier'] == $k) {
							echo 'selected="selected"';
						}
						echo '>'.$v.'</option>';
					}
	
				}
					
				?>
			</select>
			<?php

		
		
		}

		public function admin_options() {
			global $WOOSHIPPINGDETAILS_API;

			$options = get_option( 'woo_ship_options' );

			ob_start();
			?>
			<div class="wrap">
				<h2>Shipping Details Settings</h2>
				<form method="POST" action="options.php">
				<?php

					settings_fields( 'woo_ship_group' );

					do_settings_sections( 'woo_ship_group' );

					try{
						
						if( !empty( get_option( 'woo_ship_couriers' ) ) || is_array( get_option( 'woo_ship_couriers' ) ) ){
							$current_url = "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
							echo '<p class="submit"><a href="'.$current_url.'&sd_update=1" class="button button-primary">Update Companies</a></p>';
						}
						

						?>
						<table cellpadding="10px">
							<?php

							$shipping_companies = $this->get_shipping_list();

							if(is_array($shipping_companies)){

								$i = 0;
								foreach( $shipping_companies as $k => $v ){

									if($i%5==0){
										echo '<tr>';
									}

									$checked = '';

									if(1 == isset($options[$k])){
										$checked = "checked='checked'";
									}

									echo "<td><td class='forminp'>
											<input type='checkbox' name='woo_ship_options[$k]' id='$k' value='1' $checked />
										</td>
										<td scope='row'><label for='$k' >$v</label></td>
										</td>";

									$i++;
									if($i%5==0){
										echo '</tr>';
									}
								}
								if($i%5!=0){
									echo '</tr>';
								}
							}
							?>
						</table>
						<?php
						
					}catch(Exception $e){
						echo '<h3 style="color:red">'.$e->getMessage().'</h3>';
					}
					submit_button();
				?>
				</form>
			</div>
			<?php
			echo ob_get_clean();
		}

		function wshipinfo_track_page_shipping_details( $order ){

			$order_meta = get_post_custom( $order->id );

			$options = get_option( 'woo_ship_options' );

			$num = 0;

			$tracking_number = '';
			$tracking_courier = '';

			if( isset($options['codecanyon_default_message']) && $options['codecanyon_default_message'] != '' ){
				echo '<div style="padding: 1em 2em 1em 2em;margin: 0 0 2em;position: relative;background-color: #f7f6f7;color: #515151;border-top: 3px solid #b81c23;list-style: none outside;width: auto;word-wrap: break-word;">'. $options['codecanyon_default_message'].'</div>';
			}

			foreach ($order_meta as $key => $value) {

				if( strpos($key, '_order_trackno') !== false ){

					if( $num == 0 ){
						$tracking_number = $order_meta['_order_trackno'][0];
						$tracking_courier = $order_meta['_order_trackurl'][0];
						if( $tracking_number != '' ){
							if(isset($order_meta['_order_trackno']) && isset($order_meta['_order_trackurl'])){
								  $this->shipping_details($order_meta['_order_trackno'] , $order_meta['_order_trackurl'] , $order);
							}
						}
					}else{
						$tracking_number = $order_meta['_order_trackno'.$num][0];
						$tracking_courier = $order_meta['_order_trackurl'.$num][0];
						if( $tracking_number != '' ){
							if(isset($order_meta['_order_trackno'.$num]) && isset($order_meta['_order_trackurl'.$num])){
								  $this->shipping_details($order_meta['_order_trackno'.$num] , $order_meta['_order_trackurl'.$num] , $order);
							}
						}
					}
					
					$num++;
				}

			}
			
		}


		function wshipinfo_email_shipping_details( $order ) {

			$order_meta = get_post_custom( $order->id );

			$options = get_option( 'woo_ship_options' );

			$num = 0;

			$tracking_number = '';
			$tracking_courier = '';

			if( isset($options['codecanyon_default_message']) && $options['codecanyon_default_message'] != '' ){
				echo '<div style="padding: 1em 2em 1em 2em;margin: 0 0 2em;position: relative;background-color: #f7f6f7;color: #515151;border-top: 3px solid #b81c23;list-style: none outside;width: auto;word-wrap: break-word;">'. $options['codecanyon_default_message'].'</div>';
			}

			foreach ($order_meta as $key => $value) {

				if( strpos($key, '_order_trackno') !== false ){

					if( $num == 0 ){
						$tracking_number = $order_meta['_order_trackno'][0];
						$tracking_courier = $order_meta['_order_trackurl'][0];
						if( $tracking_number != '' ){
							if(isset($order_meta['_order_trackno']) && isset($order_meta['_order_trackurl'])){
								  $this->shipping_details($order_meta['_order_trackno'] , $order_meta['_order_trackurl'] , $order);
							}
						}
					}else{
						$tracking_number = $order_meta['_order_trackno'.$num][0];
						$tracking_courier = $order_meta['_order_trackurl'.$num][0];
						if( $tracking_number != '' ){
							if(isset($order_meta['_order_trackno'.$num]) && isset($order_meta['_order_trackurl'.$num])){
								  $this->shipping_details($order_meta['_order_trackno'.$num] , $order_meta['_order_trackurl'.$num] , $order);
							}
						}
					}
					
					$num++;
				}

			}
		}

		function shipping_details($trackno, $trackurl, $order){

			$shipping_companies = $this->get_shipping_list();

			//include '//includes/url_list.php';

			$track = explode('-',$trackno[0]);

			if( $trackurl[0] == 'INPERSONPICKUP' ){
				?>
				<h3><?php esc_html_e('Your Order has been marked for', 'wshipinfo-patsatech'); ?> <?php echo $shipping_companies[$trackurl[0]]; ?>.</h3>
				<?php
		   }elseif ( isset($trackno[0]) && isset($trackurl[0]) && $trackno[0] != null && $trackurl[0] != null && $trackurl[0] != 'NOTRACK' ) { ?>

				<h3><?php esc_html_e('Your Order has been shipped via', 'wshipinfo-patsatech'); ?> <?php echo $shipping_companies[$trackurl[0]]; ?>.</h3>
				<?php if ($trackurl[0] == 'POSTNLL'){ ?>
				<STRONG><?php esc_html_e('Tracking No.: ', 'wshipinfo-patsatech'); ?> </STRONG><?php echo $track[0]; ?><br/>
				<STRONG><?php esc_html_e('Postal Code: ' , 'wshipinfo-patsatech');?> </STRONG><?php echo $track[1]; ?>
				<?php } else if ($trackurl[0] == 'APCOVERNIGHT'){?>
				<STRONG><?php esc_html_e('Consignment No.: ', 'wshipinfo-patsatech'); ?> </STRONG><?php echo $track[1]; ?><br/>
				<STRONG><?php esc_html_e('Postal Code: ' , 'wshipinfo-patsatech');?> </STRONG><?php echo $track[0]; ?>
				<?php } else { ?>
				<STRONG><?php esc_html_e('Tracking No.: ', 'wshipinfo-patsatech'); ?></STRONG><?php echo $trackno[0]; ?>
				<?php } ?>
				<br/>
				<?php
				$ch = esc_html__('CLICK HERE', 'wshipinfo-patsatech');
				$ch2 = esc_html__('to track your shipment.', 'wshipinfo-patsatech');
				$form	= '';
				if($form == 'yes'){
					echo "https://shippingdetails.patsatech.com/?n=$trackno[0]&c=$trackurl[0]";
					?>
					<a href="#" onclick="document.forms['<?php echo $trackurl[0]; ?>'].submit(); ?>');"><STRONG><?php echo $ch; ?></STRONG></a> <?php echo $ch2; ?>
				<?php }else{ ?>
				<a href="<?php echo "https://shippingdetails.patsatech.com/?n=$trackno[0]&c=$trackurl[0]"; ?>" target="_blank" ><STRONG><?php echo $ch; ?></STRONG></a> <?php echo $ch2; ?>
				<?php } ?>
				<br/><br/>

			<?php }

		}

		



		function admin_shipping_details($trackno , $trackurl , $order){

			$shipping_companies = $this->get_shipping_list();

			//include '//includes/url_list.php';

			$track = explode('-',$trackno[0]);

			if( $trackurl[0] == 'INPERSONPICKUP' ){
				?>
				<STRONG><?php echo $shipping_companies[$trackurl[0]]; ?></STRONG><br/>
				<?php
			}elseif ( isset($trackno[0]) && isset($trackurl[0]) && $trackno[0] != null && $trackurl[0] != null && $trackurl[0] != 'NOTRACK' ) { ?>
				<STRONG><?php echo $shipping_companies[$trackurl[0]]; ?></STRONG><br/>
				<?php if ($trackurl[0] == 'POSTNLL'){?>
				<STRONG><?php esc_html_e('Tracking No.: ', 'wshipinfo-patsatech'); ?> </STRONG><?php echo $track[0]; ?><br/>
				<STRONG><?php esc_html_e('Postal Code: ' , 'wshipinfo-patsatech');?> </STRONG><?php echo $track[1]; ?>
				<?php } else if ($trackurl[0] == 'APCOVERNIGHT'){?>
				<STRONG><?php esc_html_e('Consignment No.: ', 'wshipinfo-patsatech'); ?> </STRONG><?php echo $track[1]; ?><br/>
				<STRONG><?php esc_html_e('Postal Code: ' , 'wshipinfo-patsatech');?> </STRONG><?php echo $track[0]; ?>
				<?php } else { ?>
				<STRONG><?php esc_html_e('Tracking No.: ', 'wshipinfo-patsatech'); ?></STRONG><?php echo $trackno[0]; ?>
				<?php } ?>
				<br/>
				<?php
				$ch = esc_html__('Track Now', 'wshipinfo-patsatech');
				?>
				<a href="<?php echo "https://shippingdetails.patsatech.com/?n=$trackno[0]&c=$trackurl[0]"; ?>" target="_blank" style="font-size: 15px;padding: 1px;display: table;margin: auto;" ><STRONG><?php echo $ch; ?></STRONG></a>
			<?php }

		}

		function get_shipping_list(){

			$options = get_option( 'woo_ship_options' );

			$shipping_companies = get_option( 'woo_ship_couriers' );

			if( ( empty($shipping_companies) || !is_array($shipping_companies) || isset($_REQUEST['sd_update']) ) ){

				$response = wp_remote_post('https://shippingdetails.patsatech.com/', array(
						'method' => 'POST',
						'timeout' => 60,
						'redirection' => 5,
						'httpversion' => '1.0',
						'body' => array(
							'action' => 'list',
						),
						'sslverify' => false
					)
				);

				if (!is_wp_error($response) && $response['response']['code'] >= 200 && $response['response']['code'] < 300) {
					$shipping_companies = json_decode($response['body'],true);
					if(is_array($shipping_companies)){
						ksort($shipping_companies);
						update_option( 'woo_ship_couriers', $shipping_companies );
						return $shipping_companies;
					}else{
						echo '<h3 style="color:red">There was error fetching the data. Please contact plugin developer at <a href="http://www.patsatech.com/contact-us">http://www.patsatech.com/contact-us</a></h3>';
					}
				}else{
					echo '<h3 style="color:red">There was error fetching the data. Please contact plugin developer at <a href="http://www.patsatech.com/contact-us">http://www.patsatech.com/contact-us</a></h3>';
				}

			}else{
				ksort($shipping_companies);
				return $shipping_companies;
			}

		}

	}
}
$GLOBALS['wooshippinginfo'] = new wooshippinginfo();
