<?php
/**
 * WC_Boxpack_Item file.
 *
 * @package woocommerce-shipping-canada-post
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WC_Boxpack_Item class.
 */
class WC_Boxpack_Item {

	/**
	 * Item weight
	 *
	 * @var float
	 */
	public $weight;

	/**
	 * Item height
	 *
	 * @var float
	 */
	public $height;

	/**
	 * Item width
	 *
	 * @var float
	 */
	public $width;

	/**
	 * Item length
	 *
	 * @var float
	 */
	public $length;

	/**
	 * Item volume.
	 *
	 * @var float
	 */
	public $volume;

	/**
	 * Item value
	 *
	 * @var float
	 */
	public $value;

	/**
	 * Item meta
	 *
	 * @var mixed
	 */
	public $meta;

	/**
	 * Class constructor.
	 *
	 * @param float $length Item length.
	 * @param float $width Item width.
	 * @param float $height Item height.
	 * @param float $weight Item weight.
	 * @param float $value Item value.
	 * @param float $meta Item meta.
	 *
	 * @return void
	 */
	public function __construct( $length, $width, $height, $weight, $value = '', $meta = array() ) {
		$dimensions = array( $length, $width, $height );

		sort( $dimensions );

		$this->length = floatval( $dimensions[2] );
		$this->width  = floatval( $dimensions[1] );
		$this->height = floatval( $dimensions[0] );

		$this->volume = floatval( $width * $height * $length );
		$this->weight = floatval( $weight );
		$this->value  = $value;
		$this->meta   = $meta;
	}

	/**
	 * Get item volume
	 *
	 * @return float
	 */
	public function get_volume() {
		return $this->volume;
	}

	/**
	 * Get item height.
	 *
	 * @return float
	 */
	public function get_height() {
		return $this->height;
	}

	/**
	 * Get item width.
	 *
	 * @return float
	 */
	public function get_width() {
		return $this->width;
	}

	/**
	 * Get item length.
	 *
	 * @return float
	 */
	public function get_length() {
		return $this->length;
	}

	/**
	 * Get item weight
	 *
	 * @return float
	 */
	public function get_weight() {
		return $this->weight;
	}

	/**
	 * Get item value.
	 *
	 * @return float
	 */
	public function get_value() {
		return $this->value;
	}

	/**
	 * Get item meta.
	 *
	 * @param string $key Item meta key.
	 *
	 * @return null|array
	 */
	public function get_meta( $key = '' ) {
		if ( $key ) {
			if ( isset( $this->meta[ $key ] ) ) {
				return $this->meta[ $key ];
			} else {
				return null;
			}
		} else {
			return array_filter( (array) $this->meta );
		}
	}
}
