<?php
/**
 * Plugin Name: WooCommerce Canada Post Shipping
 * Plugin URI: https://woocommerce.com/products/canada-post-shipping-method/
 * Description: Obtain shipping rates dynamically via the Canada Post API for your orders.
 * Version: 2.9.2
 * Author: WooCommerce
 * Author URI: https://woocommerce.com
 * Text Domain: woocommerce-shipping-canada-post
 * WC tested up to: 8.7
 * WC requires at least: 8.5
 * Tested up to: 6.5
 * Requires Plugins: woocommerce
 *
 * Copyright: © 2024 WooCommerce
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * Woo: 18623:ac029cdf3daba20b20c7b9be7dc00e0e
 *
 * @package woocommerce-shipping-canada-post
 */

/**
 * Plugin activation check
 */
function wc_canada_post_activation_check() {
	if ( ! function_exists( 'simplexml_load_string' ) ) {
		wp_die( "Sorry, but you can't run this plugin, it requires the SimpleXML library installed on your server/hosting to function." );
	}
}

if ( ! class_exists( 'WC_Shipping_Canada_Post_Init' ) ) {
	define( 'WC_CANADA_POST_VERSION', '2.9.2' ); // WRCS: DEFINED_VERSION.

	if ( ! defined( 'WC_CANADA_POST_FILE' ) ) {
		define( 'WC_CANADA_POST_FILE', __FILE__ );
	}

	if ( ! defined( 'WC_CANADA_POST_ABSPATH' ) ) {
		define( 'WC_CANADA_POST_ABSPATH', trailingslashit( __DIR__ ) );
	}

	require_once WC_CANADA_POST_ABSPATH . 'includes/class-wc-shipping-canada-post-init.php';
}

register_activation_hook( WC_CANADA_POST_FILE, 'wc_canada_post_activation_check' );

add_action( 'plugins_loaded', array( 'WC_Shipping_Canada_Post_Init', 'get_instance' ), 0 );

// Subscribe to automated translations.
add_filter( 'woocommerce_translations_updates_for_' . basename( WC_CANADA_POST_FILE, '.php' ), '__return_true' );
