/* global WDT, WDTCore */

jQuery( function ( $ ) {
	'use strict';

	var core = WDTCore;

	var handle = {
		setCookie: function ( date ) {
			if ( typeof Cookies !== 'undefined' ) {
				Cookies.set( 'delivery_time', date );
			}
		},
		clearAll: function () {
			if ( typeof Cookies !== 'undefined' ) {
				Cookies.set( 'delivery_time', '' );
			}
			picker.$el.val( '' );
		}
	};

	var picker = {
		$el: $( '.delivery-time' ),
		settings: WDT,

		init: function () {
			picker.setupLocale();
			picker.initDateTimePicker();
		},
		setupLocale: function () {
			$.timepicker.setDefaults( $.timepicker.regional[""] );
			if ( $.timepicker.regional.hasOwnProperty( picker.settings.locale ) ) {
				$.timepicker.setDefaults( $.timepicker.regional[picker.settings.locale] );
			} else if ( $.timepicker.regional.hasOwnProperty( picker.settings.localeShort ) ) {
				$.timepicker.setDefaults( $.timepicker.regional[picker.settings.localeShort] );
			}
		},
		initDateTimePicker: function () {
			if ( typeof Cookies !== 'undefined' ) {
				picker.$el.val( Cookies.get( 'delivery_time' ) );
			}

			picker.$el.datetimepicker( $.extend(
				$.datepicker.regional[picker.settings.language], // TODO
				picker.settings.customDate,
				picker.settings.customTime,
				{
					dateFormat: picker.settings.dateFormat,
					timeFormat: picker.settings.timeFormat,
					beforeShowDay: core.checkDate,
					maxDate: picker.settings.maxDate,
					minDateTime: new Date( picker.settings.minDateTime ),
					hourMax: parseInt( picker.settings.maxHour ),
					hourMin: parseInt( picker.settings.minHour ),
					showTimepicker: parseInt( picker.settings.showTimepicker ),
					onSelect: core.onSelect
				}
			) );
		}
	};

	function toggleByShippingMethod() {
		var $date = picker.$el.parent();
		$( document ).on( 'wdtcore_hide', function () {
			handle.clearAll();
			$date.hide();
		} ).on( 'wdtcore_show', function () {
			$date.show();
		} );
	}

	core.setSettings( WDT );
	core.setHandle( handle );
	picker.init();

	toggleByShippingMethod();
	core.toggleByShippingMethod();
} );
