<?php

namespace WDT;

class Assets extends \WDTCore\Assets {
	protected function enqueue_styles() {
		parent::enqueue_styles();
		wp_enqueue_style( 'jquery-ui-timepicker', "{$this->cdnjs}/jquery-ui-timepicker-addon/1.6.3/jquery-ui-timepicker-addon.min.css", '', '1.6.3' );
	}

	protected function script_dependencies() {
		$dependencies = parent::script_dependencies();
		wp_register_script( 'jquery-ui-timepicker', "{$this->cdnjs}/jquery-ui-timepicker-addon/1.6.3/jquery-ui-timepicker-addon.min.js", [
			'jquery-ui-datepicker',
			'jquery-ui-slider',
		], '1.6.3', true );
		wp_register_script( 'jquery-ui-timepicker-i18n', "{$this->cdnjs}/jquery-ui-timepicker-addon/1.6.3/i18n/jquery-ui-timepicker-addon-i18n.min.js", [ 'jquery-ui-timepicker' ], '1.6.3', true );
		$dependencies[] = 'jquery-ui-timepicker-i18n';
		return $dependencies;
	}

	protected function get_localized_params() {
		$params = parent::get_localized_params();

		// Time restriction.
		$min_hour = $this->settings->get( 'min_hour' );
		$max_hour = $this->settings->get( 'max_hour' );
		if ( '' === $min_hour || $min_hour < 0 ) {
			$min_hour = 0;
		}
		if ( '' === $max_hour || $max_hour < 0 ) {
			$max_hour = 23;
		}
		if ( $min_hour > $max_hour ) {
			$max_hour = 23;
		}

		// Get object last date what cannot access and min time available.
		$format_date  = sprintf( 'F j, Y %s:00:00', $min_hour );
		$min_datetime = date( $format_date );

		$next = $this->settings->get( 'restricted_sequence_days' ) === '' ? 0 : intval( $this->settings->get( 'restricted_sequence_days' ) ) + 1;

		// Add time restricted sequence days.
		$min_datetime = date( $format_date, strtotime( $min_datetime . ' + ' . $next . ' days' ) );

		// Languages.
		$custom_time = array_filter( [
			'timeText'   => $this->settings->get( 'custom_time_text' ),
			'hourText'   => $this->settings->get( 'custom_hour_text' ),
			'minuteText' => $this->settings->get( 'custom_minute_text' ),
			'secondText' => $this->settings->get( 'custom_second_text' ),
			'amNames'    => $this->settings->get( 'custom_am_name' ),
			'pmNames'    => $this->settings->get( 'custom_pm_name' ),
		] );

		$locale       = str_replace( '_', '-', get_locale() );
		$locale_short = substr( $locale, 0, 2 );

		return array_merge( $params, [
			'timeFormat'  => $this->settings->get( 'time_format' ),
			'minDateTime' => $min_datetime,
			'locale'      => $locale,
			'localeShort' => $locale_short,
			'minHour'     => $min_hour,
			'maxHour'     => $max_hour,
			'customTime'  => $custom_time,
		] );
	}
}
