<?php
namespace WDT;

class Checkout extends \WDTCore\Checkout {
	public function save( $order_id ) {
		$datetime = trim( filter_input( INPUT_POST, 'delivery_time', FILTER_SANITIZE_STRING ) );
		if ( $datetime ) {
			update_post_meta( $order_id, '_delivery_time', $this->formatter->timestamp( $datetime ) );
		}
	}

	/**
	 * Add fields to registered checkout fields to easily check if it's required
	 *
	 * @param  array $checkout_fields List of checkout fields.
	 *
	 * @return array
	 */
	public function set_required( $checkout_fields ) {
		if ( ! WC()->cart->needs_shipping() || ! $this->settings->get( 'required' ) ) {
			return $checkout_fields;
		}

		// Set the field required.
		$checkout_fields['wdt'] = [
			'delivery_time' => [
				'label'       => $this->settings->get( 'label' ),
				'placeholder' => $this->settings->get( 'label' ),
				'required'    => true,
			],
		];

		return $checkout_fields;
	}
}
