<?php

namespace WDT;
class Settings extends \WDTCore\Settings {
	protected function time() {
		$settings = parent::time();

		// Time format.
		$desc       = [];
		$desc[]     = __( '<code>H</code>: Hour with no leading 0 (24 hour)', 'woocommerce-delivery-time' );
		$desc[]     = __( '<code>HH</code>: Hour with leading 0 (24 hour)', 'woocommerce-delivery-time' );
		$desc[]     = __( '<code>h</code>: Hour with no leading 0 (12 hour)', 'woocommerce-delivery-time' );
		$desc[]     = __( '<code>hh</code>: Hour with leading 0 (12 hour)', 'woocommerce-delivery-time' );
		$desc[]     = __( '<code>m</code>: Minute with no leading 0', 'woocommerce-delivery-time' );
		$desc[]     = __( '<code>mm</code>: Minute with leading 0', 'woocommerce-delivery-time' );
		$desc[]     = __( '<code>TT</code>: AM or PM for AM/PM', 'woocommerce-delivery-time' );
		$desc[]     = $this->docs;
		$settings[] = [
			'name' => __( 'Time format', 'woocommerce-delivery-time' ),
			'id'   => 'time_format',
			'type' => 'text',
			'std'  => $this->get_default( 'time_format' ),
			'desc' => '<br>' . implode( '<br>', $desc ),
		];

		// Restricted time.
		$settings[] = [
			'name' => __( 'Minimum hour', 'woocommerce-delivery-time' ),
			'id'   => 'min_hour',
			'type' => 'text',
			'std'  => 0,
			'size' => 5,
		];
		$settings[] = [
			'name' => __( 'Maximum hour', 'woocommerce-delivery-time' ),
			'id'   => 'max_hour',
			'type' => 'text',
			'std'  => 23,
			'size' => 5,
		];

		return $settings;
	}

	protected function language() {
		$settings = parent::language();

		$settings[] = [
			'name' => __( 'Time', 'woocommerce-delivery-time' ),
			'id'   => 'custom_time_text',
			'type' => 'text',
		];
		$settings[] = [
			'name' => __( 'Hour', 'woocommerce-delivery-time' ),
			'id'   => 'custom_hour_text',
			'type' => 'text',
		];
		$settings[] = [
			'name' => __( 'Minute', 'woocommerce-delivery-time' ),
			'id'   => 'custom_minute_text',
			'type' => 'text',
		];
		$settings[] = [
			'name' => __( 'Second', 'woocommerce-delivery-time' ),
			'id'   => 'custom_second_text',
			'type' => 'text',
		];

		return $settings;
	}

	protected function defaults() {
		$defaults = parent::defaults();
		return array_merge( $defaults, [
			'time_format' => 'hh:mm TT',
			'min_hour'    => 0,
			'max_hour'    => 23,
		] );
	}
}
