<?php

namespace WDT;

class Shortcodes extends \WDTCore\Shortcodes {
	public function delivery_time( $atts = [] ) {
		$atts = shortcode_atts( [
			'id'     => get_the_ID(),
			'format' => $this->formatter->get_php_datetime_format(),
		], $atts );

		$datetime = get_post_meta( $atts['id'], '_delivery_time', true );
		if ( '' === $datetime ) {
			return __( 'No delivery time.', 'woocommerce-delivery-time' );
		}

		return date( $atts['format'], (int) $datetime );
	}

	/**
	 * Show delivery time picker field.
	 *
	 * @param array $atts Shortcode attributes.
	 *
	 * @return string
	 */
	public function field( $atts = [] ) {
		$atts = shortcode_atts( [
			'id' => 0,
		], $atts );
		$this->assets->enqueue();

		$datetime = $atts['id'] ? $this->delivery_time( $atts ) : '';
		ob_start();
		?>
		<p class="form-row delivery-time-field">
			<label>
				<?= esc_html( $this->settings->get( 'label' ) ); ?>
				<?php if ( $this->settings->get( 'required' ) ) : ?>
					<abbr class="required" title="<?php esc_attr_e( 'Required' ); ?>">*</abbr>
				<?php endif; ?>
			</label>
			<input type="text" name="delivery_time" class="delivery-time" value="<?= esc_attr( $datetime ); ?>">
		</p>
		<?php
		return ob_get_clean();
	}
}
