/* global WDTS */

( function ( $, window, document ) {
	'use strict';

	var core = {
		settings: null,
		handle: null,
		setSettings: function ( settings ) {
			core.settings = settings;
		},
		setHandle: function ( picker ) {
			core.handle = picker;
		},
		onSelect: function ( date ) {
			core.handle.setCookie( date );

			$.post( core.settings.ajaxUrl, {
				action: 'wdtcore_check_number_of_shipments',
				date: date
			}, core.checkShipmentsCallback );
		},
		checkShipmentsCallback: function ( response ) {
			if ( response.success ) {
				return;
			}

			alert( response.data.message );
			if ( 'exceed' === response.data.type ) {
				core.handle.clearAll();
			}
		},
		/**
		 * Check if a date is a valid date.
		 */
		checkDate: function ( date ) {
			// Restricted week days
			if ( $.inArray( date.getDay(), core.settings.restrictedWeekDays ) > - 1 ) {
				return [false];
			}

			// Restricted dates
			var check, range, from, to,
				k = core.settings.holidays.length;
			while ( k -- ) {
				check = core.settings.holidays[k];

				// Single date
				if ( - 1 === check.indexOf( '-' ) ) {
					if ( date.getTime() === core.convertStars( $.trim( check ), date ).getTime() ) {
						return [false];
					}
					continue;
				}

				// Date range
				range = check.split( '-' );
				from = core.convertStars( $.trim( range[0] ), date );
				to = core.convertStars( $.trim( range[1] ), date );

				if ( from <= to ) {
					if ( from <= date && date <= to ) {
						return [false];
					}
				}

				// Compare only if at least one of from date and to date contains stars ( * )
				else if ( range[0].indexOf( '*' ) !== - 1 || range[1].indexOf( '*' ) !== - 1 ) {
					if ( from <= date || date <= to ) {
						return [false];
					}
				}
			}

			// Date is not restricted
			return [true];
		},
		/**
		 * Convert a date string contains stars ( * ) into a Date object
		 *
		 * @param s        Date string, in format mm/dd/yyyy
		 * @param baseDate Date where we get day, month, year
		 * @return Date
		 */
		convertStars: function ( s, baseDate ) {
			var parts = s.split( '/' );

			if ( '*' === parts[0] ) {
				parts[0] = baseDate.getMonth();
			} else {
				parts[0] = parseInt( parts[0] ) - 1;
			} // Month in Javascript Date object is counted from 0 to 11

			if ( '*' === parts[1] ) {
				parts[1] = baseDate.getDate();
			}
			if ( '*' === parts[2] ) {
				parts[2] = baseDate.getFullYear();
			}

			return new Date( parts[2], parts[0], parts[1] );
		},
		toggleByShippingMethod: function () {
			var $wrapper = $( '.woocommerce-checkout' );
			$wrapper.on( 'change', '.shipping_method', function () {
				var $methods = $wrapper.find( '.shipping_method' ),
					selected = $methods.is( 'select' ) ? $methods.val() : $methods.filter( ':checked' ).val(),
					$doc = $( document );

				if ( - 1 !== $.inArray( selected, core.settings.disabledShippingMethods ) ) {
					$doc.trigger( 'wdtcore_hide' );
				} else {
					$doc.trigger( 'wdtcore_show' );
				}
			} );
			$wrapper.find( '.shipping_method' ).trigger( 'change' );
			$wrapper.find( '.shipping_method:checked' ).trigger( 'change' );
		}
	};

	window.WDTCore = core;
} )( jQuery, window, document );
