<?php
/**
 * Show delivery time in admin columns.
 *
 * @package WooCommerce Delivery Time Pro
 */

namespace WDTCore;

class AdminColumn {
	protected $shortcodes;
	protected $key;

	public function __construct( Shortcodes $shortcodes, $key ) {
		$this->shortcodes = $shortcodes;
		$this->key        = $key;
	}

	public function init() {
		add_action( 'load-edit.php', [ $this, 'execute' ] );
	}

	public function execute() {
		if ( 'edit-shop_order' !== get_current_screen()->id ) {
			return;
		}

		add_filter( 'manage_edit-shop_order_columns', [ $this, 'add_columns' ], 15 );
		add_action( 'manage_shop_order_posts_custom_column', [ $this, 'show_column' ], 15 );

		add_filter( 'manage_edit-shop_order_sortable_columns', [ $this, 'sortable_columns' ] );
		add_filter( 'pre_get_posts', [ $this, 'sort' ] );
	}

	public function add_columns( $columns ) {
		$columns['delivery'] = __( 'Delivery', 'woocommerce-delivery-time' );
		return $columns;
	}

	public function show_column( $name ) {
		if ( 'delivery' === $name ) {
			echo $this->shortcodes->delivery_time( [ 'id' => get_the_ID() ] );
		}
	}

	public function sortable_columns( $columns ) {
		$columns['delivery'] = 'delivery';
		return $columns;
	}

	public function sort( \WP_Query $query ) {
		$order_by = filter_input( INPUT_GET, 'orderby', FILTER_SANITIZE_STRING );
		if ( 'delivery' === $order_by ) {
			$query->set( 'orderby', 'meta_value_num' );
			$query->set( 'meta_key', $this->key );
		}
	}
}
