<?php
/**
 * Outputs the input of date and time picker in the checkout page.
 *
 * @package WooCommerce Delivery Time Pro
 */

namespace WDTCore;

class Checkout {
	protected $settings;
	protected $formatter;
	protected $shortcodes;

	public function __construct( Settings $settings, Formatter $formatter, Shortcodes $shortcodes ) {
		$this->settings   = $settings;
		$this->formatter  = $formatter;
		$this->shortcodes = $shortcodes;
	}

	public function init() {
		// Show and save delivery time field before order notes, e.g. after shipping address.
		add_action( 'woocommerce_before_order_notes', [ $this, 'show' ], 20 );
		add_action( 'woocommerce_checkout_update_order_meta', [ $this, 'save' ] );

		// Check if delivery time field is required.
		add_filter( 'woocommerce_checkout_fields', [ $this, 'set_required' ], 20, 1 );
	}

	/**
	 * Show delivery time field before order notes, e.g. after shipping address.
	 */
	public function show() {
		if ( WC()->cart->needs_shipping() ) {
			echo $this->shortcodes->field();
		}
	}

	public function save( $order_id ) {
	}

	/**
	 * Add fields to registered checkout fields to easily check if it's required
	 *
	 * @param  array $checkout_fields List of checkout fields.
	 *
	 * @return array
	 */
	public function set_required( $checkout_fields ) {
		if ( ! WC()->cart->needs_shipping() || ! $this->settings->get( 'required' ) ) {
			return $checkout_fields;
		}

		// Set the field required.
		$checkout_fields['wdt'] = [
			'delivery_date' => [
				'label'       => $this->settings->get( 'label' ),
				'placeholder' => $this->settings->get( 'label' ),
				'required'    => true,
			],
		];

		return $checkout_fields;
	}
}
