<?php
/**
 * Formatting for dates and times between JavaScript and PHP.
 *
 * @package WooCommerce Delivery Time Pro
 */

namespace WDTCore;

class Formatter {
	/**
	 * The instance of settings page.
	 */
	protected $settings;

	public function __construct( Settings $settings ) {
		$this->settings = $settings;
	}

	/**
	 * Convert a date to timestamp.
	 *
	 * @param string $date Date.
	 *
	 * @return int
	 */
	public function timestamp( $date ) {
		if ( ! $date ) {
			return 0;
		}

		$format    = $this->get_php_datetime_format();
		$date_time = \DateTime::createFromFormat( $format, $date );
		return $date_time->getTimestamp();
	}

	/**
	 * Get PHP date and time format from the settings, which is made for JavaScript.
	 *
	 * @return string
	 */
	public function get_php_datetime_format() {
		$format      = $this->get_php_date_format();
		$time_format = $this->get_php_time_format();
		if ( $this->settings->get( 'show_timepicker' ) && $time_format ) {
			$format .= ' ' . $this->get_php_time_format();
		}
		return $format;
	}

	/**
	 * Convert date format in jQuery UI date picker to PHP.
	 *
	 * @return string
	 */
	public function get_php_date_format() {
		$format = $this->settings->get( 'date_format' );

		// Missing:  'o' => '', '!' => '', 'oo' => '', '@' => '', "''" => "'".
		$translation = [
			'd'  => 'j',
			'dd' => 'd',
			'oo' => 'z',
			'D'  => 'D',
			'DD' => 'l',
			'm'  => 'n',
			'mm' => 'm',
			'M'  => 'M',
			'MM' => 'F',
			'y'  => 'y',
			'yy' => 'Y',
		];
		return strtr( $format, $translation );
	}

	/**
	 * Returns a time compatible format string from the JavaScript format
	 *
	 * @return string
	 */
	public function get_php_time_format() {
		$format = $this->settings->get( 'time_format' );

		// Missing: 't' => '', T' => '', 'm' => '', 's' => ''.
		$translation = [
			'H'  => 'H',
			'HH' => 'H',
			'h'  => 'H',
			'hh' => 'H',
			'mm' => 'i',
			'ss' => 's',
			'l'  => 'u',
			'tt' => 'a',
			'TT' => 'A',
		];
		return strtr( $format, $translation );
	}
}
