<?php

namespace WDTCore;

class OrderDetails {
	protected $settings;
	protected $shortcodes;
	protected $checkout;

	public function __construct( Settings $settings, Shortcodes $shortcodes, Checkout $checkout ) {
		$this->settings   = $settings;
		$this->shortcodes = $shortcodes;
		$this->checkout   = $checkout;
	}

	public function init() {
		add_action( 'woocommerce_admin_order_data_after_shipping_address', [ $this, 'show' ] );
		add_action( 'save_post_shop_order', [ $this->checkout, 'save' ] );
	}

	public function show( \WC_Order $order ) {
		echo $this->shortcodes->field( [ 'id' => $order->get_id() ] );
	}
}
