<?php
/**
 * Registers plugin shortcodes for showing input field and the delivery time.
 *
 * @package WooCommerce Delivery Time Pro
 */

namespace WDTCore;

class Shortcodes {
	protected $prefix;
	protected $assets;
	protected $settings;
	protected $formatter;

	public function __construct( $prefix, Assets $assets, Settings $settings, Formatter $formatter ) {
		$this->prefix    = $prefix;
		$this->assets    = $assets;
		$this->settings  = $settings;
		$this->formatter = $formatter;
	}

	public function init() {
		add_shortcode( $this->prefix . '_delivery_time', [ $this, 'delivery_time' ] );
		add_shortcode( $this->prefix . '_shipping_time', [ $this, 'delivery_time' ] ); // For backward compatibility.
		add_shortcode( $this->prefix . '_field', [ $this, 'field' ] );
	}

	/**
	 * Show selected delivery time.
	 *
	 * @param array $atts Shortcode attributes.
	 *
	 * @return string
	 */
	public function delivery_time( $atts = [] ) {
		return '';
	}

	/**
	 * Show delivery time field.
	 *
	 * @param array $atts Shortcode attributes.
	 *
	 * @return string
	 */
	public function field( $atts = [] ) {
		return '';
	}
}
