<?php
/**
 * Show delivery time in templates.
 */

namespace WDTCore;

class Template {
	protected $settings;
	protected $shortcodes;

	public function __construct( Settings $settings, Shortcodes $shortcodes ) {
		$this->settings   = $settings;
		$this->shortcodes = $shortcodes;
	}

	public function init() {
		// In emails.
		add_action( 'woocommerce_email_customer_details', [ $this, 'show_delivery' ], 30 );

		// On thank you page.
		add_action( 'woocommerce_thankyou', [ $this, 'show_delivery' ], 20 );

		// On My Account > View Order page.
		add_action( 'woocommerce_view_order', [ $this, 'show_delivery' ], 20 );
	}

	public function show_delivery( $order ) {
		$order_id = is_a( $order, 'WC_Order' ) ? $order->get_id() : $order;
		?>
		<p>
			<strong><?= esc_html( $this->settings->get( 'label' ) ); ?></strong>:
			<?= $this->shortcodes->delivery_time( [ 'id' => $order_id ] ); ?>
		</p>
		<?php
	}
}
