<?php
namespace WDTCore;

class Url {
	protected $plugin_url;
	protected $plugin_dir;

	public function __construct( $plugin_url, $plugin_dir ) {
		$this->plugin_url = untrailingslashit( $plugin_url );
		$this->plugin_dir = wp_normalize_path( untrailingslashit( $plugin_dir ) );
	}

	public function base_url() {
		$dir = dirname( __DIR__ );
		$dir = wp_normalize_path( untrailingslashit( $dir ) );
		return str_replace( $this->plugin_dir, $this->plugin_url, $dir );
	}
}
